<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
date_default_timezone_set('Asia/ShangHai');


require_once APPPATH.'/libraries/include/Elasticsearch/vendor/autoload.php';
use Elasticsearch\ClientBuilder;


class Es extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    session_start();
    //打开重定向
    $this->load->helper('url');
  }



  public function getEs($ips){
    //$host=['192.168.0.132:9200'];
    return $this->client = ClientBuilder::create()->setHosts($ips)->build();
  }


  public function search()
  {
    $pageNo = $this->input->get('pageNo');
    $pageSize = $this->input->get('pageSize');
    $start_time = $this->input->get('start_time');
    $end_time = $this->input->get('end_time');
    $type = $this->input->get('type');
    $hostaddr = $this->input->get('hostaddr');
    $port = $this->input->get('port');
    $start_date = new DateTime($start_time, new DateTimeZone('UTC'));
    $start_time_ios8601 = $start_date->format('Y-m-d\TH:i:s\Z');
    $end_date = new DateTime($end_time, new DateTimeZone('UTC'));
    $end_time_ios8601 = $end_date->format('Y-m-d\TH:i:s\Z');
    //获取es的ip端口
    $sql = "select es_hostaddr,es_port from kunlun_metadata_db.cluster_es_conf where is_install='yes'";
    $this->load->model('Cluster_model');
    $res = $this->Cluster_model->getList($sql);
    //获取日志的url
    if ($type == 'mysql') {
      $sql_log = "select logdir as dir from server_nodes where hostaddr='$hostaddr' and machine_type='storage'";
    } else {
      $sql_log = "select comp_datadir as dir from server_nodes where hostaddr='$hostaddr' and machine_type='computer'";
    }
    $res_log = $this->Cluster_model->getList($sql_log);
    $log_url = '';
    if (!empty($res_log[0]['dir'])) {
      $log_url = $res_log[0]['dir'];
    }
    $log_dir = $log_url . '/' . $port . '/' . 'slowquery.sql';
    $ips = array();
    foreach ($res as $row => $key) {
      $arr = $key['es_hostaddr'] . ':' . $key['es_port'];
      $ips[] = $arr;
    }
    $query = array();
    $page = 1;
    $pageNo = $pageNo ?? 1;
    $pageSize = $pageSize ?? 10;
    $searchParams['index'] = 'kunlun-*';
    $searchParams['body']['query']['bool']['must'] = array(array('term' => array('service.type' => $type)), array('match' => array('host.ip' => $hostaddr)));
    $searchParams['body']['query']['bool']['filter']['range']['@timestamp'] = array(
      'gte' => $start_time_ios8601,
      'lte' => $end_time_ios8601,
//				'forat'=>'strict_date_optional_time'
    );
    $searchParams['body']['from'] = ($pageNo - 1) * $pageSize;
    $searchParams['body']['size'] = $pageSize;
    $retDoc = $this->getEs($ips)->search($searchParams);

    print_r(json_encode($retDoc));
  }

  public function getSlowLog()
  {
    $start_time = $this->input->get('start_time');
    $end_time = $this->input->get('end_time');
    $type = $this->input->get('type');
    $hostaddr = $this->input->get('ip');
    $port = $this->input->get('port');
    $start_date = new DateTime($start_time, new DateTimeZone('UTC'));
    $start_time_ios8601 = $start_date->format('Y-m-d\TH:i:s\Z');
    $end_date = new DateTime($end_time, new DateTimeZone('UTC'));
    $end_time_ios8601 = $end_date->format('Y-m-d\TH:i:s\Z');
    //获取es的ip端口
    $this->load->model('Cluster_model');
    $sql = "select es_hostaddr,es_port from kunlun_metadata_db.cluster_es_conf where is_install='yes'";
    $res = $this->Cluster_model->getList($sql);

    //print_r($res);
    //获取日志的url
    if ($type == 'mysql') {
      $sql_log = "select logdir as dir from kunlun_metadata_db.server_nodes where hostaddr='$hostaddr' and machine_type='storage'";
    } else {
      $sql_log = "select comp_datadir as dir from kunlun_metadata_db.server_nodes where hostaddr='$hostaddr' and machine_type='computer'";
    }
    $res_log = $this->Cluster_model->getList($sql_log);
    $log_url = '';
    if (!empty($res_log[0]['dir'])) {
      $log_url = $res_log[0]['dir'];
    }
    $log_dir = $log_url . '/' . $port . '/' . 'slowquery.sql';
    $ips = array();
    foreach ($res as $row => $key) {
      $arr = $key['es_hostaddr'] . ':' . $key['es_port'];
      $ips[] = $arr;
    }
    $query = array();
    $page = 1;
    $pageNo = $pageNo ?? $page;
    $pageSize = $pageSize ?? 10;
//		$searchParams['index'] = 'kunlun-*';
    $searchParams['index'] = 'kunlun-*';
//		$searchParams['body']['query']['bool']['must']=array(array('term'=>array('service.type'=>$type)),array('term'=>array('container.id'=>'slowquery.sql')),array('match'=>array('host.ip'=>$hostaddr)),array('match'=>array('log.file.path'=>$log_dir)));
    $searchParams['body']['query']['bool']['must'] = array(array('term' => array('service.type' => $type)), array('term' => array('fileset.name' => 'slowlog')), array('match' => array('host.ip' => $hostaddr)), array('match' => array('log.file.path' => $log_dir)));
    $searchParams['body']['query']['bool']['must_not'] = array(array('match' => array('message' => 'kunlun-storage--debug')));
    $searchParams['body']['query']['bool']['filter']['range']['@timestamp'] = array(
      'gte' => $start_time_ios8601,
      'lte' => $end_time_ios8601,
    );
    $searchParams['body']['from'] = ($pageNo - 1) * $pageSize;
    $searchParams['body']['size'] = $pageSize;

//	  print_r(json_encode($searchParams));

//    print_r($ips);exit();


    $retDoc = $this->getEs($ips)->search($searchParams);

    print_r(json_encode($retDoc));

//    $this->load->model('Esearch_model');
//    $esEarchRes = $this->Esearch_model->getsearch($query, $ips, $searchParams);
//    print_r(json_encode($esEarchRes));
  }

  public function checkEsIp()
  {
    //获取token
    $arr = apache_request_headers(); //获取请求头数组
    $token = $arr["Token"];
    if (empty($token)) {
      $data['code'] = 201;
      $data['message'] = 'token不能为空';
      print_r(json_encode($data));
      return;
    }
    //判断参数
    $string = json_decode(@file_get_contents('php://input'), true);
    $hostaddr = $string['hostaddr'];
    $port = $string['port'];
    //验证token
    $this->load->model('Cluster_model');
    $sql = "select count(*)as count  from kunlun_metadata_db.cluster_es_conf where es_hostaddr='$hostaddr' and es_port='$port';";
    $res = $this->Cluster_model->getList($sql);
    if ($res[0]['count'] == 0) {
      $data['code'] = 200;
    } else {
      $data['code'] = 501;
      $data['message'] = 'ip端口重复';
    }
    print_r(json_encode($data));
  }
}
