<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Grafana extends CI_Controller
{

	public function __construct()
	{
		//session_start();
		parent::__construct();
		header('Access-Control-Allow-Origin:*'); // *代表允许任何网址请求
		header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin'); // 设置允许自定义请求头的字段
		header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE'); // 允许请求的类型
		header('Access-Control-Allow-Headers:x-requested-with,content-type,Token'); //允许接受token
		header('Content-Type: application/json;charset=utf-8');
		//header('Access-Control-Allow-Credentials: true'); // 设置是否允许发送 cookies
		$this->config->load('myconfig');
		$this->key = $this->config->item('key');
		$this->post_url = $this->config->item('post_url');
		$this->grafana_svr = $this->config->item('grafana_svr');

	}

	public function mysqlDashboard()
	{
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		$this->load->model('Cluster_model');
		$this->load->model('Mysql_model');
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		$ip = $string['hostaddr'];
		$port = $string['port'] + 1;
		//$http_data=str_replace("\\/", "/", json_encode($string));
		$if_addSource = true;
		//查prometheus的端口
		$sql = "select hostaddr,prometheus_port from cluster_mgr_nodes where member_state='source'";
		$res = $this->Cluster_model->getList($sql);
		$url = '';
		if (!empty($res)) {
			$url = 'http://' . $res[0]['hostaddr'] . ':' . $res[0]['prometheus_port'];
		}
		//查grafana数据源
		$get_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources';
		//调grafana的api查数据源
		$this->load->model('Grafana_model');
		$get_result = $this->Grafana_model->postDataSource($get_url);
		if (!empty($get_result)) {
			$get_arr = json_decode($get_result, true);
			if (count($get_arr) !== 0) {
				foreach ($get_arr as $row) {
					$pro_id = $row['id'];
					if (!empty($row['url'])) {
						$grafana_url = $row['url'];
						if ($grafana_url == $url) {
							$if_addSource = false;
						} else {
							//url不一样需要调grafana接口更新数据源(PUT)
							$update_data = '{"id":' . $pro_id . ',"orgId":"' . $row['typeLogoUrl'] . '","name":"Prometheus","type":"prometheus","typeLogoUrl":"' . $row['typeLogoUrl'] . '","access":"proxy","url":"' . $url . '","basicAuth":false,"isDefault":false,"jsonData":null}';
							$put_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources/' . $pro_id;
							$put_result = $this->Grafana_model->putData($update_data, $put_url);
							$put_result = json_decode($put_result, true);
							if ($put_result['message'] == 'Datasource updated') {
								$if_addSource = false;
							}
						}
					} else {
						//更新数据源
						$put_data = '{"id":' . $pro_id . ',"orgId":"' . $row['typeLogoUrl'] . '","name":"Prometheus","type":"prometheus","typeLogoUrl":"' . $row['typeLogoUrl'] . '","access":"proxy","url":"' . $url . '","basicAuth":false,"isDefault":false,"jsonData":null}';
						$put_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources/' . $pro_id;
						$put_result = $this->Grafana_model->putData($put_data, $put_url);
						$put_result = json_decode($put_result, true);
						if ($put_result['message'] == 'Datasource updated') {
							$if_addSource = false;
						}
					}
				}
			} else {
				$post_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources';
				$post_data = '{"name":"Prometheus","type":"prometheus","access":"proxy","url":"' . $url . '","basicAuth":false}';
				$post_result = $this->Grafana_model->postData($post_data, $post_url);
				$post_result = json_decode($post_result, true);
				if ($post_result['message'] == 'Datasource added') {
					$if_addSource = false;
				}
			}
		}
		if ($if_addSource === false) {
			//新建bashboard模板
			$host = $ip . ':' . $port;
			$mysqld_data = $this->Mysql_model->mysqlJSON($host);
			//$mysqld_data='{"dashboard": {"id": null,"uid": null,"title": "Production Overview","tags": [ "templated" ],"timezone": "browser","schemaVersion": 16,"version": 0,"refresh": "25s"},"folderId": 0,"overwrite": false}';
			//$mysqld_data = file_get_contents('./json/mysqld.json');
			//print_r($mysqld_data);exit;
			$postdb_url = 'http://admin:admin@' . $this->grafana_svr . '/api/dashboards/db';
			$postdb_result = $this->Grafana_model->postData($mysqld_data, $postdb_url);
			$postdb_result = json_decode($postdb_result, true);
			//print_r($postdb_result);exit;
			if ($postdb_result['status'] == 'success') {
				$mysql_url = $postdb_result['url'];
				$data['url'] = $mysql_url;
				$data['code'] = 200;
				print_r(json_encode($data));
			} else if ($postdb_result['status'] == 'name-exists') {
				//查dashboard的id
				$getdb_url = 'http://admin:admin@' . $this->grafana_svr . '/api/search?folderIds=0';
				$getdb_result = $this->Grafana_model->postDataSource($getdb_url);
				$db_id = '';
				$db_uid = '';
				$db_title = '';
				$db_version = '';
				if (!empty($getdb_result)) {
					$getdb_arr = json_decode($getdb_result, true);
					if (count($getdb_arr) !== 0) {
						foreach ($getdb_arr as $dbrow) {
							if ($dbrow['title'] == 'mysql') {
								$db_id = $dbrow['id'];
								$db_uid = $dbrow['uid'];
								$db_title = $dbrow['title'];
							}
						}
						if (!empty($db_id) && !empty($db_uid) && !empty($db_title)) {
							//查dashboard的version
							$getdbv_url = 'http://admin:admin@' . $this->grafana_svr . '/api/dashboards/uid/' . $db_uid;
							$getdbv_result = $this->Grafana_model->postDataSource($getdbv_url);
							if (!empty($getdbv_result)) {
								$getdbv_arr = json_decode($getdbv_result, true);
								if (count($getdbv_arr) !== 0) {
									foreach ($getdbv_arr as $dbv_row) {
										$db_version = $dbv_row['version'];
									}
								}
							}
							//更新
							$update_mysqld_data = $this->Mysql_model->updateMysqlJSON($host, $db_id, $db_uid, $db_title, $db_version);
							$update_postdb_url = 'http://admin:admin@' . $this->grafana_svr . '/api/dashboards/db';
							$update_postdb_result = $this->Grafana_model->postData($update_mysqld_data, $update_postdb_url);
							$update_postdb_result = json_decode($update_postdb_result, true);
							//print_r($update_postdb_result);exit;
							if ($update_postdb_result['status'] == 'success') {
								$update_mysql_url = $update_postdb_result['url'];
								$data['url'] = $update_mysql_url;
								$data['code'] = 200;
								print_r(json_encode($data));
							}
						}
					}
				}
			}
		}
	}
	public function pgsqlDashboard()
	{ //前五个templating可用 其他不可用todo
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		$this->load->model('Cluster_model');
		$this->load->model('PGsql_model');
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		$ip = $string['hostaddr'];
		$port = $string['port'] + 2;
		//$http_data=str_replace("\\/", "/", json_encode($string));
		$if_addSource = true;
		//查prometheus的端口
		$sql = "select hostaddr,prometheus_port from cluster_mgr_nodes where member_state='source'";
		$res = $this->Cluster_model->getList($sql);
		$url = '';
		if (!empty($res)) {
			$url = 'http://' . $res[0]['hostaddr'] . ':' . $res[0]['prometheus_port'];
		}
		//查grafana数据源
		$get_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources';
		//调grafana的api查数据源
		$this->load->model('Grafana_model');
		$get_result = $this->Grafana_model->postDataSource($get_url);
		if (!empty($get_result)) {
			$get_arr = json_decode($get_result, true);
			if (count($get_arr) !== 0) {
				foreach ($get_arr as $row) {
					$pro_id = $row['id'];
					if (!empty($row['url'])) {
						$grafana_url = $row['url'];
						if ($grafana_url == $url) {
							$if_addSource = false;
						} else {
							//url不一样需要调grafana接口更新数据源(PUT)
							$update_data = '{"id":' . $pro_id . ',"orgId":"' . $row['typeLogoUrl'] . '","name":"Prometheus","type":"prometheus","typeLogoUrl":"' . $row['typeLogoUrl'] . '","access":"proxy","url":"' . $url . '","basicAuth":false,"isDefault":false,"jsonData":null}';
							$put_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources/' . $pro_id;
							$put_result = $this->Grafana_model->putData($update_data, $put_url);
							$put_result = json_decode($put_result, true);
							if ($put_result['message'] == 'Datasource updated') {
								$if_addSource = false;
							}
						}
					} else {
						//更新数据源
						$put_data = '{"id":' . $pro_id . ',"orgId":"' . $row['typeLogoUrl'] . '","name":"Prometheus","type":"prometheus","typeLogoUrl":"' . $row['typeLogoUrl'] . '","access":"proxy","url":"' . $url . '","basicAuth":false,"isDefault":false,"jsonData":null}';
						$put_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources/' . $pro_id;
						$put_result = $this->Grafana_model->putData($put_data, $put_url);
						$put_result = json_decode($put_result, true);
						if ($put_result['message'] == 'Datasource updated') {
							$if_addSource = false;
						}
					}
				}
			} else {
				$post_url = 'http://admin:admin@' . $this->grafana_svr . '/api/datasources';
				$post_data = '{"name":"Prometheus","type":"prometheus","access":"proxy","url":"' . $url . '","basicAuth":false}';
				$post_result = $this->Grafana_model->postData($post_data, $post_url);
				$post_result = json_decode($post_result, true);
				if ($post_result['message'] == 'Datasource added') {
					//$uid=$post_result['datasource']['uid'];
					$if_addSource = false;
				}
			}
		}
		if ($if_addSource === false) {
			//新建bashboard模板
			$host = $ip . ':' . $port;
			$pgsqld_data = $this->PGsql_model->pgsqlJSON($host);
			//$pgsqld_data='{"dashboard": {"id": null,"uid": null,"title": "postgresql","tags": [ "templated" ],"timezone": "browser","schemaVersion": 16,"version": 0,"refresh": "5s"},"folderId": 0,"overwrite": false}';
			$postdb_url = 'http://admin:admin@' . $this->grafana_svr . '/api/dashboards/db';
			$postdb_result = $this->Grafana_model->postData($pgsqld_data, $postdb_url);
			$postdb_result = json_decode($postdb_result, true);
			//print_r($postdb_result);exit;
			if ($postdb_result['status'] == 'success') {
				$pgsql_url = $postdb_result['url'];
				$data['url'] = $pgsql_url;
				$data['code'] = 200;
				print_r(json_encode($data));
			} else if ($postdb_result['status'] == 'name-exists') {
				//查dashboard的id
				$getdb_url = 'http://admin:admin@' . $this->grafana_svr . '/api/search?folderIds=0';
				$getdb_result = $this->Grafana_model->postDataSource($getdb_url);
				$db_id = '';
				$db_uid = '';
				$db_title = '';
				$db_version = '';
				//print_r($getdb_result);exit;
				if (!empty($getdb_result)) {
					$getdb_arr = json_decode($getdb_result, true);
					if (count($getdb_arr) !== 0) {
						foreach ($getdb_arr as $dbrow) {
							if ($dbrow['title'] == 'pgsql') {
								$db_id = $dbrow['id'];
								$db_uid = $dbrow['uid'];
								$db_title = $dbrow['title'];
							}
						}
						if (!empty($db_id) && !empty($db_uid) && !empty($db_title)) {
							//查dashboard的version
							$getdbv_url = 'http://admin:admin@' . $this->grafana_svr . '/api/dashboards/uid/' . $db_uid;
							$getdbv_result = $this->Grafana_model->postDataSource($getdbv_url);
							if (!empty($getdbv_result)) {
								$getdbv_arr = json_decode($getdbv_result, true);
								if (count($getdbv_arr) !== 0) {
									foreach ($getdbv_arr as $dbv_row) {
										$db_version = $dbv_row['version'];
									}
								}
							}
							//更新
							$update_mysqld_data = $this->PGsql_model->updatePGsqlJSON($host, $db_id, $db_uid, $db_title, $db_version);
							//$update_mysqld_data = file_get_contents('./json/pgsql.json');
							$update_postdb_url = 'http://admin:admin@' . $this->grafana_svr . '/api/dashboards/db';
							$update_postdb_result = $this->Grafana_model->postData($update_mysqld_data, $update_postdb_url);
							//print_r($update_mysqld_data);exit;
							$update_postdb_result = json_decode($update_postdb_result, true);
							//print_r($update_postdb_result);exit;
							if ($update_postdb_result['status'] == 'success') {
								$update_mysql_url = $update_postdb_result['url'];
								$data['url'] = $update_mysql_url;
								$data['code'] = 200;
								print_r(json_encode($data));
							}
						}
					}
				}
			}
		}
	}
	public function nodeDashboard()
	{
		log_message('debug', '=== nodeDashboard() Start ===');
		
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			log_message('error', '=== nodeDashboard() Token为空 ===');
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		log_message('debug', '=== nodeDashboard() Token验证通过 ===');
		
		$this->load->model('Cluster_model');
		$this->load->model('Node_model');
		log_message('debug', '=== nodeDashboard() 加载模型完成 ===');
		
		//查主机的iplist
		$ipsql = "select hostaddr,nodemgr_prometheus_port from server_nodes where hostaddr!='pseudo_server_useless' and machine_type is not null group by hostaddr";
		log_message('debug', '=== nodeDashboard() SQL: ' . $ipsql . ' ===');
		
		$res_iplist = $this->Cluster_model->getList($ipsql);
		log_message('debug', '=== nodeDashboard() IP列表结果: ' . json_encode($res_iplist) . ' ===');
		
		$node = '';
		foreach ($res_iplist as $ip) {
			$host = $ip['hostaddr'];
			$nodeport = $ip['nodemgr_prometheus_port'];
			$ip_list = $host . ':' . $nodeport;
			$node .= $ip_list . ',';
		}
		if (!empty($node)) {
			$node = substr($node, 0, -1);
			$node = '{' . $node . '}';
		}
		log_message('debug', '=== nodeDashboard() 构建node字符串: ' . $node . ' ===');
		
		$if_addSource = true;
		
		//查prometheus的端口
		$sql = "select hostaddr,prometheus_port from cluster_mgr_nodes where member_state='source'";
		log_message('debug', '=== nodeDashboard() 查询prometheus端口SQL: ' . $sql . ' ===');
		
		$res = $this->Cluster_model->getList($sql);
		log_message('debug', '=== nodeDashboard() Prometheus端口查询结果: ' . json_encode($res) . ' ===');
		
		$url = '';
		if (!empty($res)) {
			$url = 'http://' . $res[0]['hostaddr'] . ':' . $res[0]['prometheus_port'];
			log_message('debug', '=== nodeDashboard() Prometheus URL: ' . $url . ' ===');
		} else {
			log_message('error', '=== nodeDashboard() 无法获取Prometheus URL ===');
		}
		
		//查grafana数据源
		$get_url = 'http://' . $this->grafana_svr . '/api/datasources';
		log_message('debug', '=== nodeDashboard() Grafana数据源URL: ' . $get_url . ' ===');
		
		//调grafana的api查数据源
		$this->load->model('Grafana_model');
		$get_result = $this->Grafana_model->postDataSource($get_url);
		log_message('debug', '=== nodeDashboard() Grafana数据源结果: ' . $get_result . ' ===');

		if (!empty($get_result)) {
			$get_arr = json_decode($get_result, true);
			log_message('debug', '=== nodeDashboard() 解析数据源结果: ' . json_encode($get_arr) . ' ===');
			
			if (count($get_arr) !== 0) {
				foreach ($get_arr as $row) {
					$pro_id = $row['id'];
					if (!empty($row['url'])) {
						$grafana_url = $row['url'];
						if ($grafana_url == $url) {
							$if_addSource = false;
							log_message('debug', '=== nodeDashboard() 找到匹配的数据源URL ===');
						} else {
							log_message('debug', '=== nodeDashboard() 更新数据源URL ===');
							//url不一样需要调grafana接口更新数据源(PUT)
							$update_data = '{"id":' . $pro_id . ',"orgId":"' . $row['typeLogoUrl'] . '","name":"Prometheus","type":"prometheus","typeLogoUrl":"' . $row['typeLogoUrl'] . '","access":"proxy","url":"' . $url . '","basicAuth":false,"isDefault":false,"jsonData":null}';
							$put_url = 'http://' . $this->grafana_svr . '/api/datasources/' . $pro_id;
							
							log_message('debug', '=== nodeDashboard() PUT请求URL: ' . $put_url . ' ===');
							log_message('debug', '=== nodeDashboard() PUT请求数据: ' . $update_data . ' ===');
							
							$put_result = $this->Grafana_model->putData($update_data, $put_url);
							log_message('debug', '=== nodeDashboard() PUT响应: ' . $put_result . ' ===');

							$put_result = json_decode($put_result, true);
							if ($put_result['message'] == 'Datasource updated') {
								$if_addSource = false;
								log_message('debug', '=== nodeDashboard() 数据源更新成功 ===');
							} else {
								log_message('error', '=== nodeDashboard() 数据源更新失败: ' . json_encode($put_result) . ' ===');
							}
						}
					} else {
						log_message('debug', '=== nodeDashboard() 更新空URL数据源 ===');
						//更新数据源
						$put_data = '{"id":' . $pro_id . ',"orgId":"' . $row['typeLogoUrl'] . '","name":"Prometheus","type":"prometheus","typeLogoUrl":"' . $row['typeLogoUrl'] . '","access":"proxy","url":"' . $url . '","basicAuth":false,"isDefault":false,"jsonData":null}';
						$put_url = 'http://' . $this->grafana_svr . '/api/datasources/' . $pro_id;
						
						log_message('debug', '=== nodeDashboard() PUT请求URL: ' . $put_url . ' ===');
						log_message('debug', '=== nodeDashboard() PUT请求数据: ' . $put_data . ' ===');
						
						$put_result = $this->Grafana_model->putData($put_data, $put_url);
						log_message('debug', '=== nodeDashboard() PUT响应: ' . $put_result . ' ===');
						
						$put_result = json_decode($put_result, true);
						if ($put_result['message'] == 'Datasource updated') {
							$if_addSource = false;
							log_message('debug', '=== nodeDashboard() 空URL数据源更新成功 ===');
						} else {
							log_message('error', '=== nodeDashboard() 空URL数据源更新失败: ' . json_encode($put_result) . ' ===');
						}
					}

				}
			} else {
				log_message('debug', '=== nodeDashboard() 未找到现有数据源，创建新数据源 ===');
				$post_url = 'http://' . $this->grafana_svr . '/api/datasources';
				$post_data = '{"name":"Prometheus","type":"prometheus","access":"proxy","url":"' . $url . '","basicAuth":false}';
				
				log_message('debug', '=== nodeDashboard() POST请求URL: ' . $post_url . ' ===');
				log_message('debug', '=== nodeDashboard() POST请求数据: ' . $post_data . ' ===');
				
				$post_result = $this->Grafana_model->postData($post_data, $post_url);
				log_message('debug', '=== nodeDashboard() POST响应: ' . $post_result . ' ===');
				
				$post_result = json_decode($post_result, true);
				if ($post_result['message'] == 'Datasource added') {
					$if_addSource = false;
					log_message('debug', '=== nodeDashboard() 新数据源创建成功 ===');
				} else {
					log_message('error', '=== nodeDashboard() 新数据源创建失败: ' . json_encode($post_result) . ' ===');
				}
			}
		} else {
			log_message('error', '=== nodeDashboard() 获取数据源列表失败 ===');
		}

		if (!$if_addSource) {
			log_message('debug', '=== nodeDashboard() 创建仪表盘模板 ===');
			//新建bashboard模板
			//$host=$ip.':'.$port;
			//$pgsqld_data=$this->Node_model->nodeJSON($node);
			//$pgsqld_data='{"dashboard": {"id": null,"uid": null,"title": "node","tags": [ "templated" ],"timezone": "browser","schemaVersion": 16,"version": 0,"refresh": "5s"},"folderId": 0,"overwrite": false}';
			//print_r($pgsqld_data);
			$pgsqld_data = file_get_contents('./json/node.json');
			if ($pgsqld_data === false) {
				log_message('error', '=== nodeDashboard() 读取node.json模板失败 ===');
				$data['code'] = 500;
				$data['message'] = '无法读取仪表盘模板';
				print_r(json_encode($data));
				return;
			}
			
			$postdb_url = 'http://' . $this->grafana_svr . '/api/dashboards/db';
			log_message('debug', '=== nodeDashboard() 仪表盘POST URL: ' . $postdb_url . ' ===');
			log_message('debug', '=== nodeDashboard() 仪表盘模板数据: ' . substr($pgsqld_data, 0, 100) . '... ===');
			
			$postdb_result = $this->Grafana_model->postData($pgsqld_data, $postdb_url);
			log_message('debug', '=== nodeDashboard() 仪表盘创建响应: ' . $postdb_result . ' ===');
			
			$postdb_result = json_decode($postdb_result, true);

			if ($postdb_result['status'] == 'success') {
				$pgsql_url = $postdb_result['url'];
				$data['url'] = $pgsql_url;
				$data['code'] = 200;
				log_message('debug', '=== nodeDashboard() 仪表盘创建成功，URL: ' . $pgsql_url . ' ===');
				print_r(json_encode($data));
			} else if ($postdb_result['status'] == 'name-exists') {
				log_message('debug', '=== nodeDashboard() 仪表盘已存在，正在获取现有URL ===');
				//查dashboard的id
				$getdb_url = 'http://' . $this->grafana_svr . '/api/search?folderIds=0';
				$getdb_result = $this->Grafana_model->postDataSource($getdb_url);
				log_message('debug', '=== nodeDashboard() 查询仪表盘结果: ' . $getdb_result . ' ===');
				
				$db_id = '';
				$db_uid = '';
				$db_title = '';
				$db_version = '';
				$db_url = '';
				//print_r($getdb_result);exit;
				if (!empty($getdb_result)) {
					$getdb_arr = json_decode($getdb_result, true);
					if (count($getdb_arr) !== 0) {
						foreach ($getdb_arr as $dbrow) {
							if ($dbrow['title'] == 'node') {
								$db_id = $dbrow['id'];
								$db_uid = $dbrow['uid'];
								$db_title = $dbrow['title'];
								$db_url = $dbrow['url'];
								log_message('debug', '=== nodeDashboard() 找到现有仪表盘 - ID: ' . $db_id . ', UID: ' . $db_uid . ', URL: ' . $db_url . ' ===');
							}
						}
						if (!empty($db_url)) {
							$data['url'] = $db_url;
							$data['code'] = 200;
							log_message('debug', '=== nodeDashboard() 返回现有仪表盘URL: ' . $db_url . ' ===');
							print_r(json_encode($data));
						} else {
							log_message('error', '=== nodeDashboard() 找到仪表盘但URL为空 ===');
							$data['code'] = 500;
							$data['message'] = '仪表盘URL为空';
							print_r(json_encode($data));
						}
					} else {
						log_message('error', '=== nodeDashboard() 查询结果中未找到仪表盘 ===');
						$data['code'] = 404;
						$data['message'] = '未找到仪表盘';
						print_r(json_encode($data));
					}
				} else {
					log_message('error', '=== nodeDashboard() 查询仪表盘失败 ===');
					$data['code'] = 500;
					$data['message'] = '搜索仪表盘失败';
					print_r(json_encode($data));
				}
			} else {
				log_message('error', '=== nodeDashboard() 创建仪表盘失败: ' . json_encode($postdb_result) . ' ===');
				$data['code'] = 500;
				$data['message'] = '创建仪表盘失败';
				print_r(json_encode($data));
			}
		} else {
			log_message('error', '=== nodeDashboard() 设置数据源失败 ===');
			$data['code'] = 500;
			$data['message'] = '设置数据源失败';
			print_r(json_encode($data));
		}
		
		log_message('debug', '=== nodeDashboard() End ===');
	}
}