<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Operation extends CI_Controller
{

	public function __construct()
	{
		//session_start();
		parent::__construct();
		header('Access-Control-Allow-Origin:*'); // *代表允许任何网址请求
		header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin'); // 设置允许自定义请求头的字段
		header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE'); // 允许请求的类型
		header('Access-Control-Allow-Headers:x-requested-with,content-type,Token');//允许接受token
		header('Content-Type: application/json;charset=utf-8');
		//header('Access-Control-Allow-Credentials: true'); // 设置是否允许发送 cookies
		$this->config->load('myconfig');
		$this->key = $this->config->item('key');
		$this->job_type = $this->config->item('job_type');
		$this->post_url = $this->config->item('post_url');
	}

	public function getOperationList()
	{
		//GET请求
		$serve = $_SERVER['QUERY_STRING'];
		$string = preg_split('/[=&]/', $serve);
		$arr = array();
		for ($i = 0; $i < count($string); $i += 2) {
			$arr[$string[$i]] = $string[$i + 1];
		}
		$pageNo = $arr['pageNo'];
		$pageSize = $arr['pageSize'];
		$username = $arr['username'];
		$sync = $arr['sync'];
		$status= $arr['status'];
		$start = ($pageNo - 1) * $pageSize;
		$job_type = $this->job_type;
		$this->load->model('Cluster_model');

		//获取任务信息
		if($sync==='2'){
			//var_dump($sync);exit;
			$sql = "select * from cluster_general_job_log where user_name!='internal_user'";
			if ($username == 'super_dba') {
				$sql .= "";
			} else {
				$sql .= " and user_name='$username' ";
			}
			if(!empty($status)){
				$sql .= " and status='$status' ";
			}
			$sql .= "  order by id desc limit $pageSize offset $start";
			$res = $this->Cluster_model->getList($sql);
			$total_sql = "select count(id) as count from cluster_general_job_log where user_name!='internal_user'";
			if ($username == 'super_dba') {
				$total_sql .= "";
			} else {
				$total_sql .= "  and user_name='$username' ";
			}
			if(!empty($status)){
				$total_sql .= "  and status='$status' ";
			}
			$res_total = $this->Cluster_model->getList($total_sql);
			foreach ($res as $row => $value) {
				foreach ($value as $key2 => $value2) {
					$string = json_decode($res[$row]['job_info'], true);
					//输入信息
					if ($key2 == 'memo') {
						if (!empty($value2)) {
							$info = json_decode($value2, true);
							if (!empty($info)) {
								if (!empty($info['cluster_id'])) {
									$res[$row]['cluster_id'] = $info['cluster_id'];
								} else {
									if (!empty($string['paras']['cluster_id'])) {
										$res[$row]['cluster_id'] = $string['paras']['cluster_id'];
									} else {
										if ( $res[$row]['job_type'] == 'cluster_restore') {
											if (!empty($string['paras']['dst_cluster_id'])) {
												$res[$row]['cluster_id'] = $string['paras']['dst_cluster_id'];
											} else {
												$res[$row]['cluster_id'] = '';
											}
										} else {
											$res[$row]['cluster_id'] = '';
										}
									}
								}
								if (!empty($info['error_info'])) {
									if ($res[$row]['status'] == 'ongoing') {
										$res[$row]['info'] = '';
									} else {
										$res[$row]['info'] = $info['error_info'];
										//print_r($info['error_info']);exit;
									}
								} else {
									$res[$row]['info'] = '';
								}
							}
						} else {
							$res[$row]['info'] = '';
							if (!empty($string['paras']['cluster_id'])) {
								$res[$row]['cluster_id'] = $string['paras']['cluster_id'];
							} else {
								$res[$row]['cluster_id'] = '';
							}
						}
					}
					if ($key2 == 'job_type') {
						if (!empty($value2)) {
							if ($value2 == 'create_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$shards = '';
									if (!empty($string['paras']['shards'])) {
										$shards = $string['paras']['shards'];
									}
									$nodes = '';
									if (!empty($string['paras']['nodes'])) {
										$nodes = $string['paras']['nodes'];
									}
									$comps = '';
									if (!empty($string['paras']['comps'])) {
										$comps = $string['paras']['comps'];
									}
									$max_connections = '';
									if (!empty($string['paras']['max_connections'])) {
										$max_connections = $string['paras']['max_connections'];
									}
									$innodb_size = '';
									if (!empty($string['paras']['innodb_size'])) {
										$innodb_size = $string['paras']['innodb_size'];
									}
									$cpu_cores = '';
									if (!empty($string['paras']['cpu_cores'])) {
										$cpu_cores = $string['paras']['cpu_cores'];
									}
									$ha_mode = '';
									if (!empty($string['paras']['ha_mode'])) {
										$ha_mode = $string['paras']['ha_mode'];
									}
									//get_status获取ip
									$computer_hosts = '';
									$shard_arr = '';
									//调接口
									$this->load->model('Cluster_model');
									$data_string = array(
										'version' => '1.0',
										'job_id' => $res[$row]['id'],
										'job_type' => 'get_status',
										'timestamp' => '1435749309',
										'paras' => '{}'
									);
									$post_data = json_encode($data_string);
									$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
									$post_arr = json_decode($post_arr, TRUE);
									if (!empty($post_arr['attachment']['computer_step'][0]['computer_hosts'])) {
										$computer_hosts = $post_arr['attachment']['computer_step'][0]['computer_hosts'];
									}
									if (!empty($post_arr['attachment']['shard_step'][0]['shard_hosts'])) {
										$shard_hosts = $post_arr['attachment']['shard_step'][0]['shard_hosts'][0];
										foreach ($shard_hosts as $key => $value) {
											$shard_arr .= $value;
										}
									}
									$res[$row]['object'] = $nick_name;
									$list=array('nick_name'=>$nick_name,'shards'=> $shards ,'nodes'=>$nodes,'comps'=>$comps ,'max_connections '=>$max_connections,'innodb_size' =>$innodb_size,'cpu_cores'=>$cpu_cores,'ha_mode'=>$ha_mode,'computer_iplists'=>$string['paras']['computer_iplists'],'storage_iplists'=>$string['paras']['storage_iplists'],'comp_ips'=>$computer_hosts,'storage_ips'=>$shard_arr);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'delete_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									//get_status获取ip
									$computer_hosts = '';
									$shard_hosts = '';
									//调接口
									$this->load->model('Cluster_model');
									$data_string = array(
										'version' => '1.0',
										'job_id' => $res[$row]['id'],
										'job_type' => 'get_status',
										'timestamp' => '1435749309',
										'paras' => '{}'
									);
									$post_data = json_encode($data_string);
									$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
									$post_arr = json_decode($post_arr, TRUE);
									if (!empty($post_arr['attachment']['computer_step'][0]['computer_hosts'])) {
										$computer_hosts = $post_arr['attachment']['computer_step'][0]['computer_hosts'];
									}
									if (!empty($post_arr['attachment']['shard_step'][0]['storage_hosts'])) {
										$shard_hosts = $post_arr['attachment']['shard_step'][0]['storage_hosts'];
									}
									$res[$row]['object'] = $nick_name;
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'comp_ips'=>$computer_hosts,'storage_ips'=>$shard_hosts);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'add_shards') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}

									//get_status获取ip
									$shard_arr = '';
									//调接口
									$this->load->model('Cluster_model');
									$data_string = array(
										'version' => '1.0',
										'job_id' => $res[$row]['id'],
										'job_type' => 'get_status',
										'timestamp' => '1435749309',
										'paras' => '{}'
									);
									$post_data = json_encode($data_string);
									$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
									$post_arr = json_decode($post_arr, TRUE);
									if (!empty($post_arr['attachment']['shard_hosts'])) {
										$computer_hosts = $post_arr['attachment']['shard_hosts'][0];
										//存在多个shard时，todo
										foreach ($computer_hosts as $key => $value) {
											$shard_arr .= $value;
										}
									}
									$res[$row]['object'] = $nick_name;
									$list=array('nick_name'=>$nick_name,'shards'=> $string["paras"]["shards"] ,'storage_iplists'=>$string['paras']['storage_iplists'],'storage_ips'=>$shard_arr );
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'delete_shard') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$shard_name = '';
									if (!empty($string['paras']['shard_name'])) {
										$shard_name = $string['paras']['shard_name'];
									} else {
										if (!empty($string['paras']['shard_id']) && !empty($string['paras']['cluster_id'])) {
											$shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['shard_id']);
										}
									}
									$res[$row]['object'] = $nick_name . '(' . $shard_name . ')';
									$list=array('nick_name'=>$nick_name,'shard_name'=> $shard_name);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'backup_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['backup_cluster_name'])) {
										$nick_name = $string['paras']['backup_cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
									$list=array('nick_name'=>$nick_name);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'restore_new_cluster') {
								if (!empty($string)) {
									$backup_cluster_name = '';
									if (!empty($string['paras']['backup_cluster_name'])) {
										$backup_cluster_name = $string['paras']['backup_cluster_name'];
									}
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $backup_cluster_name;
									$list=array('backup_cluster_name'=>$backup_cluster_name,'nick_name'=>$nick_name);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'add_comps') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$comps = '';
									if (!empty($string['paras']['comps'])) {
										$comps = $string['paras']['comps'];
									}
									//get_status获取ip
									$computer_hosts = '';
									//调接口
									$this->load->model('Cluster_model');
									$data_string = array(
										'version' => '1.0',
										'job_id' => $res[$row]['id'],
										'job_type' => 'get_status',
										'timestamp' => '1435749309',
										'paras' => '{}'
									);
									$post_data = json_encode($data_string);
									$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
									$post_arr = json_decode($post_arr, TRUE);
									if (!empty($post_arr['attachment']['computer_hosts'])) {
										$computer_hosts = $post_arr['attachment']['computer_hosts'];
									}
									$res[$row]['object'] = $nick_name;
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'comps'=> $comps ,'computer_iplists'=>$string['paras']['computer_iplists'],'comp_ips'=>$computer_hosts );
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'delete_comp') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$comp_id = '';
									if (!empty($string['paras']['comp_id'])) {
										$comp_id = $string['paras']['comp_id'];
									}
									$comp_name = '';
									$ip = '';
									$port = '';
									if (!empty($string['paras']['comp_id'])) {
										$comp = $this->getCompName($string['paras']['cluster_id'], $string['paras']['comp_id']);
										if (!empty($comp)) {
											$comp_name = $comp[0]['name'];
											$ip = $comp[0]['hostaddr'];
											$port = $comp[0]['port'];
										} else {
											$comp_name = '';
											$ip = '';
											$port = '';
										}
									}
									$res[$row]['object'] = $nick_name;
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'comp_id'=> $comp_id ,'ip'=>$ip,'port'=>$port,'comp_name'=>$comp_name);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'add_nodes') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$shard_name = '';
									if (!empty($string['paras']['shard_id'])) {
										$shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['shard_id']);
									}
									$shard_id = '';
									if (!empty($string['paras']['shard_id'])) {
										$shard_id = $string['paras']['shard_id'];
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$nodes = '';
									if (!empty($string['paras']['nodes'])) {
										$nodes = $string['paras']['nodes'];
									}
									//get_status获取ip
									$shard_arr = '';
									//调接口
									$this->load->model('Cluster_model');
									$data_string = array(
										'version' => '1.0',
										'job_id' => $res[$row]['id'],
										'job_type' => 'get_status',
										'timestamp' => '1435749309',
										'paras' => '{}'
									);
									$post_data = json_encode($data_string);
									$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
									$post_arr = json_decode($post_arr, TRUE);
									if (!empty($post_arr['attachment']['shard_hosts'])) {
										$computer_hosts = $post_arr['attachment']['shard_hosts'][0];
										foreach ($computer_hosts as $key => $value) {
											$shard_arr .= $value;
										}
									}
									$res[$row]['object'] = $nick_name . '(' . $shard_name . ')';
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'shard_id'=> $shard_id ,'shard_name'=>$shard_name,'nodes'=>$nodes,'storage_ips'=>$shard_arr);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'delete_node') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$shard_name = '';
									if (!empty($string['paras']['shard_id'])) {
										$shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['shard_id']);
									}
									$shard_id = '';
									if (!empty($string['paras']['shard_id'])) {
										$shard_id = $string['paras']['shard_id'];
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$res[$row]['object'] = $nick_name . '(' . $shard_name . ')';
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'shard_id'=> $shard_id ,'shard_name'=>$shard_name,'ip'=>$hostaddr,'port'=>$port);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'mysqld_exporter') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$res[$row]['object'] = $hostaddr . ':' . $port;
									$list=array('ip'=>$hostaddr,'port'=>$port);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'postgres_exporter') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$res[$row]['object'] = $hostaddr . ':' . $port;
									$list=array('ip'=>$hostaddr,'port'=>$port);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'create_machine') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$rack_id = '';
									if (!empty($string['paras']['rack_id'])) {
										$rack_id = $string['paras']['rack_id'];
									}
									$datadir = '';
									if (!empty($string['paras']['datadir'])) {
										$datadir = $string['paras']['datadir'];
									}
									$logdir = '';
									if (!empty($string['paras']['logdir'])) {
										$logdir = $string['paras']['logdir'];
									}
									$wal_log_dir = '';
									if (!empty($string['paras']['wal_log_dir'])) {
										$wal_log_dir = $string['paras']['wal_log_dir'];
									}
									$comp_datadir = '';
									if (!empty($string['paras']['comp_datadir'])) {
										$comp_datadir = $string['paras']['comp_datadir'];
									}
									$res[$row]['object'] = $hostaddr;
									$list=array('ip'=>$hostaddr,'rack_id'=>$rack_id,'datadir'=>$datadir,'logdir'=>$logdir,'wal_log_dir'=>$wal_log_dir,'comp_datadir'=>$comp_datadir);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'update_machine') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$rack_id = '';
									if (!empty($string['paras']['rack_id'])) {
										$rack_id = $string['paras']['rack_id'];
									}
									$datadir = '';
									if (!empty($string['paras']['datadir'])) {
										$datadir = $string['paras']['datadir'];
									}
									$logdir = '';
									if (!empty($string['paras']['logdir'])) {
										$logdir = $string['paras']['logdir'];
									}
									$wal_log_dir = '';
									if (!empty($string['paras']['wal_log_dir'])) {
										$wal_log_dir = $string['paras']['wal_log_dir'];
									}
									$comp_datadir = '';
									if (!empty($string['paras']['comp_datadir'])) {
										$comp_datadir = $string['paras']['comp_datadir'];
									}
									$res[$row]['object'] = $hostaddr;
									$list=array('ip'=>$hostaddr,'rack_id'=>$rack_id,'datadir'=>$datadir,'logdir'=>$logdir,'wal_log_dir'=>$wal_log_dir,'comp_datadir'=>$comp_datadir);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'delete_machine') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$res[$row]['object'] = $hostaddr;
									$list=array('ip'=>$hostaddr);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'control_instance') {
								if (!empty($string)) {
									$object = '';
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
										$res[$row]['cluster_id'] = $cluster_id;
									}
									$nick_name = '';
									if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
										$object .= $nick_name;
									}
									$shard_id = '';
									$shard_name = '';
									if (!empty($string['paras']['machine_type'])) {
										if ($string['paras']['machine_type'] == 'storage') {
											if (!empty($string['paras']['shard_id'])) {
												$shard_id = $string['paras']['shard_id'];
											}
											if (!empty($string['paras']['shard_id'])) {
												$shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['shard_id']);
												$object .= '(' . $shard_name . ')';
											}
										} else if ($string['paras']['machine_type'] == 'computer') {
										}
									}
									$res[$row]['object'] = $object;
									if($string['paras']['machine_type'] =='storage'){
										$list=array('control'=>$string['paras']['control'],'machine_type'=>$string['paras']['machine_type'],'cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'ip'=>$hostaddr,'port'=>$port,'shard_id'=>$shard_id,'shard_name'=>$shard_name);
									}else{
										$list=array('control'=>$string['paras']['control'],'machine_type'=>$string['paras']['machine_type'],'cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'ip'=>$hostaddr,'port'=>$port);
									}
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'delete_backup_storage') {
								if (!empty($string)) {
									$name = '';
									if (!empty($string['paras']['name'])) {
										$name = $string['paras']['name'];
									}
									$res[$row]['object'] = $name;
									$list=array('name'=>$name);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'create_backup_storage') {
								if (!empty($string)) {
									$name = '';
									if (!empty($string['paras']['name'])) {
										$name = $string['paras']['name'];
									}
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$stype = '';
									if (!empty($string['paras']['stype'])) {
										$stype = $string['paras']['stype'];
									}
									$res[$row]['object'] = $name . '(' . $stype . ')';
									$list=array('name'=>$name,'stype'=>$stype,'ip'=>$hostaddr,'port'=>$port);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'update_backup_storage') {
								if (!empty($string)) {
									$name = '';
									if (!empty($string['paras']['name'])) {
										$name = $string['paras']['name'];
									}
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$stype = '';
									if (!empty($string['paras']['stype'])) {
										$stype = $string['paras']['stype'];
									}
									$res[$row]['object'] = $name . '(' . $stype . ')';
									$list=array('name'=>$name,'stype'=>$stype,'ip'=>$hostaddr,'port'=>$port);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'manual_switch') {
								if (!empty($string)) {
									$assign_hostaddr = '';
									if (!empty($string['paras']['assign_hostaddr'])) {
										$assign_hostaddr = $string['paras']['assign_hostaddr'];
									} else {
										$this->load->model('Cluster_model');
										$data_string = array(
											'version' => '1.0',
											'job_id' => $res[$row]['id'],
											'job_type' => 'get_status',
											'timestamp' => '1435749309',
											'paras' => '{}'
										);
										$post_data = json_encode($data_string);
										$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
										$post_arr = json_decode($post_arr, TRUE);
										if (!empty($post_arr['attachment']['new_master_host'])) {
											$assign_hostaddr = $post_arr['attachment']['new_master_host'];
										}
									}
									$master_hostaddr = '';
									if (!empty($string['paras']['master_hostaddr'])) {
										$master_hostaddr = $string['paras']['master_hostaddr'];
									}
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$shard_id = '';
									if (!empty($string['paras']['shard_id'])) {
										$shard_id = $string['paras']['shard_id'];
									}
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$shard_name = '';
									if (!empty($string['paras']['shard_id']) && !empty($string['paras']['cluster_id'])) {
										$shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['shard_id']);
									}
									$res[$row]['object'] = $nick_name . '(' . $shard_name . ')';
									$list=array('cluster_id'=>$cluster_id,'shard_id'=>$shard_id,'old_host'=>$master_hostaddr,'new_host'=>$assign_hostaddr);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'rebuild_node') {
								if (!empty($string)) {
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$shard_id = '';
									if (!empty($string['paras']['shard_id'])) {
										$shard_id = $string['paras']['shard_id'];
									}
									$shard_name = '';
									if (!empty($string['paras']['shard_id']) && !empty($string['paras']['cluster_id'])) {
										$shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['shard_id']);
									}
									//主备延迟
									$allow_replica_delay = '';
									if (!empty($string['paras']['allow_replica_delay'])) {
										$allow_replica_delay = $string['paras']['allow_replica_delay'];
									}
									$res[$row]['object'] = $nick_name . '(' . $shard_name . ')';
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'shard_id'=>$shard_id,'shard_name'=>$shard_name,'allow_pull_from_master'=>$string['paras']['allow_pull_from_master'],'allow_replica_delay'=>$allow_replica_delay,'rb_nodes'=>$string['paras']['rb_nodes']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'cluster_restore') {
								if (!empty($string)) {
									$dst_cluster_id = '';
									if (!empty($string['paras']['dst_cluster_id'])) {
										$dst_cluster_id = $string['paras']['dst_cluster_id'];
									}
									$src_cluster_id = '';
									$src_nick_name = '';
									if (!empty($string['paras']['src_cluster_id'])) {
										$src_cluster_id = $string['paras']['src_cluster_id'];
										$src_name = $this->getClusterName($src_cluster_id);
										if (!empty($src_name)) {
											$src_nick_name = $src_name[0]['nick_name'];
										} else {
											$src_nick_name = '';
										}
									}
									$restore_time = '';
									if (!empty($string['paras']['restore_time'])) {
										$restore_time = $string['paras']['restore_time'];
									}
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['dst_cluster_id'])) {
										$name = $this->getClusterName($string['paras']['dst_cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$res[$row]['object'] = $nick_name;
									$list=array('src_cluster_id'=>$src_cluster_id,'src_nick_name'=>$src_nick_name,'dst_cluster_id'=>$dst_cluster_id,'nick_name'=>$nick_name,'restore_time'=>$restore_time);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'manual_backup_cluster') {
								if (!empty($string)) {
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$res[$row]['object'] = $nick_name;
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'expand_cluster') {
								if (!empty($string)) {
									$cluster_id = '';
									if (!empty($string['paras']['cluster_id'])) {
										$cluster_id = $string['paras']['cluster_id'];
									}
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$src_shard_id = '';
									if (!empty($string['paras']['src_shard_id'])) {
										$src_shard_id = $string['paras']['src_shard_id'];
									}
									$src_shard_name = '';
									if (!empty($string['paras']['src_shard_id'])) {
										$src_shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['src_shard_id']);;
									}
									$dst_shard_name = '';
									if (!empty($string['paras']['dst_shard_id'])) {
										$dst_shard_name = $this->getShardName($string['paras']['cluster_id'], $string['paras']['dst_shard_id']);;
									}
									$dst_shard_id = '';
									if (!empty($string['paras']['dst_shard_id'])) {
										$dst_shard_id = $string['paras']['dst_shard_id'];
									}
									$res[$row]['object'] = $nick_name;
									$list=array('cluster_id'=>$cluster_id,'nick_name'=>$nick_name,'src_shard_id'=>$src_shard_id,'src_shard_name'=>$src_shard_name,'dst_shard_id'=>$dst_shard_id,'dst_shard_name'=>$dst_shard_name,'drop_old_table'=>$string['paras']['drop_old_table'],'table_list'=>$string['paras']['table_list']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == "logical_backup") {
							}
							if ($value2 == "table_repartition") {
								//需要获取是否删除源表
								$if_del=$this->getDelSourceTable($res[$row]['id']);
								if($if_del=='deleted'){
									$res[$row]['if_del'] = 'true';
								}else{
									$res[$row]['if_del'] = 'false';
								}
							}
							if ($value2 == 'delete_rcr') {
								if (!empty($string)) {
									$slave_cluster_id = '';$master_cluster_id='';
									if (!empty($string['paras']['cluster_id'])) {
										$slave_cluster_id = $string['paras']['cluster_id'];
									}
									if (!empty($string['paras']['master_info']['cluster_id'])) {
										$master_cluster_id = $string['paras']['master_info']['cluster_id'];
									}
									$res[$row]['object'] = $master_cluster_id.'→'.$slave_cluster_id;
									$list=array('master_meta_db'=>$string['paras']['master_info']['meta_db'],'slave_meta_db'=>$string['paras']['slave_rcr_meta'],'master_cluster_id'=>$master_cluster_id,'slave_cluster_id'=>$slave_cluster_id,'sync_host_delay'=>$string['paras']['sync_host_delay'],'delay_sync'=>$string['paras']['delay_sync']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'create_rcr') {
								if (!empty($string)) {
									$slave_cluster_id = '';$meta_db='';$master_cluster_id='';$slave_meta_db='';$sync_host_delay='';$delay_sync='';$child_slave_db='';$child_master_db='';
									if (!empty($string['paras']['cluster_id'])) {
										$slave_cluster_id = $string['paras']['cluster_id'];
									}
									if (!empty($string['paras']['master_info']['cluster_id'])) {
										$master_cluster_id = $string['paras']['master_info']['cluster_id'];
									}
									$res[$row]['object'] = $master_cluster_id.'→'.$slave_cluster_id;
									$list=array('master_meta_db'=>$string['paras']['master_info']['meta_db'],'slave_meta_db'=>$string['paras']['slave_rcr_meta'],'master_cluster_id'=>$master_cluster_id,'slave_cluster_id'=>$slave_cluster_id,'sync_host_delay'=>$string['paras']['sync_host_delay'],'delay_sync'=>$string['paras']['delay_sync']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
								}
							}
							if ($value2 == 'modify_rcr') {
								if (!empty($string)) {
									$slave_cluster_id='';$master_cluster_id='';$rcr_id='';
									if (!empty($string['paras']['rcr_id'])) {
										$rcr_id = $string['paras']['rcr_id'];
									}
									if (!empty($string['paras']['rcr_id'])) {
										$slave_cluster_id = $string['paras']['rcr_id'];
									}
									if (!empty($string['paras']['master_info']['cluster_id'])) {
										$master_cluster_id = $string['paras']['master_info']['cluster_id'];
									}
									$res[$row]['object'] = $master_cluster_id.'→'.$slave_cluster_id;
									$list=array('rcr_id'=>$rcr_id,'master_meta_db'=>$string['paras']['master_info']['meta_db'],'master_cluster_id'=>$master_cluster_id,'slave_cluster_id'=>$slave_cluster_id,'work_mode'=>$string['paras']['work_mode']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'manualsw_rcr') {
								if (!empty($string)) {
									$slave_cluster_id='';$master_cluster_id='';
									if (!empty($string['paras']['cluster_id'])) {
										$master_cluster_id = $string['paras']['cluster_id'];
									}
									if (!empty($string['paras']['slave_info']['cluster_id'])) {
										$slave_cluster_id = $string['paras']['slave_info']['cluster_id'];
									}
									$res[$row]['object'] = $master_cluster_id.'→'.$slave_cluster_id;
									$list=array('slave_meta_db'=> $string['paras']['slave_info']['meta_db'],'master_cluster_id'=>$master_cluster_id,'slave_cluster_id'=>$slave_cluster_id,'allow_sw_delay'=>$string['paras']['allow_sw_delay']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'update_machine_idc') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$res[$row]['object'] =$hostaddr;
									$list=array('ip'=>$hostaddr,'idc_id'=>$string['paras']['dc_id']);
									$res[$row]['list'] = $list;
								} else {
									$res[$row]['list'] = '';
									$res[$row]['object'] = '';
								}
							}
						} else {
							$res[$row]['job_type'] = '';
						}
					}

				}

			}
		}else{
			$this->load->model('Login_model');
			//先查表是否存在
			$sqldalay = "select TABLE_NAME from information_schema.TABLES where TABLE_NAME = 'cluster_job_record';";
			$resdalay = $this->Login_model->getList($sqldalay);
			if ($resdalay !== false) {
				$sql_sync = "select job_id,sync_num,job_type,status,memo,job_info as info,when_started,when_ended,user_name from cluster_job_record where 1=1";
				if ($username == 'super_dba') {
					$sql_sync .= "";
				} else {
					$sql_sync .= " and user_name='$username' ";
				}
				if(!empty($status)){
					$sql_sync .= " and status='$status' ";
				}
				$sql_sync .= "  order by id desc limit $pageSize offset $start";
				//print_r($sql_sync);exit;
				$res = $this->Login_model->getList($sql_sync);

				foreach ($res as $row => $value) {
					foreach ($value as $key2 => $value2) {
						if ($key2 == 'job_type') {
							if (!empty($value2)) {
								foreach ($job_type as $k2 => $v2) {
									if ($value2 == $v2['code']) {
										$res[$row]['job_type'] = $v2['name'];
										break;
									} else {
										$res[$row]['job_type'] = $value2;
									}
								}
							}
						}
						if ($key2 == 'memo') {
							$res[$row]['job_info'] = json_decode($value2,true);
						}
					}
				}
				$total_sql_sync = "select count(id) as count from cluster_job_record where 1=1";
				if ($username == 'super_dba') {
					$total_sql_sync .= "";
				} else {
					$total_sql_sync .= " and user_name='$username' ";
				}
				if(!empty($status)){
					$total_sql_sync .= " and status='$status' ";
				}
				$res_total = $this->Login_model->getList($total_sql_sync);

			}

		}
		if($res===false){
			$res = array();
		}
		$data['code'] = 200;
		$data['list'] = $res;
		$data['total'] = $res_total ? (int)$res_total[0]['count'] : 0;
		print_r(json_encode($data));
	}

	public function getNickName($cluster_name)
	{
		$sql = "select nick_name from db_clusters where name='$cluster_name' ";
		$this->load->model('Cluster_model');
		$res = $this->Cluster_model->getList($sql);
		return $res[0]['nick_name'];
	}

	public function getHomeOperationList()
	{
		$job_type = $this->job_type;
		$this->load->model('Cluster_model');
		//获取任务信息
		$sql = "select job_type,when_started,status,job_info,user_name from cluster_general_job_log where user_name!='internal_user'";
		$sql .= "  order by id desc limit 100";
		$res = $this->Cluster_model->getList($sql);
		if ($res === false) {
			$res = array();
		} else {
			foreach ($res as $row => $value) {
				foreach ($value as $key2 => $value2) {
					$string = json_decode($res[$row]['job_info'], true);
					if ($key2 == 'job_type') {
						if (!empty($value2)) {
							foreach ($job_type as $k2 => $v2) {
								if ($value2 == $v2['code']) {
									$res[$row]['job_type'] = $v2['name'];
									break;
								} else {
									$res[$row]['job_type'] = $value2;
								}
							}
							if ($value2 == 'create_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'delete_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'add_shards') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'delete_shard') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'backup_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['backup_cluster_name'])) {
										$nick_name = $string['paras']['backup_cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'restore_new_cluster') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'add_comps') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_id'])) {
										$name = $this->getClusterName($string['paras']['cluster_id']);
										if (!empty($name)) {
											$nick_name = $name[0]['nick_name'];
										} else {
											$nick_name = '';
										}
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'delete_comp') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'add_nodes') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'delete_node') {
								if (!empty($string)) {
									$nick_name = '';
									if (!empty($string['paras']['nick_name'])) {
										$nick_name = $string['paras']['nick_name'];
									} else if (!empty($string['paras']['cluster_name'])) {
										$nick_name = $string['paras']['cluster_name'];
									}
									$res[$row]['object'] = $nick_name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'mysqld_exporter') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$res[$row]['object'] = $hostaddr . ':' . $port;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'postgres_exporter') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$port = '';
									if (!empty($string['paras']['port'])) {
										$port = $string['paras']['port'];
									}
									$res[$row]['object'] = $hostaddr . ':' . $port;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'create_machine') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$res[$row]['object'] = $hostaddr;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'update_machine') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$res[$row]['object'] = $hostaddr;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'delete_machine') {
								if (!empty($string)) {
									$hostaddr = '';
									if (!empty($string['paras']['hostaddr'])) {
										$hostaddr = $string['paras']['hostaddr'];
									}
									$res[$row]['object'] = $hostaddr;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'control_instance') {
								if (!empty($string)) {
									$control = '';
									if (!empty($string['paras']['control'])) {
										$control = $string['paras']['control'];
									}
									$res[$row]['object'] = $control;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'delete_backup_storage') {
								if (!empty($string)) {
									$name = '';
									if (!empty($string['paras']['name'])) {
										$name = $string['paras']['name'];
									}
									$res[$row]['object'] = $name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'create_backup_storage') {
								if (!empty($string)) {
									$name = '';
									if (!empty($string['paras']['name'])) {
										$name = $string['paras']['name'];
									}
									$res[$row]['object'] = $name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'update_backup_storage') {
								if (!empty($string)) {
									$name = '';
									if (!empty($string['paras']['name'])) {
										$name = $string['paras']['name'];
									}
									$res[$row]['object'] = $name;
								} else {
									$res[$row]['object'] = '';
								}
							}
							if ($value2 == 'manual_switch') {
								$res[$row]['object'] = '';
							}
						} else {
							$res[$row]['job_type'] = '';
						}
					}

				}
			}
		}
		$data['code'] = 200;
		$data['list'] = $res;
		print_r(json_encode($data));
	}

	public function getOptionCount()
	{
		$job_type = $this->job_type;
		$this->load->model('Cluster_model');
		//获取任务信息
		$sql = "select job_type,count(job_type) as count from cluster_general_job_log  GROUP BY job_type;";
		$res = $this->Cluster_model->getList($sql);
		if ($res === false) {
			$res = array();
		} else {
			$type = array();
			$per_total = array();
			$numbers = array();
			foreach ($res as $key => $row) {
				foreach ($row as $k1 => $v1) {
					$job_type_arr = '';
					if ($k1 == "job_type") {
						$person_count = $this->getTypePer($v1);
						foreach ($job_type as $k2 => $v2) {
							if ($v1 == $v2['code']) {
								$job_type_arr = $v2['name'];
								break;
							}
						}
						$type[] = $job_type_arr;
						$per_total[] = (int)$person_count;
					}
					if ($k1 == "count") {
						$numbers[] = (int)$v1;
					}
				}
			}
			$data['code'] = 200;
			$data['type'] = $type;
			$data['numbers'] = $numbers;
			$data['per_total'] = $per_total;
			print_r(json_encode($data));
		}
	}

	public function getTypePer($job_type)
	{
		$this->load->model('Cluster_model');
		$sql = "select count(user_name) as count from ( select user_name from cluster_general_job_log where job_type='$job_type' GROUP BY user_name) as a;";
		$res = $this->Cluster_model->getList($sql);
		if ($res === false) {
			$count = 0;
		} else {
			$count = $res[0]['count'];
		}
		return $count;
	}

	public function getClusterName($id)
	{
		$sql = "select name,nick_name from db_clusters where id='$id'";
		$this->load->model('Cluster_model');
		$res = $this->Cluster_model->getList($sql);
		return $res;
	}

	public function getShardName($db_cluster_id, $id)
	{
		$sql = "select name from shards where id='$id' and db_cluster_id='$db_cluster_id'";
		$this->load->model('Cluster_model');
		$res = $this->Cluster_model->getList($sql);
		if (!empty($res)) {
			return $res[0]['name'];
		} else {
			return '';
		}
	}

	public function getCompName($db_cluster_id, $id)
	{
		$sql = "select name,hostaddr,port from comp_nodes where id='$id' and db_cluster_id='$db_cluster_id'";
		$this->load->model('Cluster_model');
		$res = $this->Cluster_model->getList($sql);
		return $res;
	}
	public function delTable()
	{
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		//调接口
		$this->load->model('Cluster_model');
		$post_data = str_replace("\\/", "/", json_encode($string));
		$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
		$post_arr = json_decode($post_arr, TRUE);
		$data = $post_arr;
		print_r(json_encode($data));
	}
	public function getDelSourceTable($id)
	{
		$sql = "select status from cluster_scheduler_jobs where  job_type='del_table_repartition_src_table' and memo like '%$id%'";
		$this->load->model('Cluster_model');
		$res = $this->Cluster_model->getList($sql);
		return $res[0]['status'];
	}


}
