package testutils

import (
	"encoding/json"
	"fmt"
	"strings"
)

// FormatPacketHex 格式化数据包为十六进制视图
func FormatPacketHex(data []byte) string {
	var hexStr strings.Builder

	hexStr.WriteString("原始数据:")
	hexStr.WriteString(fmt.Sprintf("%02X ", data))
	hexStr.WriteString("\n")
	hexStr.WriteString("----------------------------------------------------------------------\n")

	hexStr.WriteString(fmt.Sprintf("数据包长度: %d 字节\n", len(data)))
	hexStr.WriteString("偏移量    十六进制                                        ASCII\n")
	hexStr.WriteString("----------------------------------------------------------------------\n")

	for i := 0; i < len(data); i += 16 {
		// 偏移量
		hexStr.WriteString(fmt.Sprintf("%08X  ", i))

		// 十六进制部分 - 前8个字节
		for j := 0; j < 8; j++ {
			if i+j < len(data) {
				hexStr.WriteString(fmt.Sprintf("%02X ", data[i+j]))
			} else {
				hexStr.WriteString("   ")
			}
		}

		// 空格分隔
		hexStr.WriteString(" ")

		// 十六进制部分 - 后8个字节
		for j := 8; j < 16; j++ {
			if i+j < len(data) {
				hexStr.WriteString(fmt.Sprintf("%02X ", data[i+j]))
			} else {
				hexStr.WriteString("   ")
			}
		}

		// ASCII部分
		hexStr.WriteString(" |")
		for j := 0; j < 16; j++ {
			if i+j < len(data) {
				if data[i+j] >= 32 && data[i+j] <= 126 {
					hexStr.WriteString(string(data[i+j]))
				} else {
					hexStr.WriteString(".")
				}
			} else {
				hexStr.WriteString(" ")
			}
		}
		hexStr.WriteString("|\n")
	}

	return hexStr.String()
}

// IsValidJSON 检查数据是否为有效的JSON
func IsValidJSON(data []byte) bool {
	var js json.RawMessage
	return json.Unmarshal(data, &js) == nil
}
