package main

import (
	"fmt"
	"log"
	"net/http"
	"os"
	"streamServer/database"
	"streamServer/routes"
	"time"
)

func main() {
	//config.LoadConfig()

	dir, err := os.Getwd()
	if err != nil {
		fmt.Println("Error:", err)
		return
	}
	database.InitDB(dir + "/KunlunMonitor/streamServer/meta.json")

	// 你的其他代码
	if database.DB != nil {
		log.Println("数据库连接已成功，可以在其他包中使用 database.DB")
	}

	// 启动配置服务
	go func() {
		configRouter := routes.SetupConfigRouter()
		log.Fatal(configRouter.Run(":8081")) // 配置服务端口
	}()

	// 启动定时任务
	go startTask()

	// 启动同步服务
	syncRouter := routes.SetupSyncRouter()
	log.Fatal(syncRouter.Run(":18989"))

}

// 定时任务函数
func startTask() {
	ticker := time.NewTicker(1 * time.Second)
	defer ticker.Stop()

	for {
		select {
		case <-ticker.C:
			// 定时任务的逻辑，比如发送 HTTP 请求
			sendRequest()
		}
	}
}

// 模拟发送 HTTP 请求
func sendRequest() {
	resp, err := http.Get("http://localhost:8081/task")
	if err != nil {
		fmt.Println("Failed to send request:", err)
		return
	}
	defer resp.Body.Close()

	fmt.Println("Request sent, response status:", resp.StatusCode)
}
