#! /bin/bash
# Copyright (c) 2019 ZettaDB inc. All rights reserved.
# This source code is licensed under Apache 2.0 License,
# combined with Common Clause Condition 1.0, as detailed in the NOTICE file.

cd /kunlun
. ./env.sh

test -w /proc/sys/kernel/core_pattern && echo "core.%e.%p.%t" > /proc/sys/kernel/core_pattern

metaseeds="$1"
localip="${2:-`hostname`}"
clumgrhosts="$3"
SAVE_IFS="$IFS"
initconfig=""
IFS=","
for addr in $clumgrhosts; do
	initconfig="${initconfig}$addr:28001:0,"
done
IFS="$SAVE_IFS"
cd /kunlun

# change host/port if necessary.
if test ! "$metaseeds" = ""; then
	bash change_config.sh $CLMGR_DIR/conf/cluster_mgr.cnf meta_group_seeds "$metaseeds"
fi
bash change_config.sh $CLMGR_DIR/conf/cluster_mgr.cnf raft_group_member_init_config "$initconfig"
bash change_config.sh $CLMGR_DIR/conf/cluster_mgr.cnf brpc_http_port 28000
bash change_config.sh $CLMGR_DIR/conf/cluster_mgr.cnf brpc_raft_port 28001
bash change_config.sh $CLMGR_DIR/conf/cluster_mgr.cnf prometheus_port_start 57010
bash change_config.sh $CLMGR_DIR/conf/cluster_mgr.cnf local_ip "$localip"

# start cluster_mgr
cd /kunlun/$CLMGR_DIR/bin
bash start_cluster_mgr.sh >& run.log </dev/null &

/bin/bash

