<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MetadataController extends CI_Controller
{
    /**
     * @var CI_Config
     */
    public $config;

    /**
     * @var CI_Loader
     */
    public $load;

    private $saas_server;
    private $config_items = array();
    public $Change_model;
    public $Cluster_model;

    public function __construct()
    {
        parent::__construct();
        
        // 设置响应头
        header('Access-Control-Allow-Origin:*');
        header('Access-Control-Allow-Headers: Content-Type,Content-Length,Accept-Encoding,X-Requested-with, Origin');
        header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');
        header('Access-Control-Allow-Headers:x-requested-with,content-type,Token');
        header('Content-Type: application/json;charset=utf-8');

        // 加载配置
        $this->config->load('myconfig');
        $this->config_items = $this->config->item('myconfig');
        
        // 加载模型
        $this->load->model('Change_model');
        $this->load->model('Cluster_model');

        // 初始化配置项
        if(is_array($this->config_items)) {
            $this->saas_server = isset($this->config_items['saas_server']) ? $this->config_items['saas_server'] : '';
        }
    }

    public function getMetadata()
    {
        try {
            // 获取 POST 数据
            $raw_input = file_get_contents('php://input');
            $postData = json_decode($raw_input, true);
            
            // 记录请求数据
            log_message('debug', 'GetMetadata request data: ' . $raw_input);

            // 验证数据格式
            if (empty($postData) || !is_array($postData)) {
                throw new Exception('Invalid request format');
            }

            // 验证必需参数
            if (!isset($postData['user_name']) || empty($postData['user_name'])) {
                throw new Exception('Missing required parameter: user_name');
            }

            // 读取meta.json文件
            $meta_file = APPPATH . '../json/meta.json';
            if (!file_exists($meta_file)) {
                throw new Exception('Meta configuration file not found');
            }

            $meta_config = json_decode(file_get_contents($meta_file), true);
            if (!$meta_config || !isset($meta_config['nodes']) || empty($meta_config['nodes'])) {
                throw new Exception('Invalid meta configuration');
            }

            // 遍历节点尝试连接
            $meta_info = null;
            foreach ($meta_config['nodes'] as $node) {
                $result = $this->getMeta($node['ip'], $node['port']);
                if ($result && isset($result['code']) && $result['code'] == 200) {
                    $meta_info = $result;
                    break;
                }
                log_message('debug', 'Failed to connect to node: ' . $node['ip'] . ':' . $node['port']);
            }

            if (!$meta_info) {
                throw new Exception('Failed to connect to any meta node');
            }

            // 更新配置文件
            //$this->updateMetaConfig($meta_info[0], $meta_info[1]);
            
            // 返回成功响应
            $response = array(
                'code' => 200,
                'message' => 'Success',
                'data' => $meta_info
            );

        } catch (Exception $e) {
            log_message('error', 'GetMetadata error: ' . $e->getMessage());
            $response = array(
                'code' => 500,
                'message' => $e->getMessage()
            );
        }

        // 设置响应头
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($response);
    }

    private function updateMetaConfig($host, $port)
    {
        try {
            // 1. 更新 myconfig.php
            $config_file = APPPATH . 'config/myconfig.php';
            $config_content = file_get_contents($config_file);
            
            $pattern_host = "/\\\$config\['meta_db_host'\]\s*=\s*'[^']*'/";
            $pattern_port = "/\\\$config\['meta_db_port'\]\s*=\s*'[^']*'/";
            
            $new_host = "\$config['meta_db_host'] = '" . $host . "'";
            $new_port = "\$config['meta_db_port'] = '" . $port . "'";
            
            $config_content = preg_replace($pattern_host, $new_host, $config_content);
            $config_content = preg_replace($pattern_port, $new_port, $config_content);
            
            if (file_put_contents($config_file, $config_content) === false) {
                throw new Exception('Failed to update myconfig.php');
            }
            
            // 2. 更新 database.php
            $database_config = "<?php
defined('BASEPATH') OR exit('No direct script access allowed');
\$active_group = 'default';
\$query_builder = TRUE;
\$db_debug = FALSE;
\$db['role'] = array(
    'dsn' => '',
    'hostname' => '$host',
    'port' => $port,
    'username' => 'pgx',
    'password' => 'pgx_pwd',
    'database' => 'kunlun_dba_tools_db',
    'dbdriver' => 'mysqli',
    'dbprefix' => '',
    'pconnect' => FALSE,
    'db_debug' => FALSE,
    'cache_on' => FALSE,
    'cachedir' => '',
    'char_set' => 'utf8',
    'dbcollat' => 'utf8_general_ci',
    'swap_pre' => '',
    'encrypt' => FALSE,
    'compress' => FALSE,
    'stricton' => FALSE,
    'failover' => array(),
    'options' => array(PDO::ATTR_TIMEOUT => 5),
    'save_queries' => TRUE
);
\$db['default'] = array(
    'dsn' => '',
    'hostname' => '$host',
    'port' => $port,
    'username' => 'pgx',
    'password' => 'pgx_pwd',
    'database' => 'kunlun_metadata_db',
    'dbdriver' => 'mysqli',
    'dbprefix' => '',
    'pconnect' => FALSE,
    'db_debug' => FALSE,
    'cache_on' => FALSE,
    'cachedir' => '',
    'char_set' => 'utf8',
    'dbcollat' => 'utf8_general_ci',
    'swap_pre' => '',
    'encrypt' => FALSE,
    'compress' => FALSE,
    'stricton' => FALSE,
    'failover' => array(),
    'options' => array(PDO::ATTR_TIMEOUT => 5),
    'save_queries' => TRUE
);";

            if (file_put_contents(APPPATH . 'config/database.php', $database_config) === false) {
                throw new Exception('Failed to update database.php');
            }

            // 3. 更新 meta.json
            $meta_data = array(
                'nodes' => array(
                    array(
                        'ip' => $host,
                        'port' => $port
                    )
                ),
                'saas' => 0,
                'version' => '1.4.1'
            );

            if (file_put_contents(APPPATH . '../json/meta.json', json_encode($meta_data, JSON_PRETTY_PRINT)) === false) {
                throw new Exception('Failed to update meta.json');
            }
            
            log_message('debug', 'All configuration files updated successfully');
            
        } catch (Exception $e) {
            log_message('error', 'Failed to update configuration: ' . $e->getMessage());
            throw $e;
        }
    }

    public function getMeta($ip, $port)
    {
        //记录输入参数
        log_message('debug', 'getMeta input - IP: ' . $ip . ', Port: ' . $port);
        
        try {
            //先查主是否通,不通才遍历
            $sql_master = "select hostaddr,port from cluster_mgr_nodes where member_state='source'";
            log_message('debug', 'Executing SQL: ' . $sql_master);
            
            $res_master = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql_master);
            log_message('debug', 'SQL result: ' . json_encode($res_master));
            
            if ($res_master['code'] == 200) {
                $host = $this->Cluster_model->ipTranslation($res_master[0]);
                log_message('debug', 'Translated IP: ' . $host);
                
                // 添加重试机制
                $max_retries = 3;
                $retry_count = 0;
                $cluster_mgr_result = false;
                
                while ($retry_count < $max_retries && !$cluster_mgr_result) {
                    $cluster_mgr_result = $this->getClusterMgrMaster($host, $res_master[1]);
                    if (!$cluster_mgr_result) {
                        $retry_count++;
                        if ($retry_count < $max_retries) {
                            log_message('debug', "Retrying connection to $host:{$res_master[1]}, attempt $retry_count of $max_retries");
                            sleep(1); // 等待1秒后重试
                        }
                    }
                }
                
                log_message('debug', 'Cluster MGR result: ' . ($cluster_mgr_result ? 'true' : 'false'));
                
                if ($cluster_mgr_result === true) {
                    $data[0] = $host;
                    $data[1] = $res_master[1];
                    $data['code'] = 200;
                    return $data;
                }

                $sql = "select hostaddr,port from cluster_mgr_nodes where hostaddr!='$res_master[0]' or port!='$res_master[1]'";
                $res = $this->Change_model->getAllMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql, '');
                
                if ($res['code'] == 200 && !empty($res['list'])) {
                    foreach ($res['list'] as $k => $v) {
                        // 对每个备用节点也使用重试机制
                        $retry_count = 0;
                        $cluster_mgr_result = false;
                        
                        while ($retry_count < $max_retries && !$cluster_mgr_result) {
                            $cluster_mgr_result = $this->getClusterMgrMaster($host, $v['port']);
                            if (!$cluster_mgr_result) {
                                $retry_count++;
                                if ($retry_count < $max_retries) {
                                    log_message('debug', "Retrying connection to $host:{$v['port']}, attempt $retry_count of $max_retries");
                                    sleep(1);
                                }
                            }
                        }
                        
                        if ($cluster_mgr_result === true) {
                            $data[0] = $host;
                            $data[1] = $v['port'];
                            $data['code'] = 200;
                            return $data;
                        }
                    }
                    $data['code'] = 500;
                    $data[0] = 'Unable to connect to any cluster manager node after retries';
                } else {
                    $data['code'] = 500;
                    $data[0] = 'No available backup nodes found in cluster_mgr_nodes';
                }
            } else {
                $data['code'] = $res_master['code'];
                $data[0] = 'Failed to query cluster_mgr_nodes table: ' . $res_master[0];
            }
            
        } catch (Exception $e) {
            log_message('error', 'Error in getMeta: ' . $e->getMessage());
            $data['code'] = 500;
            $data[0] = 'Internal error: ' . $e->getMessage();
        }
        
        return $data;
    }

    private function getClusterMgrMaster($ip, $port)
    {
        $url = 'http://' . $ip . ':' . $port . '/HttpService/Emit';
        log_message('debug', 'Attempting to connect to: ' . $url);
        
        $ch = curl_init();
        if ($ch === false) {
            log_message('error', 'Failed to initialize CURL');
            return false;
        }
        
        // 设置CURL选项
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => true,
            CURLOPT_CONNECTTIMEOUT => 1,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => array(
                'User-Agent: KunlunMonitor/1.0',
                'Accept: */*'
            )
        ));
        
        $result = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        curl_close($ch);
        
        if ($result === false) {
            log_message('error', 'CURL execution failed: ' . $error);
            return false;
        }
        
        // 检查连接是否成功（包括HTTP/0.9响应）
        if ($httpcode == 0 && $result !== false) {
            log_message('debug', 'Received HTTP/0.9 response, considering as success');
            return true;
        }
        
        log_message('debug', 'HTTP response code: ' . $httpcode);
        return $httpcode == 200;
    }

    private function cUrlData($url, $data)
    {
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $this->saas_server . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $data,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                ),
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function getRbrMain($ip, $port, $sql)
    {
        $res = $this->Change_model->getMysql($ip, $port, 'pgx', 'pgx_pwd', 'kunlun_metadata_db', $sql);
        $res_count = count($res);
        $data['list'] = $res;
        $data['count'] = $res_count;
        return $data;
    }
} 