/*-------------------------------------------------------------------------
 *
 * com_common.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		Common types and symbols used by both PostgreSQL and MySQL protocols.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/com_common.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef COM_COMMON_H
#define COM_COMMON_H
extern int PostPortNumber;
extern int MySQLPortNumber;
#define DEF_MYSQL_PORT 5306
typedef enum enumFrontEndType {
	FE_UNKNOWN, FE_PG, FE_MYSQL
} enumFrontEndType;

extern int g_client_connection_type;

typedef enum Choice {OPTIONAL, REQUIRED, PROHIBITED} Choice;
extern const char *FrontEndTypeStr[];

inline static enumFrontEndType GetListenSocketType(int portNumber)
{
	if (portNumber == PostPortNumber) return FE_PG;
	else if (portNumber == MySQLPortNumber) return FE_MYSQL;
	else return FE_UNKNOWN;
}

#endif // !COM_COMMON_H
