#ifndef MONITOR_H
#define MONITOR_H

#include "postgres.h"

#include "port/atomics.h"
#include "utils/tuplestore.h"

#define PERCENTILE_SIZE 1000
#define HISTORY_NUM 4
#define CPU_TIME_HISTORY 6
struct percentile_t
{
	pg_atomic_uint64 values[PERCENTILE_SIZE];
	pg_atomic_uint64 total;
	uint64_t prev_values[HISTORY_NUM][PERCENTILE_SIZE];
	uint64_t prev_totals[HISTORY_NUM];
	uint64_t latest_history;
	double range_min;
	double range_max;
	double range_deduct;
	double range_mult;
};

struct cpu_usage_t
{
	//  time used of user and system
	pg_atomic_uint64 cpu_utime_us;
	pg_atomic_uint64 cpu_stime_us;
	uint64_t lastest_history;
	uint64_t utime_history[CPU_TIME_HISTORY];
	uint64_t stime_history[CPU_TIME_HISTORY];
	struct timeval history_tv[CPU_TIME_HISTORY];
	double percentile_history[CPU_TIME_HISTORY];
};

struct ShmGlobalMonitor_t
{
	uint64 reboot_count;
	int64 tcp_retrans_segs_initval;
	pg_atomic_uint64 statements_total;
	pg_atomic_uint64 statements_errs;

	pg_atomic_uint64 transactions;
	pg_atomic_uint64 rollbacked_transactions;
	pg_atomic_uint64 distributed_transactions;
	pg_atomic_uint64 distributed_transaction_errs;

	pg_atomic_uint64 client_connections_open;
	pg_atomic_uint64 client_connections_closed;

	pg_atomic_uint64 shard_connections_open;
	pg_atomic_uint64 shard_connections_closed;
	pg_atomic_uint64 shard_connect_errs;
	pg_atomic_uint64 shard_sql_errs;
	pg_atomic_uint64 shard_read_tuples;

	pg_atomic_uint64 mdserver_connect_errs;
	pg_atomic_uint64 mdserver_sql_errs;

	struct cpu_usage_t cpu_usage;

	struct percentile_t perf_percentitle;
	struct percentile_t tx_log_percentitle;
	struct percentile_t tx_commit_percentitle;
};

extern struct ShmGlobalMonitor_t *GlobalMonitor;

extern void ShmGlobalMonitorInit(void);
extern void monitor_statement_latency(double latency_ms);
extern void monitor_tx_log_latency(TimestampTz start, TimestampTz end);
extern void monitor_tx_commit_latency(TimestampTz start, TimestampTz end);
extern void monitor_add_shard_read_tuples(void);
extern void monitor_periodic_tick(void);

#define Natts_monitor 3
#define Anum_monitor_metric_name 0
#define Anum_monitor_metric_value 1
#define Anum_monitor_metric_desc 2

#endif