/*-------------------------------------------------------------------------
 *
 * mysql_field.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		Field metadata for MySQL protocol.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/mysql_field.h
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"
#include "libmysql/field_types.h"

typedef struct MySQLFieldMeta {
  NameData db_name;
  NameData table_name, org_table_name;
  NameData col_name, org_col_name;
  unsigned long length;
  unsigned int charsetnr, flags;
  int decimals;
  enum_field_types type;
  Oid pg_typid;
} MySQLFieldMeta;

struct FormData_pg_attribute;

extern bool field_is_multi_byte_text(MySQLFieldMeta *field);

// if field charset or client charset is not multi-byte, no conversion needed
extern bool field_needs_charset_conversion(MySQLFieldMeta *field);

// each multi byte char takes 1-N bytes, varying with client charset. compute
// max possible space in bytes needed for the field value given the field
// length(NO. of chars)
extern size_t calc_multi_byte_text_field_size(MySQLFieldMeta *field);

