/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.Backend;

class XactListener {
    private static final Deque<TransactionListener> s_listeners = new ArrayDeque<TransactionListener>();

    XactListener() {
    }

    static void onAbort() throws SQLException {
        for (TransactionListener listener : s_listeners.toArray(new TransactionListener[s_listeners.size()])) {
            listener.onAbort(Backend.getSession());
        }
    }

    static void onCommit() throws SQLException {
        for (TransactionListener listener : s_listeners.toArray(new TransactionListener[s_listeners.size()])) {
            listener.onCommit(Backend.getSession());
        }
    }

    static void onPrepare() throws SQLException {
        for (TransactionListener listener : s_listeners.toArray(new TransactionListener[s_listeners.size()])) {
            listener.onPrepare(Backend.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(TransactionListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (s_listeners.contains(listener)) {
                return;
            }
            s_listeners.push(listener);
            if (1 == s_listeners.size()) {
                XactListener._register();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(TransactionListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (!s_listeners.remove(listener)) {
                return;
            }
            if (0 == s_listeners.size()) {
                XactListener._unregister();
            }
        }
    }

    private static native void _register();

    private static native void _unregister();
}

