/*-------------------------------------------------------------------------
 *
 * mysql_com_sys.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		Macros and types for platform independence.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/mysql_com_sys.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef MYSQL_COMM_SYS_H
#define MYSQL_COMM_SYS_H

#include <unistd.h>
#include <arpa/inet.h>


#ifndef MY_ATTRIBUTE
#if defined(__GNUC__) || defined(__clang__)
#define MY_ATTRIBUTE(A) __attribute__(A)
#else
#define MY_ATTRIBUTE(A)
#endif
#endif

#ifdef _WIN32

#define FN_DIRSEP '\\'

#define socket_errno WSAGetLastError()
#define SOCKET_EINTR WSAEINTR
#define SOCKET_EAGAIN WSAEINPROGRESS
#define SOCKET_EWOULDBLOCK WSAEWOULDBLOCK
#define SOCKET_EADDRINUSE WSAEADDRINUSE
#define SOCKET_ETIMEDOUT WSAETIMEDOUT
#define SOCKET_ECONNRESET WSAECONNRESET
#define SOCKET_ENFILE ENFILE
#define SOCKET_EMFILE EMFILE


typedef int MY_MODE;
typedef int mode_t;
typedef int socket_len_t;
typedef SOCKET my_socket;
typedef DWORD my_thread_t;

typedef struct thread_attr {
  DWORD dwStackSize;
  int detachstate;
} my_thread_attr_t;


#else

#define FN_DIRSEP '/'

typedef mode_t MY_MODE;
typedef socklen_t socket_len_t;
typedef int my_socket; /* File descriptor for sockets */
typedef pthread_t my_thread_t;
typedef pthread_attr_t my_thread_attr_t;

#define socket_errno errno

#ifndef closesocket
#define closesocket(A) close(A)
#endif


#define SOCKET_EINTR EINTR
#define SOCKET_EAGAIN EAGAIN
#define SOCKET_EWOULDBLOCK EWOULDBLOCK
#define SOCKET_EADDRINUSE EADDRINUSE
#define SOCKET_ETIMEDOUT ETIMEDOUT
#define SOCKET_ECONNRESET ECONNRESET
#define SOCKET_ENFILE ENFILE
#define SOCKET_EMFILE EMFILE

#endif


typedef struct MYSQL_SOCKET {
  my_socket fd;
} MYSQL_SOCKET;

#ifndef MYSQL_ABI_CHECK
#if defined(_WIN32)
#include <windows.h>
#else
#include <pthread.h>  // IWYU pragma: export
#include <sched.h>    // IWYU pragma: export
#endif
#endif /* MYSQL_ABI_CHECK */


#ifndef _WIN32
#define INVALID_SOCKET -1
#endif /* _WIN32 */

#define SIZEOF_CHARP 8 //(sizeof(char*))

#endif // !MYSQL_COMM_SYS_H
