/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Savepoint;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;

public class PgSavepoint
implements Savepoint {
    private static final WeakHashMap<PgSavepoint, Boolean> s_knownSavepoints = new WeakHashMap();
    private final String m_name;
    private int m_xactId;
    private int m_nestLevel;
    private boolean m_reborn = false;
    private static PgSavepoint s_nursery;

    private static void forgetNestLevelsGE(int nestLevel) {
        assert (Backend.threadMayEnterPG());
        Iterator<PgSavepoint> it = s_knownSavepoints.keySet().iterator();
        while (it.hasNext()) {
            PgSavepoint sp = it.next();
            if (sp.m_nestLevel < nestLevel) continue;
            it.remove();
            sp.m_nestLevel = 0;
        }
    }

    private PgSavepoint(String name) {
        this.m_name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PgSavepoint set(String name) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint sp;
            s_nursery = sp = new PgSavepoint(name);
            try {
                sp.m_xactId = sp._set(name);
            }
            finally {
                s_nursery = null;
            }
            s_knownSavepoints.put(sp, Boolean.TRUE);
            return sp;
        }
    }

    static PgSavepoint forId(int savepointId) {
        if (savepointId != 0) {
            assert (Backend.threadMayEnterPG());
            if (null != s_nursery) {
                PgSavepoint sp = s_nursery;
                sp.m_xactId = savepointId;
                s_nursery = null;
                return sp;
            }
            for (PgSavepoint sp : s_knownSavepoints.keySet()) {
                if (savepointId != sp.m_xactId) continue;
                return sp;
            }
        }
        return null;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (0 == this.m_nestLevel) {
                throw new SQLNonTransientException("attempt to release savepoint " + (null != this.m_name ? '\"' + this.m_name + '\"' : Integer.valueOf(this.m_xactId)) + " that is no longer valid", "3B001");
            }
            PgSavepoint._release(this.m_xactId, this.m_nestLevel);
            PgSavepoint.forgetNestLevelsGE(this.m_nestLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (0 == this.m_nestLevel) {
                throw new SQLNonTransientException("attempt to roll back to savepoint " + (null != this.m_name ? '\"' + this.m_name + '\"' : Integer.valueOf(this.m_xactId)) + " that is no longer valid", "3B001");
            }
            PgSavepoint._rollback(this.m_xactId, this.m_nestLevel);
            PgSavepoint.forgetNestLevelsGE(1 + this.m_nestLevel);
            try {
                s_nursery = this;
                this.m_xactId = this._set(this.m_name);
                this.m_reborn = true;
            }
            finally {
                s_nursery = null;
            }
        }
    }

    @Override
    public String getSavepointName() throws SQLException {
        return this.m_name;
    }

    @Override
    public int getSavepointId() {
        return this.m_xactId;
    }

    public void onInvocationExit(boolean withError) throws SQLException {
        assert (Backend.threadMayEnterPG());
        if (this.m_nestLevel == 0) {
            return;
        }
        Logger logger = Logger.getAnonymousLogger();
        if (!withError && (this.m_reborn || Backend.isReleaseLingeringSavepoints())) {
            if (!this.m_reborn) {
                logger.warning("Releasing savepoint '" + this.m_xactId + "' since its lifespan exceeds that of the function where it was set");
            }
            PgSavepoint._release(this.m_xactId, this.m_nestLevel);
            PgSavepoint.forgetNestLevelsGE(this.m_nestLevel);
        } else {
            if (!withError || !this.m_reborn) {
                logger.warning("Rolling back to savepoint '" + this.m_xactId + "' since its lifespan exceeds that of the function where it was set");
            }
            PgSavepoint._rollback(this.m_xactId, this.m_nestLevel);
            PgSavepoint.forgetNestLevelsGE(this.m_nestLevel);
        }
    }

    private native int _set(String var1) throws SQLException;

    private static native void _release(int var0, int var1) throws SQLException;

    private static native void _rollback(int var0, int var1) throws SQLException;
}

