/* -------------------------------------------------------------------------
 *
 * pg_attr_ext.h
 *	  definition of extended properties of an attribute (pg_attr_ext)
 *
 * Copyright (c) 2025, Klustron, www.klustron.com, all rights reserved.
 *
 * src/include/catalog/pg_attr_ext.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 * -------------------------------------------------------------------------
 */
#ifndef PG_ATTR_EXT_H
#define PG_ATTR_EXT_H

#include "catalog/genbki.h"
#include "catalog/pg_attr_ext_d.h"
/*
  Extra properties of columns.
  Only if a column has non-default values for some of such properties does it have an entry in this table.
*/
CATALOG(pg_attr_ext,12354,AttributeExtRelationId) BKI_WITHOUT_OIDS
{
	Oid			attrelid;
	int16		attnum;
	char		visibility BKI_DEFAULT('v'); /* visible by default, invisible if added as PK or row version */
	char		auto_add_kind BKI_DEFAULT('\0'); /* 0 if not added implicitly automatically, otherwise there could be several scenarios a column is auto added to a table */
	char		storage_scheme BKI_DEFAULT('\0'); /* 0 if stored in row, otherwise such fields are sent to storage node as 0 byte. */
	char		encrypt_algo BKI_DEFAULT('\0'); /* 0 if not encrypted*/
	int32		encrypt_key BKI_DEFAULT(0);  /* encryption key id, 0 if not encrypted*/
	int64		transmited_size BKI_DEFAULT(0); /* set if transmitting a huge field as a stream, so a row can be inserted given initial part, and use this for incremental appends */

#ifdef CATALOG_VARLEN           /* variable-length fields start here */
	text		storage_ref[1] BKI_DEFAULT(_null_); /* storage reference, e.g. path or object key */
#endif
} FormData_pg_attr_ext;

#define ATTR_VISIBILITY_NORMAL 'v' /* regular visible column */
#define ATTR_VISIBILITY_INVISIBLE 'i' /* invisible column */

#define ATTR_AUTO_ADD_PK 'p'	/* auto added as primary key, must be an integer bound to a sequence */
#define ATTR_AUTO_ADD_EDGE1 'e' /* added as graph node table's simple edges column */
#define ATTR_AUTO_ADD_EDGE2 'E' /* added as graph node table's complex edges column */
#define ATTR_AUTO_ADD_ROWVSN 'v' /* added as row version column */
#define ATTR_AUTO_ADD_TREE_BRANCH 't' /* added as tree branches column */
#define ATTR_AUTO_ADD_NODE_ID 'n' /* added as node id column of tree or graph */

#define ATTR_STORAGE_LO_OBJSTOR 'o' /* large object stored in object store */
#define ATTR_STORAGE_LO_DFS 'd' /* large object stored in a distributed FS mounted to comp node's server */

#define ATTR_ENCRYPT_AES 'a'
#define ATTR_ENCRYPT_GUOMI_SM4 'g'

/* there could be more visibility settings */



/* ----------------
 *		Form_pg_attr_ext corresponds to a pointer to a tuple with
 *		the format of pg_attr_ext relation.
 * ----------------
 */
typedef FormData_pg_attr_ext *Form_pg_attr_ext;


extern int16 move_invisible_cols(Oid relid, int16*pnatts);
extern void modify_catalog_attnum(Oid relid, int16 oldattnum, int16 newattnum);
#endif							/* PG_ATTR_EXT_H */
