/*-------------------------------------------------------------------------
 *
 * pg_matview.h
 * 		extra information about materilized views
 *
 * Copyright (c) 2019-2025 Klustron inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * src/include/catalog/pg_matview.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_MATVIEW_H
#define PG_MATVIEW_H

#include "catalog/genbki.h"
#include "catalog/pg_matview_d.h"

/*
 * extra information about materilized views.
 * matviews that are not VARYING and do not use a partitioned table to store its result-set are
 * not in this table.
 * */
CATALOG(pg_matview,12353,MatViewRelationId) BKI_WITHOUT_OIDS
{
	Oid  mv_relid; /* OID of the matview */
	Oid  storage_relid BKI_DEFAULT(0);/* the relation that stores this matview's query result. InvalidOid if storing in the same relation(default behavior) */
	bool varying; /* a matview that's not VARYING may store its result-set in a partitioned table, hence this field. */
	/* only varying matviews have below fields */
	oidvector rels; /* OIDs of relations this matview queries, i.e. they are involved in the matview's query. */
	oidvector idxes; /* OIDs of PK/unique index of corresponding(at same slot) relation in rels that should be used to look for matching rows */
	oidvector storage_idxes; /* OIDs of indexes created for the storage relation of the matview */
	oidvector reqcols_pairs; /* column pairs, source(higher 16bit)->dest(lower 16bit) */
}
FormData_pg_matview;

typedef FormData_pg_matview*Form_pg_matview;

#endif /* !PG_MATVIEW_H */
