set remote_rel.apply_ddl_log_mode=1;

CREATE OR REPLACE FUNCTION pg_catalog.utc_timestamp() RETURNS  timestamp AS $$ select CURRENT_TIMESTAMP(0) at time zone 'UTC'; $$ LANGUAGE sql PARALLEL SAFE;

CREATE OR REPLACE FUNCTION pg_catalog.timediff(ts1 timestamptz, ts2 timestamp) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.timediff(ts1 timestamptz, ts2 timestamptz) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.timediff(ts1 timestamp, ts2 timestamptz) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.timediff(ts1 timestamp, ts2 timestamp) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.nextval_safe(seq_name varchar(64)) RETURNS bigint AS $$ select nextval(seq_name::regclass)::bigint; $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION pg_catalog.round(d double precision, n int)  returns double as $$ select round($1::numeric,$2)::double;  $$ language sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.curdate() returns date as $$ select current_date; $$ language sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.curtime() returns time as $$ select current_time(0)::time; $$ language sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.date_sub(date, interval) returns date as $$ select ($1 - $2)::date; $$ language sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.date_sub(datetime, interval) returns datetime as $$ select ($1 - $2)::datetime; $$ language sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.date_add(date, interval) returns date as $$ select ($1 + $2)::date; $$ language sql PARALLEL safe;

CREATE OR REPLACE FUNCTION pg_catalog.date_add(datetime, interval) returns datetime as $$ select ($1 + $2)::datetime; $$ language sql PARALLEL safe;

CREATE FUNCTION pg_catalog.numeric_text_eq (numeric,  text) RETURNS bool AS 'select $1 =$2::numeric' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.numeric_text_neq(numeric,  text) RETURNS bool AS 'select $1<>$2::numeric' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE OPERATOR pg_catalog.=   (LEFTARG = numeric, RIGHTARG = text, PROCEDURE = numeric_text_eq, COMMUTATOR = '=' );
CREATE OPERATOR pg_catalog.<>  (LEFTARG = numeric, RIGHTARG = text, PROCEDURE = numeric_text_neq, COMMUTATOR = '<>' );

CREATE FUNCTION pg_catalog.text_numeric_eq (text, numeric) RETURNS bool AS 'select $1::numeric =$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_numeric_neq(text, numeric) RETURNS bool AS 'select $1::numeric<>$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE OPERATOR pg_catalog.=   (LEFTARG = text, RIGHTARG = numeric, PROCEDURE = text_numeric_eq, COMMUTATOR = '=' );
CREATE OPERATOR pg_catalog.<>  (LEFTARG = text, RIGHTARG = numeric, PROCEDURE = text_numeric_neq, COMMUTATOR = '<>' );

CREATE FUNCTION pg_catalog.date_text_eq (date,  text) RETURNS bool AS 'select $1 =$2::date' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.date_text_ne (date,  text) RETURNS bool AS 'select $1 <>$2::date' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.date_text_lt (date,  text) RETURNS bool AS 'select $1 < $2::date' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.date_text_le (date,  text) RETURNS bool AS 'select $1 <=$2::date' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.date_text_gt (date,  text) RETURNS bool AS 'select $1 > $2::date' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.date_text_ge (date,  text) RETURNS bool AS 'select $1 >= $2::date' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE OPERATOR pg_catalog.=	(LEFTARG = date, RIGHTARG = text, PROCEDURE = date_text_eq, COMMUTATOR = '=' );
CREATE OPERATOR pg_catalog.<>	(LEFTARG = date, RIGHTARG = text, PROCEDURE = date_text_ne, COMMUTATOR = '<>' );
CREATE OPERATOR pg_catalog.<	(LEFTARG = date, RIGHTARG = text, PROCEDURE = date_text_lt, COMMUTATOR = '>=' );
CREATE OPERATOR pg_catalog.<=	(LEFTARG = date, RIGHTARG = text, PROCEDURE = date_text_le, COMMUTATOR = '>' );
CREATE OPERATOR pg_catalog.>	(LEFTARG = date, RIGHTARG = text, PROCEDURE = date_text_gt, COMMUTATOR = '<=' );
CREATE OPERATOR pg_catalog.>=	(LEFTARG = date, RIGHTARG = text, PROCEDURE = date_text_gt, COMMUTATOR = '<' );

CREATE FUNCTION pg_catalog.text_date_eq (text, date) RETURNS bool AS 'select $1::date =$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_date_ne (text, date) RETURNS bool AS 'select $1::date <>$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_date_lt (text, date) RETURNS bool AS 'select $1::date < $2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_date_le (text, date) RETURNS bool AS 'select $1::date <=$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_date_gt (text, date) RETURNS bool AS 'select $1::date > $2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_date_ge (text, date) RETURNS bool AS 'select $1::date >= $2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE OPERATOR pg_catalog.=	(LEFTARG = text, RIGHTARG = date, PROCEDURE = text_date_eq, COMMUTATOR = '=' );
CREATE OPERATOR pg_catalog.<>	(LEFTARG = text, RIGHTARG = date, PROCEDURE = text_date_ne, COMMUTATOR = '<>' );
CREATE OPERATOR pg_catalog.<	(LEFTARG = text, RIGHTARG = date, PROCEDURE = text_date_lt, COMMUTATOR = '>=' );
CREATE OPERATOR pg_catalog.<=	(LEFTARG = text, RIGHTARG = date, PROCEDURE = text_date_le, COMMUTATOR = '>' );
CREATE OPERATOR pg_catalog.>	(LEFTARG = text, RIGHTARG = date, PROCEDURE = text_date_gt, COMMUTATOR = '<=' );
CREATE OPERATOR pg_catalog.>=	(LEFTARG = text, RIGHTARG = date, PROCEDURE = text_date_gt, COMMUTATOR = '<' );

CREATE FUNCTION pg_catalog.timestamp_text_eq (timestamp,  text) RETURNS bool AS 'select $1 =$2::timestamp' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.timestamp_text_ne (timestamp,  text) RETURNS bool AS 'select $1 <>$2::timestamp' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.timestamp_text_lt (timestamp,  text) RETURNS bool AS 'select $1 < $2::timestamp' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.timestamp_text_le (timestamp,  text) RETURNS bool AS 'select $1 <=$2::timestamp' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.timestamp_text_gt (timestamp,  text) RETURNS bool AS 'select $1 > $2::timestamp' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.timestamp_text_ge (timestamp,  text) RETURNS bool AS 'select $1 >= $2::timestamp' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE OPERATOR pg_catalog.=	(LEFTARG = timestamp, RIGHTARG = text, PROCEDURE = timestamp_text_eq, COMMUTATOR = '=' );
CREATE OPERATOR pg_catalog.<>	(LEFTARG = timestamp, RIGHTARG = text, PROCEDURE = timestamp_text_ne, COMMUTATOR = '<>' );
CREATE OPERATOR pg_catalog.<	(LEFTARG = timestamp, RIGHTARG = text, PROCEDURE = timestamp_text_lt, COMMUTATOR = '>=' );
CREATE OPERATOR pg_catalog.<=	(LEFTARG = timestamp, RIGHTARG = text, PROCEDURE = timestamp_text_le, COMMUTATOR = '>' );
CREATE OPERATOR pg_catalog.>	(LEFTARG = timestamp, RIGHTARG = text, PROCEDURE = timestamp_text_gt, COMMUTATOR = '<=' );
CREATE OPERATOR pg_catalog.>=	(LEFTARG = timestamp, RIGHTARG = text, PROCEDURE = timestamp_text_gt, COMMUTATOR = '<' );

CREATE FUNCTION pg_catalog.text_timestamp_eq (text, timestamp) RETURNS bool AS 'select $1::timestamp =$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_timestamp_ne (text, timestamp) RETURNS bool AS 'select $1::timestamp <>$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_timestamp_lt (text, timestamp) RETURNS bool AS 'select $1::timestamp < $2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_timestamp_le (text, timestamp) RETURNS bool AS 'select $1::timestamp <=$2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_timestamp_gt (text, timestamp) RETURNS bool AS 'select $1::timestamp > $2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE FUNCTION pg_catalog.text_timestamp_ge (text, timestamp) RETURNS bool AS 'select $1::timestamp >= $2' LANGUAGE sql IMMUTABLE STRICT PARALLEL safe;
CREATE OPERATOR pg_catalog.=	 (LEFTARG = text, RIGHTARG = timestamp, PROCEDURE = text_timestamp_eq, COMMUTATOR = '=' );
CREATE OPERATOR pg_catalog.<>	(LEFTARG = text, RIGHTARG = timestamp, PROCEDURE = text_timestamp_ne, COMMUTATOR = '<>' );
CREATE OPERATOR pg_catalog.<	 (LEFTARG = text, RIGHTARG = timestamp, PROCEDURE = text_timestamp_lt, COMMUTATOR = '>=' );
CREATE OPERATOR pg_catalog.<=	(LEFTARG = text, RIGHTARG = timestamp, PROCEDURE = text_timestamp_le, COMMUTATOR = '>' );
CREATE OPERATOR pg_catalog.>	 (LEFTARG = text, RIGHTARG = timestamp, PROCEDURE = text_timestamp_gt, COMMUTATOR = '<=' );
CREATE OPERATOR pg_catalog.>=	(LEFTARG = text, RIGHTARG = timestamp, PROCEDURE = text_timestamp_gt, COMMUTATOR = '<' );

CREATE EXTENSION IF NOT EXISTS plpgsql;
CREATE OR REPLACE FUNCTION pg_catalog.rcr_abort_any_ddl_command_on_replica() RETURNS event_trigger
  PARALLEL SAFE
 LANGUAGE plpgsql
  AS $$
DECLARE
  ddl_log_applier_mode int;
BEGIN
  EXECUTE 'SHOW remote_rel.apply_ddl_log_mode' INTO ddl_log_applier_mode;
  IF ddl_log_applier_mode = 0 THEN
    RAISE EXCEPTION 'Command % is rejected because current KlustronDB cluster is a replica cluster of RCR.', tg_tag;
  END IF;
END;
$$;

