/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogFormatter;

public class ELogHandler
extends Handler {
    public static final int LOG_DEBUG5 = 10;
    public static final int LOG_DEBUG4 = 11;
    public static final int LOG_DEBUG3 = 12;
    public static final int LOG_DEBUG2 = 13;
    public static final int LOG_DEBUG1 = 14;
    public static final int LOG_LOG = 15;
    public static final int LOG_INFO = 17;
    public static final int LOG_NOTICE = 18;
    public static final int LOG_WARNING = 19;
    public static final int LOG_ERROR = 20;
    public static final int LOG_FATAL = 21;
    public static final int LOG_PANIC = 22;

    @Override
    public void publish(LogRecord record) {
        Level level = record.getLevel();
        int pgLevel = level == null ? 15 : (level.equals(Level.SEVERE) ? 20 : (level.equals(Level.WARNING) ? 19 : (level.equals(Level.INFO) ? 17 : (level.equals(Level.FINE) ? 14 : (level.equals(Level.FINER) ? 13 : (level.equals(Level.FINEST) ? 12 : 15))))));
        Backend.log(pgLevel, this.getFormatter().format(record));
    }

    public ELogHandler() {
        this.configure();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static void init() {
        Properties props = new Properties();
        props.setProperty("handlers", ELogHandler.class.getName());
        props.setProperty(".level", ELogHandler.getPgLevel().getName());
        ByteArrayOutputStream po = new ByteArrayOutputStream();
        try {
            props.store(po, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(po.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Level getPgLevel() {
        String[] options = new String[]{"log_min_messages", "client_min_messages"};
        Level finestLevel = null;
        for (String option : options) {
            String pgLevel = Backend.getConfigOption(option);
            if (null == pgLevel) continue;
            pgLevel = pgLevel.toLowerCase().trim();
            Level level = null;
            if (pgLevel.equals("panic") || pgLevel.equals("fatal")) {
                level = Level.OFF;
            } else if (pgLevel.equals("error")) {
                level = Level.SEVERE;
            } else if (pgLevel.equals("warning")) {
                level = Level.WARNING;
            } else if (pgLevel.equals("notice")) {
                level = Level.CONFIG;
            } else if (pgLevel.equals("info")) {
                level = Level.INFO;
            } else if (pgLevel.equals("debug1")) {
                level = Level.FINE;
            } else if (pgLevel.equals("debug2")) {
                level = Level.FINER;
            } else if (pgLevel.equals("debug3") || pgLevel.equals("debug4") || pgLevel.equals("debug5")) {
                level = Level.FINEST;
            }
            if (null == level || null != finestLevel && finestLevel.intValue() <= level.intValue()) continue;
            finestLevel = level;
        }
        if (null == finestLevel) {
            finestLevel = Level.ALL;
        }
        return finestLevel;
    }

    private void configure() {
        String cname;
        LogManager mgr = LogManager.getLogManager();
        String val = mgr.getProperty((cname = ELogHandler.class.getName()) + ".filter");
        if (val != null) {
            try {
                this.setFilter((Filter)Class.forName(val.trim()).newInstance());
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            this.setFilter(null);
        }
        if ((val = mgr.getProperty(cname + ".formatter")) != null) {
            try {
                this.setFormatter((Formatter)Class.forName(val.trim()).newInstance());
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            this.setFormatter(new ELogFormatter());
        }
        if ((val = mgr.getProperty(cname + ".encoding")) != null) {
            try {
                this.setEncoding(val.trim());
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

