/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.postgresql.pljava.jdbc.ResultSetBase;
import org.postgresql.pljava.jdbc.ResultSetField;
import org.postgresql.pljava.jdbc.SyntheticResultSetMetaData;

public class SyntheticResultSet
extends ResultSetBase {
    private final ResultSetField[] m_fields;
    private final ArrayList<Object[]> m_tuples;
    private final HashMap<String, Integer> m_fieldIndexes;

    SyntheticResultSet(ResultSetField[] fields, ArrayList<Object[]> tuples) throws SQLException {
        super(tuples.size());
        this.m_fields = fields;
        this.m_tuples = tuples;
        this.m_fieldIndexes = new HashMap();
        int i = this.m_fields.length;
        while (--i >= 0) {
            this.m_fieldIndexes.put(this.m_fields[i].getColumnLabel(), i + 1);
        }
        Object[][] tupleTest = (Object[][])this.m_tuples.toArray((T[])new Object[0][]);
        for (i = 0; i < tupleTest.length; ++i) {
            int j = this.m_fields.length;
            while (--j >= 0) {
                Object value = tupleTest[i][j];
                if (value == null || this.m_fields[j].canContain(value.getClass())) continue;
                throw new SQLException("Unable to store class " + value.getClass() + " in ResultSetField '" + this.m_fields[j].getColumnLabel() + "' with OID " + this.m_fields[j].getOID() + " (expected class: " + this.m_fields[j].getJavaClass() + ")");
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.m_tuples.clear();
        super.close();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer idx = this.m_fieldIndexes.get(columnName.toUpperCase());
        if (idx != null) {
            return idx;
        }
        throw new SQLException("No such field: '" + columnName + "'");
    }

    @Override
    protected Object getObjectValue(int columnIndex, Class<?> type) throws SQLException {
        return this.getCurrentRow()[columnIndex - 1];
    }

    protected final Object[] getCurrentRow() throws SQLException {
        int row = this.getRow();
        if (row < 1 || row > this.m_tuples.size()) {
            throw new SQLException("ResultSet is not positioned on a valid row");
        }
        return this.m_tuples.get(row - 1);
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.getRow() == this.m_tuples.size();
    }

    @Override
    public boolean next() throws SQLException {
        int row = this.getRow();
        if (row < this.m_tuples.size()) {
            this.setRow(row + 1);
            return true;
        }
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new SyntheticResultSetMetaData(this.m_fields);
    }
}

