/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventConsumer;

class XMLEventToStreamConsumer
implements XMLEventConsumer,
XMLStreamConstants {
    protected final XMLStreamWriter m_xsw;
    protected StartElement m_startElement;
    protected Location m_location;

    XMLEventToStreamConsumer(XMLStreamWriter xsw) {
        if (null == xsw) {
            throw new NullPointerException("XMLEventToStreamConsumer");
        }
        this.m_xsw = xsw;
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (null == event) {
            throw new NullPointerException("XMLEventToStreamConsumer.add");
        }
        switch (event.getEventType()) {
            case 5: {
                this.add((Comment)event);
                break;
            }
            case 3: {
                this.add((ProcessingInstruction)event);
                break;
            }
            case 4: 
            case 12: {
                this.add((Characters)event);
                break;
            }
            case 11: {
                this.add((DTD)event);
                break;
            }
            case 9: {
                this.add((EntityReference)event);
                break;
            }
            case 7: {
                this.add((StartDocument)event);
                break;
            }
            case 8: {
                this.add((EndDocument)event);
                break;
            }
            case 1: {
                this.add((StartElement)event);
                break;
            }
            case 2: {
                this.add((EndElement)event);
                break;
            }
            default: {
                throw new XMLStreamException("Unexpected XMLEvent type " + event.getEventType());
            }
        }
    }

    protected void addNonEmptyIfCached() throws XMLStreamException {
        if (null == this.m_startElement) {
            return;
        }
        this.add(this.m_startElement, false);
        this.m_startElement = null;
        this.m_location = null;
    }

    protected void add(Comment event) throws XMLStreamException {
        this.addNonEmptyIfCached();
        this.m_xsw.writeComment(event.getText());
    }

    protected void add(ProcessingInstruction event) throws XMLStreamException {
        this.addNonEmptyIfCached();
        this.m_xsw.writeProcessingInstruction(event.getTarget(), event.getData());
    }

    protected void add(Characters event) throws XMLStreamException {
        this.addNonEmptyIfCached();
        String content = event.getData();
        if (event.isCData()) {
            this.m_xsw.writeCData(content);
        } else {
            this.m_xsw.writeCharacters(content);
        }
    }

    protected void add(DTD event) throws XMLStreamException {
        this.m_xsw.writeDTD(event.getDocumentTypeDeclaration());
    }

    protected void add(EntityReference event) throws XMLStreamException {
        this.addNonEmptyIfCached();
        this.m_xsw.writeEntityRef(event.getName());
    }

    protected void add(StartDocument event) throws XMLStreamException {
        String version = event.getVersion();
        String encoding = event.getCharacterEncodingScheme();
        if (event.encodingSet()) {
            this.m_xsw.writeStartDocument(encoding, version);
        } else {
            this.m_xsw.writeStartDocument(version);
        }
    }

    protected void add(EndDocument event) throws XMLStreamException {
        if (null != this.m_startElement) {
            this.add(this.m_startElement, true);
            this.m_startElement = null;
            this.m_location = null;
        }
        this.m_xsw.writeEndDocument();
    }

    protected void add(StartElement event) throws XMLStreamException {
        this.addNonEmptyIfCached();
        this.m_startElement = event;
        this.m_location = event.getLocation();
    }

    protected void add(StartElement event, boolean empty) throws XMLStreamException {
        QName qn = event.getName();
        if (empty) {
            this.m_xsw.writeEmptyElement(qn.getPrefix(), qn.getLocalPart(), qn.getNamespaceURI());
        } else {
            this.m_xsw.writeStartElement(qn.getPrefix(), qn.getLocalPart(), qn.getNamespaceURI());
        }
        for (Namespace n : this.namespaces(event)) {
            this.add(n);
        }
        for (Attribute a : this.attributes(event)) {
            this.add(a);
        }
    }

    protected void add(EndElement event) throws XMLStreamException {
        if (null != this.m_startElement) {
            boolean empty = XMLEventToStreamConsumer.locationsEqual(this.m_location, event.getLocation());
            this.add(this.m_startElement, empty);
            this.m_startElement = null;
            this.m_location = null;
            if (empty) {
                return;
            }
        }
        this.m_xsw.writeEndElement();
    }

    protected void add(Attribute a) throws XMLStreamException {
        QName n = a.getName();
        this.m_xsw.writeAttribute(n.getPrefix(), n.getNamespaceURI(), n.getLocalPart(), a.getValue());
    }

    protected void add(Namespace n) throws XMLStreamException {
        this.m_xsw.writeNamespace(n.getPrefix(), n.getNamespaceURI());
    }

    protected static boolean locationsEqual(Location a, Location b) {
        if (null == a || null == b) {
            return false;
        }
        if (!XMLEventToStreamConsumer.locationIdsEqual(a.getPublicId(), b.getPublicId())) {
            return false;
        }
        if (!XMLEventToStreamConsumer.locationIdsEqual(a.getSystemId(), b.getSystemId())) {
            return false;
        }
        int aOffset = a.getCharacterOffset();
        if (b.getCharacterOffset() != aOffset) {
            return false;
        }
        int aColumn = a.getColumnNumber();
        if (b.getColumnNumber() != aColumn) {
            return false;
        }
        int aLine = a.getLineNumber();
        if (b.getLineNumber() != aLine) {
            return false;
        }
        return -1 != aOffset || -1 != aColumn && -1 != aLine;
    }

    private static boolean locationIdsEqual(String a, String b) {
        if (a == b) {
            return true;
        }
        if (null != a) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    protected Attributes attributes(StartElement event) {
        Attributes as = new Attributes();
        as.m_event = event;
        return as;
    }

    protected Namespaces namespaces(StartElement event) {
        Namespaces ns = new Namespaces();
        ns.m_event = event;
        return ns;
    }

    static class Namespaces
    extends ElementIterable<Namespace> {
        Namespaces() {
        }

        @Override
        public Iterator<Namespace> iterator() {
            return this.m_event.getNamespaces();
        }
    }

    static class Attributes
    extends ElementIterable<Attribute> {
        Attributes() {
        }

        @Override
        public Iterator<Attribute> iterator() {
            return this.m_event.getAttributes();
        }
    }

    static abstract class ElementIterable<T>
    implements Iterable<T> {
        protected StartElement m_event;

        ElementIterable() {
        }

        @Override
        public abstract Iterator<T> iterator();
    }
}

