/*-------------------------------------------------------------------------
 *
 * pg_mysql_srs_basics.h
 * 		basic information of MySQL spatial reference systems.
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * src/include/catalog/pg_mysql_srs_basics.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_MYSQL_SRS_BASICS_H
#define PG_MYSQL_SRS_BASICS_H

#include "catalog/genbki.h"
#include "catalog/pg_mysql_srs_basics_d.h"

/*
 * info acquired from mysql-8.0.26.
 * */
CATALOG(pg_mysql_srs_basics,12366,MySQLSRSBasicsId) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	Oid srid;
	int16 is_geographic;
	int16 is_lat_long;
	int16 is_projected;
	int16 is_cartesian;
}
FormData_pg_mysql_srs_basics;

typedef FormData_pg_mysql_srs_basics*Form_pg_mysql_srs_basics;

#endif /* !PG_MYSQL_SRS_BASICS_H */
