/*-------------------------------------------------------------------------
 *
 * crypt_genhash_impl.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		crypto and salt.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/crypt_genhash_impl.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef CRYPT_HASHGEN_IMPL_H
#define CRYPT_HASHGEN_IMPL_H
#define ROUNDS_DEFAULT 5000
#define ROUNDS_MIN ROUNDS_DEFAULT
#define ROUNDS_MAX (0xFFF * 1000)
#define MIXCHARS 32
#define CRYPT_SALT_LENGTH 20
#define CRYPT_MAGIC_LENGTH 3
#define CRYPT_PARAM_LENGTH 13
#define SHA256_HASH_LENGTH 43
#define CRYPT_MAX_PASSWORD_SIZE                                  \
  (CRYPT_SALT_LENGTH + SHA256_HASH_LENGTH + CRYPT_MAGIC_LENGTH + \
   CRYPT_PARAM_LENGTH)
#define MAX_PLAINTEXT_LENGTH 256

#include <stddef.h>

int extract_user_salt(const char **salt_begin, const char **salt_end);
char *mysql_crypt_genhash(char *ctbuffer, size_t ctbufflen, const char *plaintext,
                       size_t plaintext_len, const char *switchsalt,
                       const char **params, unsigned int *num_rounds);
void generate_user_salt(char *buffer, int buffer_len);
void xor_string(char *to, int to_len, char *pattern, int pattern_len);

#endif
