/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class SQL_ASCII
extends Charset {
    static final Charset US_ASCII;

    private SQL_ASCII() {
        super("X-PGSQL_ASCII", Provider.s_aliases);
    }

    @Override
    public boolean contains(Charset cs) {
        return this.equals(cs) || US_ASCII.equals(cs);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    static {
        try {
            US_ASCII = Charset.forName("US-ASCII");
        }
        catch (IllegalArgumentException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static class Encoder
    extends CharsetEncoder {
        Encoder() {
            super(Holder.s_list.get(0), 0.998f, 1.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int ipos;
            int opos = out.position();
            int ilim = in.limit();
            int olim = out.limit();
            for (ipos = in.position(); ipos < ilim; ++ipos) {
                if (opos == olim) {
                    in.position(ipos);
                    out.position(opos);
                    return CoderResult.OVERFLOW;
                }
                char c = in.get(ipos);
                if ('\ufdd8' <= c && c < '\ufde0') {
                    if (ipos + 1 == ilim) break;
                    char d = in.get(ipos + 1);
                    if ('\ufde0' > d || d > '\ufdef') {
                        in.position(ipos);
                        out.position(opos);
                        return CoderResult.malformedForLength(2);
                    }
                    c = (char)((c & 0xF) << 4 | d & 0xF);
                    ++ipos;
                } else if (c >= '\u0080') {
                    in.position(ipos);
                    out.position(opos);
                    return CoderResult.unmappableForLength(1);
                }
                out.put(opos++, (byte)c);
            }
            in.position(ipos);
            out.position(opos);
            return CoderResult.UNDERFLOW;
        }
    }

    static class Decoder
    extends CharsetDecoder {
        Decoder() {
            super(Holder.s_list.get(0), 1.002f, 2.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int ipos;
            int opos = out.position();
            int ilim = in.limit();
            int olim = out.limit();
            for (ipos = in.position(); ipos < ilim; ++ipos) {
                char b = (char)(0xFF & in.get(ipos));
                if (b < '\u0080') {
                    if (opos == olim) {
                        in.position(ipos);
                        out.position(opos);
                        return CoderResult.OVERFLOW;
                    }
                    out.put(opos++, b);
                    continue;
                }
                if (opos + 1 >= olim) {
                    in.position(ipos);
                    out.position(opos);
                    return CoderResult.OVERFLOW;
                }
                out.put(opos++, (char)(0xFDD0 | b >> 4));
                out.put(opos++, (char)(0xFDE0 | b & 0xF));
            }
            in.position(ipos);
            out.position(opos);
            return CoderResult.UNDERFLOW;
        }
    }

    public static class Provider
    extends CharsetProvider {
        static final String s_canonName = "X-PGSQL_ASCII";
        static final String[] s_aliases = new String[]{"SQL_ASCII"};

        @Override
        public Charset charsetForName(String charsetName) {
            if (s_canonName.equalsIgnoreCase(charsetName)) {
                return Holder.s_list.get(0);
            }
            for (String s : s_aliases) {
                if (!s.equalsIgnoreCase(charsetName)) continue;
                return Holder.s_list.get(0);
            }
            return null;
        }

        @Override
        public Iterator<Charset> charsets() {
            return Holder.s_list.iterator();
        }
    }

    static class Holder {
        static final List<Charset> s_list = Collections.singletonList(new SQL_ASCII());

        Holder() {
        }
    }
}

