/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.pljava.internal.Portal;
import org.postgresql.pljava.internal.SPI;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.internal.TupleTable;
import org.postgresql.pljava.jdbc.ResultSetBase;
import org.postgresql.pljava.jdbc.SPIResultSetMetaData;
import org.postgresql.pljava.jdbc.SPIStatement;

public class SPIResultSet
extends ResultSetBase {
    private final SPIStatement m_statement;
    private final Portal m_portal;
    private final TupleDesc m_tupleDesc;
    private final long m_maxRows;
    private Tuple m_currentRow;
    private Tuple m_nextRow;
    private TupleTable m_table;
    private int m_tableRow;
    private boolean m_open;

    SPIResultSet(SPIStatement statement, Portal portal, long maxRows) throws SQLException {
        super(statement.getFetchSize());
        this.m_statement = statement;
        this.m_portal = portal;
        this.m_maxRows = maxRows;
        this.m_tupleDesc = portal.getTupleDesc();
        this.m_tableRow = -1;
        this.m_open = true;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_open) {
            this.m_open = false;
            this.m_portal.close();
            this.m_statement.resultSetClosed(this);
            this.m_table = null;
            this.m_tableRow = -1;
            this.m_currentRow = null;
            this.m_nextRow = null;
            super.close();
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_currentRow != null && this.peekNext() == null;
    }

    @Override
    public boolean next() throws SQLException {
        this.m_currentRow = this.peekNext();
        this.m_nextRow = null;
        boolean result = this.m_currentRow != null;
        this.setRow(result ? this.getRow() + 1 : -1);
        return result;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.getPortal().getName();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.m_tupleDesc.getColumnIndex(columnName);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.m_statement;
    }

    protected final Portal getPortal() throws SQLException {
        if (!this.m_open) {
            throw new SQLException("ResultSet is closed");
        }
        return this.m_portal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TupleTable getTupleTable() throws SQLException {
        if (this.m_table == null) {
            long mx;
            Portal portal = this.getPortal();
            if (portal.isAtEnd()) {
                return null;
            }
            int fetchSize = this.getFetchSize();
            if (this.m_maxRows > 0L) {
                mx = this.m_maxRows - portal.getPortalPos();
                if (mx <= 0L) {
                    return null;
                }
                if (mx > (long)fetchSize) {
                    mx = fetchSize;
                }
            } else {
                mx = fetchSize;
            }
            try {
                long result = portal.fetch(true, mx);
                if (result > 0L) {
                    this.m_table = SPI.getTupTable(this.m_tupleDesc);
                }
                this.m_tableRow = -1;
            }
            finally {
                SPI.freeTupTable();
            }
        }
        return this.m_table;
    }

    protected final Tuple getCurrentRow() throws SQLException {
        if (this.m_currentRow == null) {
            throw new SQLException("ResultSet is not positioned on a valid row");
        }
        return this.m_currentRow;
    }

    protected final Tuple peekNext() throws SQLException {
        if (this.m_nextRow != null) {
            return this.m_nextRow;
        }
        TupleTable table = this.getTupleTable();
        if (table == null) {
            return null;
        }
        if (this.m_tableRow >= table.getCount() - 1) {
            this.m_table = null;
            table = this.getTupleTable();
            if (table == null) {
                return null;
            }
        }
        this.m_nextRow = table.getSlot(++this.m_tableRow);
        return this.m_nextRow;
    }

    @Override
    protected Object getObjectValue(int columnIndex, Class<?> type) throws SQLException {
        return this.getCurrentRow().getObject(this.m_tupleDesc, columnIndex, type);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new SPIResultSetMetaData(this.m_tupleDesc);
    }
}

