/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;

public class MarkableSequenceInputStream
extends InputStream {
    public static final InputStream NO_MORE = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private boolean m_closed = false;
    private InputStream m_markedStream = null;
    private ListIterator<InputStream> m_streams;
    private int m_readlimit_orig;
    private int m_readlimit_curr;
    private boolean m_markSupported;
    private boolean m_markSupported_determined;

    public MarkableSequenceInputStream(InputStream ... streams) {
        if (null == streams) {
            throw new NullPointerException("MarkableSequenceInputStream(null)");
        }
        LinkedList<InputStream> isl = new LinkedList<InputStream>();
        for (InputStream s : streams) {
            if (null == s) {
                throw new NullPointerException("MarkableSequenceInputStream(..., null, ...)");
            }
            isl.add(s);
        }
        this.m_streams = isl.listIterator();
    }

    public MarkableSequenceInputStream(BlockingQueue<InputStream> queue) {
        this.m_streams = new FetchingListIterator<InputStream>(new LinkedList(), queue, NO_MORE);
    }

    private InputStream currentStream() throws IOException {
        if (this.m_closed) {
            throw new IOException("I/O on closed InputStream");
        }
        if (this.m_streams.hasNext()) {
            return this.m_streams.next();
        }
        return null;
    }

    private InputStream nextStream() throws IOException {
        if (null == this.m_markedStream) {
            this.m_streams.previous().close();
            assert (!this.m_streams.hasPrevious());
            this.m_streams.remove();
            if (this.m_streams.hasNext()) {
                return this.m_streams.next();
            }
        } else if (this.m_streams.hasNext()) {
            InputStream is = this.m_streams.next();
            is.mark(this.m_readlimit_curr);
            return is;
        }
        return null;
    }

    private void decrementLimit(long bytes) {
        assert (0L < bytes);
        if (null == this.m_markedStream) {
            return;
        }
        if (bytes < (long)this.m_readlimit_curr) {
            this.m_readlimit_curr = (int)((long)this.m_readlimit_curr - bytes);
            return;
        }
        this.mark(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            InputStream s = this.currentStream();
            while (null != s) {
                int c = s.read();
                if (-1 != c) {
                    this.decrementLimit(1L);
                    this.m_streams.previous();
                    return c;
                }
                s = this.nextStream();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            InputStream s = this.currentStream();
            while (null != s) {
                int rslt = s.read(b, off, len);
                if (-1 != rslt) {
                    this.decrementLimit(rslt);
                    this.m_streams.previous();
                    return rslt;
                }
                s = this.nextStream();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            long totalSkipped = 0L;
            InputStream s = this.currentStream();
            while (null != s) {
                long skipped = s.skip(n);
                this.decrementLimit(skipped);
                totalSkipped += skipped;
                if (0L >= (n -= skipped)) {
                    this.m_streams.previous();
                    break;
                }
                if (-1 != s.read()) {
                    --n;
                    this.decrementLimit(1L);
                    ++totalSkipped;
                    continue;
                }
                s = this.nextStream();
            }
            return totalSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            if (this.m_closed) {
                return 0;
            }
            InputStream s = this.currentStream();
            if (null == s) {
                return 0;
            }
            this.m_streams.previous();
            return s.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            if (this.m_closed) {
                return;
            }
            while (this.m_streams.hasPrevious()) {
                this.m_streams.previous();
            }
            while (this.m_streams.hasNext()) {
                this.m_streams.next().close();
            }
            this.m_streams = null;
            this.m_closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            if (this.m_closed) {
                return;
            }
            InputStream activeStream = null;
            if (this.m_streams.hasNext()) {
                this.m_streams.next();
                activeStream = this.m_streams.previous();
            }
            if (null != this.m_markedStream) {
                InputStream is = activeStream;
                while (is != this.m_markedStream) {
                    is = this.m_streams.previous();
                }
                this.m_markedStream = null;
                is = this.m_streams.next();
                while (is != activeStream) {
                    try {
                        is = this.nextStream();
                    }
                    catch (IOException e) {
                        throw new UndeclaredThrowableException(e);
                    }
                }
                if (null != activeStream) {
                    this.m_streams.previous();
                }
            }
            if (0 >= readlimit) {
                this.m_readlimit_orig = 0;
                this.m_readlimit_curr = 0;
                return;
            }
            this.m_readlimit_curr = this.m_readlimit_orig = readlimit;
            if (null == activeStream) {
                return;
            }
            this.m_markedStream = activeStream;
            activeStream.mark(readlimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            if (this.m_closed) {
                throw new IOException("reset on closed InputStream");
            }
            if (null == this.m_markedStream) {
                if (0 < this.m_readlimit_orig) {
                    return;
                }
                throw new IOException("reset without mark");
            }
            InputStream is = this.currentStream();
            while (true) {
                is = this.m_streams.previous();
                is.reset();
                if (is == this.m_markedStream) break;
                is.mark(0);
            }
            this.m_readlimit_curr = this.m_readlimit_orig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        MarkableSequenceInputStream markableSequenceInputStream = this;
        synchronized (markableSequenceInputStream) {
            InputStream is;
            if (this.m_markSupported_determined) {
                return this.m_markSupported;
            }
            if (this.m_closed) {
                return false;
            }
            InputStream activeStream = null;
            if (this.m_streams.hasNext()) {
                this.m_streams.next();
                activeStream = this.m_streams.previous();
            }
            if (null != this.m_markedStream) {
                is = activeStream;
                while (is != this.m_markedStream) {
                    is = this.m_streams.previous();
                }
            }
            this.m_markSupported = true;
            while (this.m_streams.hasNext()) {
                if (this.m_streams.next().markSupported()) continue;
                this.m_markSupported = false;
            }
            is = null;
            while (is != activeStream) {
                is = this.m_streams.previous();
            }
            this.m_markSupported_determined = true;
            return this.m_markSupported;
        }
    }

    public static class FetchingListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> m_li;
        private BlockingQueue<E> m_q;
        private final E m_sentinel;

        public FetchingListIterator(List<E> list, BlockingQueue<E> queue, E sentinel) {
            if (null == list || null == queue || null == sentinel) {
                throw new NullPointerException("a null parameter was passed to FetchingListIterator");
            }
            this.m_li = list.listIterator();
            this.m_q = queue;
            this.m_sentinel = sentinel;
        }

        @Override
        public boolean hasNext() {
            E e;
            boolean has = this.m_li.hasNext();
            if (has || null == this.m_q) {
                return has;
            }
            try {
                e = this.m_q.take();
            }
            catch (InterruptedException ex) {
                this.m_q = null;
                throw (CancellationException)new CancellationException("Interrupted waiting for input").initCause(ex);
            }
            if (this.m_sentinel == e) {
                this.m_q = null;
                return has;
            }
            this.m_li.add(e);
            this.m_li.previous();
            return true;
        }

        @Override
        public E next() {
            this.hasNext();
            return this.m_li.next();
        }

        @Override
        public int nextIndex() {
            this.hasNext();
            return this.m_li.nextIndex();
        }

        @Override
        public void add(E e) {
            this.m_li.add(e);
        }

        @Override
        public boolean hasPrevious() {
            return this.m_li.hasPrevious();
        }

        @Override
        public E previous() {
            return this.m_li.previous();
        }

        @Override
        public int previousIndex() {
            return this.m_li.previousIndex();
        }

        @Override
        public void remove() {
            this.m_li.remove();
        }

        @Override
        public void set(E e) {
            this.m_li.set(e);
        }
    }
}

