/*-------------------------------------------------------------------------
 *
 * nodeRemotescan.h
 *
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 *
 * src/include/executor/nodeRemotescan.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef NODEREMOTESCAN_H
#define NODEREMOTESCAN_H

#include "access/parallel.h"
#include "nodes/execnodes.h"


extern Index InvalidIndex;
struct VarPickerCtx;
extern TupleTableSlot *ExecRemoteScan(PlanState *pstate);
extern bool var_picker(Node **ppnode, struct VarPickerCtx*ctx);
extern bool var_picker_hdlr(Node **ppnode, struct VarPickerCtx*ctx);
extern TupleDesc expandTupleDesc2(TupleDesc tpd);
extern void reset_var_picker_ctx(struct VarPickerCtx *vpc);
extern TupleDesc
ExecScanTypeFromTL(EState *estate, RemoteScanState *rss,
	Relation rel, Index scanrelid, bool skipjunk);
extern RemoteScanState *ExecInitRemoteScan(RemoteScan *node, EState *estate, int eflags);
extern void ExecEndRemoteScan(RemoteScanState *node);
extern void ExecReScanRemoteScan(RemoteScanState *node);

/* parallel scan support */
extern void ExecRemoteScanEstimate(RemoteScanState *node, ParallelContext *pcxt);
extern void ExecRemoteScanInitializeDSM(RemoteScanState *node, ParallelContext *pcxt);
extern void ExecRemoteScanReInitializeDSM(RemoteScanState *node, ParallelContext *pcxt);
extern void ExecRemoteScanInitializeWorker(RemoteScanState *node,
							ParallelWorkerContext *pwcxt);
extern void ExecStoreRemoteTuple(TypeInputInfo *tii, MYSQL_ROW row,
	unsigned long *lengths, TupleTableSlot *slot, int firstNCols);
extern void init_type_input_info(TypeInputInfo **tii, TupleTableSlot *slot,
	EState *estate);
extern void release_shard_conn(RemoteScanState *node);

extern int add_unique_col_var(PlanState *rss, TupleDesc rel_tupdesc,TupleDesc typeInfo,
	int cur_resno, TargetEntry *tle,
	Var *colvar, bool set_tle_resname, RelColArray *relcols);
extern void validate_column_reference(Var *colvar, Relation rel);
extern void AppendLimitClause(RemoteScanState *rss);
extern int append_cols_for_whole_var(PlanState *rss, TupleDesc rel_tupdesc,
	TupleDesc *pp_typeInfo, int cur_resno, RelColArray *relcols, int scanrelid);
extern bool decide_remote_scan_param_driven(Plan *plan);
extern RelColRef* appendRelColRef(RelColArray *rca, int relidx, int attno);
extern void closeRelRemoteJoin(EState *estate);
extern const char *get_rel_aliasname(EState *estate, Index rteid);
extern void MaterializeOtherRemoteScan(RemoteScanState *rss);
#endif							/* NODEREMOTESCAN_H */
