/*-------------------------------------------------------------------------
 *
 * planremote.h
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 * 		src/include/optimizer/planremote.h
 *
 *-------------------------------------------------------------------------
*/

#ifndef PLAN_REMOTE_H
#define PLAN_REMOTE_H

#include "postgres.h"
#include "nodes/plannodes.h"
#include "nodes/parsenodes.h"
#include "nodes/remotenodes.h"
struct PlannerInfo;
struct RemoteAggPath;
/*
  An edge of *pptr pointing to rs, we may later add a Material node M so that
  *pptr->M->rs. Each edge has one and only one such object, upper nodes may
  refer to it in multiple Lists.
*/
typedef struct RemoteScanRef
{
	Plan **pptr;
	RemoteScan *rs;
	bool materialized;
	/*
	  True if this is the 1st RemoteScan of an Append node. In certain cases
	  only the 1st need to be materialized.
	*/
	bool is_append_1st;
	Oid shardid;
	struct RemoteScanRef *next;
} RemoteScanRef;

/*
  A Plan node's list of shards that it and its decendants access.
*/
typedef struct ShardRemoteScanRef
{
	Oid shardid;
	List *rsrl;// list of RemoteScanRef pointers, or remotescan refs accessing this shard
	struct ShardRemoteScanRef *next; // for next shard
} ShardRemoteScanRef;


/*
  dzw: push down SET operations if setopr's left&right RS nodes are on the
  same shard. We combine a subtree of SETops of same operation
  (UNION/INTERSECT/EXCEPT) in the same RSO node, and use rso_plans to refer to
  these RS/RJ/RSO plans; and use RSO.plan.left/right_tree to refer to other
  RSOs(of different setopr type) or other nodes.
  SET operations to be pushed down don't need optimization in computing node,
  so we should use the parse nodes to produce RSOPath nodes and use them to
  produce the RSO subtree.

  SetOperation is a type of parser module but we do need it so move this type
  here to avoid poluting plannodes.h by #including parsernodes.h.
*/
typedef struct RemoteSetOp
{
	Plan		plan;
	SetOperation	rso_setop;
	Oid				rso_shardid;
	List			*rso_plans;
} RemoteSetOp;


extern ShardRemoteScanRef *dupShardRemoteScanRefs(ShardRemoteScanRef *src);
extern void materialize_conflicting_remotescans(PlannedStmt *pstmt);
extern bool ReleaseShardConnection(PlanState *ps);
extern Remote_OLD_state* add_unique_old_state(EState*estate, UniqueState *uniquestate);
extern Remote_OLD_state* add_sort_old_state(EState*estate, SortState *sortstate);
extern Remote_OLD_state* add_limit_old_state(EState*estate, LimitState *limitstate);
extern Remote_OLD_state *get_top_old_state(EState*estate);
extern List *extract_remote_plan(Plan *plan, bool get_all_rj);
extern Remote_OLD_state *pop_top_old_state(EState *estate);
extern bool fix_tuple_resname_with_tlist(List *tlist, PlanState *planstate);

#endif // !PLAN_REMOTE_H
