/*-------------------------------------------------------------------------
 *
 * pg_cluster_meta.h
 *	  definition of the "cluster_meta (db cluster_meta)" system catalog (pg_cluster_meta)
 *
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * src/include/catalog/pg_cluster_meta.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_CLUSTER_META_H
#define PG_CLUSTER_META_H

#include "catalog/genbki.h"
#include "catalog/pg_cluster_meta_d.h"

#define KUNLUN_METADATA_DBNAME "Kunlun_Metadata_DB"

/*
 * This meta table always has one row only.
 * */
CATALOG(pg_cluster_meta,12349,ClusterMetaRelationId) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	Oid comp_node_id;      /* ID and name of the computing node, used to identify this node in the cluster.*/
	Oid cluster_id;	       /* the ID and name of the cluster this computing node belongs to. */
	Oid cluster_master_id; /* the cluster's master node's server_id, references pg_cluster_meta_nodes.server_id */
	int32 ha_mode;	       /* storage ha mode: 0: no_rep; 1: mgr; 2: rbr */
	NameData cluster_name;
	NameData comp_node_name;
	int32 meta_ha_mode; /* meta server ha mode */
}
FormData_pg_cluster_meta;

typedef FormData_pg_cluster_meta*Form_pg_cluster_meta;

typedef enum Storage_HA_Mode
{
	HA_INVALID = -1,
	HA_NO_REP = 0,
	HA_MGR,
	HA_RBR
} Storage_HA_Mode;

typedef struct CMNConnInfo
{
	NameData usr;
	char *hostaddr;
	char *pwd;
	uint16_t port;
	bool is_primary;
	Oid nodeid;
} CMNConnInfo;

extern Oid comp_node_id;

extern Oid current_cluster_id(void);
extern const char *current_cluster_name(void);
extern Storage_HA_Mode storage_ha_mode(void);
extern Storage_HA_Mode meta_cluster_ha_mode(void);
extern bool is_meta_cluster_catalog_available(void);
extern Oid get_meta_cluster_master(void);
extern void get_meta_cluster_secret(char *host, int hostlen, int *port, char *user, int userlen, char *pwd, int pwdlen);
extern int get_meta_all_nodes(CMNConnInfo *nodes, int size, Oid *master_nodeid);
extern bool pg_meta_cluster_set_master(Oid master_nodeid);
extern bool pg_meta_cluster_nodes_set_master(Oid master_nodeid);
extern void pg_meta_cluster_add_one(Oid nodeid,
				  Datum hostaddr,
				  int32 port,
				  NameData *user,
				  Datum passwd);
extern void pg_meta_cluster_del_one(Oid nodeid);

#endif /* !PG_CLUSTER_META_H */
