/*-------------------------------------------------------------------------
 *
 * remote_path.h
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 * 		src/include/optimizer/remote_path.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef REMOTE_PATH_H
#define REMOTE_PATH_H

extern Path *create_remotescan_path(PlannerInfo *root, RelOptInfo *rel,
				    Relids required_outer, bool parallel_safe);
extern RemotePath *
create_remote_index_path(PlannerInfo *root, RelOptInfo *rel, IndexOptInfo *index,
		List *clauses, List *indexclausecols,
		List *indexorderbys, List *indexorderbycols,
		List *pathkeys, ScanDirection indexscandir,
		bool indexonly, Relids required_outer,
		double loop_count, bool partial_safe);

extern bool can_do_remote_join(PlannerInfo *root, RelOptInfo *rel1, RelOptInfo *rel2,
			       JoinType jt, List *restrictionList);
extern int add_remote_path_to_joinrel(PlannerInfo *root,
				       RelOptInfo *joinrel,
				       RelOptInfo *outerrel,
				       RelOptInfo *innerrel,
				       JoinType jointype,
				       SpecialJoinInfo *sjinfo,
				       List *restrictlist);
extern bool can_push_down_restrictions(PlannerInfo *root, List *restrictionList);

extern RemotePath *
set_project_at_remote(PlannerInfo *root, RelOptInfo *rel, RemotePath *path, PathTarget *tlist);

extern bool can_do_remote_sort(PlannerInfo *root, RelOptInfo *rel, RelOptInfo *inputrel,
			       Path *subpath, List *pathkeys);
extern RemotePath *
create_remote_sort_path(PlannerInfo *root,
			RelOptInfo *inputrel,
			Path *subpath,
			RelOptInfo *rel,
			List *pathkeys,
			double limittuples);

extern RemotePath *
create_remote_agg_path(PlannerInfo *root, RelOptInfo *input_rel,
		       Path *subpath, RelOptInfo *grouped_rel, List *havingQual,
		       List *groupClause, double numgroups);
extern bool can_do_remoteagg(PlannerInfo *root, RelOptInfo *input_rel,
			     RelOptInfo *grouped_rel, List *havingQual);

extern bool can_do_remote_distinct(PlannerInfo *root,
				   RelOptInfo *input_rel,
				   RelOptInfo *distinct_rel);
extern RemotePath *create_remote_distinct(PlannerInfo *root,
					  RelOptInfo *input_rel,
					  RelOptInfo *distinct_rel,
					  RemotePath *subpath,
					  double dNumDistinct);
#endif // !REMOTE_PATH_H
