#ifndef NODE_REMOTEPLAN_H
#define NODE_REMOTEPLAN_H

#include "postgres.h"

#include "access/parallel.h"
#include "nodes/execnodes.h"
#include "nodes/plannodes.h"

/**
 * @brief Initialize the plan state of remote plan
 */
extern RemotePlanState *ExecInitRemotePlan(RemotePlan *node, EState *estate, int eflags);

/**
 * @brief Begin rescan of the remote plan
 */
extern void ExecReScanRemotePlan(RemotePlanState *node);

/**
 * @brief Free resouces allocated  in remote plan state
 */
extern void ExecEndRemotePlan(RemotePlanState *node);

/**
 * @brieif Compute the amount of space we'll need in the parallel
 *  query DSM, and inform pcxt->estimator about our needs.
 */
extern void ExecRemotePlanEstimate(RemotePlanState *node, ParallelContext *pcxt);

/**
 * @brief Set up parallel remote scan
 */
extern void ExecRemotePlanInitializeDSM(RemotePlanState *node, ParallelContext *pcxt);

/**
 * @brief Reset shared state before begin a fresh remote scan
 */
extern void ExecRemotePlanReInitializeDSM(RemotePlanState *node, ParallelContext *pcxt);

/**
 * @brief Copy information from TOC into planstate.
 */
extern void ExecRemotePlanInitializeWorker(RemotePlanState *node, ParallelWorkerContext *pwcxt);

/**
 * @brief Initialize type's input information for transform mysql output into pg field data
 */
extern void init_type_input_info(TypeInputInfo **pinputinfo, TupleTableSlot *slot, EState *estate);

/**
 * @brief Transform mysql output into pg field data 
 */
extern void ExecStoreRemoteTuple(TypeInputInfo *inputinfo,
				 MYSQL_ROW row,
				 unsigned long *lengths,
				 enum enum_field_types *fieldtypes,
				 TupleTableSlot *slot,
				 int firstNCols);
#endif