set remote_rel.apply_ddl_log_mode=1;

CREATE FUNCTION utc_timestamp() RETURNS SETOF timestamp AS $$
BEGIN
	return query select CURRENT_TIMESTAMP(0) at time zone 'UTC';
END;
$$ LANGUAGE plpgsql;


CREATE FUNCTION unix_timestamp() RETURNS SETOF bigint AS $$
BEGIN
	return query SELECT EXTRACT(EPOCH FROM current_timestamp(0))::bigint;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION unix_timestamp(ts timestamp) RETURNS SETOF bigint AS $$
BEGIN
	return query SELECT EXTRACT(EPOCH FROM ts)::bigint;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION unix_timestamp(ts timestamptz) RETURNS SETOF bigint AS $$
BEGIN
	return query SELECT EXTRACT(EPOCH FROM ts)::bigint;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION timediff(ts1 timestamptz, ts2 timestamp) RETURNS SETOF text AS $$
BEGIN
	return query select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION timediff(ts1 timestamptz, ts2 timestamptz) RETURNS SETOF text AS $$
BEGIN
	return query select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION timediff(ts1 timestamp, ts2 timestamptz) RETURNS SETOF text AS $$
BEGIN
	return query select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION timediff(ts1 timestamp, ts2 timestamp) RETURNS SETOF text AS $$
BEGIN
	return query select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
END;
$$ LANGUAGE plpgsql;
