#!/bin/bash

cnfpath=`realpath ../conf/cluster_mgr.cnf`

num=`ps -ef | grep ${cnfpath} | grep -v grep | grep -v vim | wc -l`
[ $num -gt 0 ] && {
        echo `pwd`"/cluster_mgr is running, so quit to start again" 
        exit 0
}

ulimit -c unlimited
if test "$USE_VALGRIND" = ""; then
	./cluster_mgr ${cnfpath} >../log/std.log 2>&1
else
	valgrind --leak-check=full --trace-children=yes --undef-value-errors=no ./cluster_mgr ${cnfpath} >../log/std.log 2>&1
fi
ps -ef | grep ${cnfpath} | grep -v grep
