/*-------------------------------------------------------------------------
 *
 * pg_mysql_collation_mapping.h
 *	  mapping of PostgreSQL and MySQL system character sets.
 *
 *
 * Copyright (c) 2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * src/include/catalog/pg_mysql_collation_mapping.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_MYSQL_COLLATION_MAPPING_H
#define PG_MYSQL_COLLATION_MAPPING_H

#include "catalog/genbki.h"
#include "catalog/pg_mysql_collation_mapping_d.h"

/*
  Map a pg's collation to a mysql collation.
 * */
CATALOG(pg_mysql_collation_mapping,12356,PgMySQLCollationMappingId) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
  NameData pg_collname; /* pg collation name */
  int32 pg_charset_enc;
  int32 mysql_collation_code; /*comes from mysql ctype*.cc */
  bool is_default BKI_DEFAULT(f); /* whether this collation is default collation for the charset */
  bool deduced; /* we deduce a few entries from info from various docs and internet */
  NameData mysql_csname; /* mysql charset */
  NameData mysql_collname; /* mysql collation */
}
FormData_pg_mysql_collation_mapping;

typedef FormData_pg_mysql_collation_mapping*Form_pg_mysql_collation_mapping;

#endif /* !PG_MYSQL_COLLATION_MAPPING_H */
