#ifndef REMOTE_PLAN_UTILS_H
#define REMOTE_PLAN_UTILS_H

#include "nodes/execnodes.h"
#include "nodes/plannodes.h"
#include "nodes/relation.h"

typedef Node *(Replace_param_func)(PlannerInfo *root, Node *expr);

/**
 * @brief Generate full name on storage shards in formats `db_$$_schema`.`objname`
 */
extern const char *make_qualified_name(Oid nspid, const char *objname, int *plen);

/**
 * @brief Generate escpaed database name on storage shards in formats db_$$_schema.
 */
extern char *make_escaped_remote_dbname(Oid nspid);

extern char *make_escaped_remote_name(const char *name);

/**
 * @brief Dump the detail information abort remote path as warning
 */
void debug_remote_path(PlannerInfo *root, RemotePath *remote, const char *func);

/**
 * @brief Make remote plan based the remote path
 *
 * @param root         The global planning information
 * @param path        The remote path
 * @param tlist         The Target list
 * @param func        Function convert the var coming from outer node into param_exec
 */
extern RemotePlan *make_remote_plan(PlannerInfo *root, RemotePath *path,
                                    List *tlist, Replace_param_func *func);

/**
 * @brief Combine the params into the prepared sql by replacing the holdplace with the
 *      actual value of the coresponding param
 *
 * @param combined_sql  Output string
 */
extern void combine_remote_sql_param(EState *estate, const char* prepared_sql,
                                     List *params, List *params_location, StringInfo combined_sql);

extern void compute_remote_sql_param_digest(EState *estate, List *params, StringInfo digest);

/**
 * @brief Convert list of param node into list of ShardStmtParam, which used to execute remote sql in
 *  binary protocal
 * 
 * @return List*  list of ShardStmtParam
 */
extern List* make_execute_param_list(EState *estate, List *params);

#endif