set remote_rel.apply_ddl_log_mode=1;

CREATE OR REPLACE FUNCTION utc_timestamp() RETURNS  timestamp AS $$ select CURRENT_TIMESTAMP(0) at time zone 'UTC'; $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION unix_timestamp() RETURNS bigint AS $$ SELECT EXTRACT(EPOCH FROM current_timestamp(0))::bigint; $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION unix_timestamp(ts timestamp) RETURNS bigint AS $$ SELECT EXTRACT(EPOCH FROM ts)::bigint; $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION unix_timestamp(ts timestamptz) RETURNS bigint AS $$ SELECT EXTRACT(EPOCH FROM ts)::bigint; $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION timediff(ts1 timestamptz, ts2 timestamp) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION timediff(ts1 timestamptz, ts2 timestamptz) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION timediff(ts1 timestamp, ts2 timestamptz) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION timediff(ts1 timestamp, ts2 timestamp) RETURNS text AS $$
	select concat(((extract (days from (ts1-ts2)))*24 + extract (hours from (ts1-ts2)))::text,
		':' , (extract (minutes from (ts1-ts2)))::text , ':',
		((extract (seconds from (ts1-ts2)))::bigint)::text) as timediff;
$$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION nextval_safe(seq_name varchar(64)) RETURNS bigint AS $$ select nextval(seq_name::regclass)::bigint; $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION round(d double precision, n int)  returns double as $$ select round($1::numeric,$2)::double;  $$ language sql;

CREATE OR REPLACE FUNCTION curdate() returns date as $$ select current_date; $$ language sql;

CREATE OR REPLACE FUNCTION curtime() returns time as $$ select current_time(0)::time; $$ language sql;

CREATE OR REPLACE FUNCTION date_sub(date, interval) returns date as $$ select ($1 - $2)::date; $$ language sql;

CREATE OR REPLACE FUNCTION date_sub(datetime, interval) returns datetime as $$ select ($1 - $2)::datetime; $$ language sql;

CREATE OR REPLACE FUNCTION date_add(date, interval) returns date as $$ select ($1 + $2)::date; $$ language sql;

CREATE OR REPLACE FUNCTION date_add(datetime, interval) returns datetime as $$ select ($1 + $2)::datetime; $$ language sql;

CREATE FUNCTION numeric_text_eq (numeric,  text) RETURNS bool AS 'select $1 =$2::numeric' LANGUAGE sql IMMUTABLE STRICT;
CREATE FUNCTION numeric_text_neq(numeric,  text) RETURNS bool AS 'select $1<>$2::numeric' LANGUAGE sql IMMUTABLE STRICT;
CREATE OPERATOR =   (LEFTARG = numeric, RIGHTARG = text, PROCEDURE = numeric_text_eq, COMMUTATOR = '=' );
CREATE OPERATOR <>  (LEFTARG = numeric, RIGHTARG = text, PROCEDURE = numeric_text_neq, COMMUTATOR = '<>' );

CREATE FUNCTION text_numeric_eq (text, numeric) RETURNS bool AS 'select $1::numeric =$2' LANGUAGE sql IMMUTABLE STRICT;
CREATE FUNCTION text_numeric_neq(text, numeric) RETURNS bool AS 'select $1::numeric<>$2' LANGUAGE sql IMMUTABLE STRICT;
CREATE OPERATOR =   (LEFTARG = text, RIGHTARG = numeric, PROCEDURE = text_numeric_eq, COMMUTATOR = '=' );
CREATE OPERATOR <>  (LEFTARG = text, RIGHTARG = numeric, PROCEDURE = text_numeric_neq, COMMUTATOR = '<>' );
