#!/bin/bash
MODE=${1:-double}

cnfpath=`realpath ../conf/node_mgr.cnf`
source ./extra.env

num=`ps -ef | grep ${cnfpath} | grep -v grep | grep -v vim | wc -l`
[ $num -gt 0 ] && {
        echo `pwd`"node_mgr is running, so quit to start again" 
        exit 0
}

if test "$USE_VALGRIND" = ""; then
	if [ ${MODE} == "single" ]; then
		./node_mgr ${cnfpath} ${MODE} >../log/std.log 2>&1 &
	else
		./node_mgr ${cnfpath} >../log/std.log 2>&1
	fi
else
	valgrind --leak-check=full --undef-value-errors=no ./node_mgr ${cnfpath} >../log/std.log 2>&1
fi

# sleep 5 seconds to let the process appear in ps command, for busy machines.
sleep 5

ps --sort=start_time -ef | grep ${cnfpath} | grep -v grep | awk '{print $2}' | head -1 > nodemgr.pid
