/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.ResultSetField;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIDriver;
import org.postgresql.pljava.jdbc.SyntheticResultSet;
import org.postgresql.pljava.jdbc.TypeOid;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIDatabaseMetaData
implements DatabaseMetaData {
    private static final String KEYWORDS = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    private final SPIConnection m_connection;
    private static final int VARHDRSZ = 4;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static final HashMap<String, String> s_tableTypeClauses = new HashMap();
    private static final String[] s_defaultTableTypes;

    public SPIDatabaseMetaData(SPIConnection conn) {
        this.m_connection = conn;
    }

    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            this.INDEX_MAX_KEYS = Integer.parseInt(Backend.getConfigOption("max_index_keys"));
        }
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String sql = "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace OPERATOR(pg_catalog.=) n.oid\tAND t.typname OPERATOR(pg_catalog.=) 'name'\tAND n.nspname OPERATOR(pg_catalog.=) 'pg_catalog'";
            ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
            if (!rs.next()) {
                throw new SQLException("Unable to find name datatype in the system catalogs.");
            }
            this.NAMEDATALEN = rs.getInt("typlen");
            rs.close();
        }
        return this.NAMEDATALEN - 1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return "jdbc:default:connection";
    }

    @Override
    public String getUserName() throws SQLException {
        return AclId.getUser().getName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.m_connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "PostgreSQL";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        int[] ver = this.m_connection.getVersionNumber();
        return ver[0] + "." + ver[1] + "." + ver[2];
    }

    @Override
    public String getDriverName() throws SQLException {
        return "PostgreSQL pljava SPI Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        SPIDriver d = new SPIDriver();
        return d.getMajorVersion() + "." + d.getMinorVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return new SPIDriver().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return new SPIDriver().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return KEYWORDS;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan,truncate";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String funcs = "ascii,char,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase,replace";
        return funcs;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (level == 8 || level == 2) {
            return true;
        }
        return this.getDatabaseMajorVersion() >= 8 && (level == 1 || level == 4);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    private static String escapeQuotes(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int prevChar = 32;
        int prevPrevChar = 32;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\'' && (prevChar != 92 || prevChar == 92 && prevPrevChar == 92)) {
                sb.append("'");
            }
            prevPrevChar = prevChar;
            prevChar = c;
        }
        return sb.toString();
    }

    private static String resolveSchemaConditionWithOperator(String expr, String schema, String operator) {
        if (schema == null) {
            return "1 OPERATOR(pg_catalog.=) 1";
        }
        if (!"".equals(schema)) {
            return expr + " " + operator + " '" + SPIDatabaseMetaData.escapeQuotes(schema) + "' ";
        }
        return expr + " " + operator + " 'public' ";
    }

    private static String resolveSchemaCondition(String expr, String schema) {
        return SPIDatabaseMetaData.resolveSchemaConditionWithOperator(expr, schema, "OPERATOR(pg_catalog.=)");
    }

    private static String resolveSchemaPatternCondition(String expr, String schema) {
        return SPIDatabaseMetaData.resolveSchemaConditionWithOperator(expr, schema, "LIKE");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d  ON (p.oid OPERATOR(pg_catalog.=) d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (  d.classoid OPERATOR(pg_catalog.=) c.oid  AND c.relname OPERATOR(pg_catalog.=) 'pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (  c.relnamespace OPERATOR(pg_catalog.=) pn.oid  AND pn.nspname OPERATOR(pg_catalog.=) 'pg_catalog')  WHERE p.pronamespace OPERATOR(pg_catalog.=) n.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (procedureNamePattern != null) {
            sql = sql + " AND p.proname LIKE '" + SPIDatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME ";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ResultSetField[] f = new ResultSetField[13];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("PROCEDURE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("PROCEDURE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("PROCEDURE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[3] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("COLUMN_TYPE", TypeOid.INT2, 2);
        f[5] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[6] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[7] = new ResultSetField("PRECISION", TypeOid.INT4, 4);
        f[8] = new ResultSetField("LENGTH", TypeOid.INT4, 4);
        f[9] = new ResultSetField("SCALE", TypeOid.INT2, 2);
        f[10] = new ResultSetField("RADIX", TypeOid.INT2, 2);
        f[11] = new ResultSetField("NULLABLE", TypeOid.INT2, 2);
        f[12] = new ResultSetField("REMARKS", TypeOid.VARCHAR, this.getMaxNameLength());
        String sql = "SELECT  n.nspname, p.proname, p.prorettype, p.proargtypes,  t.typtype::pg_catalog.varchar, t.typrelid  FROM  pg_catalog.pg_proc p, pg_catalog.pg_namespace n,  pg_catalog.pg_type t WHERE p.pronamespace OPERATOR(pg_catalog.=) n.oid AND p.prorettype OPERATOR(pg_catalog.=) t.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (procedureNamePattern != null) {
            sql = sql + " AND p.proname LIKE '" + SPIDatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY n.nspname, p.proname ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        String schema = null;
        String procedureName = null;
        Oid returnType = null;
        String returnTypeType = null;
        Oid returnTypeRelid = null;
        Oid[] argTypes = null;
        while (rs.next()) {
            schema = rs.getString("nspname");
            procedureName = rs.getString("proname");
            returnType = (Oid)rs.getObject("prorettype");
            returnTypeType = rs.getString("typtype");
            returnTypeRelid = (Oid)rs.getObject("typrelid");
            argTypes = (Oid[])rs.getObject("proargtypes");
            if (!returnTypeType.equals("c")) {
                Object[] tuple = new Object[]{null, schema, procedureName, "returnValue", new Short(5), new Short((short)this.m_connection.getSQLType(returnType)), this.m_connection.getPGType(returnType), null, null, null, null, new Short(2), null};
                v.add(tuple);
            }
            for (int i = 0; i < argTypes.length; ++i) {
                Oid argOid = argTypes[i];
                Object[] tuple = new Object[]{null, schema, procedureName, "$" + (i + 1), new Short(1), new Short((short)this.m_connection.getSQLType(argOid)), this.m_connection.getPGType(argOid), null, null, null, null, new Short(2), null};
                v.add(tuple);
            }
            if (!returnTypeType.equals("c")) continue;
            String columnsql = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a WHERE a.attrelid = ? ORDER BY a.attnum ";
            PreparedStatement stmt = this.m_connection.prepareStatement(columnsql);
            stmt.setObject(1, returnTypeRelid);
            ResultSet columnrs = stmt.executeQuery(columnsql);
            while (columnrs.next()) {
                Oid columnTypeOid = (Oid)columnrs.getObject("atttypid");
                Object[] tuple = new Object[]{null, schema, procedureName, columnrs.getString("attname"), new Short(3), new Short((short)this.m_connection.getSQLType(columnTypeOid)), this.m_connection.getPGType(columnTypeOid), null, null, null, null, new Short(2), null};
                v.add(tuple);
            }
            columnrs.close();
            stmt.close();
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String useSchemas = "SCHEMAS";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE  n.nspname LIKE 'pg!_%' ESCAPE '!'  OR n.nspname OPERATOR(pg_catalog.=) 'information_schema'  WHEN true THEN CASE   WHEN   n.nspname OPERATOR(pg_catalog.=) 'pg_catalog'   OR n.nspname OPERATOR(pg_catalog.=) 'information_schema'  THEN CASE c.relkind    WHEN 'r'::pg_catalog.\"char\" THEN 'SYSTEM TABLE'    WHEN 'v'::pg_catalog.\"char\" THEN 'SYSTEM VIEW'    WHEN 'i'::pg_catalog.\"char\" THEN 'SYSTEM INDEX'    ELSE NULL    END   WHEN n.nspname OPERATOR(pg_catalog.=) 'pg_toast'  THEN CASE c.relkind    WHEN 'r'::pg_catalog.\"char\" THEN 'SYSTEM TOAST TABLE'    WHEN 'i'::pg_catalog.\"char\" THEN 'SYSTEM TOAST INDEX'    ELSE NULL    END   ELSE CASE c.relkind    WHEN 'r'::pg_catalog.\"char\" THEN 'TEMPORARY TABLE'    WHEN 'i'::pg_catalog.\"char\" THEN 'TEMPORARY INDEX'    ELSE NULL    END   END  WHEN false THEN CASE c.relkind   WHEN 'r'::pg_catalog.\"char\" THEN 'TABLE'   WHEN 'i'::pg_catalog.\"char\" THEN 'INDEX'   WHEN 'S'::pg_catalog.\"char\" THEN 'SEQUENCE'   WHEN 'v'::pg_catalog.\"char\" THEN 'VIEW'   ELSE NULL   END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (  c.oid OPERATOR(pg_catalog.=) d.objoid  AND d.objsubid OPERATOR(pg_catalog.=) 0)  LEFT JOIN pg_catalog.pg_class dc ON (  d.classoid OPERATOR(pg_catalog.=) dc.oid  AND dc.relname OPERATOR(pg_catalog.=) 'pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (  dn.oid OPERATOR(pg_catalog.=) dc.relnamespace  AND dn.nspname OPERATOR(pg_catalog.=) 'pg_catalog')  WHERE c.relnamespace OPERATOR(pg_catalog.=) n.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (types == null) {
            types = s_defaultTableTypes;
        }
        if (tableNamePattern != null) {
            select = select + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        String sql = select;
        sql = sql + " AND (false ";
        for (int i = 0; i < types.length; ++i) {
            String clause = s_tableTypeClauses.get(types[i]);
            if (clause == null) continue;
            sql = sql + " OR ( " + clause + " ) ";
        }
        sql = sql + ") ";
        sql = sql + orderby;
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String sql = "SELECT nspname AS TABLE_SCHEM FROM pg_catalog.pg_namespace WHERE nspname  OPERATOR(pg_catalog.<>) 'pg_toast' AND nspname NOT LIKE 'pg!_temp!_%' ESCAPE '!' ORDER BY TABLE_SCHEM";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT datname AS TABLE_CAT FROM pg_catalog.pg_database ORDER BY TABLE_CAT";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Object[] types = s_tableTypeClauses.keySet().toArray(new String[s_tableTypeClauses.size()]);
        Arrays.sort(types);
        ResultSetField[] f = new ResultSetField[1];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField(new String("TABLE_TYPE"), TypeOid.VARCHAR, this.getMaxNameLength());
        for (int i = 0; i < types.length; ++i) {
            Object[] tuple = new Object[]{types[i]};
            v.add(tuple);
        }
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        ResultSetField[] f = new ResultSetField[]{new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DATA_TYPE", TypeOid.INT2, 2), new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4), new ResultSetField("BUFFER_LENGTH", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DECIMAL_DIGITS", TypeOid.INT4, 4), new ResultSetField("NUM_PREC_RADIX", TypeOid.INT4, 4), new ResultSetField("NULLABLE", TypeOid.INT4, 4), new ResultSetField("REMARKS", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_DEF", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("SQL_DATA_TYPE", TypeOid.INT4, 4), new ResultSetField("SQL_DATETIME_SUB", TypeOid.INT4, 4), new ResultSetField("CHAR_OCTET_LENGTH", TypeOid.INT4, 4), new ResultSetField("ORDINAL_POSITION", TypeOid.INT4, 4), new ResultSetField("IS_NULLABLE", TypeOid.VARCHAR, this.getMaxNameLength())};
        String sql = "SELECT n.nspname, c.relname, a.attname, a.atttypid as atttypid, a.attnotnull, a.atttypmod, a.attlen::pg_catalog.int4 as attlen, a.attnum, pg_catalog.pg_get_expr(def.adbin, c.oid) AS adsrc, dsc.description FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c  ON (c.relnamespace OPERATOR(pg_catalog.=) n.oid)  JOIN pg_catalog.pg_attribute a   ON (a.attrelid OPERATOR(pg_catalog.=) c.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (  a.attrelid OPERATOR(pg_catalog.=) def.adrelid  AND a.attnum OPERATOR(pg_catalog.=) def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (  c.oid OPERATOR(pg_catalog.=) dsc.objoid  AND a.attnum OPERATOR(pg_catalog.=) dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (  dc.oid OPERATOR(pg_catalog.=) dsc.classoid  AND dc.relname OPERATOR(pg_catalog.=) 'pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (  dc.relnamespace OPERATOR(pg_catalog.=) dn.oid  AND dn.nspname OPERATOR(pg_catalog.=) 'pg_catalog')  WHERE a.attnum OPERATOR(pg_catalog.>) 0 AND NOT a.attisdropped  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + SPIDatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname,relname,attnum ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            Object[] tuple = new Object[18];
            Oid typeOid = (Oid)rs.getObject("atttypid");
            tuple[0] = null;
            tuple[1] = rs.getString("nspname");
            tuple[2] = rs.getString("relname");
            tuple[3] = rs.getString("attname");
            tuple[4] = new Short((short)this.m_connection.getSQLType(typeOid));
            String pgType = this.m_connection.getPGType(typeOid);
            tuple[5] = this.m_connection.getPGType(typeOid);
            String defval = rs.getString("adsrc");
            if (defval != null) {
                if (pgType.equals("int4")) {
                    if (defval.indexOf("nextval(") != -1) {
                        tuple[5] = "serial";
                    }
                } else if (pgType.equals("int8") && defval.indexOf("nextval(") != -1) {
                    tuple[5] = "bigserial";
                }
            }
            tuple[8] = new Integer(0);
            if (pgType.equals("bpchar") || pgType.equals("varchar")) {
                int atttypmod = rs.getInt("atttypmod");
                tuple[6] = new Integer(atttypmod != -1 ? atttypmod - 4 : 0);
            } else if (pgType.equals("numeric") || pgType.equals("decimal")) {
                int attypmod = rs.getInt("atttypmod") - 4;
                tuple[6] = new Integer(attypmod >> 16 & 0xFFFF);
                tuple[8] = new Integer(attypmod & 0xFFFF);
                tuple[9] = new Integer(10);
            } else if (pgType.equals("bit") || pgType.equals("varbit")) {
                tuple[6] = rs.getObject("atttypmod");
                tuple[9] = new Integer(2);
            } else {
                tuple[6] = rs.getObject("attlen");
                tuple[9] = new Integer(10);
            }
            tuple[7] = null;
            tuple[10] = new Integer(rs.getBoolean("attnotnull") ? 0 : 1);
            tuple[11] = rs.getString("description");
            tuple[12] = rs.getString("adsrc");
            tuple[13] = null;
            tuple[14] = null;
            tuple[15] = tuple[6];
            tuple[16] = new Integer(rs.getInt("attnum"));
            tuple[17] = rs.getBoolean("attnotnull") ? "NO" : "YES";
            v.add(tuple);
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ResultSetField[] f = new ResultSetField[8];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        if (table == null) {
            table = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        f[0] = new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[3] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("GRANTOR", TypeOid.VARCHAR, this.getMaxNameLength());
        f[5] = new ResultSetField("GRANTEE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[6] = new ResultSetField("PRIVILEGE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[7] = new ResultSetField("IS_GRANTABLE", TypeOid.VARCHAR, this.getMaxNameLength());
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl,a.attname  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u, pg_catalog.pg_attribute a  WHERE c.relnamespace OPERATOR(pg_catalog.=) n.oid  AND u.usesysid OPERATOR(pg_catalog.=) c.relowner  AND c.oid OPERATOR(pg_catalog.=) a.attrelid  AND c.relkind OPERATOR(pg_catalog.=) 'r'  AND a.attnum OPERATOR(pg_catalog.>) 0 AND NOT a.attisdropped  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        sql = sql + " AND c.relname OPERATOR(pg_catalog.=) '" + SPIDatabaseMetaData.escapeQuotes(table) + "' ";
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + SPIDatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY attname ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        String schemaName = null;
        String tableName = null;
        String column = null;
        String owner = null;
        String[] acls = null;
        HashMap permissions = null;
        Object[] permNames = null;
        while (rs.next()) {
            schemaName = rs.getString("nspname");
            tableName = rs.getString("relname");
            column = rs.getString("attname");
            owner = rs.getString("usename");
            acls = (String[])rs.getObject("relacl");
            permissions = this.parseACL(acls, owner);
            permNames = permissions.keySet().toArray(new String[permissions.size()]);
            Arrays.sort(permNames);
            for (int i = 0; i < permNames.length; ++i) {
                ArrayList grantees = (ArrayList)permissions.get(permNames[i]);
                for (int j = 0; j < grantees.size(); ++j) {
                    String grantee = (String)grantees.get(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    Object[] tuple = new Object[]{null, schemaName, tableName, column, owner, grantee, permNames[i], grantable};
                    v.add(tuple);
                }
            }
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSetField[] f = new ResultSetField[7];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[3] = new ResultSetField("GRANTOR", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("GRANTEE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[5] = new ResultSetField("PRIVILEGE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[6] = new ResultSetField("IS_GRANTABLE", TypeOid.VARCHAR, this.getMaxNameLength());
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u  WHERE c.relnamespace = n.oid  AND u.usesysid OPERATOR(pg_catalog.=) c.relowner  AND c.relkind OPERATOR(pg_catalog.=) 'r'  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname, relname ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        String schema = null;
        String table = null;
        String owner = null;
        String[] acls = null;
        HashMap permissions = null;
        Object[] permNames = null;
        while (rs.next()) {
            schema = rs.getString("nspname");
            table = rs.getString("relname");
            owner = rs.getString("usename");
            acls = (String[])rs.getObject("relacl");
            permissions = this.parseACL(acls, owner);
            permNames = permissions.keySet().toArray(new String[permissions.size()]);
            Arrays.sort(permNames);
            for (int i = 0; i < permNames.length; ++i) {
                ArrayList grantees = (ArrayList)permissions.get(permNames[i]);
                for (int j = 0; j < grantees.size(); ++j) {
                    String grantee = (String)grantees.get(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    Object[] tuple = new Object[]{null, schema, table, owner, grantee, permNames[i], grantable};
                    v.add(tuple);
                }
            }
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    private void addACLPrivileges(String acl, HashMap privileges) {
        int equalIndex = acl.lastIndexOf("=");
        String name = acl.substring(0, equalIndex);
        if (name.length() == 0) {
            name = "PUBLIC";
        }
        String privs = acl.substring(equalIndex + 1);
        for (int i = 0; i < privs.length(); ++i) {
            String sqlpriv;
            char c = privs.charAt(i);
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            ArrayList<String> usersWithPermission = (ArrayList<String>)privileges.get(sqlpriv);
            if (usersWithPermission == null) {
                usersWithPermission = new ArrayList<String>();
                privileges.put(sqlpriv, usersWithPermission);
            }
            usersWithPermission.add(name);
        }
    }

    protected HashMap parseACL(String[] aclArray, String owner) {
        if (aclArray == null || aclArray.length == 0) {
            aclArray = new String[]{owner + "=arwdRxt"};
        }
        HashMap privileges = new HashMap();
        for (int i = 0; i < aclArray.length; ++i) {
            String acl = aclArray[i];
            this.addACLPrivileges(acl, privileges);
        }
        return privileges;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSetField[] f = new ResultSetField[8];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("SCOPE", TypeOid.INT2, 2);
        f[1] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[3] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4);
        f[5] = new ResultSetField("BUFFER_LENGTH", TypeOid.INT4, 4);
        f[6] = new ResultSetField("DECIMAL_DIGITS", TypeOid.INT2, 2);
        f[7] = new ResultSetField("PSEUDO_COLUMN", TypeOid.INT2, 2);
        String where = "";
        String from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
        where = " AND ct.relnamespace OPERATOR(pg_catalog.=) n.oid  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        String sql = "SELECT a.attname, a.atttypid as atttypid " + from + " WHERE ct.oid OPERATOR(pg_catalog.=) i.indrelid  AND ci.oid OPERATOR(pg_catalog.=) i.indexrelid  AND a.attrelid OPERATOR(pg_catalog.=) ci.oid AND i.indisprimary  AND ct.relname OPERATOR(pg_catalog.=) '" + SPIDatabaseMetaData.escapeQuotes(table) + "' " + where + " ORDER BY a.attnum ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            Object[] tuple = new Object[8];
            Oid columnTypeOid = (Oid)rs.getObject("atttypid");
            tuple[0] = new Short((short)scope);
            tuple[1] = rs.getString("attname");
            tuple[2] = new Short((short)this.m_connection.getSQLType(columnTypeOid));
            tuple[3] = this.m_connection.getPGType(columnTypeOid);
            tuple[4] = null;
            tuple[5] = null;
            tuple[6] = null;
            tuple[7] = new Short(1);
            v.add(tuple);
        }
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSetField[] f = new ResultSetField[8];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("SCOPE", TypeOid.INT2, 2);
        f[1] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[3] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4);
        f[5] = new ResultSetField("BUFFER_LENGTH", TypeOid.INT4, 4);
        f[6] = new ResultSetField("DECIMAL_DIGITS", TypeOid.INT2, 2);
        f[7] = new ResultSetField("PSEUDO_COLUMN", TypeOid.INT2, 2);
        Object[] tuple = new Object[]{null, "ctid", new Short((short)this.m_connection.getSQLType("tid")), "tid", null, null, null, new Short(2)};
        v.add(tuple);
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String where = "";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
        where = " AND ct.relnamespace OPERATOR(pg_catalog.=) n.oid AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        String sql = select + " ct.relname AS TABLE_NAME,  a.attname AS COLUMN_NAME, a.attnum::pg_catalog.int2 AS KEY_SEQ,  ci.relname AS PK_NAME " + from + " WHERE ct.oid OPERATOR(pg_catalog.=) i.indrelid AND ci.oid OPERATOR(pg_catalog.=) i.indexrelid  AND a.attrelid OPERATOR(pg_catalog.=) ci.oid AND i.indisprimary ";
        if (table != null && !"".equals(table)) {
            sql = sql + " AND ct.relname OPERATOR(pg_catalog.=) '" + SPIDatabaseMetaData.escapeQuotes(table) + "' ";
        }
        sql = sql + where + " ORDER BY table_name, pk_name, key_seq";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ResultSetField[] f = new ResultSetField[]{new ResultSetField("PKTABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKTABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKTABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKCOLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKCOLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("KEY_SEQ", TypeOid.INT2, 2), new ResultSetField("UPDATE_RULE", TypeOid.INT2, 2), new ResultSetField("DELETE_RULE", TypeOid.INT2, 2), new ResultSetField("FK_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PK_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DEFERRABILITY", TypeOid.INT2, 2)};
        String sql = "SELECT NULL::pg_catalog.text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::pg_catalog.text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n::pg_catalog.int2 AS KEY_SEQ, CASE con.confupdtype  WHEN 'c'::pg_catalog.\"char\" THEN 0 WHEN 'n'::pg_catalog.\"char\" THEN 2 WHEN 'd'::pg_catalog.\"char\" THEN 4 WHEN 'r'::pg_catalog.\"char\" THEN 1 WHEN 'a'::pg_catalog.\"char\" THEN 3 ELSE NULL END::pg_catalog.int2 AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c'::pg_catalog.\"char\" THEN 0 WHEN 'n'::pg_catalog.\"char\" THEN 2 WHEN 'd'::pg_catalog.\"char\" THEN 4 WHEN 'r'::pg_catalog.\"char\" THEN 1 WHEN 'a'::pg_catalog.\"char\" THEN 3 ELSE NULL END::pg_catalog.int2 AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END::pg_catalog.int2 AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n),  pg_catalog.pg_depend dep, pg_catalog.pg_class pkic  WHERE pkn.oid OPERATOR(pg_catalog.=) pkc.relnamespace AND pkc.oid OPERATOR(pg_catalog.=) pka.attrelid AND pka.attnum OPERATOR(pg_catalog.=) con.confkey[pos.n] AND con.confrelid OPERATOR(pg_catalog.=) pkc.oid  AND fkn.oid OPERATOR(pg_catalog.=) fkc.relnamespace AND fkc.oid OPERATOR(pg_catalog.=) fka.attrelid AND fka.attnum OPERATOR(pg_catalog.=) con.conkey[pos.n] AND con.conrelid OPERATOR(pg_catalog.=) fkc.oid  AND con.contype OPERATOR(pg_catalog.=) 'f' AND con.oid OPERATOR(pg_catalog.=) dep.objid AND pkic.oid OPERATOR(pg_catalog.=) dep.refobjid AND pkic.relkind OPERATOR(pg_catalog.=) 'i' AND dep.classid OPERATOR(pg_catalog.=) 'pg_constraint'::pg_catalog.regclass::pg_catalog.oid AND dep.refclassid OPERATOR(pg_catalog.=) 'pg_class'::pg_catalog.regclass::pg_catalog.oid AND " + SPIDatabaseMetaData.resolveSchemaCondition("pkn.nspname", primarySchema) + " AND " + SPIDatabaseMetaData.resolveSchemaCondition("fkn.nspname", foreignSchema);
        if (primaryTable != null && !"".equals(primaryTable)) {
            sql = sql + " AND pkc.relname OPERATOR(pg_catalog.=) '" + SPIDatabaseMetaData.escapeQuotes(primaryTable) + "' ";
        }
        if (foreignTable != null && !"".equals(foreignTable)) {
            sql = sql + " AND fkc.relname OPERATOR(pg_catalog.=) '" + SPIDatabaseMetaData.escapeQuotes(foreignTable) + "' ";
        }
        sql = primaryTable != null ? sql + " ORDER BY fkn.nspname,fkc.relname,pos.n" : sql + " ORDER BY pkn.nspname,pkc.relname,pos.n";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schema, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schema, table, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ResultSetField[] f = new ResultSetField[18];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[2] = new ResultSetField("PRECISION", TypeOid.INT4, 4);
        f[3] = new ResultSetField("LITERAL_PREFIX", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("LITERAL_SUFFIX", TypeOid.VARCHAR, this.getMaxNameLength());
        f[5] = new ResultSetField("CREATE_PARAMS", TypeOid.VARCHAR, this.getMaxNameLength());
        f[6] = new ResultSetField("NULLABLE", TypeOid.INT2, 2);
        f[7] = new ResultSetField("CASE_SENSITIVE", TypeOid.BOOL, 1);
        f[8] = new ResultSetField("SEARCHABLE", TypeOid.INT2, 2);
        f[9] = new ResultSetField("UNSIGNED_ATTRIBUTE", TypeOid.BOOL, 1);
        f[10] = new ResultSetField("FIXED_PREC_SCALE", TypeOid.BOOL, 1);
        f[11] = new ResultSetField("AUTO_INCREMENT", TypeOid.BOOL, 1);
        f[12] = new ResultSetField("LOCAL_TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[13] = new ResultSetField("MINIMUM_SCALE", TypeOid.INT2, 2);
        f[14] = new ResultSetField("MAXIMUM_SCALE", TypeOid.INT2, 2);
        f[15] = new ResultSetField("SQL_DATA_TYPE", TypeOid.INT4, 4);
        f[16] = new ResultSetField("SQL_DATETIME_SUB", TypeOid.INT4, 4);
        f[17] = new ResultSetField("NUM_PREC_RADIX", TypeOid.INT4, 4);
        String sql = "SELECT typname FROM pg_catalog.pg_type WHERE typrelid OPERATOR(pg_catalog.=) 0";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        Integer i9 = new Integer(9);
        Integer i10 = new Integer(10);
        Short nn = new Short(0);
        Short ts = new Short(3);
        String typname = null;
        while (rs.next()) {
            Object[] tuple1;
            Object[] tuple = new Object[18];
            typname = rs.getString(1);
            tuple[0] = typname;
            tuple[1] = new Short((short)this.m_connection.getSQLType(typname));
            tuple[2] = i9;
            tuple[6] = nn;
            tuple[7] = Boolean.FALSE;
            tuple[8] = ts;
            tuple[9] = Boolean.FALSE;
            tuple[10] = Boolean.FALSE;
            tuple[11] = Boolean.FALSE;
            tuple[17] = i10;
            v.add(tuple);
            if (typname.equals("int4")) {
                tuple1 = (Object[])tuple.clone();
                tuple1[0] = "serial";
                tuple1[11] = Boolean.TRUE;
                v.add(tuple1);
                continue;
            }
            if (!typname.equals("int8")) continue;
            tuple1 = (Object[])tuple.clone();
            tuple1[0] = "bigserial";
            tuple1[11] = Boolean.TRUE;
            v.add(tuple1);
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_index i, pg_catalog.pg_attribute a, pg_catalog.pg_am am ";
        String where = " AND n.oid OPERATOR(pg_catalog.=) ct.relnamespace  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        String sql = select + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,  CASE i.indisclustered  WHEN true THEN " + 1 + " ELSE CASE WHEN am.amname OPERATOR(pg_catalog.=) 'hash' THEN " + 2 + " ELSE " + 3 + " END  END::pg_catalog.int2 AS TYPE,  a.attnum::pg_catalog.int2 AS ORDINAL_POSITION,  a.attname AS COLUMN_NAME,  NULL AS ASC_OR_DESC,  ci.reltuples AS CARDINALITY,  ci.relpages AS PAGES,  NULL AS FILTER_CONDITION " + from + " WHERE ct.oid OPERATOR(pg_catalog.=) i.indrelid AND ci.oid OPERATOR(pg_catalog.=) i.indexrelid AND a.attrelid OPERATOR(pg_catalog.=) ci.oid AND ci.relam OPERATOR(pg_catalog.=) am.oid " + where + " AND ct.relname OPERATOR(pg_catalog.=) '" + SPIDatabaseMetaData.escapeQuotes(tableName) + "' ";
        if (unique) {
            sql = sql + " AND i.indisunique ";
        }
        sql = sql + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type != 1003) {
            return false;
        }
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT null AS type_cat, n.nspname AS type_schem, t.typname AS type_name, null AS class_name, CASE WHEN t.typtype OPERATOR(pg_catalog.=) 'c' THEN 2002 ELSE 2001 END AS data_type, pg_catalog.obj_description(t.oid, 'pg_type') AS remarks, CASE WHEN t.typtype OPERATOR(pg_catalog.=) 'd' THEN (  select CASE";
        for (int i = 0; i < SPIConnection.JDBC_TYPE_NAMES.length; ++i) {
            sql = sql + " WHEN typname OPERATOR(pg_catalog.=) '" + SPIConnection.JDBC_TYPE_NUMBERS[i] + "' THEN " + SPIConnection.JDBC_TYPE_NUMBERS[i];
        }
        sql = sql + " ELSE 1111 END FROM pg_type WHERE oid OPERATOR(pg_catalog.=) t.typbasetype) ELSE null END AS base_type FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace OPERATOR(pg_catalog.=) n.oid AND n.nspname OPERATOR(pg_catalog.<>) 'pg_catalog' AND n.nspname OPERATOR(pg_catalog.<>) 'pg_toast'";
        String toAdd = "";
        if (types != null) {
            toAdd = toAdd + " and (false ";
            block5: for (int i = 0; i < types.length; ++i) {
                switch (types[i]) {
                    case 2002: {
                        toAdd = toAdd + " or t.typtype OPERATOR(pg_catalog.=) 'c'";
                        continue block5;
                    }
                    case 2001: {
                        toAdd = toAdd + " or t.typtype OPERATOR(pg_catalog.=) 'd'";
                    }
                }
            }
            toAdd = toAdd + " ) ";
        } else {
            toAdd = toAdd + " AND t.typtype IN ('c'::pg_catalog.\"char\", 'd'::pg_catalog.\"char\") ";
        }
        if (typeNamePattern != null) {
            int firstQualifier = typeNamePattern.indexOf(46);
            int secondQualifier = typeNamePattern.lastIndexOf(46);
            if (firstQualifier != -1) {
                schemaPattern = firstQualifier != secondQualifier ? typeNamePattern.substring(firstQualifier + 1, secondQualifier) : typeNamePattern.substring(0, firstQualifier);
                typeNamePattern = typeNamePattern.substring(secondQualifier + 1);
            }
            toAdd = toAdd + " and t.typname like '" + SPIDatabaseMetaData.escapeQuotes(typeNamePattern) + "'";
        }
        if (schemaPattern != null) {
            toAdd = toAdd + " and n.nspname like '" + SPIDatabaseMetaData.escapeQuotes(schemaPattern) + "'";
        }
        sql = sql + toAdd;
        sql = sql + " order by data_type, type_schem, type_name";
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        return rs;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public boolean rowChangesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int type) throws SQLException {
        return false;
    }

    private Statement createMetaDataStatement() throws SQLException {
        return this.m_connection.createStatement(1003, 1007);
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new UnsupportedFeatureException("DatabaseMetaData.getSuperTypes");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedFeatureException("DatabaseMetaData.getSuperTables");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new UnsupportedFeatureException("getAttributes");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return 2 == holdability;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.m_connection.getVersionNumber()[0];
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.m_connection.getVersionNumber()[1];
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private ResultSet createSyntheticResultSet(ResultSetField[] f, ArrayList tuples) throws SQLException {
        return new SyntheticResultSet(f, tuples);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLFeatureNotSupportedException(this.getClass().getSimpleName() + " does not wrap " + iface.getName(), "0A000");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.getFunctionColumns( String, String, String, String ) not implemented yet.", "0A000");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.getFunctions( String, String, String ) not implemented yet.", "0A000");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.getClientInfoProperties() not implemented yet.", "0A000");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.autoCommitFailureClosesAllResultSets() not implemented yet.", "0A000");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.supportsStoredFunctionsUsingCallSyntax() not implemented yet.", "0A000");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.getSchemas( String, String ) not implemented yet.", "0A000");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.getRowIdLifetime() not implemented yet.", "0A000");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIDatabaseMetadata.getPseudoColumns(String,String,String,String) not implemented yet.", "0A000");
    }

    static {
        s_tableTypeClauses.put("TABLE", "c.relkind OPERATOR(pg_catalog.=) 'r' AND n.nspname NOT LIKE 'pg!_%' ESCAPE '!' AND n.nspname OPERATOR(pg_catalog.<>) 'information_schema'");
        s_tableTypeClauses.put("VIEW", "c.relkind OPERATOR(pg_catalog.=) 'v' AND n.nspname OPERATOR(pg_catalog.<>) 'pg_catalog' AND n.nspname OPERATOR(pg_catalog.<>) 'information_schema'");
        s_tableTypeClauses.put("INDEX", "c.relkind OPERATOR(pg_catalog.=) 'i' AND n.nspname NOT LIKE 'pg!_%' ESCAPE '!' AND n.nspname OPERATOR(pg_catalog.<>) 'information_schema'");
        s_tableTypeClauses.put("SEQUENCE", "c.relkind OPERATOR(pg_catalog.=) 'S'");
        s_tableTypeClauses.put("SYSTEM TABLE", "c.relkind OPERATOR(pg_catalog.=) 'r' AND ( n.nspname OPERATOR(pg_catalog.=) 'pg_catalog' OR n.nspname OPERATOR(pg_catalog.=) 'information_schema')");
        s_tableTypeClauses.put("SYSTEM TOAST TABLE", "c.relkind OPERATOR(pg_catalog.=) 'r' AND n.nspname OPERATOR(pg_catalog.=) 'pg_toast'");
        s_tableTypeClauses.put("SYSTEM TOAST INDEX", "c.relkind OPERATOR(pg_catalog.=) 'i' AND n.nspname OPERATOR(pg_catalog.=) 'pg_toast'");
        s_tableTypeClauses.put("SYSTEM VIEW", "c.relkind OPERATOR(pg_catalog.=) 'v' AND ( n.nspname OPERATOR(pg_catalog.=) 'pg_catalog' OR n.nspname OPERATOR(pg_catalog.=) 'information_schema') ");
        s_tableTypeClauses.put("SYSTEM INDEX", "c.relkind OPERATOR(pg_catalog.=) 'i' AND ( n.nspname OPERATOR(pg_catalog.=) 'pg_catalog' OR n.nspname OPERATOR(pg_catalog.=) 'information_schema') ");
        s_tableTypeClauses.put("TEMPORARY TABLE", "c.relkind OPERATOR(pg_catalog.=) 'r' AND n.nspname LIKE 'pg!_temp!_%' ESCAPE '!' ");
        s_tableTypeClauses.put("TEMPORARY INDEX", "c.relkind OPERATOR(pg_catalog.=) 'i' AND n.nspname LIKE 'pg!_temp!_%' ESCAPE '!' ");
        s_defaultTableTypes = new String[]{"TABLE", "VIEW", "INDEX", "SEQUENCE", "TEMPORARY TABLE"};
    }
}

