/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SingleRowReader
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final State m_state;

    public SingleRowReader(DualState.Key cookie, long resourceOwner, long hth, TupleDesc tupleDesc) throws SQLException {
        this.m_state = new State(cookie, this, resourceOwner, hth);
        this.m_tupleDesc = tupleDesc;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getObjectValue(int columnIndex, Class<?> type) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SingleRowReader._getObject(this.m_state.getHeapTupleHeaderPtr(), this.m_tupleDesc.getNativePointer(), columnIndex, type);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    private static SQLException readOnlyException() {
        return new UnsupportedFeatureException("ResultSet is read-only");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }

    private static native Object _getObject(long var0, long var2, int var4, Class<?> var5) throws SQLException;

    private static class State
    extends DualState.SingleGuardedLong<SingleRowReader> {
        private State(DualState.Key cookie, SingleRowReader srr, long ro, long hth) {
            super(cookie, srr, ro, hth);
        }

        private long getHeapTupleHeaderPtr() throws SQLException {
            this.pin();
            try {
                long l = this.guardedLong();
                return l;
            }
            finally {
                this.unpin();
            }
        }
    }
}

