/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlgen;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.BreakIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.postgresql.pljava.ResultSetHandle;
import org.postgresql.pljava.ResultSetProvider;
import org.postgresql.pljava.TriggerData;
import org.postgresql.pljava.annotation.BaseUDT;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.MappedUDT;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLActions;
import org.postgresql.pljava.annotation.SQLType;
import org.postgresql.pljava.annotation.Trigger;
import org.postgresql.pljava.sqlgen.AnnotationValueException;
import org.postgresql.pljava.sqlgen.Commentable;
import org.postgresql.pljava.sqlgen.DDRWriter;
import org.postgresql.pljava.sqlgen.ImpProvider;
import org.postgresql.pljava.sqlgen.Lexicals;
import org.postgresql.pljava.sqlgen.Snippet;
import org.postgresql.pljava.sqlgen.SnippetTiebreaker;
import org.postgresql.pljava.sqlgen.TriggerNamer;
import org.postgresql.pljava.sqlgen.TypeTiebreaker;
import org.postgresql.pljava.sqlgen.Vertex;
import org.postgresql.pljava.sqlgen.VertexPair;

class DDRProcessorImpl {
    final Elements elmu;
    final Filer filr;
    final Locale loca;
    final Messager msgr;
    final Map<String, String> opts;
    final SourceVersion srcv;
    final Types typu;
    final TypeMapper tmpr;
    final SnippetTiebreaker snippetTiebreaker;
    final String nameTrusted;
    final String nameUntrusted;
    final String output;
    final String defaultImplementor;
    final boolean reproducible;
    final DeclaredType TY_ITERATOR;
    final DeclaredType TY_OBJECT;
    final DeclaredType TY_RESULTSET;
    final DeclaredType TY_RESULTSETPROVIDER;
    final DeclaredType TY_RESULTSETHANDLE;
    final DeclaredType TY_SQLDATA;
    final DeclaredType TY_SQLINPUT;
    final DeclaredType TY_SQLOUTPUT;
    final DeclaredType TY_STRING;
    final DeclaredType TY_TRIGGERDATA;
    final NoType TY_VOID;
    final TypeElement AN_FUNCTION;
    final TypeElement AN_SQLACTION;
    final TypeElement AN_SQLACTIONS;
    final TypeElement AN_SQLTYPE;
    final TypeElement AN_TRIGGER;
    final TypeElement AN_BASEUDT;
    final TypeElement AN_MAPPEDUDT;
    Map<SnippetsKey, Snippet> snippets = new HashMap<SnippetsKey, Snippet>();
    List<VertexPair<Snippet>> snippetVPairs = new ArrayList<VertexPair<Snippet>>();
    Map<String, VertexPair<Snippet>> provider = new HashMap<String, VertexPair<Snippet>>();
    static final Pattern arrayish = Pattern.compile("(?si:(?:\\[\\s*+\\d*+\\s*+\\]|ARRAY)\\s*+)$");

    DDRProcessorImpl(ProcessingEnvironment processingEnv) {
        this.elmu = processingEnv.getElementUtils();
        this.filr = processingEnv.getFiler();
        this.loca = processingEnv.getLocale();
        this.msgr = processingEnv.getMessager();
        this.opts = processingEnv.getOptions();
        this.srcv = processingEnv.getSourceVersion();
        this.typu = processingEnv.getTypeUtils();
        this.tmpr = new TypeMapper();
        String optv = this.opts.get("ddr.name.trusted");
        this.nameTrusted = null != optv ? optv : "java";
        optv = this.opts.get("ddr.name.untrusted");
        this.nameUntrusted = null != optv ? optv : "javaU";
        optv = this.opts.get("ddr.implementor");
        this.defaultImplementor = null != optv ? ("-".equals(optv) ? null : optv) : "PostgreSQL";
        optv = this.opts.get("ddr.output");
        this.output = null != optv ? optv : "pljava.ddr";
        optv = this.opts.get("ddr.reproducible");
        this.reproducible = null != optv ? Boolean.parseBoolean(optv) : true;
        this.snippetTiebreaker = this.reproducible ? new SnippetTiebreaker() : null;
        this.TY_ITERATOR = this.typu.getDeclaredType(this.elmu.getTypeElement(Iterator.class.getName()), new TypeMirror[0]);
        this.TY_OBJECT = this.typu.getDeclaredType(this.elmu.getTypeElement(Object.class.getName()), new TypeMirror[0]);
        this.TY_RESULTSET = this.typu.getDeclaredType(this.elmu.getTypeElement(ResultSet.class.getName()), new TypeMirror[0]);
        this.TY_RESULTSETPROVIDER = this.typu.getDeclaredType(this.elmu.getTypeElement(ResultSetProvider.class.getName()), new TypeMirror[0]);
        this.TY_RESULTSETHANDLE = this.typu.getDeclaredType(this.elmu.getTypeElement(ResultSetHandle.class.getName()), new TypeMirror[0]);
        this.TY_SQLDATA = this.typu.getDeclaredType(this.elmu.getTypeElement(SQLData.class.getName()), new TypeMirror[0]);
        this.TY_SQLINPUT = this.typu.getDeclaredType(this.elmu.getTypeElement(SQLInput.class.getName()), new TypeMirror[0]);
        this.TY_SQLOUTPUT = this.typu.getDeclaredType(this.elmu.getTypeElement(SQLOutput.class.getName()), new TypeMirror[0]);
        this.TY_STRING = this.typu.getDeclaredType(this.elmu.getTypeElement(String.class.getName()), new TypeMirror[0]);
        this.TY_TRIGGERDATA = this.typu.getDeclaredType(this.elmu.getTypeElement(TriggerData.class.getName()), new TypeMirror[0]);
        this.TY_VOID = this.typu.getNoType(TypeKind.VOID);
        this.AN_FUNCTION = this.elmu.getTypeElement(Function.class.getName());
        this.AN_SQLACTION = this.elmu.getTypeElement(SQLAction.class.getName());
        this.AN_SQLACTIONS = this.elmu.getTypeElement(SQLActions.class.getName());
        this.AN_SQLTYPE = this.elmu.getTypeElement(SQLType.class.getName());
        this.AN_TRIGGER = this.elmu.getTypeElement(Trigger.class.getName());
        this.AN_BASEUDT = this.elmu.getTypeElement(BaseUDT.class.getName());
        this.AN_MAPPEDUDT = this.elmu.getTypeElement(MappedUDT.class.getName());
    }

    void msg(Diagnostic.Kind kind, String fmt, Object ... args) {
        this.msgr.printMessage(kind, String.format(fmt, args));
    }

    void msg(Diagnostic.Kind kind, Element e, String fmt, Object ... args) {
        this.msgr.printMessage(kind, String.format(fmt, args), e);
    }

    void msg(Diagnostic.Kind kind, Element e, AnnotationMirror a, String fmt, Object ... args) {
        this.msgr.printMessage(kind, String.format(fmt, args), e, a);
    }

    void msg(Diagnostic.Kind kind, Element e, AnnotationMirror a, AnnotationValue v, String fmt, Object ... args) {
        this.msgr.printMessage(kind, String.format(fmt, args), e, a, v);
    }

    <S extends Snippet> S getSnippet(Object o, Class<S> c) {
        return (S)this.snippets.get(new SnippetsKey(o, c));
    }

    void putSnippet(Object o, Snippet s) {
        this.snippets.put(new SnippetsKey(o, s.getClass()), s);
    }

    boolean process(Set<? extends TypeElement> tes, RoundEnvironment re) {
        boolean functionPresent = false;
        boolean sqlActionPresent = false;
        boolean sqlActionsPresent = false;
        boolean baseUDTPresent = false;
        boolean mappedUDTPresent = false;
        boolean willClaim = true;
        for (TypeElement typeElement : tes) {
            if (this.AN_FUNCTION.equals(typeElement)) {
                functionPresent = true;
                continue;
            }
            if (this.AN_SQLACTION.equals(typeElement)) {
                sqlActionPresent = true;
                continue;
            }
            if (this.AN_SQLACTIONS.equals(typeElement)) {
                sqlActionsPresent = true;
                continue;
            }
            if (this.AN_BASEUDT.equals(typeElement)) {
                baseUDTPresent = true;
                continue;
            }
            if (this.AN_MAPPEDUDT.equals(typeElement)) {
                mappedUDTPresent = true;
                continue;
            }
            if (this.AN_SQLTYPE.equals(typeElement)) continue;
            this.msg(Diagnostic.Kind.WARNING, (Element)typeElement, "pljava annotation processor version may be older than this annotation:\n%s", typeElement.toString());
            willClaim = false;
        }
        if (baseUDTPresent) {
            for (Element element : re.getElementsAnnotatedWith(this.AN_BASEUDT)) {
                this.processUDT(element, UDTKind.BASE);
            }
        }
        if (mappedUDTPresent) {
            for (Element element : re.getElementsAnnotatedWith(this.AN_MAPPEDUDT)) {
                this.processUDT(element, UDTKind.MAPPED);
            }
        }
        if (functionPresent) {
            for (Element element : re.getElementsAnnotatedWith(this.AN_FUNCTION)) {
                this.processFunction(element);
            }
        }
        if (sqlActionPresent) {
            for (Element element : re.getElementsAnnotatedWith(this.AN_SQLACTION)) {
                this.processSQLAction(element);
            }
        }
        if (sqlActionsPresent) {
            for (Element element : re.getElementsAnnotatedWith(this.AN_SQLACTIONS)) {
                this.processSQLActions(element);
            }
        }
        this.tmpr.workAroundJava7Breakage();
        if (!re.processingOver()) {
            this.defensiveEarlyCharacterize();
        } else if (!re.errorRaised()) {
            this.generateDescriptor();
        }
        return willClaim;
    }

    void defensiveEarlyCharacterize() {
        for (Snippet snip : this.snippets.values()) {
            if (!snip.characterize()) continue;
            VertexPair<Snippet> v = new VertexPair<Snippet>(snip);
            this.snippetVPairs.add(v);
            for (String s : snip.provides()) {
                if (null == this.provider.put(s, v)) continue;
                this.msg(Diagnostic.Kind.ERROR, "tag %s has more than one provider", s);
            }
        }
        this.snippets.clear();
    }

    void generateDescriptor() {
        LinkedList<Vertex<Snippet>> revReady;
        LinkedList<Vertex<Snippet>> fwdReady;
        boolean errorRaised = false;
        HashSet<String> fwdConsumers = new HashSet<String>();
        HashSet<String> revConsumers = new HashSet<String>();
        for (VertexPair<Snippet> v : this.snippetVPairs) {
            VertexPair<Snippet> p;
            String imp = v.payload().implementor();
            if (null != imp) {
                fwdConsumers.add(imp);
                revConsumers.add(imp);
                p = this.provider.get(imp);
                if (null != p) {
                    p.fwd.precede(v.fwd);
                    p.rev.precede(v.rev);
                    if (0 == ((Snippet)p.rev.payload).undeployStrings().length) {
                        p.rev.payload = new ImpProvider((Snippet)p.rev.payload);
                    }
                } else if (!this.defaultImplementor.equals(imp)) {
                    ++v.fwd.indegree;
                    ++v.rev.indegree;
                }
            }
            for (String string : v.payload().requires()) {
                fwdConsumers.add(string);
                p = this.provider.get(string);
                if (null != p) {
                    p.fwd.precede(v.fwd);
                    v.rev.precede(p.rev);
                    continue;
                }
                this.msg(Diagnostic.Kind.ERROR, "tag \"%s\" is required but nowhere provided", string);
                errorRaised = true;
            }
            for (String string : v.payload().requires()) {
                revConsumers.add(string);
            }
        }
        if (errorRaised) {
            return;
        }
        LinkedList<Vertex<Snippet>> fwdBlocked = new LinkedList<Vertex<Snippet>>();
        LinkedList<Vertex<Snippet>> revBlocked = new LinkedList<Vertex<Snippet>>();
        if (this.reproducible) {
            fwdReady = new PriorityQueue<Vertex<Snippet>>(11, this.snippetTiebreaker);
            revReady = new PriorityQueue<Vertex<Snippet>>(11, this.snippetTiebreaker);
        } else {
            fwdReady = new LinkedList();
            revReady = new LinkedList();
        }
        for (VertexPair vertexPair : this.snippetVPairs) {
            Vertex v = vertexPair.fwd;
            if (0 == v.indegree) {
                fwdReady.add(v);
            } else {
                fwdBlocked.add(v);
            }
            v = vertexPair.rev;
            if (0 == v.indegree) {
                revReady.add(v);
                continue;
            }
            revBlocked.add(v);
        }
        Snippet[] fwdSnips = this.order(fwdReady, fwdBlocked, fwdConsumers);
        Snippet[] snippetArray = this.order(revReady, revBlocked, revConsumers);
        if (null == fwdSnips || null == snippetArray) {
            return;
        }
        try {
            DDRWriter.emit(fwdSnips, snippetArray, this);
        }
        catch (IOException ioe) {
            this.msg(Diagnostic.Kind.ERROR, "while writing %s: %s", this.output, ioe.getMessage());
        }
    }

    Snippet[] order(Queue<Vertex<Snippet>> ready, Queue<Vertex<Snippet>> blocked, Set<String> consumer) {
        Snippet[] snips;
        block6: {
            snips = new Snippet[ready.size() + blocked.size()];
            Vertex cycleBreaker = null;
            int i = 0;
            block0: while (true) {
                if (!ready.isEmpty()) {
                    Vertex<Snippet> v = ready.remove();
                    snips[i++] = (Snippet)v.payload;
                    v.use(ready, blocked);
                    String[] stringArray = ((Snippet)v.payload).provides();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block0;
                        String p = stringArray[n2];
                        consumer.remove(p);
                        ++n2;
                    }
                }
                if (blocked.isEmpty()) break block6;
                Iterator it = blocked.iterator();
                while (it.hasNext()) {
                    Vertex v = (Vertex)it.next();
                    if (1 < v.indegree || null == ((Snippet)v.payload).implementor() || this.provider.containsKey(((Snippet)v.payload).implementor())) continue;
                    if (this.reproducible) {
                        if (null != cycleBreaker && 0 >= this.snippetTiebreaker.compare(cycleBreaker, v)) continue;
                        cycleBreaker = v;
                        continue;
                    }
                    --v.indegree;
                    it.remove();
                    ready.add(v);
                    continue block0;
                }
                if (null == cycleBreaker) break;
                blocked.remove(cycleBreaker);
                --cycleBreaker.indegree;
                ready.add(cycleBreaker);
                cycleBreaker = null;
            }
            for (String s : consumer) {
                this.msg(Diagnostic.Kind.ERROR, "requirement in a cycle: %s", s);
            }
            return null;
        }
        return snips;
    }

    void processSQLAction(Element e) {
        SQLActionImpl sa = this.getSnippet(e, SQLActionImpl.class);
        if (null == sa) {
            sa = new SQLActionImpl();
            this.putSnippet(e, sa);
        }
        for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(e)) {
            if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_SQLACTION)) continue;
            this.populateAnnotationImpl(sa, e, annotationMirror);
        }
    }

    void processSQLActions(Element e) {
        for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(e)) {
            if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_SQLACTIONS)) continue;
            SQLActionsImpl sas = new SQLActionsImpl();
            this.populateAnnotationImpl(sas, e, annotationMirror);
            for (SQLAction sa : sas.value()) {
                this.putSnippet(sa, (Snippet)((Object)sa));
            }
        }
    }

    void processUDT(Element e, UDTKind k) {
        switch (e.getKind()) {
            case CLASS: {
                break;
            }
            case ANNOTATION_TYPE: 
            case ENUM: 
            case INTERFACE: {
                this.msg(Diagnostic.Kind.ERROR, e, "A pljava UDT must be a class", new Object[0]);
            }
            default: {
                return;
            }
        }
        Set<Modifier> mods = e.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC)) {
            this.msg(Diagnostic.Kind.ERROR, e, "A pljava UDT must be public", new Object[0]);
        }
        if (mods.contains((Object)Modifier.ABSTRACT)) {
            this.msg(Diagnostic.Kind.ERROR, e, "A pljava UDT must not be abstract", new Object[0]);
        }
        if (!((TypeElement)e).getNestingKind().equals((Object)NestingKind.TOP_LEVEL)) {
            if (!mods.contains((Object)Modifier.STATIC)) {
                this.msg(Diagnostic.Kind.ERROR, e, "When nested, a pljava UDT must be static (not inner)", new Object[0]);
            }
            Element ee = e;
            while (null != (ee = ee.getEnclosingElement())) {
                if (!ee.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.msg(Diagnostic.Kind.ERROR, ee, "A pljava UDT must not have a non-public enclosing class", new Object[0]);
                }
                if (!((TypeElement)ee).getNestingKind().equals((Object)NestingKind.TOP_LEVEL)) continue;
            }
        }
        switch (k) {
            case BASE: {
                BaseUDTImpl bu = this.getSnippet(e, BaseUDTImpl.class);
                if (null == bu) {
                    bu = new BaseUDTImpl((TypeElement)e);
                    this.putSnippet(e, bu);
                }
                for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(e)) {
                    if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_BASEUDT)) continue;
                    this.populateAnnotationImpl(bu, e, annotationMirror);
                }
                bu.registerFunctions();
                break;
            }
            case MAPPED: {
                MappedUDTImpl mu = this.getSnippet(e, MappedUDTImpl.class);
                if (null == mu) {
                    mu = new MappedUDTImpl((TypeElement)e);
                    this.putSnippet(e, mu);
                }
                for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(e)) {
                    if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_MAPPEDUDT)) continue;
                    this.populateAnnotationImpl(mu, e, annotationMirror);
                }
                mu.registerMapping();
            }
        }
    }

    ExecutableElement huntFor(List<ExecutableElement> ees, String name, boolean isStatic, TypeMirror retType, TypeMirror ... paramTypes) {
        ExecutableElement quarry = null;
        block0: for (ExecutableElement ee : ees) {
            List<? extends TypeMirror> pts;
            if (null != name && !ee.getSimpleName().contentEquals(name) || ee.isVarArgs() || null != retType && !this.typu.isSameType(ee.getReturnType(), retType) || (pts = ((ExecutableType)ee.asType()).getParameterTypes()).size() != paramTypes.length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!this.typu.isSameType(pts.get(i), paramTypes[i])) continue block0;
            }
            Set<Modifier> mods = ee.getModifiers();
            if (!mods.contains((Object)Modifier.PUBLIC) || isStatic && !mods.contains((Object)Modifier.STATIC)) continue;
            if (null == quarry) {
                quarry = ee;
                continue;
            }
            this.msg(Diagnostic.Kind.ERROR, (Element)ee, "Found more than one candidate " + (null == name ? "constructor" : name + " method"), new Object[0]);
        }
        return quarry;
    }

    void processFunction(Element e) {
        FunctionImpl f;
        if (!ElementKind.METHOD.equals((Object)e.getKind())) {
            return;
        }
        Set<Modifier> mods = e.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC)) {
            this.msg(Diagnostic.Kind.ERROR, e, "A pljava function must be public", new Object[0]);
        }
        Element ee = e;
        while (null != (ee = ee.getEnclosingElement())) {
            if (!ElementKind.CLASS.equals((Object)ee.getKind())) continue;
            if (!ee.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.msg(Diagnostic.Kind.ERROR, ee, "A pljava function must not have a non-public enclosing class", new Object[0]);
            }
            if (!((TypeElement)ee).getNestingKind().equals((Object)NestingKind.TOP_LEVEL)) continue;
        }
        if (null == (f = this.getSnippet(e, FunctionImpl.class))) {
            f = new FunctionImpl((ExecutableElement)e);
            this.putSnippet(e, f);
        }
        for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(e)) {
            if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_FUNCTION)) continue;
            this.populateAnnotationImpl(f, e, annotationMirror);
        }
    }

    static <T> T[] avToArray(Object o, Class<T> k) {
        boolean isEnum = k.isEnum();
        List vs = (List)o;
        Object[] a = (Object[])Array.newInstance(k, vs.size());
        int i = 0;
        for (AnnotationValue av : vs) {
            Object v = DDRProcessorImpl.getValue(av);
            if (isEnum) {
                v = Enum.valueOf(k.asSubclass(Enum.class), ((VariableElement)v).getSimpleName().toString());
            }
            a[i++] = k.cast(v);
        }
        return a;
    }

    void populateAnnotationImpl(AbstractAnnotationImpl inst, Element e, AnnotationMirror am) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> explicit = am.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> defaulted = this.elmu.getElementValuesWithDefaults(am);
        Element anne = am.getAnnotationType().asElement();
        List<ExecutableElement> keys = ElementFilter.methodsIn(anne.getEnclosedElements());
        for (ExecutableElement executableElement : keys) {
            if (defaulted.containsKey(executableElement)) continue;
            this.msg(Diagnostic.Kind.ERROR, e, am, "annotation missing required element \"%s\"", executableElement.getSimpleName());
        }
        for (Map.Entry entry : defaulted.entrySet()) {
            ExecutableElement k = (ExecutableElement)entry.getKey();
            AnnotationValue av = (AnnotationValue)entry.getValue();
            boolean isExplicit = explicit.containsKey(k);
            String name = k.getSimpleName().toString();
            Class<?> kl = inst.getClass();
            try {
                Object v = DDRProcessorImpl.getValue(av);
                kl.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), Object.class, Boolean.TYPE, Element.class).invoke((Object)inst, v, isExplicit, e);
            }
            catch (AnnotationValueException ave) {
                this.msg(Diagnostic.Kind.ERROR, e, am, "unresolved value for annotation member \"%s\" (check for missing/misspelled import, etc.)", name);
            }
            catch (NoSuchMethodException nsme22) {
                Object nsme22;
                Object v = DDRProcessorImpl.getValue(av);
                try {
                    Field f = kl.getField("_" + name);
                    Class<?> fkl = f.getType();
                    if (!isExplicit && null != f.get(inst)) continue;
                    if (fkl.isArray()) {
                        try {
                            f.set(inst, DDRProcessorImpl.avToArray(v, fkl.getComponentType()));
                        }
                        catch (AnnotationValueException ave) {
                            this.msg(Diagnostic.Kind.ERROR, e, am, "unresolved value for an element of annotation member \"%s\" (check for missing/misspelled import, etc.)", name);
                        }
                    } else if (fkl.isEnum()) {
                        f.set(inst, Enum.valueOf(fkl.asSubclass(Enum.class), ((VariableElement)v).getSimpleName().toString()));
                    } else {
                        f.set(inst, v);
                    }
                    nsme22 = null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (null == nsme22) continue;
                throw new RuntimeException("Incomplete implementation in annotation processor", nsme22);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Incorrect implementation of annotation processor", iae);
            }
            catch (InvocationTargetException ite) {
                String msg = ite.getCause().getMessage();
                this.msg(Diagnostic.Kind.ERROR, e, am, av, "%s", msg);
            }
        }
    }

    static Object getValue(AnnotationValue av) {
        if ("com.sun.tools.javac.code.Attribute.Error".equals(av.getClass().getCanonicalName())) {
            throw new AnnotationValueException();
        }
        return av.getValue();
    }

    class TypeMapper {
        ArrayList<Map.Entry<TypeMirror, String>> protoMappings = new ArrayList();
        ArrayList<Map.Entry<TypeMirror, String>> finalMappings;

        TypeMapper() {
            this.addMap(Boolean.TYPE, "boolean");
            this.addMap(Boolean.class, "boolean");
            this.addMap(Byte.TYPE, "smallint");
            this.addMap(Byte.class, "smallint");
            this.addMap(Character.TYPE, "smallint");
            this.addMap(Character.class, "smallint");
            this.addMap(Double.TYPE, "double precision");
            this.addMap(Double.class, "double precision");
            this.addMap(Float.TYPE, "real");
            this.addMap(Float.class, "real");
            this.addMap(Integer.TYPE, "integer");
            this.addMap(Integer.class, "integer");
            this.addMap(Long.TYPE, "bigint");
            this.addMap(Long.class, "bigint");
            this.addMap(Short.TYPE, "smallint");
            this.addMap(Short.class, "smallint");
            this.addMap(Number.class, "pg_catalog.numeric");
            this.addMap(String.class, "pg_catalog.varchar");
            this.addMap(Date.class, "pg_catalog.timestamp");
            this.addMap(Timestamp.class, "pg_catalog.timestamp");
            this.addMap(Time.class, "pg_catalog.time");
            this.addMap(java.sql.Date.class, "pg_catalog.date");
            this.addMap(SQLXML.class, "pg_catalog.xml");
            this.addMap(BigInteger.class, "pg_catalog.numeric");
            this.addMap(BigDecimal.class, "pg_catalog.numeric");
            this.addMap(ResultSet.class, "pg_catalog.record");
            this.addMap(Object.class, "pg_catalog.\"any\"");
            this.addMap(byte[].class, "pg_catalog.bytea");
            this.addMapIfExists("java.time.LocalDate", "pg_catalog.date");
            this.addMapIfExists("java.time.LocalTime", "pg_catalog.time");
            this.addMapIfExists("java.time.OffsetTime", "pg_catalog.timetz");
            this.addMapIfExists("java.time.LocalDateTime", "pg_catalog.timestamp");
            this.addMapIfExists("java.time.OffsetDateTime", "pg_catalog.timestamptz");
        }

        private boolean mappingsFrozen() {
            return null != this.finalMappings;
        }

        private void workAroundJava7Breakage() {
            if (this.mappingsFrozen()) {
                return;
            }
            ArrayList<Vertex<Map.Entry<TypeMirror, String>>> vs = new ArrayList<Vertex<Map.Entry<TypeMirror, String>>>(this.protoMappings.size());
            for (Map.Entry<TypeMirror, String> me : this.protoMappings) {
                vs.add(new Vertex<Map.Entry<TypeMirror, String>>(me));
            }
            int i = vs.size();
            while (i-- > 1) {
                Vertex vi = (Vertex)vs.get(i);
                TypeMirror typeMirror = (TypeMirror)((Map.Entry)vi.payload).getKey();
                int j = i;
                while (j-- > 0) {
                    Vertex vj = (Vertex)vs.get(j);
                    TypeMirror cj = (TypeMirror)((Map.Entry)vj.payload).getKey();
                    boolean oij = DDRProcessorImpl.this.typu.isAssignable(typeMirror, cj);
                    boolean oji = DDRProcessorImpl.this.typu.isAssignable(cj, typeMirror);
                    if (oji == oij) continue;
                    if (oij) {
                        vi.precede(vj);
                        continue;
                    }
                    vj.precede(vi);
                }
            }
            AbstractCollection q = DDRProcessorImpl.this.reproducible ? new PriorityQueue<Vertex<Map.Entry<TypeMirror, String>>>(11, new TypeTiebreaker()) : new LinkedList();
            for (Vertex vertex : vs) {
                if (0 != vertex.indegree) continue;
                q.add(vertex);
            }
            this.protoMappings.clear();
            this.finalMappings = this.protoMappings;
            this.protoMappings = null;
            while (!q.isEmpty()) {
                Vertex v = (Vertex)q.remove();
                v.use(q);
                this.finalMappings.add((Map.Entry<TypeMirror, String>)v.payload);
            }
        }

        private TypeMirror typeMirrorFromClass(Class<?> k) {
            if (k.isArray()) {
                TypeMirror ctm = this.typeMirrorFromClass(k.getComponentType());
                return DDRProcessorImpl.this.typu.getArrayType(ctm);
            }
            if (k.isPrimitive()) {
                TypeKind tk = TypeKind.valueOf(k.getName().toUpperCase());
                return DDRProcessorImpl.this.typu.getPrimitiveType(tk);
            }
            String cname = k.getCanonicalName();
            if (null == cname) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.WARNING, "Cannot register type mapping for class %sthat lacks a canonical name", k.getName());
                return null;
            }
            TypeElement te = DDRProcessorImpl.this.elmu.getTypeElement(cname);
            if (null == te) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.WARNING, "Found no TypeElement for %s", cname);
                return null;
            }
            return te.asType();
        }

        void addMap(Class<?> k, String v) {
            this.addMap(this.typeMirrorFromClass(k), v);
        }

        void addMapIfExists(String k, String v) {
            TypeElement te = DDRProcessorImpl.this.elmu.getTypeElement(k);
            if (null != te) {
                this.addMap(te.asType(), v);
            }
        }

        void addMap(TypeMirror tm, String v) {
            if (this.mappingsFrozen()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, "addMap(%s, %s)\ncalled after workAroundJava7Breakage", tm.toString(), v);
                return;
            }
            this.protoMappings.add(new AbstractMap.SimpleImmutableEntry<TypeMirror, String>(tm, v));
        }

        String getSQLType(TypeMirror tm, Element e) {
            return this.getSQLType(tm, e, null, false, false);
        }

        String getSQLType(TypeMirror tm, Element e, SQLType st, boolean contravariant, boolean withDefault) {
            ArrayType at;
            boolean array = false;
            boolean row = false;
            String rslt = null;
            String[] defaults = null;
            if (null != st) {
                rslt = st.value();
                defaults = st.defaultValue();
            }
            if (tm.getKind().equals((Object)TypeKind.ARRAY) && !(at = (ArrayType)tm).getComponentType().getKind().equals((Object)TypeKind.BYTE)) {
                array = true;
                tm = at.getComponentType();
            }
            if (!array && DDRProcessorImpl.this.typu.isSameType(tm, DDRProcessorImpl.this.TY_RESULTSET)) {
                row = true;
            }
            if (null != rslt) {
                return this.typeWithDefault(e, rslt, array, row, defaults, withDefault);
            }
            if (tm.getKind().equals((Object)TypeKind.VOID)) {
                return "pg_catalog.void";
            }
            if (tm.getKind().equals((Object)TypeKind.ERROR)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "Cannot determine mapping to SQL type for unresolved type", new Object[0]);
                rslt = tm.toString();
            } else {
                ArrayList ms = this.finalMappings;
                if (contravariant) {
                    ms = (ArrayList)ms.clone();
                    Collections.reverse(ms);
                }
                for (Map.Entry<TypeMirror, String> me : ms) {
                    TypeMirror ktm = me.getKey();
                    if (ktm instanceof PrimitiveType) {
                        if (!DDRProcessorImpl.this.typu.isSameType(tm, ktm)) continue;
                        rslt = me.getValue();
                        break;
                    }
                    boolean accept = contravariant ? DDRProcessorImpl.this.typu.isAssignable(ktm, tm) : DDRProcessorImpl.this.typu.isAssignable(tm, ktm);
                    if (!accept) continue;
                    if (!contravariant && DDRProcessorImpl.this.typu.isSameType(ktm, DDRProcessorImpl.this.TY_OBJECT)) break;
                    rslt = me.getValue();
                    break;
                }
            }
            if (null == rslt) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "No known mapping to an SQL type", new Object[0]);
                rslt = tm.toString();
            }
            if (array) {
                rslt = rslt + "[]";
            }
            return this.typeWithDefault(e, rslt, array, row, defaults, withDefault);
        }

        String typeWithDefault(Element e, String rslt, boolean array, boolean row, String[] defaults, boolean withDefault) {
            if (null == defaults || !withDefault) {
                return rslt;
            }
            int n = defaults.length;
            if (row) {
                assert (!array);
                if (n > 0 && rslt.equalsIgnoreCase("record")) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "Only supported default for unknown RECORD type is {}", new Object[0]);
                }
            } else if (n != 1) {
                array = true;
            } else if (!array) {
                array = arrayish.matcher(rslt).matches();
            }
            StringBuilder sb = new StringBuilder(rslt);
            sb.append(" DEFAULT ");
            sb.append(row ? "ROW(" : "CAST(");
            if (array) {
                sb.append("ARRAY[");
            }
            if (n > 1) {
                sb.append("\n\t");
            }
            for (String s : defaults) {
                sb.append(DDRWriter.eQuote(s));
                if (0 >= --n) continue;
                sb.append(",\n\t");
            }
            if (array) {
                sb.append(']');
            }
            if (!row) {
                sb.append(" AS ").append(rslt);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    class BaseUDTImpl
    extends AbstractUDTImpl
    implements BaseUDT {
        BaseUDTFunctionImpl in;
        BaseUDTFunctionImpl out;
        BaseUDTFunctionImpl recv;
        BaseUDTFunctionImpl send;
        public String _typeModifierInput;
        public String _typeModifierOutput;
        public String _analyze;
        int _internalLength;
        public Boolean _passedByValue;
        BaseUDT.Alignment _alignment;
        BaseUDT.Storage _storage;
        public String _like;
        char _category;
        public Boolean _preferred;
        String _defaultValue;
        public String _element;
        char _delimiter;
        public Boolean _collatable;
        boolean lengthExplicit;
        boolean alignmentExplicit;
        boolean storageExplicit;
        boolean categoryExplicit;
        boolean delimiterExplicit;

        @Override
        public String typeModifierInput() {
            return this._typeModifierInput;
        }

        @Override
        public String typeModifierOutput() {
            return this._typeModifierOutput;
        }

        @Override
        public String analyze() {
            return this._analyze;
        }

        @Override
        public int internalLength() {
            return this._internalLength;
        }

        @Override
        public boolean passedByValue() {
            return this._passedByValue;
        }

        @Override
        public BaseUDT.Alignment alignment() {
            return this._alignment;
        }

        @Override
        public BaseUDT.Storage storage() {
            return this._storage;
        }

        @Override
        public String like() {
            return this._like;
        }

        @Override
        public char category() {
            return this._category;
        }

        @Override
        public boolean preferred() {
            return this._preferred;
        }

        @Override
        public String defaultValue() {
            return this._defaultValue;
        }

        @Override
        public String element() {
            return this._element;
        }

        @Override
        public char delimiter() {
            return this._delimiter;
        }

        @Override
        public boolean collatable() {
            return this._collatable;
        }

        public void setInternalLength(Object o, boolean explicit, Element e) {
            this._internalLength = (Integer)o;
            this.lengthExplicit = explicit;
        }

        public void setAlignment(Object o, boolean explicit, Element e) {
            this._alignment = BaseUDT.Alignment.valueOf(((VariableElement)o).getSimpleName().toString());
            this.alignmentExplicit = explicit;
        }

        public void setStorage(Object o, boolean explicit, Element e) {
            this._storage = BaseUDT.Storage.valueOf(((VariableElement)o).getSimpleName().toString());
            this.storageExplicit = explicit;
        }

        public void setDefaultValue(Object o, boolean explicit, Element e) {
            if (explicit) {
                this._defaultValue = (String)o;
            }
        }

        public void setCategory(Object o, boolean explicit, Element e) {
            this._category = ((Character)o).charValue();
            this.categoryExplicit = explicit;
        }

        public void setDelimiter(Object o, boolean explicit, Element e) {
            this._delimiter = ((Character)o).charValue();
            this.delimiterExplicit = explicit;
        }

        BaseUDTImpl(TypeElement e) {
            super(e);
        }

        void registerFunctions() {
            this.setQname();
            ExecutableElement instanceReadSQL = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "readSQL", false, DDRProcessorImpl.this.TY_VOID, DDRProcessorImpl.this.TY_SQLINPUT, DDRProcessorImpl.this.TY_STRING);
            ExecutableElement instanceWriteSQL = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "writeSQL", false, DDRProcessorImpl.this.TY_VOID, DDRProcessorImpl.this.TY_SQLOUTPUT);
            ExecutableElement instanceToString = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "toString", false, DDRProcessorImpl.this.TY_STRING, new TypeMirror[0]);
            ExecutableElement staticParse = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "parse", true, this.tclass.asType(), DDRProcessorImpl.this.TY_STRING, DDRProcessorImpl.this.TY_STRING);
            if (null == staticParse) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "A pljava UDT must have a public static parse(String,String) method that returns the UDT", new Object[0]);
            } else {
                this.in = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.INPUT);
                DDRProcessorImpl.this.putSnippet(staticParse, this.in);
            }
            this.out = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.OUTPUT);
            DDRProcessorImpl.this.putSnippet(null != instanceToString ? instanceToString : this.out, this.out);
            this.recv = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.RECEIVE);
            DDRProcessorImpl.this.putSnippet(null != instanceReadSQL ? instanceReadSQL : this.recv, this.recv);
            this.send = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.SEND);
            DDRProcessorImpl.this.putSnippet(null != instanceWriteSQL ? instanceWriteSQL : this.send, this.send);
        }

        @Override
        public boolean characterize() {
            if ("".equals(this.typeModifierInput()) && !"".equals(this.typeModifierOutput())) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "UDT typeModifierOutput useless without typeModifierInput", new Object[0]);
            }
            if (1 > this.internalLength() && -1 != this.internalLength()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "UDT internalLength must be positive, or -1 for varying", new Object[0]);
            }
            if (this.passedByValue() && (8 < this.internalLength() || -1 == this.internalLength())) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "Only a UDT of fixed length <= 8 can be passed by value", new Object[0]);
            }
            if (-1 == this.internalLength() && -1 == this.alignment().compareTo(BaseUDT.Alignment.INT4)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "A variable-length UDT must have alignment at least INT4", new Object[0]);
            }
            if (-1 != this.internalLength() && BaseUDT.Storage.PLAIN != this.storage()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "Storage for a fixed-length UDT must be PLAIN", new Object[0]);
            }
            if (' ' > this.category() || this.category() > '~') {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "UDT category must be a printable ASCII character", new Object[0]);
            }
            return true;
        }

        @Override
        public String[] deployStrings() {
            ArrayList<String> al = new ArrayList<String>();
            al.add("CREATE TYPE " + this.qname);
            al.addAll(Arrays.asList(this.in.deployStrings()));
            al.addAll(Arrays.asList(this.out.deployStrings()));
            al.addAll(Arrays.asList(this.recv.deployStrings()));
            al.addAll(Arrays.asList(this.send.deployStrings()));
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TYPE ").append(this.qname).append(" (\n\t");
            this.in.appendTypeOp(sb).append(",\n\t");
            this.out.appendTypeOp(sb).append(",\n\t");
            this.recv.appendTypeOp(sb).append(",\n\t");
            this.send.appendTypeOp(sb);
            if (!"".equals(this.typeModifierInput())) {
                sb.append(",\n\tTYPMOD_IN = ").append(this.typeModifierInput());
            }
            if (!"".equals(this.typeModifierOutput())) {
                sb.append(",\n\tTYPMOD_OUT = ").append(this.typeModifierOutput());
            }
            if (!"".equals(this.analyze())) {
                sb.append(",\n\tANALYZE = ").append(this.typeModifierOutput());
            }
            if (this.lengthExplicit || "".equals(this.like())) {
                sb.append(",\n\tINTERNALLENGTH = ").append(-1 == this.internalLength() ? "VARIABLE" : String.valueOf(this.internalLength()));
            }
            if (this.passedByValue()) {
                sb.append(",\n\tPASSEDBYVALUE");
            }
            if (this.alignmentExplicit || "".equals(this.like())) {
                sb.append(",\n\tALIGNMENT = ").append(this.alignment().name());
            }
            if (this.storageExplicit || "".equals(this.like())) {
                sb.append(",\n\tSTORAGE = ").append(this.storage().name());
            }
            if (!"".equals(this.like())) {
                sb.append(",\n\tLIKE = ").append(this.like());
            }
            if (this.categoryExplicit) {
                sb.append(",\n\tCATEGORY = ").append(DDRWriter.eQuote(String.valueOf(this.category())));
            }
            if (this.preferred()) {
                sb.append(",\n\tPREFERRED = true");
            }
            if (null != this.defaultValue()) {
                sb.append(",\n\tDEFAULT = ").append(DDRWriter.eQuote(this.defaultValue()));
            }
            if (!"".equals(this.element())) {
                sb.append(",\n\tELEMENT = ").append(this.element());
            }
            if (this.delimiterExplicit) {
                sb.append(",\n\tDELIMITER = ").append(DDRWriter.eQuote(String.valueOf(this.delimiter())));
            }
            if (this.collatable()) {
                sb.append(",\n\tCOLLATABLE = true");
            }
            al.add(sb.append("\n)").toString());
            this.addComment(al);
            return al.toArray(new String[al.size()]);
        }

        @Override
        public String[] undeployStrings() {
            return new String[]{"DROP TYPE " + this.qname + " CASCADE"};
        }
    }

    class MappedUDTImpl
    extends AbstractUDTImpl
    implements MappedUDT {
        String[] _structure;

        @Override
        public String[] structure() {
            return this._structure;
        }

        public void setStructure(Object o, boolean explicit, Element e) {
            if (explicit) {
                this._structure = DDRProcessorImpl.avToArray(o, String.class);
            }
        }

        MappedUDTImpl(TypeElement e) {
            super(e);
        }

        public void registerMapping() {
            this.setQname();
        }

        @Override
        public boolean characterize() {
            return true;
        }

        @Override
        public String[] deployStrings() {
            ArrayList<String> al = new ArrayList<String>();
            if (null != this.structure()) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TYPE ").append(this.qname).append(" AS (");
                int i = this.structure().length;
                for (String s : this.structure()) {
                    sb.append("\n\t").append(s).append(0 < --i ? (char)',' : '\n');
                }
                sb.append(')');
                al.add(sb.toString());
            }
            al.add("SELECT sqlj.add_type_mapping(" + DDRWriter.eQuote(this.qname) + ", " + DDRWriter.eQuote(this.tclass.toString()) + ')');
            this.addComment(al);
            return al.toArray(new String[al.size()]);
        }

        @Override
        public String[] undeployStrings() {
            ArrayList<String> al = new ArrayList<String>();
            al.add("SELECT sqlj.drop_type_mapping(" + DDRWriter.eQuote(this.qname) + ')');
            if (null != this.structure()) {
                al.add("DROP TYPE " + this.qname);
            }
            return al.toArray(new String[al.size()]);
        }
    }

    abstract class AbstractUDTImpl
    extends AbstractAnnotationImpl
    implements Snippet,
    Commentable {
        public String[] _provides;
        public String[] _requires;
        public String _name;
        public String _schema;
        TypeElement tclass;
        String qname;

        public String name() {
            return this._name;
        }

        public String schema() {
            return this._schema;
        }

        @Override
        public String[] provides() {
            return this._provides;
        }

        @Override
        public String[] requires() {
            return this._requires;
        }

        AbstractUDTImpl(TypeElement e) {
            ExecutableElement niladicCtor;
            this.tclass = e;
            if (!DDRProcessorImpl.this.typu.isAssignable(e.asType(), DDRProcessorImpl.this.TY_SQLDATA)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)e, "A pljava UDT must implement %s", DDRProcessorImpl.this.TY_SQLDATA);
            }
            if (null == (niladicCtor = DDRProcessorImpl.this.huntFor(ElementFilter.constructorsIn(this.tclass.getEnclosedElements()), null, false, null, new TypeMirror[0]))) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "A pljava UDT must have a public no-arg constructor", new Object[0]);
            }
        }

        protected void setQname() {
            if ("".equals(this._name)) {
                this._name = this.tclass.getSimpleName().toString();
            }
            this.qname = "".equals(this._schema) ? this._name : this._schema + "." + this._name;
            if (!DDRProcessorImpl.this.tmpr.mappingsFrozen()) {
                DDRProcessorImpl.this.tmpr.addMap(this.tclass.asType(), this.qname);
            }
        }

        protected void addComment(ArrayList<String> al) {
            String comm = this.comment();
            if (null == comm) {
                return;
            }
            al.add("COMMENT ON TYPE " + this.qname + "\nIS " + DDRWriter.eQuote(comm));
        }
    }

    class BaseUDTFunctionImpl
    extends FunctionImpl {
        BaseUDTImpl ui;
        TypeElement te;
        BaseUDTFunctionID id;

        BaseUDTFunctionImpl(BaseUDTImpl ui, TypeElement te, BaseUDTFunctionID id) {
            super(null);
            this.ui = ui;
            this.te = te;
            this.id = id;
            this._type = id.getRet(ui);
            this._name = ui.name() + '_' + id.getSuffix();
            this._schema = ui.schema();
            this._cost = -1;
            this._rows = -1;
            this._onNullInput = Function.OnNullInput.CALLED;
            this._security = Function.Security.INVOKER;
            this._effects = Function.Effects.VOLATILE;
            this._trust = Function.Trust.SANDBOXED;
            this._parallel = Function.Parallel.UNSAFE;
            this._leakproof = false;
            this._settings = new String[0];
            this._triggers = new Trigger[0];
            this._provides = this._settings;
            this._requires = this._settings;
        }

        @Override
        void appendParams(StringBuilder sb, boolean dflts) {
            sb.append(this.id.getParam(this.ui));
        }

        @Override
        void appendAS(StringBuilder sb) {
            sb.append("UDT[").append(this.te.toString()).append("] ");
            sb.append(this.id.name());
        }

        StringBuilder appendTypeOp(StringBuilder sb) {
            sb.append(this.id.name()).append(" = ");
            if (!"".equals(this.schema())) {
                sb.append(this.schema()).append('.');
            }
            return sb.append(this.name());
        }

        @Override
        public boolean characterize() {
            return false;
        }

        public void setType(Object o, boolean explicit, Element e) {
            if (explicit) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "The type of a UDT function may not be changed", new Object[0]);
            }
        }

        @Override
        public void setRows(Object o, boolean explicit, Element e) {
            if (explicit) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "The rows attribute of a UDT function may not be set", new Object[0]);
            }
        }

        public void setProvides(Object o, boolean explicit, Element e) {
            if (explicit) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "A UDT function does not have its own provides/requires", new Object[0]);
            }
        }

        public void setRequires(Object o, boolean explicit, Element e) {
            if (explicit) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "A UDT function does not have its own provides/requires", new Object[0]);
            }
        }

        @Override
        public void setTriggers(Object o, boolean explicit, Element e) {
            if (explicit) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "A UDT function may not have associated triggers", new Object[0]);
            }
        }

        @Override
        public void setImplementor(Object o, boolean explicit, Element e) {
            if (explicit) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, e, "A UDT function does not have its own implementor", new Object[0]);
            }
        }

        @Override
        public String implementor() {
            return this.ui.implementor();
        }

        @Override
        public String derivedComment(Element e) {
            String comm = super.derivedComment(e);
            if (null != comm) {
                return comm;
            }
            return this.id.name() + " method for type " + this.ui.qname;
        }
    }

    static enum BaseUDTFunctionID {
        INPUT("in", "pg_catalog.cstring, pg_catalog.oid, integer", null),
        OUTPUT("out", null, "pg_catalog.cstring"),
        RECEIVE("recv", "pg_catalog.internal, pg_catalog.oid, integer", null),
        SEND("send", null, "pg_catalog.bytea");

        private String suffix;
        private String param;
        private String ret;

        private BaseUDTFunctionID(String suffix, String param, String ret) {
            this.suffix = suffix;
            this.param = param;
            this.ret = ret;
        }

        String getSuffix() {
            return this.suffix;
        }

        String getParam(BaseUDTImpl u) {
            if (null != this.param) {
                return this.param;
            }
            return u.qname;
        }

        String getRet(BaseUDTImpl u) {
            if (null != this.ret) {
                return this.ret;
            }
            return u.qname;
        }
    }

    class FunctionImpl
    extends AbstractAnnotationImpl
    implements Function,
    Snippet,
    Commentable {
        ExecutableElement func;
        public String _type;
        public String _name;
        public String _schema;
        public Function.OnNullInput _onNullInput;
        public Function.Security _security;
        public Function.Effects _effects;
        public Function.Trust _trust;
        public Function.Parallel _parallel;
        public Boolean _leakproof;
        int _cost;
        int _rows;
        public String[] _settings;
        public String[] _provides;
        public String[] _requires;
        Trigger[] _triggers;
        boolean complexViaInOut;
        boolean setof;
        TypeMirror setofComponent;
        boolean trigger;
        TypeMirror returnTypeMapKey;
        SQLType[] paramTypeAnnotations;

        @Override
        public String type() {
            return this._type;
        }

        @Override
        public String name() {
            return this._name;
        }

        @Override
        public String schema() {
            return this._schema;
        }

        @Override
        public Function.OnNullInput onNullInput() {
            return this._onNullInput;
        }

        @Override
        public Function.Security security() {
            return this._security;
        }

        @Override
        public Function.Effects effects() {
            return this._effects;
        }

        @Override
        public Function.Trust trust() {
            return this._trust;
        }

        @Override
        public Function.Parallel parallel() {
            return this._parallel;
        }

        @Override
        public boolean leakproof() {
            return this._leakproof;
        }

        @Override
        public int cost() {
            return this._cost;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public String[] settings() {
            return this._settings;
        }

        @Override
        public String[] provides() {
            return this._provides;
        }

        @Override
        public String[] requires() {
            return this._requires;
        }

        @Override
        public Trigger[] triggers() {
            return this._triggers;
        }

        FunctionImpl(ExecutableElement e) {
            this.complexViaInOut = false;
            this.setof = false;
            this.setofComponent = null;
            this.trigger = false;
            this.returnTypeMapKey = null;
            this.func = e;
        }

        public void setCost(Object o, boolean explicit, Element e) {
            this._cost = (Integer)o;
            if (this._cost < 0 && explicit) {
                throw new IllegalArgumentException("cost must be nonnegative");
            }
        }

        public void setRows(Object o, boolean explicit, Element e) {
            this._rows = (Integer)o;
            if (this._rows < 0 && explicit) {
                throw new IllegalArgumentException("rows must be nonnegative");
            }
        }

        public void setTriggers(Object o, boolean explicit, Element e) {
            AnnotationMirror[] ams = DDRProcessorImpl.avToArray(o, AnnotationMirror.class);
            this._triggers = new Trigger[ams.length];
            int i = 0;
            for (AnnotationMirror am : ams) {
                TriggerImpl ti = new TriggerImpl(this, am);
                DDRProcessorImpl.this.populateAnnotationImpl(ti, e, am);
                this._triggers[i++] = ti;
            }
        }

        @Override
        public boolean characterize() {
            TypeMirror tm;
            TypeMirror ret;
            Set<Modifier> mods;
            if ("".equals(this._name)) {
                this._name = this.func.getSimpleName().toString();
            }
            if (!(mods = this.func.getModifiers()).contains((Object)Modifier.STATIC)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "A pljava function must be static", new Object[0]);
            }
            if ((ret = this.func.getReturnType()).getKind().equals((Object)TypeKind.ERROR)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Unable to resolve return type of function", new Object[0]);
                return false;
            }
            ExecutableType et = (ExecutableType)this.func.asType();
            List<? extends TypeMirror> ptms = et.getParameterTypes();
            int arity = ptms.size();
            if (!"".equals(this.type()) && ret.getKind().equals((Object)TypeKind.BOOLEAN)) {
                this.complexViaInOut = true;
                tm = ptms.get(arity - 1);
                if (tm.getKind().equals((Object)TypeKind.ERROR) || !DDRProcessorImpl.this.typu.isSameType(tm, DDRProcessorImpl.this.TY_RESULTSET)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.getParameters().get(arity - 1), "Last parameter of complex-type-returning function must be ResultSet", new Object[0]);
                    return false;
                }
            } else {
                List<? extends TypeMirror> typeArgs = this.specialization(ret, DDRProcessorImpl.this.TY_ITERATOR);
                if (null != typeArgs) {
                    this.setof = true;
                    if (1 != typeArgs.size()) {
                        DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Need one type argument for Iterator return type", new Object[0]);
                        return false;
                    }
                    this.setofComponent = typeArgs.get(0);
                    if (null == this.setofComponent) {
                        DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Failed to find setof component type", new Object[0]);
                        return false;
                    }
                } else if (DDRProcessorImpl.this.typu.isAssignable(ret, DDRProcessorImpl.this.TY_RESULTSETPROVIDER) || DDRProcessorImpl.this.typu.isAssignable(ret, DDRProcessorImpl.this.TY_RESULTSETHANDLE)) {
                    this.setof = true;
                } else if (ret.getKind().equals((Object)TypeKind.VOID) && 1 == arity && !(tm = ptms.get(0)).getKind().equals((Object)TypeKind.ERROR) && DDRProcessorImpl.this.typu.isSameType(tm, DDRProcessorImpl.this.TY_TRIGGERDATA)) {
                    this.trigger = true;
                }
            }
            this.returnTypeMapKey = ret;
            if (!this.setof && -1 != this.rows()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "ROWS specified on a function not returning SETOF", new Object[0]);
            }
            if (!this.trigger && 0 != this._triggers.length) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "a function with triggers needs void return and one TriggerData parameter", new Object[0]);
            }
            this.collectParameterTypeAnnotations();
            this.deployStrings();
            for (Trigger t : this.triggers()) {
                ((TriggerImpl)t).characterize();
            }
            return true;
        }

        void collectParameterTypeAnnotations() {
            List<? extends VariableElement> ves = this.func.getParameters();
            this.paramTypeAnnotations = new SQLType[ves.size()];
            int i = 0;
            for (VariableElement variableElement : ves) {
                for (AnnotationMirror annotationMirror : DDRProcessorImpl.this.elmu.getAllAnnotationMirrors(variableElement)) {
                    if (!annotationMirror.getAnnotationType().asElement().equals(DDRProcessorImpl.this.AN_SQLTYPE)) continue;
                    SQLTypeImpl sti = new SQLTypeImpl();
                    DDRProcessorImpl.this.populateAnnotationImpl(sti, variableElement, annotationMirror);
                    this.paramTypeAnnotations[i] = sti;
                }
                ++i;
            }
        }

        void appendNameAndParams(StringBuilder sb, boolean dflts) {
            if (!"".equals(this.schema())) {
                sb.append(this.schema()).append('.');
            }
            sb.append(this.name()).append('(');
            this.appendParams(sb, dflts);
            sb.append(')');
        }

        void appendParams(StringBuilder sb, boolean dflts) {
            if (!this.trigger) {
                ExecutableType et = (ExecutableType)this.func.asType();
                List<? extends TypeMirror> tms = et.getParameterTypes();
                Iterator<? extends VariableElement> ves = this.func.getParameters().iterator();
                if (this.complexViaInOut) {
                    tms = tms.subList(0, tms.size() - 1);
                }
                int s = tms.size();
                int i = 0;
                for (TypeMirror typeMirror : tms) {
                    String name;
                    VariableElement ve = ves.next();
                    SQLType st = this.paramTypeAnnotations[i];
                    String string = name = null == st ? null : st.name();
                    if (null == name) {
                        name = ve.getSimpleName().toString();
                    }
                    sb.append("\n\t").append(name);
                    sb.append(' ');
                    sb.append(DDRProcessorImpl.this.tmpr.getSQLType(typeMirror, ve, st, true, dflts));
                    if (++i >= s) continue;
                    sb.append(',');
                }
            }
        }

        void appendAS(StringBuilder sb) {
            Element e;
            if (!(this.complexViaInOut || this.setof || this.trigger)) {
                sb.append(DDRProcessorImpl.this.typu.erasure(this.func.getReturnType())).append('=');
            }
            if (!(e = this.func.getEnclosingElement()).getKind().equals((Object)ElementKind.CLASS)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Somehow this method got enclosed by something other than a class", new Object[0]);
            }
            sb.append(e.toString()).append('.');
            sb.append(this.trigger ? this.func.getSimpleName() : this.func.toString());
        }

        @Override
        public String[] deployStrings() {
            ArrayList<String> al = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE OR REPLACE FUNCTION ");
            this.appendNameAndParams(sb, true);
            sb.append("\n\tRETURNS ");
            if (this.trigger) {
                sb.append("pg_catalog.trigger");
            } else {
                if (this.setof) {
                    sb.append("SETOF ");
                }
                if (!"".equals(this.type())) {
                    sb.append(this.type());
                } else if (null != this.setofComponent) {
                    sb.append(DDRProcessorImpl.this.tmpr.getSQLType(this.setofComponent, this.func));
                } else if (this.setof) {
                    sb.append("pg_catalog.RECORD");
                } else {
                    sb.append(DDRProcessorImpl.this.tmpr.getSQLType(this.returnTypeMapKey, this.func));
                }
            }
            sb.append("\n\tLANGUAGE ");
            if (Function.Trust.SANDBOXED.equals((Object)this.trust())) {
                sb.append(DDRProcessorImpl.this.nameTrusted);
            } else {
                sb.append(DDRProcessorImpl.this.nameUntrusted);
            }
            sb.append(' ').append((Object)this.effects());
            if (this.leakproof()) {
                sb.append(" LEAKPROOF");
            }
            sb.append('\n');
            if (Function.OnNullInput.RETURNS_NULL.equals((Object)this.onNullInput())) {
                sb.append("\tRETURNS NULL ON NULL INPUT\n");
            }
            if (Function.Security.DEFINER.equals((Object)this.security())) {
                sb.append("\tSECURITY DEFINER\n");
            }
            if (!Function.Parallel.UNSAFE.equals((Object)this.parallel())) {
                sb.append("\tPARALLEL ").append((Object)this.parallel()).append('\n');
            }
            if (-1 != this.cost()) {
                sb.append("\tCOST ").append(this.cost()).append('\n');
            }
            if (-1 != this.rows()) {
                sb.append("\tROWS ").append(this.rows()).append('\n');
            }
            for (String s : this.settings()) {
                sb.append("\tSET ").append(s).append('\n');
            }
            sb.append("\tAS '");
            this.appendAS(sb);
            sb.append('\'');
            al.add(sb.toString());
            String comm = this.comment();
            if (null != comm) {
                sb.setLength(0);
                sb.append("COMMENT ON FUNCTION ");
                this.appendNameAndParams(sb, false);
                sb.append("\nIS ");
                sb.append(DDRWriter.eQuote(comm));
                al.add(sb.toString());
            }
            for (Trigger t : this.triggers()) {
                for (String s : ((TriggerImpl)t).deployStrings()) {
                    al.add(s);
                }
            }
            return al.toArray(new String[al.size()]);
        }

        @Override
        public String[] undeployStrings() {
            String[] rslt = new String[1 + this.triggers().length];
            int i = rslt.length - 1;
            for (Trigger t : this.triggers()) {
                for (String s : ((TriggerImpl)t).undeployStrings()) {
                    rslt[--i] = s;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("DROP FUNCTION ");
            this.appendNameAndParams(sb, false);
            rslt[rslt.length - 1] = sb.toString();
            return rslt;
        }

        List<? extends TypeMirror> specialization(TypeMirror tm, DeclaredType dt) {
            if (!DDRProcessorImpl.this.typu.isAssignable(DDRProcessorImpl.this.typu.erasure(tm), dt)) {
                return null;
            }
            LinkedList<? extends TypeMirror> pending = new LinkedList<TypeMirror>();
            pending.add(tm);
            while (!pending.isEmpty()) {
                tm = (TypeMirror)pending.remove(0);
                if (DDRProcessorImpl.this.typu.isSameType(DDRProcessorImpl.this.typu.erasure(tm), dt)) {
                    return ((DeclaredType)tm).getTypeArguments();
                }
                pending.addAll(DDRProcessorImpl.this.typu.directSupertypes(tm));
            }
            return Collections.emptyList();
        }
    }

    class TriggerImpl
    extends AbstractAnnotationImpl
    implements Trigger,
    Snippet,
    Commentable {
        public String[] _arguments;
        public Trigger.Constraint _constraint;
        public Trigger.Event[] _events;
        public String _fromSchema;
        public String _from;
        public String _name;
        public String _schema;
        public String _table;
        public Trigger.Scope _scope;
        public Trigger.Called _called;
        public String _when;
        public String[] _columns;
        public String _tableOld;
        public String _tableNew;
        FunctionImpl func;
        AnnotationMirror origin;
        boolean refOld;
        boolean refNew;
        boolean isConstraint;

        @Override
        public String[] arguments() {
            return this._arguments;
        }

        @Override
        public Trigger.Constraint constraint() {
            return this._constraint;
        }

        @Override
        public Trigger.Event[] events() {
            return this._events;
        }

        @Override
        public String fromSchema() {
            return this._fromSchema;
        }

        @Override
        public String from() {
            return this._from;
        }

        @Override
        public String name() {
            return this._name;
        }

        @Override
        public String schema() {
            return this._schema;
        }

        @Override
        public String table() {
            return this._table;
        }

        @Override
        public Trigger.Scope scope() {
            return this._scope;
        }

        @Override
        public Trigger.Called called() {
            return this._called;
        }

        @Override
        public String when() {
            return this._when;
        }

        @Override
        public String[] columns() {
            return this._columns;
        }

        @Override
        public String tableOld() {
            return this._tableOld;
        }

        @Override
        public String tableNew() {
            return this._tableNew;
        }

        @Override
        public String[] provides() {
            return new String[0];
        }

        @Override
        public String[] requires() {
            return new String[0];
        }

        public void setConstraint(Object o, boolean explicit, Element e) {
            if (explicit) {
                this.isConstraint = true;
                this._constraint = Trigger.Constraint.valueOf(((VariableElement)o).getSimpleName().toString());
            }
        }

        TriggerImpl(FunctionImpl f, AnnotationMirror am) {
            this.isConstraint = false;
            this.func = f;
            this.origin = am;
        }

        @Override
        public boolean characterize() {
            if (Trigger.Scope.ROW.equals((Object)this._scope)) {
                for (Trigger.Event e : this._events) {
                    if (!Trigger.Event.TRUNCATE.equals((Object)e)) continue;
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "TRUNCATE trigger cannot be FOR EACH ROW", new Object[0]);
                }
            } else if (Trigger.Called.INSTEAD_OF.equals((Object)this._called)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "INSTEAD OF trigger cannot be FOR EACH STATEMENT", new Object[0]);
            }
            if (!"".equals(this._when) && Trigger.Called.INSTEAD_OF.equals((Object)this._called)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "INSTEAD OF triggers do not support WHEN conditions", new Object[0]);
            }
            if (0 < this._columns.length) {
                if (Trigger.Called.INSTEAD_OF.equals((Object)this._called)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "INSTEAD OF triggers do not support lists of columns", new Object[0]);
                }
                boolean seen = false;
                for (Trigger.Event e : this._events) {
                    if (!Trigger.Event.UPDATE.equals((Object)e)) continue;
                    seen = true;
                }
                if (!seen) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Column list is meaningless unless UPDATE is a trigger event", new Object[0]);
                }
            }
            this.refOld = !"".equals(this._tableOld);
            boolean bl = this.refNew = !"".equals(this._tableNew);
            if (this.refOld || this.refNew) {
                if (!Trigger.Called.AFTER.equals((Object)this._called)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Only AFTER triggers can reference OLD TABLE or NEW TABLE", new Object[0]);
                }
                boolean badOld = this.refOld;
                boolean badNew = this.refNew;
                block7: for (Trigger.Event e : this._events) {
                    switch (e) {
                        case INSERT: {
                            badNew = false;
                            continue block7;
                        }
                        case UPDATE: {
                            badNew = false;
                            badOld = false;
                            continue block7;
                        }
                        case DELETE: {
                            badOld = false;
                        }
                    }
                }
                if (badOld) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Trigger must be callable on UPDATE or DELETE to reference OLD TABLE", new Object[0]);
                }
                if (badNew) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Trigger must be callable on UPDATE or INSERT to reference NEW TABLE", new Object[0]);
                }
            }
            if (this.isConstraint) {
                if (!Trigger.Called.AFTER.equals((Object)this._called)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "A constraint trigger must be an AFTER trigger", new Object[0]);
                }
                if (!Trigger.Scope.ROW.equals((Object)this._scope)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "A constraint trigger must be FOR EACH ROW", new Object[0]);
                }
                if ("".equals(this._from) && !"".equals(this._fromSchema)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "To use fromSchema, specify a table name with from", new Object[0]);
                }
            } else {
                if (!"".equals(this._from)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Only a constraint trigger can use 'from'", new Object[0]);
                }
                if (!"".equals(this._fromSchema)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Only a constraint trigger can use 'fromSchema'", new Object[0]);
                }
            }
            if ("".equals(this._name)) {
                this._name = TriggerNamer.synthesizeName(this);
            }
            return false;
        }

        @Override
        public String[] deployStrings() {
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE ");
            if (this.isConstraint) {
                sb.append("CONSTRAINT ");
            }
            sb.append("TRIGGER ").append(this.name()).append("\n\t");
            switch (this.called()) {
                case BEFORE: {
                    sb.append("BEFORE ");
                    break;
                }
                case AFTER: {
                    sb.append("AFTER ");
                    break;
                }
                case INSTEAD_OF: {
                    sb.append("INSTEAD OF ");
                }
            }
            int s = this._events.length;
            for (Trigger.Event event : this._events) {
                sb.append(event.toString());
                if (Trigger.Event.UPDATE.equals((Object)event) && 0 < this._columns.length) {
                    sb.append(" OF ");
                    int cs = this._columns.length;
                    for (String c : this._columns) {
                        sb.append(c);
                        if (0 >= --cs) continue;
                        sb.append(", ");
                    }
                }
                if (0 >= --s) continue;
                sb.append(" OR ");
            }
            sb.append("\n\tON ");
            if (!"".equals(this.schema())) {
                sb.append(this.schema()).append('.');
            }
            sb.append(this.table());
            if (!"".equals(this.from())) {
                sb.append("\n\tFROM ");
                if (!"".equals(this.fromSchema())) {
                    sb.append(this.fromSchema()).append('.');
                }
                sb.append(this.from());
            }
            if (this.isConstraint) {
                sb.append("\n\t");
                switch (this._constraint) {
                    case NOT_DEFERRABLE: {
                        sb.append("NOT DEFERRABLE");
                        break;
                    }
                    case INITIALLY_IMMEDIATE: {
                        sb.append("DEFERRABLE INITIALLY IMMEDIATE");
                        break;
                    }
                    case INITIALLY_DEFERRED: {
                        sb.append("DEFERRABLE INITIALLY DEFERRED");
                    }
                }
            }
            if (this.refOld || this.refNew) {
                sb.append("\n\tREFERENCING");
                if (this.refOld) {
                    sb.append(" OLD TABLE AS ").append(this._tableOld);
                }
                if (this.refNew) {
                    sb.append(" NEW TABLE AS ").append(this._tableNew);
                }
            }
            sb.append("\n\tFOR EACH ");
            sb.append(this.scope().toString());
            if (!"".equals(this._when)) {
                sb.append("\n\tWHEN ").append(this._when);
            }
            sb.append("\n\tEXECUTE PROCEDURE ");
            this.func.appendNameAndParams(sb, false);
            sb.setLength(sb.length() - 1);
            s = this._arguments.length;
            for (String string : this._arguments) {
                sb.append("\n\t").append(DDRWriter.eQuote(string));
                if (0 >= --s) continue;
                sb.append(',');
            }
            sb.append(')');
            String string = this.comment();
            if (null == string) {
                return new String[]{sb.toString()};
            }
            return new String[]{sb.toString(), "COMMENT ON TRIGGER " + this.name() + " ON " + ("".equals(this.schema()) ? "" : this.schema() + '.') + this.table() + "\nIS " + DDRWriter.eQuote(string)};
        }

        @Override
        public String[] undeployStrings() {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TRIGGER ").append(this.name()).append("\n\tON ");
            if (!"".equals(this.schema())) {
                sb.append(this.schema()).append('.');
            }
            sb.append(this.table());
            return new String[]{sb.toString()};
        }
    }

    class SQLActionImpl
    extends AbstractAnnotationImpl
    implements SQLAction,
    Snippet {
        public String[] _install;
        public String[] _remove;
        public String[] _provides;
        public String[] _requires;

        SQLActionImpl() {
        }

        @Override
        public String[] install() {
            return this._install;
        }

        @Override
        public String[] remove() {
            return this._remove;
        }

        @Override
        public String[] provides() {
            return this._provides;
        }

        @Override
        public String[] requires() {
            return this._requires;
        }

        @Override
        public String[] deployStrings() {
            return this._install;
        }

        @Override
        public String[] undeployStrings() {
            return this._remove;
        }

        @Override
        public boolean characterize() {
            return true;
        }
    }

    class SQLActionsImpl
    extends AbstractAnnotationImpl
    implements SQLActions {
        SQLAction[] _value;

        SQLActionsImpl() {
        }

        @Override
        public SQLAction[] value() {
            return this._value;
        }

        public void setValue(Object o, boolean explicit, Element e) {
            AnnotationMirror[] ams = DDRProcessorImpl.avToArray(o, AnnotationMirror.class);
            this._value = new SQLAction[ams.length];
            int i = 0;
            for (AnnotationMirror am : ams) {
                SQLActionImpl a = new SQLActionImpl();
                DDRProcessorImpl.this.populateAnnotationImpl(a, e, am);
                this._value[i++] = a;
            }
        }
    }

    class SQLTypeImpl
    extends AbstractAnnotationImpl
    implements SQLType {
        String _value;
        String[] _defaultValue;
        String _name;

        SQLTypeImpl() {
        }

        @Override
        public String value() {
            return this._value;
        }

        @Override
        public String[] defaultValue() {
            return this._defaultValue;
        }

        @Override
        public String name() {
            return this._name;
        }

        public void setValue(Object o, boolean explicit, Element e) {
            if (explicit) {
                this._value = (String)o;
            }
        }

        public void setDefaultValue(Object o, boolean explicit, Element e) {
            if (explicit) {
                this._defaultValue = DDRProcessorImpl.avToArray(o, String.class);
            }
        }

        public void setName(Object o, boolean explicit, Element e) {
            if (!explicit) {
                return;
            }
            this._name = (String)o;
            if (this._name.startsWith("\"") && !Lexicals.ISO_DELIMITED_IDENTIFIER.matcher(this._name).matches()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.WARNING, e, "malformed parameter name: %s", this._name);
            }
        }
    }

    class AbstractAnnotationImpl
    implements Annotation {
        String _implementor;
        String _comment;

        AbstractAnnotationImpl() {
            this._implementor = DDRProcessorImpl.this.defaultImplementor;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException();
        }

        public String implementor() {
            return this._implementor;
        }

        public void setImplementor(Object o, boolean explicit, Element e) {
            if (explicit) {
                this._implementor = "".equals(o) ? null : (String)o;
            }
        }

        public String comment() {
            return this._comment;
        }

        public void setComment(Object o, boolean explicit, Element e) {
            if (explicit) {
                this._comment = (String)o;
                if ("".equals(this._comment)) {
                    this._comment = null;
                }
            } else {
                this._comment = ((Commentable)((Object)this)).derivedComment(e);
            }
        }

        public String derivedComment(Element e) {
            String dc = DDRProcessorImpl.this.elmu.getDocComment(e);
            if (null == dc) {
                return null;
            }
            return this.firstSentence(dc);
        }

        public String firstSentence(String s) {
            BreakIterator bi = BreakIterator.getSentenceInstance(DDRProcessorImpl.this.loca);
            bi.setText(s);
            int start = bi.first();
            int end = bi.next();
            if (-1 == end) {
                return null;
            }
            return s.substring(start, end).trim();
        }
    }

    static enum UDTKind {
        BASE,
        MAPPED;

    }

    static final class SnippetsKey {
        final Object o;
        final Class<? extends Snippet> c;

        SnippetsKey(Object o, Class<? extends Snippet> c) {
            assert (Snippet.class != c) : "Snippet key must be a subtype";
            this.o = o;
            this.c = c;
        }

        public boolean equals(Object oth) {
            if (!(oth instanceof SnippetsKey)) {
                return false;
            }
            SnippetsKey osk = (SnippetsKey)oth;
            return this.o.equals(osk.o) && (this.c.isAssignableFrom(osk.c) || osk.c.isAssignableFrom(this.c));
        }

        public int hashCode() {
            return this.o.hashCode();
        }
    }
}

