#ifndef MY_COLLATION_H
#define MY_COLLATION_H

#include "my_inttypes.h"

typedef struct CHARSET_INFO CHARSET_INFO;

extern const char **get_all_collations(void);

extern const CHARSET_INFO *get_collation_by_name(const char *);
extern int my_strnncoll(const CHARSET_INFO *cs, const char *s1, size_t s1len,
						const char *s2, size_t s2len);
extern size_t my_strnxfrm(const CHARSET_INFO *, uchar *dst, size_t dstlen,
						  uint num_codepoints, const uchar *src, size_t srclen,
						  uint flags);
extern size_t my_strnxfrmlen(const CHARSET_INFO *, size_t num_bytes);

extern size_t my_casedn_multiply(const CHARSET_INFO *cs);
extern size_t my_caseup_multiply(const CHARSET_INFO *cs);

extern size_t my_caseup_str(const CHARSET_INFO *cs, char *src);
extern size_t my_casedn_str(const CHARSET_INFO *cs, char *src);

extern size_t my_caseup(const CHARSET_INFO *cs, const char *src, size_t srclen,
						char *dst, size_t dstlen);
extern size_t my_casedn(const CHARSET_INFO *cs, const char *src, size_t srclen,
						char *dst, size_t dstlen);

extern int my_wildcmp(const CHARSET_INFO *, const char *str, const char *str_end,
					  const char *wildstr, const char *wildend, int escape,
					  int w_one, int w_many);

extern uint my_strstr(const CHARSET_INFO *, const char *b, size_t b_length,
					  const char *s, size_t s_length);

extern uint my_strstr_nth(const CHARSET_INFO *, const char *b, size_t b_length,
					  const char *s, size_t s_length, uint nth);
#endif
