/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.postgresql.pljava.internal.SyntheticXMLReader;
import org.postgresql.pljava.internal.VarlenaWrapper;
import org.postgresql.pljava.internal.VarlenaXMLRenderer;
import org.xml.sax.SAXException;

public class PgNodeTreeAsXML
extends VarlenaXMLRenderer {
    public static final String LPAR_TOK = "(";
    public static final String RPAR_TOK = ")";
    public static final String LBRA_TOK = "{";
    public static final String RBRA_TOK = "}";

    PgNodeTreeAsXML(VarlenaWrapper.Input vwi) throws SQLException {
        super(vwi);
    }

    @Override
    protected SyntheticXMLReader.EventCarrier next(ByteBuffer buf) {
        if (0 == buf.remaining()) {
            return null;
        }
        try {
            final CharBuffer cb = this.m_decoder.decode(buf);
            return new SyntheticXMLReader.EventCarrier(){

                @Override
                public void toSAX() throws IOException, SAXException, SQLException {
                    this.nodeRead(null);
                }

                private String nextToken() {
                    return PgNodeTreeAsXML.this.nextToken(cb);
                }

                private void nodeRead(String token) throws IOException, SAXException, SQLException {
                    if (null == token && null == (token = this.nextToken())) {
                        return;
                    }
                    NodeTokenType type = NodeTokenType.of(token);
                    switch (type) {
                        case LEFT_BRACE: {
                            this.parseNodeString();
                            break;
                        }
                        case LEFT_PAREN: {
                            String listType;
                            token = this.nextToken();
                            if (null == token) {
                                throw new SQLException("unterminated List structure");
                            }
                            String string = "i".equals(token) ? "int" : ("o".equals(token) ? "oid" : (listType = "b".equals(token) ? "bit" : null));
                            if (null != listType) {
                                this.startElement("list", this.cleared().withAttribute("all", listType));
                                while (true) {
                                    if (null == (token = this.nextToken())) {
                                        throw new SQLException("unterminated List structure");
                                    }
                                    if (PgNodeTreeAsXML.RPAR_TOK != token) {
                                        this.startElement("v");
                                        this.characters(token);
                                        this.endElement("v");
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                this.startElement("list");
                                while (PgNodeTreeAsXML.RPAR_TOK != token) {
                                    this.nodeRead(token);
                                    token = this.nextToken();
                                    if (null != token) continue;
                                    throw new SQLException("unterminated List structure");
                                }
                            }
                            this.endElement("list");
                            break;
                        }
                        case RIGHT_PAREN: {
                            throw new SQLException("unexpected right parenthesis");
                        }
                        case OTHER_TOKEN: {
                            if (token.isEmpty()) {
                                this.startElement("null");
                                this.endElement("null");
                                break;
                            }
                            throw new SQLException("unrecognized token: \"" + token + '\"');
                        }
                        case T_Integer: 
                        case T_Float: {
                            this.startElement(type.name());
                            this.characters(token);
                            this.endElement(type.name());
                            break;
                        }
                        case T_String: {
                            this.startElement(type.name());
                            this.characters(token.substring(1, token.length() - 1));
                            this.endElement(type.name());
                            break;
                        }
                        case T_BitString: {
                            this.startElement(type.name());
                            this.characters(token.substring(1));
                            this.endElement(type.name());
                        }
                    }
                }

                private void parseNodeString() throws IOException, SAXException, SQLException {
                    String token = this.nextToken();
                    if (null == token || PgNodeTreeAsXML.RBRA_TOK == token) {
                        throw new SQLException("badly formatted node string \"" + token + '\"');
                    }
                    String tokname = token;
                    boolean seenMember = false;
                    this.startElement(tokname);
                    boolean isCONST = "CONST".equals(tokname);
                    while (true) {
                        if (null == (token = this.nextToken())) {
                            throw new SQLException("unterminated node structure");
                        }
                        if (PgNodeTreeAsXML.RBRA_TOK == token) break;
                        if (token.startsWith(":")) {
                            if (seenMember) {
                                this.endElement("member");
                            }
                            seenMember = true;
                            String name = token.substring(1);
                            if (isCONST && "constvalue".equals(name)) {
                                this.readDatum();
                                continue;
                            }
                            this.startElement("member", this.cleared().withAttribute("name", name));
                            continue;
                        }
                        if (PgNodeTreeAsXML.LBRA_TOK == token || PgNodeTreeAsXML.LPAR_TOK == token) {
                            this.nodeRead(token);
                            continue;
                        }
                        if (!seenMember) {
                            throw new SQLException("node value outside member");
                        }
                        this.characters(token);
                    }
                    if (seenMember) {
                        this.endElement("member");
                    }
                    this.endElement(tokname);
                }

                private void readDatum() throws IOException, SAXException, SQLException {
                    String token = this.nextToken();
                    if (null == token) {
                        throw new SQLException("malformed constvalue (expected length)");
                    }
                    if (token.isEmpty()) {
                        this.startElement("member", this.cleared().withAttribute("name", "constvalue"));
                        return;
                    }
                    this.startElement("member", this.cleared().withAttribute("name", "constvalue").withAttribute("length", token));
                    token = this.nextToken();
                    if (!"[".equals(token)) {
                        throw new SQLException("malformed constvalue (expected \"[\" got \"" + token + "\")");
                    }
                    while (true) {
                        if (null == (token = this.nextToken())) {
                            throw new SQLException("unterminated constvalue");
                        }
                        if ("]".equals(token)) break;
                        int b = Integer.parseInt(token);
                        assert (-128 <= b && b < 128) : "constvalue out of range";
                        this.characters(Integer.toHexString(512 + b).substring(1).toUpperCase());
                    }
                }
            };
        }
        catch (CharacterCodingException e) {
            return this.exceptionCarrier(e);
        }
    }

    String nextToken(CharBuffer cb) {
        int beg = cb.position();
        int end = cb.limit();
        int cur = beg;
        char ch = '\u0000';
        while (cur < end && (' ' == (ch = cb.get(cur)) || '\n' == ch || '\t' == ch)) {
            beg = ++cur;
        }
        if (cur == end) {
            cb.position(cur);
            return null;
        }
        if ('(' == ch || ')' == ch || '{' == ch || '}' == ch) {
            cb.position(++cur);
            switch (ch) {
                case '(': {
                    return LPAR_TOK;
                }
                case ')': {
                    return RPAR_TOK;
                }
                case '{': {
                    return LBRA_TOK;
                }
                case '}': {
                    return RBRA_TOK;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        while (-1 == "(){} \n\t".indexOf(ch)) {
            if ('\\' == ch && ++cur < end) {
                sb.append(cb.get(cur++));
            } else {
                sb.append(ch);
            }
            if (cur == end) break;
            ch = cb.get(cur);
        }
        cb.position(cur);
        if (2 == sb.length() && 0 == sb.indexOf("<>")) {
            return "";
        }
        return sb.toString();
    }

    static enum NodeTokenType {
        T_Integer,
        T_Float,
        T_String,
        T_BitString,
        RIGHT_PAREN,
        LEFT_PAREN,
        LEFT_BRACE,
        OTHER_TOKEN;

        private static final Pattern s_maybeNumber;

        static NodeTokenType of(String token) {
            if (PgNodeTreeAsXML.LPAR_TOK == token) {
                return LEFT_PAREN;
            }
            if (PgNodeTreeAsXML.RPAR_TOK == token) {
                return RIGHT_PAREN;
            }
            if (PgNodeTreeAsXML.LBRA_TOK == token) {
                return LEFT_BRACE;
            }
            if (token.startsWith("\"") && token.endsWith("\"")) {
                return T_String;
            }
            if (token.startsWith("b")) {
                return T_BitString;
            }
            if (s_maybeNumber.matcher(token).lookingAt()) {
                try {
                    Integer.parseInt(token);
                    return T_Integer;
                }
                catch (NumberFormatException e) {
                    return T_Float;
                }
            }
            return OTHER_TOKEN;
        }

        static {
            s_maybeNumber = Pattern.compile("^[-+]?+\\.?+\\d");
        }
    }
}

