/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLSyntaxErrorException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.postgresql.pljava.Session;
import org.postgresql.pljava.SessionManager;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;
import org.postgresql.pljava.sqlj.Loader;

@SQLAction(install={"\tCREATE TABLE sqlj.jar_repository(\t\tjarId       SERIAL PRIMARY KEY,\t\tjarName     CHARACTER VARYING(100) UNIQUE NOT NULL,\t\tjarOrigin   CHARACTER VARYING(500) NOT NULL,\t\tjarOwner    pg_catalog.NAME NOT NULL,\t\tjarManifest pg_catalog.TEXT\t)", "\tCOMMENT ON TABLE sqlj.jar_repository IS\t'Information on jars loaded by PL/Java, one row per jar.'", "\tGRANT SELECT ON sqlj.jar_repository TO public", "\tCREATE TABLE sqlj.jar_entry(\t\tentryId     SERIAL PRIMARY KEY,\t\tentryName   CHARACTER VARYING(200) NOT NULL,\t\tjarId       INT NOT NULL\t\t\t\t\tREFERENCES sqlj.jar_repository ON DELETE CASCADE,\t\tentryImage  pg_catalog.BYTEA NOT NULL,\t\tUNIQUE(jarId, entryName)\t)", "\tCOMMENT ON TABLE sqlj.jar_entry IS\t'Name and content of each entry in every jar loaded by PL/Java.'", "\tGRANT SELECT ON sqlj.jar_entry TO public", "\tCREATE TABLE sqlj.jar_descriptor(\t\tjarId       INT REFERENCES sqlj.jar_repository ON DELETE CASCADE,\t\tordinal     pg_catalog.INT2,\t\tPRIMARY KEY (jarId, ordinal),\t\tentryId     INT NOT NULL REFERENCES sqlj.jar_entry ON DELETE CASCADE\t)", "\tCOMMENT ON TABLE sqlj.jar_descriptor IS\t'Associates each jar with zero-or-more deployment descriptors (a row for each), with ordinal indicating their order of mention in the manifest.'", "\tGRANT SELECT ON sqlj.jar_descriptor TO public", "\tCREATE TABLE sqlj.classpath_entry(\t\tschemaName  CHARACTER VARYING(30) NOT NULL,\t\tordinal     pg_catalog.INT2 NOT NULL,\t\tjarId       INT NOT NULL\t\t\t\t\tREFERENCES sqlj.jar_repository ON DELETE CASCADE,\t\tPRIMARY KEY(schemaName, ordinal)\t)", "\tCOMMENT ON TABLE sqlj.classpath_entry IS\t'Associates each schema with zero-or-more jars (a row for each), with ordinal indicating their order of precedence in the classpath.'", "\tGRANT SELECT ON sqlj.classpath_entry TO public", "\tCREATE TABLE sqlj.typemap_entry(\t\tmapId       SERIAL PRIMARY KEY,\t\tjavaName    CHARACTER VARYING(200) NOT NULL,\t\tsqlName     pg_catalog.NAME NOT NULL\t)", "\tCOMMENT ON TABLE sqlj.typemap_entry IS\t'A row for each SQL type <-> Java type custom mapping.'", "\tGRANT SELECT ON sqlj.typemap_entry TO public"}, remove={"\tDROP TABLE sqlj.typemap_entry", "\tDROP TABLE sqlj.jar_repository CASCADE"})
public class Commands {
    private static final Logger s_logger = Logger.getLogger(Commands.class.getName());
    private static final Pattern ddrSection = Pattern.compile("(?<=[\\r\\n])Name: ((?:.|(?:\\r\\n?+|\\n) )++)(?:\\r\\n?+|\\n)(?:[^\\r\\n]++(?:\\r\\n?+|\\n)(?![\\r\\n]))*SQLJDeploymentDescriptor: (?:(?:\\r\\n?+|\\r) )*+TRUE(?!\\S)", 2);
    private static final Pattern mfCont = Pattern.compile("(?:\\r\\n?+|\\n) ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClassImages(int jarId, InputStream urlStream, int sz) throws SQLException {
        PreparedStatement stmt = null;
        PreparedStatement descIdFetchStmt = null;
        PreparedStatement descIdStoreStmt = null;
        ResultSet rs = null;
        try {
            JarEntry je;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream img = new ByteArrayOutputStream();
            stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_entry(entryName, jarId, entryImage) VALUES(?, ?, ?)");
            BufferedInputStream bis = new BufferedInputStream(urlStream);
            String manifest = Commands.rawManifest(bis, sz);
            JarInputStream jis = new JarInputStream(bis);
            if (manifest != null) {
                PreparedStatement us = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarManifest = ? WHERE jarId OPERATOR(pg_catalog.=) ?");
                try {
                    us.setString(1, manifest);
                    us.setInt(2, jarId);
                    if (us.executeUpdate() != 1) {
                        throw new SQLException("Jar repository update did not update 1 row");
                    }
                }
                finally {
                    SQLUtils.close(us);
                }
            }
            while ((je = jis.getNextJarEntry()) != null) {
                int nBytes;
                if (je.isDirectory()) continue;
                String entryName = je.getName();
                img.reset();
                while ((nBytes = jis.read(buf)) > 0) {
                    img.write(buf, 0, nBytes);
                }
                jis.closeEntry();
                stmt.setString(1, entryName);
                stmt.setInt(2, jarId);
                stmt.setBytes(3, img.toByteArray());
                if (stmt.executeUpdate() == 1) continue;
                throw new SQLException("Jar entry insert did not insert 1 row");
            }
            Matcher ddr = ddrSection.matcher(null != manifest ? manifest : "");
            Matcher cnt = mfCont.matcher("");
            int ordinal = 0;
            while (ddr.find()) {
                String entryName = cnt.reset(ddr.group(1)).replaceAll("");
                if (descIdFetchStmt == null) {
                    descIdFetchStmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryId FROM sqlj.jar_entry WHERE jarId OPERATOR(pg_catalog.=) ?  AND entryName OPERATOR(pg_catalog.=) ?");
                }
                descIdFetchStmt.setInt(1, jarId);
                descIdFetchStmt.setString(2, entryName);
                rs = descIdFetchStmt.executeQuery();
                if (!rs.next()) {
                    throw new SQLException("Failed to refetch row in sqlj.jar_entry");
                }
                int deployImageId = rs.getInt(1);
                if (descIdStoreStmt == null) {
                    descIdStoreStmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_descriptor (jarId, entryId, ordinal) VALUES ( ?, ?, ? )");
                }
                descIdStoreStmt.setInt(1, jarId);
                descIdStoreStmt.setInt(2, deployImageId);
                descIdStoreStmt.setInt(3, ordinal);
                if (descIdStoreStmt.executeUpdate() != 1) {
                    throw new SQLException("Jar deployment descriptor insert did not insert 1 row");
                }
                ++ordinal;
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException("I/O exception reading jar file: " + e.getMessage(), "58030", e);
            }
            catch (Throwable throwable) {
                SQLUtils.close(rs);
                SQLUtils.close(descIdStoreStmt);
                SQLUtils.close(descIdFetchStmt);
                SQLUtils.close(stmt);
                throw throwable;
            }
        }
        SQLUtils.close(rs);
        SQLUtils.close(descIdStoreStmt);
        SQLUtils.close(descIdFetchStmt);
        SQLUtils.close(stmt);
    }

    private static String rawManifest(BufferedInputStream bis, int markLimit) throws IOException {
        ZipEntry ze;
        bis.mark(markLimit > 0 ? markLimit : 0x2000000);
        ZipInputStream zis = new ZipInputStream(bis);
        while (null != (ze = zis.getNextEntry())) {
            if ("META-INF/MANIFEST.MF".equals(ze.getName())) {
                int got;
                StringBuilder sb = new StringBuilder();
                CharsetDecoder u8 = Charset.forName("UTF-8").newDecoder();
                InputStreamReader isr = new InputStreamReader((InputStream)zis, u8);
                char[] b = new char[512];
                while (-1 != (got = isr.read(b))) {
                    sb.append(b, 0, got);
                }
                zis.closeEntry();
                bis.reset();
                return sb.toString();
            }
            zis.closeEntry();
        }
        bis.reset();
        return null;
    }

    @Function(schema="sqlj", name="add_type_mapping", security=Function.Security.DEFINER)
    public static void addTypeMapping(String sqlTypeName, String javaClassName) throws SQLException {
        PreparedStatement stmt = null;
        try {
            ClassLoader loader = Loader.getCurrentLoader();
            Class<?> cls = loader.loadClass(javaClassName);
            if (!SQLData.class.isAssignableFrom(cls)) {
                throw new SQLException("Class " + javaClassName + " does not implement java.sql.SQLData");
            }
            sqlTypeName = Commands.getFullSqlNameOwned(sqlTypeName);
            stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.typemap_entry(javaName, sqlName) VALUES(?,?)");
            stmt.setString(1, javaClassName);
            stmt.setString(2, sqlTypeName);
            stmt.executeUpdate();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new SQLException("No such class: " + javaClassName, "46103", e);
            }
            catch (Throwable throwable) {
                SQLUtils.close(stmt);
                throw throwable;
            }
        }
        SQLUtils.close(stmt);
        Loader.clearSchemaLoaders();
    }

    @Function(schema="sqlj", name="drop_type_mapping", security=Function.Security.DEFINER)
    public static void dropTypeMapping(String sqlTypeName) throws SQLException {
        PreparedStatement stmt = null;
        try {
            sqlTypeName = Commands.getFullSqlNameOwned(sqlTypeName);
            stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.typemap_entry WHERE sqlName OPERATOR(pg_catalog.=) ?");
            stmt.setString(1, sqlTypeName);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.close(stmt);
            throw throwable;
        }
        SQLUtils.close(stmt);
        Loader.clearSchemaLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Function(schema="sqlj", name="get_classpath", security=Function.Security.DEFINER)
    public static String getClassPath(String schemaName) throws SQLException {
        String string;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            schemaName = schemaName == null || schemaName.length() == 0 ? "public" : schemaName.toLowerCase();
            stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT r.jarName FROM  sqlj.jar_repository r  INNER JOIN sqlj.classpath_entry c  ON r.jarId OPERATOR(pg_catalog.=) c.jarId WHERE c.schemaName OPERATOR(pg_catalog.=) ? ORDER BY c.ordinal");
            stmt.setString(1, schemaName);
            rs = stmt.executeQuery();
            StringBuffer buf = null;
            while (rs.next()) {
                if (buf == null) {
                    buf = new StringBuffer();
                } else {
                    buf.append(':');
                }
                buf.append(rs.getString(1));
            }
            string = buf == null ? null : buf.toString();
        }
        catch (Throwable throwable) {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            throw throwable;
        }
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return string;
    }

    public static String getCurrentSchema() throws SQLException {
        Session session = SessionManager.current();
        return ((org.postgresql.pljava.internal.Session)session).getOuterUserSchema();
    }

    @Function(schema="sqlj", name="install_jar", security=Function.Security.DEFINER)
    public static void installJar(byte[] image, String jarName, boolean deploy) throws SQLException {
        Commands.installJar("streamed byte image", jarName, deploy, image);
    }

    @Function(schema="sqlj", name="install_jar", security=Function.Security.DEFINER)
    public static void installJar(String urlString, String jarName, boolean deploy) throws SQLException {
        Commands.installJar(urlString, jarName, deploy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Function(schema="sqlj", name="remove_jar", security=Function.Security.DEFINER)
    public static void removeJar(String jarName, boolean undeploy) throws SQLException {
        Commands.assertJarName(jarName);
        AclId[] ownerRet = new AclId[1];
        int jarId = Commands.getJarId(jarName, ownerRet);
        if (jarId < 0) {
            throw new SQLException("No Jar named '" + jarName + "' is known to the system", "4600B");
        }
        AclId user = AclId.getOuterUser();
        if (!user.isSuperuser() && !user.equals(ownerRet[0])) {
            throw new SQLSyntaxErrorException("Only super user or owner can remove a jar", "42501");
        }
        if (undeploy) {
            Commands.deployRemove(jarId, jarName);
        }
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_repository WHERE jarId OPERATOR(pg_catalog.=) ?");
        try {
            stmt.setInt(1, jarId);
            if (stmt.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(stmt);
        }
        Loader.clearSchemaLoaders();
    }

    @Function(schema="sqlj", name="replace_jar", security=Function.Security.DEFINER)
    public static void replaceJar(byte[] jarImage, String jarName, boolean redeploy) throws SQLException {
        Commands.replaceJar("streamed byte image", jarName, redeploy, jarImage);
    }

    @Function(schema="sqlj", name="replace_jar", security=Function.Security.DEFINER)
    public static void replaceJar(String urlString, String jarName, boolean redeploy) throws SQLException {
        Commands.replaceJar(urlString, jarName, redeploy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Function(schema="sqlj", name="set_classpath", security=Function.Security.DEFINER)
    public static void setClassPath(String schemaName, String path) throws SQLException {
        int jarId;
        PreparedStatement stmt;
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = "public";
        }
        if ("public".equals(schemaName = schemaName.toLowerCase())) {
            if (!AclId.getOuterUser().isSuperuser()) {
                throw new SQLSyntaxErrorException("Permission denied. Only a super user can set the classpath of the public schema", "42501");
            }
        } else {
            Oid schemaId = Commands.getSchemaId(schemaName);
            if (schemaId == null) {
                throw new SQLNonTransientException("No such schema: " + schemaName, "3F000");
            }
            if (!AclId.getOuterUser().hasSchemaCreatePermission(schemaId)) {
                throw new SQLSyntaxErrorException("Permission denied. User must have create permission on the target schema in order to set the classpath", "42501");
            }
        }
        ArrayList<Integer> entries = null;
        if (path != null && path.length() > 0) {
            entries = new ArrayList<Integer>();
            stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName OPERATOR(pg_catalog.=) ?");
            try {
                int colon;
                do {
                    String jarName;
                    if ((colon = path.indexOf(58)) >= 0) {
                        jarName = path.substring(0, colon);
                        path = path.substring(colon + 1);
                    } else {
                        jarName = path;
                    }
                    jarId = Commands.getJarId(stmt, jarName, null);
                    if (jarId < 0) {
                        throw new SQLNonTransientException("No such jar: " + jarName, "46102");
                    }
                    entries.add(jarId);
                } while (colon >= 0);
            }
            finally {
                SQLUtils.close(stmt);
            }
        }
        stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.classpath_entry WHERE schemaName OPERATOR(pg_catalog.=) ?");
        try {
            stmt.setString(1, schemaName);
            stmt.executeUpdate();
        }
        finally {
            SQLUtils.close(stmt);
        }
        if (entries != null) {
            stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.classpath_entry(schemaName, ordinal, jarId) VALUES(?, ?, ?)");
            try {
                int top = entries.size();
                for (int idx = 0; idx < top; ++idx) {
                    jarId = (Integer)entries.get(idx);
                    stmt.setString(1, schemaName);
                    stmt.setInt(2, idx + 1);
                    stmt.setInt(3, jarId);
                    stmt.executeUpdate();
                }
            }
            finally {
                SQLUtils.close(stmt);
            }
        }
        Loader.clearSchemaLoaders();
    }

    private static boolean assertInPath(String jarName, String[] originalSchemaAndPath) throws SQLException {
        String currentSchema = Commands.getCurrentSchema();
        String currentClasspath = Commands.getClassPath(currentSchema);
        originalSchemaAndPath[0] = currentSchema;
        originalSchemaAndPath[1] = currentClasspath;
        if (currentClasspath == null) {
            Commands.setClassPath(currentSchema, jarName);
            return true;
        }
        String[] elems = currentClasspath.split(":");
        int idx = elems.length;
        boolean found = false;
        while (--idx >= 0) {
            if (!elems[idx].equals(jarName)) continue;
            found = true;
            break;
        }
        if (found) {
            return false;
        }
        Commands.setClassPath(currentSchema, jarName + ':' + currentClasspath);
        return true;
    }

    private static void assertJarName(String jarName) throws SQLException {
        int len;
        if (jarName != null && (len = jarName.length()) > 0 && Character.isJavaIdentifierStart(jarName.charAt(0))) {
            int idx;
            for (idx = 1; idx < len && Character.isJavaIdentifierPart(jarName.charAt(idx)); ++idx) {
            }
            if (idx == len) {
                return;
            }
        }
        throw new SQLNonTransientException("The jar name '" + jarName + "' is not a valid name", "46002");
    }

    private static void deployInstall(int jarId, String jarName) throws SQLException {
        SQLDeploymentDescriptor[] depDesc = Commands.getDeploymentDescriptors(jarId);
        String[] originalSchemaAndPath = new String[2];
        boolean classpathChanged = Commands.assertInPath(jarName, originalSchemaAndPath);
        for (SQLDeploymentDescriptor dd : depDesc) {
            dd.install(SQLUtils.getDefaultConnection());
        }
        if (classpathChanged) {
            Commands.setClassPath(originalSchemaAndPath[0], originalSchemaAndPath[1]);
        }
    }

    private static void deployRemove(int jarId, String jarName) throws SQLException {
        block4: {
            SQLDeploymentDescriptor[] depDesc = Commands.getDeploymentDescriptors(jarId);
            String[] originalSchemaAndPath = new String[2];
            boolean classpathChanged = Commands.assertInPath(jarName, originalSchemaAndPath);
            int i = depDesc.length;
            while (i-- > 0) {
                depDesc[i].remove(SQLUtils.getDefaultConnection());
            }
            try {
                if (classpathChanged) {
                    Commands.setClassPath(originalSchemaAndPath[0], originalSchemaAndPath[1]);
                }
            }
            catch (SQLException sqle) {
                if ("3F000".equals(sqle.getSQLState())) break block4;
                throw sqle;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SQLDeploymentDescriptor[] getDeploymentDescriptors(int jarId) throws SQLException {
        SQLDeploymentDescriptor[] sQLDeploymentDescriptorArray;
        ResultSet rs = null;
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT e.entryImage FROM sqlj.jar_descriptor d INNER JOIN sqlj.jar_entry e   ON d.entryId OPERATOR(pg_catalog.=) e.entryId WHERE d.jarId OPERATOR(pg_catalog.=) ? ORDER BY d.ordinal");
        try {
            stmt.setInt(1, jarId);
            rs = stmt.executeQuery();
            ArrayList<SQLDeploymentDescriptor> sdds = new ArrayList<SQLDeploymentDescriptor>();
            while (rs.next()) {
                byte[] bytes = rs.getBytes(1);
                sdds.add(new SQLDeploymentDescriptor(new String(bytes, "UTF8")));
            }
            sQLDeploymentDescriptorArray = sdds.toArray(new SQLDeploymentDescriptor[sdds.size()]);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new SQLException("JVM does not support UTF8!!");
                catch (ParseException e2) {
                    throw new SQLException(e2.getMessage() + " at " + e2.getErrorOffset());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                throw throwable;
            }
        }
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return sQLDeploymentDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFullSqlNameOwned(String sqlTypeName) throws SQLException {
        String string;
        Oid typeId = Oid.forTypeName(sqlTypeName);
        s_logger.info("Type id = " + typeId.toString());
        AclId invoker = AclId.getOuterUser();
        ResultSet rs = null;
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT n.nspname, t.typname, pg_catalog.pg_has_role(?, t.typowner, 'USAGE') FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.oid OPERATOR(pg_catalog.=) ? AND n.oid OPERATOR(pg_catalog.=) t.typnamespace");
        try {
            stmt.setObject(1, invoker);
            stmt.setObject(2, typeId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Unable to obtain type info for " + typeId);
            }
            if (!rs.getBoolean(3)) {
                throw new SQLSyntaxErrorException("Permission denied. Only superuser or type's owner may add or drop a type mapping.", "42501");
            }
            string = rs.getString(1) + '.' + rs.getString(2);
        }
        catch (Throwable throwable) {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            throw throwable;
        }
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(PreparedStatement stmt, String jarName, AclId[] ownerRet) throws SQLException {
        stmt.setString(1, jarName);
        ResultSet rs = stmt.executeQuery();
        try {
            if (!rs.next()) {
                int n = -1;
                return n;
            }
            int id = rs.getInt(1);
            if (ownerRet != null) {
                String ownerName = rs.getString(2);
                ownerRet[0] = AclId.fromName(ownerName);
            }
            int n = id;
            return n;
        }
        finally {
            SQLUtils.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(String jarName, AclId[] ownerRet) throws SQLException {
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId, jarOwner FROM sqlj.jar_repository WHERE jarName OPERATOR(pg_catalog.=) ?");
        try {
            int n = Commands.getJarId(stmt, jarName, ownerRet);
            return n;
        }
        finally {
            SQLUtils.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Oid getSchemaId(String schemaName) throws SQLException {
        PreparedStatement stmt;
        ResultSet rs;
        block3: {
            Oid oid;
            rs = null;
            stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT oid FROM pg_catalog.pg_namespace WHERE nspname OPERATOR(pg_catalog.=) ?");
            try {
                stmt.setString(1, schemaName);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                oid = null;
            }
            catch (Throwable throwable) {
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                throw throwable;
            }
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            return oid;
        }
        Oid oid = (Oid)rs.getObject(1);
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installJar(String urlString, String jarName, boolean deploy, byte[] image) throws SQLException {
        if (Backend.isCreatingExtension()) {
            throw new SQLFeatureNotSupportedException("A jar cannot (yet) be installed as an extension in its own right.", "0A000");
        }
        Commands.assertJarName(jarName);
        if (Commands.getJarId(jarName, null) >= 0) {
            throw new SQLNonTransientException("A jar named '" + jarName + "' already exists", "46002");
        }
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_repository(jarName, jarOrigin, jarOwner) VALUES(?, ?, ?)");
        try {
            stmt.setString(1, jarName);
            stmt.setString(2, urlString);
            stmt.setString(3, AclId.getOuterUser().getName());
            if (stmt.executeUpdate() != 1) {
                throw new SQLException("Jar repository insert did not insert 1 row");
            }
        }
        finally {
            SQLUtils.close(stmt);
        }
        AclId[] ownerRet = new AclId[1];
        int jarId = Commands.getJarId(jarName, ownerRet);
        if (jarId < 0) {
            throw new SQLException("Unable to obtain id of '" + jarName + "'");
        }
        if (image == null) {
            Backend.addClassImages(jarId, urlString);
        } else {
            ByteArrayInputStream imageStream = new ByteArrayInputStream(image);
            Commands.addClassImages(jarId, imageStream, image.length);
        }
        Loader.clearSchemaLoaders();
        if (deploy) {
            Commands.deployInstall(jarId, jarName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceJar(String urlString, String jarName, boolean redeploy, byte[] image) throws SQLException {
        AclId[] ownerRet = new AclId[1];
        int jarId = Commands.getJarId(jarName, ownerRet);
        if (jarId < 0) {
            throw new SQLNonTransientException("No Jar named '" + jarName + "' is known to the system", "4600A");
        }
        AclId user = AclId.getOuterUser();
        if (!user.isSuperuser() && !user.equals(ownerRet[0])) {
            throw new SQLSyntaxErrorException("Only super user or owner can replace a jar", "42501");
        }
        if (redeploy) {
            Commands.deployRemove(jarId, jarName);
        }
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarOrigin = ?, jarOwner = ?, jarManifest = NULL WHERE jarId OPERATOR(pg_catalog.=) ?");
        try {
            stmt.setString(1, urlString);
            stmt.setString(2, user.getName());
            stmt.setInt(3, jarId);
            if (stmt.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(stmt);
        }
        stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_entry WHERE jarId OPERATOR(pg_catalog.=) ?");
        try {
            stmt.setInt(1, jarId);
            stmt.executeUpdate();
        }
        finally {
            SQLUtils.close(stmt);
        }
        if (image == null) {
            Backend.addClassImages(jarId, urlString);
        } else {
            ByteArrayInputStream imageStream = new ByteArrayInputStream(image);
            Commands.addClassImages(jarId, imageStream, image.length);
        }
        Loader.clearSchemaLoaders();
        if (redeploy) {
            Commands.deployInstall(jarId, jarName);
        }
    }
}

