#ifndef REMOTE_TUPLE_CACHE_H
#define REMOTE_TUPLE_CACHE_H
#include "postgres.h"

#include "access/htup.h"
#include "executor/tuptable.h"
#include "lib/stringinfo.h"
#include "nodes/pg_list.h"
#include "utils/hsearch.h"

typedef struct RemoteTupleCache
{
	MemoryContext context;
	HTAB *hashtable;
} RemoteTupleCache;

typedef struct RemoteTupleCacheEntry
{
	StringInfoData key;
	List *tuples_head;
	ListCell *next;
} RemoteTupleCacheEntry;

extern RemoteTupleCache *tuple_cache_create(MemoryContext context);

extern void tuple_cache_insert(RemoteTupleCache *cache, StringInfo key, TupleTableSlot *slot);

extern RemoteTupleCacheEntry *tuple_cache_lookup(RemoteTupleCache *cache, StringInfo key);

extern void tuple_cache_destroy(RemoteTupleCache *);

#endif