/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.PgSavepoint;

public class Invocation {
    private static Invocation[] s_levels = new Invocation[10];
    private final int m_nestingLevel;
    private PgSavepoint m_savepoint;

    private Invocation(int level) {
        this.m_nestingLevel = level;
    }

    public int getNestingLevel() {
        return this.m_nestingLevel;
    }

    final PgSavepoint getSavepoint() {
        return this.m_savepoint;
    }

    final void setSavepoint(PgSavepoint savepoint) {
        this.m_savepoint = savepoint;
    }

    public void onExit(boolean withError) throws SQLException {
        try {
            if (this.m_savepoint != null) {
                this.m_savepoint.onInvocationExit(withError);
            }
        }
        finally {
            Invocation.s_levels[this.m_nestingLevel] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Invocation current() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            int top;
            Invocation curr = Invocation._getCurrent();
            if (curr != null) {
                return curr;
            }
            int level = Invocation._getNestingLevel();
            if (level < (top = s_levels.length)) {
                curr = s_levels[level];
                if (curr != null) {
                    curr._register();
                    return curr;
                }
            } else {
                int newSize = top;
                while ((newSize <<= 2) <= level) {
                }
                Invocation[] levels = new Invocation[newSize];
                System.arraycopy(s_levels, 0, levels, 0, top);
                s_levels = levels;
            }
            Invocation.s_levels[level] = curr = new Invocation(level);
            curr._register();
            return curr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearErrorCondition() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            Invocation._clearErrorCondition();
        }
    }

    private native void _register();

    private static native Invocation _getCurrent();

    private static native int _getNestingLevel();

    private static native void _clearErrorCondition();
}

