/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.postgresql.pljava.jdbc.AbstractResultSet;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class ObjectResultSet
extends AbstractResultSet {
    private boolean m_wasNull = false;

    @Override
    public boolean wasNull() {
        return this.m_wasNull;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Array.class);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Clob c = this.getClob(columnIndex);
        return c == null ? null : c.getAsciiStream();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedFeatureException("getBigDecimal(int, int)");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Blob b = this.getBlob(columnIndex);
        return b == null ? null : b.getBinaryStream();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        return bytes == null ? null : new BlobValue(bytes);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean b = this.getValue(columnIndex, Boolean.class);
        return b == null ? false : b;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Number b = this.getNumber(columnIndex, Byte.TYPE);
        return b == null ? (byte)0 : b.byteValue();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, byte[].class);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Clob c = this.getClob(columnIndex);
        return c == null ? null : c.getCharacterStream();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return str == null ? null : new ClobValue(str);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Date.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getValue(columnIndex, Date.class, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Number d = this.getNumber(columnIndex, Double.TYPE);
        return d == null ? 0.0 : d.doubleValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Number f = this.getNumber(columnIndex, Float.TYPE);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Number i = this.getNumber(columnIndex, Integer.TYPE);
        return i == null ? 0 : i.intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Number l = this.getNumber(columnIndex, Long.TYPE);
        return l == null ? 0L : l.longValue();
    }

    @Override
    public final Object getObject(int columnIndex) throws SQLException {
        Object value = this.getObjectValue(columnIndex);
        this.m_wasNull = value == null;
        return value;
    }

    public final Object getObject(int columnIndex, Map map) throws SQLException {
        Object value = this.getObjectValue(columnIndex, map);
        this.m_wasNull = value == null;
        return value;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Ref.class);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Number s = this.getNumber(columnIndex, Short.TYPE);
        return s == null ? (short)0 : s.shortValue();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, String.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Time.class);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getValue(columnIndex, Time.class, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getValue(columnIndex, Timestamp.class, cal);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedFeatureException("ResultSet.getUnicodeStream");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, URL.class);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedFeatureException("Refresh row");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.updateObject(columnIndex, (Object)new ClobValue(new InputStreamReader(x, "US-ASCII"), length));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateBlob(columnIndex, (Blob)new BlobValue(x, length));
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateClob(columnIndex, (Clob)new ClobValue(x, length));
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateObject(columnIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.updateObject(columnIndex, null);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public final <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object value = this.getObjectValue(columnIndex, type);
        boolean bl = this.m_wasNull = value == null;
        if (this.m_wasNull || type.isInstance(value)) {
            return type.cast(value);
        }
        throw new SQLException("Cannot convert " + value.getClass().getName() + " to " + type.getName());
    }

    protected final Number getNumber(int columnIndex, Class cls) throws SQLException {
        Object value = this.getObjectValue(columnIndex);
        this.m_wasNull = value == null;
        return SPIConnection.basicNumericCoercion(cls, value);
    }

    protected final <T> T getValue(int columnIndex, Class<T> cls) throws SQLException {
        return SPIConnection.basicCoercion(cls, this.getObject(columnIndex));
    }

    protected <T> T getValue(int columnIndex, Class<T> cls, Calendar cal) throws SQLException {
        return SPIConnection.basicCalendricalCoercion(cls, this.getObject(columnIndex), cal);
    }

    protected Object getObjectValue(int columnIndex, Map typeMap) throws SQLException {
        if (typeMap == null) {
            return this.getObjectValue(columnIndex);
        }
        throw new UnsupportedFeatureException("Obtaining values using explicit Map");
    }

    protected Object getObjectValue(int columnIndex) throws SQLException {
        return this.getObjectValue(columnIndex, (Class)null);
    }

    protected abstract Object getObjectValue(int var1, Class<?> var2) throws SQLException;
}

