/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIParameterMetaData;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.TypeBridge;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIPreparedStatement
extends SPIStatement
implements PreparedStatement {
    private final Oid[] m_typeIds;
    private final Object[] m_values;
    private final int[] m_sqlTypes;
    private final String m_statement;
    private ExecutionPlan m_plan;

    public SPIPreparedStatement(SPIConnection conn, String statement, int paramCount) {
        super(conn);
        this.m_statement = statement;
        this.m_typeIds = new Oid[paramCount];
        this.m_values = new Object[paramCount];
        this.m_sqlTypes = new int[paramCount];
        Arrays.fill(this.m_sqlTypes, 0);
    }

    @Override
    public void close() throws SQLException {
        if (this.m_plan != null) {
            this.m_plan.close();
            this.m_plan = null;
        }
        this.clearParameters();
        super.close();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void setNull(int columnIndex, int sqlType) throws SQLException {
        this.setObject(columnIndex, null, sqlType);
    }

    @Override
    public void setBoolean(int columnIndex, boolean value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 16);
    }

    @Override
    public void setByte(int columnIndex, byte value) throws SQLException {
        this.setObject(columnIndex, (Object)value, -6);
    }

    @Override
    public void setShort(int columnIndex, short value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 5);
    }

    @Override
    public void setInt(int columnIndex, int value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 4);
    }

    @Override
    public void setLong(int columnIndex, long value) throws SQLException {
        this.setObject(columnIndex, (Object)value, -5);
    }

    @Override
    public void setFloat(int columnIndex, float value) throws SQLException {
        this.setObject(columnIndex, (Object)Float.valueOf(value), 6);
    }

    @Override
    public void setDouble(int columnIndex, double value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 8);
    }

    @Override
    public void setBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 3);
    }

    @Override
    public void setString(int columnIndex, String value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 12);
    }

    @Override
    public void setBytes(int columnIndex, byte[] value) throws SQLException {
        this.setObject(columnIndex, (Object)value, -3);
    }

    @Override
    public void setDate(int columnIndex, Date value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 91);
    }

    @Override
    public void setTime(int columnIndex, Time value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 92);
    }

    @Override
    public void setTimestamp(int columnIndex, Timestamp value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 93);
    }

    @Override
    public void setAsciiStream(int columnIndex, InputStream value, int length) throws SQLException {
        try {
            this.setObject(columnIndex, (Object)new ClobValue(new InputStreamReader(value, "US-ASCII"), length), 2005);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    @Override
    public void setUnicodeStream(int columnIndex, InputStream value, int arg2) throws SQLException {
        throw new UnsupportedFeatureException("PreparedStatement.setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int columnIndex, InputStream value, int length) throws SQLException {
        this.setObject(columnIndex, (Object)new BlobValue(value, length), 2004);
    }

    @Override
    public void clearParameters() throws SQLException {
        Arrays.fill(this.m_values, null);
        Arrays.fill(this.m_sqlTypes, 0);
    }

    @Override
    public void setObject(int columnIndex, Object value, int sqlType, int scale) throws SQLException {
        this.setObject(columnIndex, value, sqlType);
    }

    @Override
    public void setObject(int columnIndex, Object value, int sqlType) throws SQLException {
        this.setObject(columnIndex, value, sqlType, TypeBridge.wrap(value));
    }

    private void setObject(int columnIndex, Object value, int sqlType, TypeBridge.Holder vAlt) throws SQLException {
        Oid op;
        if (columnIndex < 1 || columnIndex > this.m_sqlTypes.length) {
            throw new SQLException("Illegal parameter index");
        }
        Oid id = null;
        id = null != vAlt ? new Oid(vAlt.defaultOid()) : (sqlType != 1111 ? Oid.forSqlType(sqlType) : Oid.forJavaObject(value));
        if (id == null) {
            id = Oid.forSqlType(12);
        }
        if ((op = this.m_typeIds[--columnIndex]) == null) {
            this.m_typeIds[columnIndex] = id;
        } else if (null == vAlt && !op.equals(id)) {
            this.m_typeIds[columnIndex] = id;
            if (this.m_plan != null) {
                this.m_plan.close();
                this.m_plan = null;
            }
        }
        this.m_sqlTypes[columnIndex] = sqlType;
        this.m_values[columnIndex] = null == vAlt ? value : vAlt;
    }

    @Override
    public void setObject(int columnIndex, Object value) throws SQLException {
        if (value == null) {
            throw new SQLException("Can't assign null unless the SQL type is known");
        }
        TypeBridge.Holder vAlt = TypeBridge.wrap(value);
        int sqlType = null == vAlt ? SPIConnection.getTypeForClass(value.getClass()) : 1111;
        this.setObject(columnIndex, value, sqlType, vAlt);
    }

    private int[] getSqlTypes() {
        int idx = this.m_sqlTypes.length;
        int[] types = (int[])this.m_sqlTypes.clone();
        while (--idx >= 0) {
            if (types[idx] != 0) continue;
            types[idx] = 12;
        }
        return types;
    }

    @Override
    public boolean execute() throws SQLException {
        int[] sqlTypes = this.m_sqlTypes;
        int idx = sqlTypes.length;
        while (--idx >= 0) {
            if (sqlTypes[idx] != 0) continue;
            throw new SQLException("Not all parameters have been set");
        }
        if (this.m_plan == null) {
            this.m_plan = ExecutionPlan.prepare(this.m_statement, this.m_typeIds);
        }
        boolean result = this.executePlan(this.m_plan, this.m_values);
        this.clearParameters();
        return result;
    }

    @Override
    public boolean execute(String statement) throws SQLException {
        throw new UnsupportedFeatureException("Can't execute other statements using a prepared statement");
    }

    @Override
    public void addBatch() throws SQLException {
        this.internalAddBatch(new Object[]{this.m_values.clone(), this.m_sqlTypes.clone(), this.m_typeIds.clone()});
        this.clearParameters();
    }

    @Override
    public void addBatch(String statement) throws SQLException {
        throw new UnsupportedFeatureException("Can't add batch statements to a prepared statement");
    }

    @Override
    public void setCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        this.setObject(columnIndex, (Object)new ClobValue(value, length), 2005);
    }

    @Override
    public void setRef(int columnIndex, Ref value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2006);
    }

    @Override
    public void setBlob(int columnIndex, Blob value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2004);
    }

    @Override
    public void setClob(int columnIndex, Clob value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2005);
    }

    @Override
    public void setArray(int columnIndex, Array value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 2003);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    @Override
    public void setDate(int columnIndex, Date value, Calendar cal) throws SQLException {
        if (cal != null && cal != Calendar.getInstance()) {
            throw new UnsupportedFeatureException("Setting date using explicit Calendar");
        }
        this.setObject(columnIndex, (Object)value, 91);
    }

    @Override
    public void setTime(int columnIndex, Time value, Calendar cal) throws SQLException {
        if (cal != null && cal != Calendar.getInstance()) {
            throw new UnsupportedFeatureException("Setting time using explicit Calendar");
        }
        this.setObject(columnIndex, (Object)value, 92);
    }

    @Override
    public void setTimestamp(int columnIndex, Timestamp value, Calendar cal) throws SQLException {
        if (cal != null && cal != Calendar.getInstance()) {
            throw new UnsupportedFeatureException("Setting time using explicit Calendar");
        }
        this.setObject(columnIndex, (Object)value, 93);
    }

    @Override
    public void setNull(int columnIndex, int sqlType, String typeName) throws SQLException {
        Oid op;
        Oid id = Oid.forTypeName(typeName);
        if (null == (op = this.m_typeIds[--columnIndex])) {
            this.m_typeIds[columnIndex] = id;
        } else if (!op.equals(id)) {
            this.m_typeIds[columnIndex] = id;
            if (null != this.m_plan) {
                this.m_plan.close();
                this.m_plan = null;
            }
        }
        this.m_sqlTypes[columnIndex] = sqlType;
        this.m_values[columnIndex] = null;
    }

    @Override
    public void setURL(int columnIndex, URL value) throws SQLException {
        this.setObject(columnIndex, (Object)value, 70);
    }

    public String toString() {
        return this.m_statement;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new SPIParameterMetaData(this.getSqlTypes());
    }

    @Override
    protected long executeBatchEntry(Object batchEntry) throws SQLException {
        long ret = -2L;
        Object[] batchParams = (Object[])batchEntry;
        Object batchValues = batchParams[0];
        Object batchSqlTypes = batchParams[1];
        Object[] batchTypeIds = (Object[])batchParams[2];
        System.arraycopy(batchValues, 0, this.m_values, 0, this.m_values.length);
        System.arraycopy(batchSqlTypes, 0, this.m_sqlTypes, 0, this.m_sqlTypes.length);
        for (int i = 0; i < this.m_typeIds.length; ++i) {
            if (this.m_typeIds[i] == batchTypeIds[i]) continue;
            if (this.m_plan != null) {
                this.m_plan.close();
                this.m_plan = null;
            }
            System.arraycopy(batchTypeIds, 0, this.m_typeIds, 0, this.m_typeIds.length);
            break;
        }
        if (this.execute()) {
            this.getResultSet().close();
        } else {
            long updCount = this.getUpdateCount();
            if (updCount >= 0L) {
                ret = updCount;
            }
        }
        return ret;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterIndex, (Object)xmlObject, 2009);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setNClob( int, Reader ) not implemented yet.", "0A000");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setNClob( int, NClob ) not implemented yet.", "0A000");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setNClob( int, Reader, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setBlob( int, InputStream ) not implemented yet.", "0A000");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setBlob( int, InputStream, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setClob( int, Reader ) not implemented yet.", "0A000");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setClob( int, Reader, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setNCharacterStream( int, Reader ) not implemented yet.", "0A000");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setNCharacterStream( int, Reader, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setCharacterStream( int, Reader ) not implemented yet.", "0A000");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setCharacterStream( int, Reader, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setBinaryStream( int, InputStream ) not implemented yet.", "0A000");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setBinaryStream( int, InputStream, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setAsciiStream( int, InputStream ) not implemented yet.", "0A000");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setAsciiStream( int, InputStream, long ) not implemented yet.", "0A000");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setNString( int, String ) not implemented yet.", "0A000");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setRowId( int, RowId ) not implemented yet.", "0A000");
    }
}

