/*-------------------------------------------------------------------------
 *
 * mysql_error.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		MySQL error code definitions.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/mysql_error.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef MYSQL_ERRNO_H
#define MYSQL_ERRNO_H

// must be the same error number as mysql

// client error codes
#define CR_COMPRESSION_WRONGLY_CONFIGURED 2066


// internal errnos
#define MY_ERRNO_EDOM 33
#define MY_ERRNO_ERANGE 34
#define EE_SSL_ERROR_FROM_FILE 59
#define EE_SSL_ERROR 60
#define EE_NET_SEND_ERROR_IN_BOOTSTRAP 61
#define EE_PACKETS_OUT_OF_ORDER 62
#define EE_UNKNOWN_PROTOCOL_OPTION 63

// server error codes
#define ER_CANT_CREATE_FILE 1004
#define ER_CANT_CREATE_TABLE 1005
#define ER_CANT_CREATE_DB 1006
#define ER_DB_CREATE_EXISTS 1007
#define ER_DB_DROP_EXISTS 1008
#define ER_DB_DROP_RMDIR 1010
#define ER_CANT_FIND_SYSTEM_REC 1012
#define ER_CANT_GET_STAT 1013
#define ER_CANT_LOCK 1015
#define ER_CANT_OPEN_FILE 1016
#define ER_FILE_NOT_FOUND 1017
#define ER_CANT_READ_DIR 1018
#define ER_CHECKREAD 1020
#define ER_DUP_KEY 1022
#define ER_ERROR_ON_READ 1024
#define ER_ERROR_ON_RENAME 1025
#define ER_ERROR_ON_WRITE 1026
#define ER_FILE_USED 1027
#define ER_GET_ERRNO 1030
#define ER_ILLEGAL_HA 1031
#define ER_KEY_NOT_FOUND 1032
#define ER_OPEN_AS_READONLY 1036
#define ER_OUTOFMEMORY 1037
#define ER_OUT_OF_SORTMEMORY 1038
#define ER_CON_COUNT_ERROR 1040
#define ER_OUT_OF_RESOURCES 1041
#define ER_BAD_HOST_ERROR 1042
#define ER_HANDSHAKE_ERROR 1043
#define ER_DBACCESS_DENIED_ERROR 1044
#define ER_ACCESS_DENIED_ERROR 1045
#define ER_NO_DB_ERROR 1046
#define ER_UNKNOWN_COM_ERROR 1047
#define ER_BAD_NULL_ERROR 1048
#define ER_BAD_DB_ERROR 1049
#define ER_TABLE_EXISTS_ERROR 1050
#define ER_BAD_TABLE_ERROR 1051
#define ER_NON_UNIQ_ERROR 1052
#define ER_SERVER_SHUTDOWN 1053
#define ER_BAD_FIELD_ERROR 1054
#define ER_WRONG_FIELD_WITH_GROUP 1055
#define ER_WRONG_GROUP_FIELD 1056
#define ER_WRONG_SUM_SELECT 1057
#define ER_WRONG_VALUE_COUNT 1058
#define ER_TOO_LONG_IDENT 1059
#define ER_DUP_FIELDNAME 1060
#define ER_DUP_KEYNAME 1061
#define ER_DUP_ENTRY 1062
#define ER_WRONG_FIELD_SPEC 1063
#define ER_PARSE_ERROR 1064
#define ER_EMPTY_QUERY 1065
#define ER_NONUNIQ_TABLE 1066
#define ER_INVALID_DEFAULT 1067
#define ER_MULTIPLE_PRI_KEY 1068
#define ER_TOO_MANY_KEYS 1069
#define ER_TOO_MANY_KEY_PARTS 1070
#define ER_TOO_LONG_KEY 1071
#define ER_KEY_COLUMN_DOES_NOT_EXITS 1072
#define ER_TOO_BIG_FIELDLENGTH 1074
#define ER_WRONG_AUTO_KEY 1075
#define ER_READY 1076
#define ER_SHUTDOWN_COMPLETE 1079
#define ER_FORCING_CLOSE 1080
#define ER_IPSOCK_ERROR 1081
#define ER_NO_SUCH_INDEX 1082
#define ER_WRONG_FIELD_TERMINATORS 1083
#define ER_BLOBS_AND_NO_TERMINATED 1084
#define ER_TEXTFILE_NOT_READABLE 1085
#define ER_FILE_EXISTS_ERROR 1086
#define ER_LOAD_INFO 1087
#define ER_ALTER_INFO 1088
#define ER_WRONG_SUB_KEY 1089
#define ER_CANT_REMOVE_ALL_FIELDS 1090
#define ER_CANT_DROP_FIELD_OR_KEY 1091
#define ER_INSERT_INFO 1092
#define ER_UPDATE_TABLE_USED 1093
#define ER_NO_SUCH_THREAD 1094
#define ER_KILL_DENIED_ERROR 1095
#define ER_NO_TABLES_USED 1096
#define ER_TOO_BIG_SET 1097
#define ER_NO_UNIQUE_LOGFILE 1098
#define ER_TABLE_NOT_LOCKED_FOR_WRITE 1099
#define ER_TABLE_NOT_LOCKED 1100
#define ER_BLOB_CANT_HAVE_DEFAULT 1101
#define ER_WRONG_DB_NAME 1102
#define ER_WRONG_TABLE_NAME 1103
#define ER_TOO_BIG_SELECT 1104
#define ER_UNKNOWN_ERROR 1105
#define ER_UNKNOWN_PROCEDURE 1106
#define ER_WRONG_PARAMCOUNT_TO_PROCEDURE 1107
#define ER_WRONG_PARAMETERS_TO_PROCEDURE 1108
#define ER_UNKNOWN_TABLE 1109
#define ER_FIELD_SPECIFIED_TWICE 1110
#define ER_INVALID_GROUP_FUNC_USE 1111
#define ER_UNSUPPORTED_EXTENSION 1112
#define ER_TABLE_MUST_HAVE_COLUMNS 1113
#define ER_RECORD_FILE_FULL 1114
#define ER_UNKNOWN_CHARACTER_SET 1115
#define ER_TOO_MANY_TABLES 1116
#define ER_TOO_MANY_FIELDS 1117
#define ER_TOO_BIG_ROWSIZE 1118
#define ER_STACK_OVERRUN 1119
#define ER_WRONG_OUTER_JOIN_UNUSED 1120
#define ER_NULL_COLUMN_IN_INDEX 1121
#define ER_CANT_FIND_UDF 1122
#define ER_CANT_INITIALIZE_UDF 1123
#define ER_UDF_NO_PATHS 1124
#define ER_UDF_EXISTS 1125
#define ER_CANT_OPEN_LIBRARY 1126
#define ER_CANT_FIND_DL_ENTRY 1127
#define ER_FUNCTION_NOT_DEFINED 1128
#define ER_HOST_IS_BLOCKED 1129
#define ER_HOST_NOT_PRIVILEGED 1130
#define ER_PASSWORD_ANONYMOUS_USER 1131
#define ER_PASSWORD_NOT_ALLOWED 1132
#define ER_PASSWORD_NO_MATCH 1133
#define ER_UPDATE_INFO 1134
#define ER_WRONG_VALUE_COUNT_ON_ROW 1136
#define ER_CANT_REOPEN_TABLE 1137
#define ER_INVALID_USE_OF_NULL 1138
#define ER_REGEXP_ERROR 1139
#define ER_MIX_OF_GROUP_FUNC_AND_FIELDS 1140
#define ER_NONEXISTING_GRANT 1141
#define ER_TABLEACCESS_DENIED_ERROR 1142
#define ER_COLUMNACCESS_DENIED_ERROR 1143
#define ER_ILLEGAL_GRANT_FOR_TABLE 1144
#define ER_GRANT_WRONG_HOST_OR_USER 1145
#define ER_NO_SUCH_TABLE 1146
#define ER_NONEXISTING_TABLE_GRANT 1147
#define ER_NOT_ALLOWED_COMMAND 1148
#define ER_SYNTAX_ERROR 1149
#define ER_ABORTING_CONNECTION 1152
#define ER_NET_PACKET_TOO_LARGE 1153
#define ER_NET_READ_ERROR_FROM_PIPE 1154
#define ER_NET_FCNTL_ERROR 1155
#define ER_NET_PACKETS_OUT_OF_ORDER 1156
#define ER_NET_UNCOMPRESS_ERROR 1157
#define ER_NET_READ_ERROR 1158
#define ER_NET_READ_INTERRUPTED 1159
#define ER_NET_ERROR_ON_WRITE 1160
#define ER_NET_WRITE_INTERRUPTED 1161
#define ER_TOO_LONG_STRING 1162


#define ER_WRONG_COLUMN_NAME 1166
#define ER_WRONG_KEY_COLUMN 1167
#define ER_DUP_UNIQUE 1169
#define ER_PRIMARY_CANT_HAVE_NULL 1171
#define ER_REQUIRES_PRIMARY_KEY 1173
#define ER_KEY_DOES_NOT_EXITS 1176
#define ER_CHECK_NO_SUCH_TABLE 1177
#define ER_CHECK_NOT_IMPLEMENTED 1178
#define ER_CANT_DO_THIS_DURING_AN_TRANSACTION 1179
#define ER_ERROR_DURING_COMMIT 1180
#define ER_ERROR_DURING_ROLLBACK 1181
#define ER_ERROR_DURING_FLUSH_LOGS 1182
#define ER_NEW_ABORTING_CONNECTION 1184
#define ER_FT_MATCHING_KEY_NOT_FOUND 1191
#define ER_UNKNOWN_SYSTEM_VARIABLE 1193
#define ER_WARNING_NOT_COMPLETE_ROLLBACK 1196
#define ER_TRANS_CACHE_FULL 1197
#define ER_TOO_MANY_USER_CONNECTIONS 1203
#define ER_SET_CONSTANTS_ONLY 1204
#define ER_LOCK_WAIT_TIMEOUT 1205
#define ER_LOCK_TABLE_FULL 1206
#define ER_READ_ONLY_TRANSACTION 1207
#define ER_WRONG_ARGUMENTS 1210
#define ER_NO_PERMISSION_TO_CREATE_USER 1211
#define ER_LOCK_DEADLOCK 1213
#define ER_TABLE_CANT_HANDLE_FT 1214
#define ER_CANNOT_ADD_FOREIGN 1215
#define ER_NO_REFERENCED_ROW 1216
#define ER_ROW_IS_REFERENCED 1217
#define ER_ERROR_WHEN_EXECUTING_COMMAND 1220
#define ER_WRONG_USAGE 1221
#define ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT 1222
#define ER_CANT_UPDATE_WITH_READLOCK 1223
#define ER_MIXING_NOT_ALLOWED 1224
#define ER_DUP_ARGUMENT 1225
#define ER_USER_LIMIT_REACHED 1226
#define ER_SPECIFIC_ACCESS_DENIED_ERROR 1227
#define ER_LOCAL_VARIABLE 1228
#define ER_GLOBAL_VARIABLE 1229
#define ER_NO_DEFAULT 1230
#define ER_WRONG_VALUE_FOR_VAR 1231
#define ER_WRONG_TYPE_FOR_VAR 1232
#define ER_VAR_CANT_BE_READ 1233
#define ER_CANT_USE_OPTION_HERE 1234
#define ER_NOT_SUPPORTED_YET 1235
#define ER_INCORRECT_GLOBAL_LOCAL_VAR 1238
#define ER_WRONG_FK_DEF 1239
#define ER_KEY_REF_DO_NOT_MATCH_TABLE_REF 1240
#define ER_OPERAND_COLUMNS 1241
#define ER_SUBQUERY_NO_1_ROW 1242
#define ER_UNKNOWN_STMT_HANDLER 1243
#define ER_AUTO_CONVERT 1246
#define ER_ILLEGAL_REFERENCE 1247
#define ER_DERIVED_MUST_HAVE_ALIAS 1248
#define ER_SELECT_REDUCED 1249
#define ER_TABLENAME_NOT_ALLOWED_HERE 1250
#define ER_NOT_SUPPORTED_AUTH_MODE 1251
#define ER_COLLATION_CHARSET_MISMATCH 1253
#define ER_TOO_BIG_FOR_UNCOMPRESS 1256
#define ER_ZLIB_Z_MEM_ERROR 1257
#define ER_ZLIB_Z_BUF_ERROR 1258
#define ER_ZLIB_Z_DATA_ERROR 1259
#define ER_CUT_VALUE_GROUP_CONCAT 1260
#define ER_WARN_TOO_FEW_RECORDS 1261
#define ER_WARN_TOO_MANY_RECORDS 1262
#define ER_WARN_NULL_TO_NOTNULL 1263
#define ER_WARN_DATA_OUT_OF_RANGE 1264
#define WARN_DATA_TRUNCATED 1265
#define ER_WARN_USING_OTHER_HANDLER 1266
#define ER_CANT_AGGREGATE_2COLLATIONS 1267
#define ER_REVOKE_GRANTS 1269
#define ER_CANT_AGGREGATE_3COLLATIONS 1270
#define ER_CANT_AGGREGATE_NCOLLATIONS 1271
#define ER_VARIABLE_IS_NOT_STRUCT 1272
#define ER_UNKNOWN_COLLATION 1273
#define ER_WARN_FIELD_RESOLVED 1276
#define ER_UNTIL_COND_IGNORED 1279
#define ER_WRONG_NAME_FOR_INDEX 1280
#define ER_WRONG_NAME_FOR_CATALOG 1281
#define ER_BAD_FT_COLUMN 1283
#define ER_WARN_HOSTNAME_WONT_WORK 1285
#define ER_WARN_DEPRECATED_SYNTAX 1287
#define ER_NON_UPDATABLE_TABLE 1288
#define ER_FEATURE_DISABLED 1289
#define ER_OPTION_PREVENTS_STATEMENT 1290
#define ER_DUPLICATED_VALUE_IN_TYPE 1291
#define ER_TRUNCATED_WRONG_VALUE 1292
#define ER_INVALID_ON_UPDATE 1294
#define ER_UNKNOWN_TIME_ZONE 1298
#define ER_WARN_INVALID_TIMESTAMP 1299
#define ER_INVALID_CHARACTER_STRING 1300
#define ER_WARN_ALLOWED_PACKET_OVERFLOWED 1301
#define ER_CONFLICTING_DECLARATIONS 1302

#define ER_SP_NO_RECURSIVE_CREATE 1303
#define ER_SP_ALREADY_EXISTS 1304
#define ER_SP_DOES_NOT_EXIST 1305
#define ER_SP_DROP_FAILED 1306
#define ER_SP_STORE_FAILED 1307
#define ER_SP_LILABEL_MISMATCH 1308
#define ER_SP_LABEL_REDEFINE 1309
#define ER_SP_LABEL_MISMATCH 1310
#define ER_SP_UNINIT_VAR 1311
#define ER_SP_BADSELECT 1312
#define ER_SP_BADRETURN 1313
#define ER_SP_BADSTATEMENT 1314

#define ER_QUERY_INTERRUPTED 1317

#define ER_SP_WRONG_NO_OF_ARGS 1318
#define ER_SP_COND_MISMATCH 1319
#define ER_SP_NORETURN 1320
#define ER_SP_NORETURNEND 1321
#define ER_SP_BAD_CURSOR_QUERY 1322
#define ER_SP_BAD_CURSOR_SELECT 1323
#define ER_SP_CURSOR_MISMATCH 1324
#define ER_SP_CURSOR_ALREADY_OPEN 1325
#define ER_SP_CURSOR_NOT_OPEN 1326
#define ER_SP_UNDECLARED_VAR 1327
#define ER_SP_WRONG_NO_OF_FETCH_ARGS 1328
#define ER_SP_FETCH_NO_DATA 1329
#define ER_SP_DUP_PARAM 1330
#define ER_SP_DUP_VAR 1331
#define ER_SP_DUP_COND 1332
#define ER_SP_DUP_CURS 1333
#define ER_SP_CANT_ALTER 1334
#define ER_SP_SUBSELECT_NYI 1335
#define ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG 1336
#define ER_SP_VARCOND_AFTER_CURSHNDLR 1337
#define ER_SP_CURSOR_AFTER_HANDLER 1338
#define ER_SP_CASE_NOT_FOUND 1339


#define ER_FPARSER_TOO_BIG_FILE 1340
#define ER_FPARSER_BAD_HEADER 1341
#define ER_FPARSER_EOF_IN_COMMENT 1342
#define ER_FPARSER_ERROR_IN_PARAMETER 1343
#define ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER 1344


#define ER_VIEW_NO_EXPLAIN 1345
#define ER_WRONG_OBJECT 1347
#define ER_NONUPDATEABLE_COLUMN 1348
#define ER_VIEW_SELECT_CLAUSE 1350
#define ER_VIEW_SELECT_VARIABLE 1351
#define ER_VIEW_SELECT_TMPTABLE 1352
#define ER_VIEW_WRONG_LIST 1353
#define ER_WARN_VIEW_MERGE 1354
#define ER_WARN_VIEW_WITHOUT_KEY 1355
#define ER_VIEW_INVALID 1356
#define ER_SP_NO_DROP_SP 1357

#define ER_TRG_ALREADY_EXISTS 1359
#define ER_TRG_DOES_NOT_EXIST 1360
#define ER_TRG_ON_VIEW_OR_TEMP_TABLE 1361
#define ER_TRG_CANT_CHANGE_ROW 1362
#define ER_TRG_NO_SUCH_ROW_IN_TRG 1363


#define ER_NO_DEFAULT_FOR_FIELD 1364
#define ER_DIVISION_BY_ZERO 1365
#define ER_TRUNCATED_WRONG_VALUE_FOR_FIELD 1366
#define ER_ILLEGAL_VALUE_FOR_TYPE 1367

#define ER_VIEW_NONUPD_CHECK 1368
#define ER_VIEW_CHECK_FAILED 1369

#define ER_PROCACCESS_DENIED_ERROR 1370
#define ER_IO_ERR_LOG_INDEX_READ 1374
#define ER_FSEEK_FAIL 1376
#define ER_LOG_IN_USE 1378
#define ER_LOG_PURGE_UNKNOWN_ERR 1379
#define ER_RESERVED_SYNTAX 1382
#define ER_PS_MANY_PARAM 1390
#define ER_KEY_PART_0 1391

#define ER_VIEW_CHECKSUM 1392
#define ER_VIEW_MULTIUPDATE 1393
#define ER_VIEW_NO_INSERT_FIELD_LIST 1394
#define ER_VIEW_DELETE_MERGE_VIEW 1395
#define ER_CANNOT_USER 1396

#define ER_NONEXISTING_PROC_GRANT 1403
#define ER_PROC_AUTO_GRANT_FAIL 1404
#define ER_PROC_AUTO_REVOKE_FAIL 1405
#define ER_DATA_TOO_LONG 1406
#define ER_SP_BAD_SQLSTATE 1407
#define ER_STARTUP 1408
#define ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR 1409
#define ER_CANT_CREATE_USER_WITH_GRANT 1410
#define ER_WRONG_VALUE_FOR_TYPE 1411
#define ER_TABLE_DEF_CHANGED 1412
#define ER_SP_DUP_HANDLER 1413
#define ER_SP_NOT_VAR_ARG 1414
#define ER_SP_NO_RETSET 1415
#define ER_STMT_HAS_NO_OPEN_CURSOR 1421

#define ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG 1422
#define ER_NO_DEFAULT_FOR_VIEW_FIELD 1423
#define ER_SP_NO_RECURSION 1424
#define ER_TOO_BIG_SCALE 1425
#define ER_TOO_BIG_PRECISION 1426
#define ER_M_BIGGER_THAN_D 1427

#define ER_WRONG_LOCK_OF_SYSTEM_TABLE 1428
#define ER_CONNECT_TO_FOREIGN_DATA_SOURCE 1429
#define ER_QUERY_ON_FOREIGN_DATA_SOURCE 1430
#define ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST 1431
#define ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE 1432
#define ER_FOREIGN_DATA_STRING_INVALID 1433

#define ER_TRG_IN_WRONG_SCHEMA 1435
#define ER_STACK_OVERRUN_NEED_MORE 1436
#define ER_TOO_LONG_BODY 1437
#define ER_TOO_BIG_DISPLAYWIDTH 1439
#define ER_DATETIME_FUNCTION_OVERFLOW 1441
#define ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG 1442
#define ER_VIEW_PREVENT_UPDATE 1443
#define ER_PS_NO_RECURSION 1444
#define ER_SP_CANT_SET_AUTOCOMMIT 1445
#define ER_VIEW_FRM_NO_USER 1447
#define ER_VIEW_OTHER_USER 1448
#define ER_NO_SUCH_USER 1449
#define ER_FORBID_SCHEMA_CHANGE 1450
#define ER_ROW_IS_REFERENCED_2 1451
#define ER_NO_REFERENCED_ROW_2 1452
#define ER_SP_BAD_VAR_SHADOW 1453
#define ER_TRG_NO_DEFINER 1454
#define ER_OLD_FILE_FORMAT 1455
#define ER_SP_RECURSION_LIMIT 1456
#define ER_SP_WRONG_NAME 1458
#define ER_TABLE_NEEDS_UPGRADE 1459
#define ER_SP_NO_AGGREGATE 1460
#define ER_MAX_PREPARED_STMT_COUNT_REACHED 1461
#define ER_VIEW_RECURSIVE 1462
#define ER_NON_GROUPING_FIELD_USED 1463
#define ER_TABLE_CANT_HANDLE_SPKEYS 1464
#define ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA 1465
#define ER_REMOVED_SPACES 1466
#define ER_USERNAME 1468
#define ER_HOSTNAME 1469
#define ER_WRONG_STRING_LENGTH 1470
#define ER_NON_INSERTABLE_TABLE 1471
#define ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT 1473
#define ER_NAME_BECOMES_EMPTY 1474
#define ER_AMBIGUOUS_FIELD_TERM 1475
#define ER_FOREIGN_SERVER_EXISTS 1476
#define ER_FOREIGN_SERVER_DOESNT_EXIST 1477

#define ER_PARTITION_REQUIRES_VALUES_ERROR 1479
#define ER_PARTITION_WRONG_VALUES_ERROR 1480
#define ER_PARTITION_MAXVALUE_ERROR 1481
#define ER_PARTITION_WRONG_NO_PART_ERROR 1484
#define ER_PARTITION_WRONG_NO_SUBPART_ERROR 1485
#define ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR 1486
#define ER_FIELD_NOT_FOUND_PART_ERROR 1488
#define ER_INCONSISTENT_PARTITION_INFO_ERROR 1490
#define ER_PARTITION_FUNC_NOT_ALLOWED_ERROR 1491
#define ER_PARTITIONS_MUST_BE_DEFINED_ERROR 1492
#define ER_RANGE_NOT_INCREASING_ERROR 1493
#define ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR 1494
#define ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR 1495
#define ER_PARTITION_ENTRY_ERROR 1496
#define ER_PARTITION_NOT_DEFINED_ERROR 1498
#define ER_TOO_MANY_PARTITIONS_ERROR 1499
#define ER_SUBPARTITION_ERROR 1500
#define ER_BLOB_FIELD_IN_PART_FUNC_ERROR 1502
#define ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF 1503
#define ER_NO_PARTS_ERROR 1504
#define ER_PARTITION_MGMT_ON_NONPARTITIONED 1505
#define ER_FOREIGN_KEY_ON_PARTITIONED 1506
#define ER_DROP_PARTITION_NON_EXISTENT 1507
#define ER_DROP_LAST_PARTITION 1508
#define ER_COALESCE_ONLY_ON_HASH_PARTITION 1509
#define ER_REORG_HASH_ONLY_ON_SAME_NO 1510
#define ER_REORG_NO_PARAM_ERROR 1511
#define ER_ONLY_ON_RANGE_LIST_PARTITION 1512
#define ER_ADD_PARTITION_SUBPART_ERROR 1513
#define ER_ADD_PARTITION_NO_NEW_PARTITION 1514
#define ER_COALESCE_PARTITION_NO_PARTITION 1515
#define ER_REORG_PARTITION_NOT_EXIST 1516
#define ER_SAME_NAME_PARTITION 1517
#define ER_CONSECUTIVE_REORG_PARTITIONS 1519
#define ER_REORG_OUTSIDE_RANGE 1520
#define ER_PARTITION_FUNCTION_FAILURE 1521
#define ER_LIMITED_PART_RANGE 1523
#define ER_PLUGIN_IS_NOT_LOADED 1524
#define ER_WRONG_VALUE 1525
#define ER_NO_PARTITION_FOR_GIVEN_VALUE 1526
#define ER_FILEGROUP_OPTION_ONLY_ONCE 1527
#define ER_CREATE_FILEGROUP_FAILED 1528
#define ER_DROP_FILEGROUP_FAILED 1529
#define ER_TABLESPACE_AUTO_EXTEND_ERROR 1530
#define ER_WRONG_SIZE_NUMBER 1531
#define ER_SIZE_OVERFLOW_ERROR 1532
#define ER_ALTER_FILEGROUP_FAILED 1533

#define ER_DROP_INDEX_FK 1553
#define ER_WARN_DEPRECATED_SYNTAX_WITH_VER 1554
#define ER_FOREIGN_DUPLICATE_KEY_OLD_UNUSED 1557

#define ER_PARTITION_NO_TEMPORARY 1562
#define ER_PARTITION_CONST_DOMAIN_ERROR 1563
#define ER_PARTITION_FUNCTION_IS_NOT_ALLOWED 1564

#define ER_NULL_IN_VALUES_LESS_THAN 1566
#define ER_WRONG_PARTITION_NAME 1567
#define ER_CANT_CHANGE_TX_CHARACTERISTICS 1568
#define ER_DUP_ENTRY_AUTOINCREMENT_CASE 1569
#define ER_PARTITION_MERGE_ERROR 1572

#define ER_BASE64_DECODE_ERROR 1575
#define ER_ONLY_INTEGERS_ALLOWED 1578
#define ER_UNSUPORTED_LOG_ENGINE 1579
#define ER_BAD_LOG_STATEMENT 1580
#define ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT 1582
#define ER_WRONG_PARAMETERS_TO_NATIVE_FCT 1583
#define ER_WRONG_PARAMETERS_TO_STORED_FCT 1584
#define ER_NATIVE_FCT_NAME_COLLISION 1585
#define ER_DUP_ENTRY_WITH_KEY_NAME 1586
#define ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT 1591
#define ER_VIEW_NO_CREATION_CTX 1599
#define ER_VIEW_INVALID_CREATION_CTX 1600
#define ER_TRG_CORRUPTED_FILE 1602
#define ER_TRG_NO_CREATION_CTX 1603
#define ER_TRG_INVALID_CREATION_CTX 1604
#define ER_TRG_CANT_OPEN_TABLE 1606
#define ER_LOG_PURGE_NO_FILE 1612
#define WARN_OPTION_IGNORED 1618
#define ER_VARIABLE_IS_READONLY 1621
#define ER_WARN_ENGINE_TRANSACTION_ROLLBACK 1622
#define ER_CONFLICT_FN_PARSE_ERROR 1626
#define ER_EXCEPTIONS_WRITE_ERROR 1627
#define ER_TOO_LONG_TABLE_COMMENT 1628
#define ER_TOO_LONG_FIELD_COMMENT 1629
#define ER_FUNC_INEXISTENT_NAME_COLLISION 1630
#define ER_DATABASE_NAME 1631
#define ER_TABLE_NAME 1632
#define ER_PARTITION_NAME 1633
#define ER_SUBPARTITION_NAME 1634
#define ER_TEMPORARY_NAME 1635
#define ER_RENAMED_NAME 1636
#define ER_TOO_MANY_CONCURRENT_TRXS 1637
#define WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED 1638
#define ER_DEBUG_SYNC_TIMEOUT 1639
#define ER_DEBUG_SYNC_HIT_LIMIT 1640
#define ER_DUP_SIGNAL_SET 1641
#define ER_SIGNAL_WARN 1642
#define ER_SIGNAL_NOT_FOUND 1643
#define ER_SIGNAL_EXCEPTION 1644
#define ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER 1645
#define ER_SIGNAL_BAD_CONDITION_TYPE 1646
#define WARN_COND_ITEM_TRUNCATED 1647
#define ER_COND_ITEM_TOO_LONG 1648



#define ER_UNKNOWN_LOCALE 1649
#define ER_WRONG_TYPE_COLUMN_VALUE_ERROR 1654 
#define ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR 1655
#define ER_MAXVALUE_IN_VALUES_IN 1656
#define ER_TOO_MANY_VALUES_ERROR 1657
#define ER_DATA_OUT_OF_RANGE 1690

#define ER_PATH_LENGTH 1680
#define ER_VALUES_IS_NOT_INT_TYPE_ERROR 1697
#define ER_ACCESS_DENIED_NO_PASSWORD_ERROR 1698
#define ER_INDEX_COLUMN_TOO_LONG 1709
#define ER_ERROR_IN_TRIGGER_BODY 1710
#define ER_ERROR_IN_UNKNOWN_TRIGGER_BODY 1711
#define ER_INDEX_CORRUPT 1712

#define ER_UNKNOWN_PARTITION 1735
#define ER_TABLES_DIFFERENT_METADATA 1736
#define ER_ROW_DOES_NOT_MATCH_PARTITION 1737

#define ER_PARTITION_CLAUSE_ON_NONPARTITIONED 1747
#define ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET 1748

#define ER_UNKNOWN_EXPLAIN_FORMAT 1791

#define ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION 1792


#define ER_DISCARD_FK_CHECKS_RUNNING 1807
#define ER_TABLE_SCHEMA_MISMATCH 1808
#define ER_TABLE_IN_SYSTEM_TABLESPACE 1809
#define ER_IO_READ_ERROR 1810
#define ER_IO_WRITE_ERROR 1811

#define ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2 1805

#define ER_INTERNAL_ERROR 1815
#define ER_NOT_VALID_PASSWORD 1819
#define ER_MUST_CHANGE_PASSWORD 1820
#define ER_FK_NO_INDEX_CHILD 1821
#define ER_FK_NO_INDEX_PARENT 1822
#define ER_FK_FAIL_ADD_SYSTEM 1823
#define ER_FK_CANNOT_OPEN_PARENT 1824
#define ER_FK_INCORRECT_OPTION 1825
#define ER_FK_DUP_NAME 1826
#define ER_PASSWORD_FORMAT 1827
#define ER_FK_COLUMN_CANNOT_DROP 1828
#define ER_FK_COLUMN_CANNOT_DROP_CHILD 1829
#define ER_FK_COLUMN_NOT_NULL 1830
#define ER_DUP_INDEX 1831
#define ER_FK_COLUMN_CANNOT_CHANGE 1832
#define ER_FK_COLUMN_CANNOT_CHANGE_CHILD 1833
#define ER_MALFORMED_PACKET 1835
#define ER_READ_ONLY_MODE 1836


#define ER_ALTER_OPERATION_NOT_SUPPORTED 1845
#define ER_DUP_UNKNOWN_IN_INDEX 1859
#define ER_IDENT_CAUSES_TOO_LONG_PATH 1860
#define ER_MUST_CHANGE_PASSWORD_LOGIN 1862
#define ER_ROW_IN_WRONG_PARTITION 1863
#define ER_ACCESS_DENIED_CHANGE_USER_ERROR 1873

#define ER_TABLE_CORRUPT 1877
#define ER_TEMP_FILE_WRITE_FAILURE 1878
#define ER_MISSING_KEY 1886
#define ER_FILE_CORRUPT 3000
#define ER_CANNOT_DISCARD_TEMPORARY_TABLE 3007
#define ER_FK_DEPTH_EXCEEDED 3008
#define ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE_V2 3009
#define ER_WARN_TRIGGER_DOESNT_HAVE_CREATED 3010
#define ER_REFERENCED_TRG_DOES_NOT_EXIST 3011
#define ER_EXPLAIN_NOT_SUPPORTED 3012
#define ER_INVALID_FIELD_SIZE 3013

#define ER_NO_FT_MATERIALIZED_SUBQUERY 3018                                                      

#define ER_INVALID_ARGUMENT_FOR_LOGARITHM 3020
#define ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO 3022
#define ER_QUERY_TIMEOUT 3024
#define ER_NON_RO_SELECT_DISABLE_TIMER 3025

#define ER_AGGREGATE_ORDER_FOR_UNION 3028
#define ER_AGGREGATE_ORDER_NON_AGG_QUERY 3029

#define ER_STD_BAD_ALLOC_ERROR 3044
#define ER_STD_DOMAIN_ERROR 3045
#define ER_STD_LENGTH_ERROR 3046
#define ER_STD_INVALID_ARGUMENT 3047
#define ER_STD_OUT_OF_RANGE_ERROR 3048
#define ER_STD_OVERFLOW_ERROR 3049
#define ER_STD_RANGE_ERROR 3050
#define ER_STD_UNDERFLOW_ERROR 3051
#define ER_STD_LOGIC_ERROR 3052
#define ER_STD_RUNTIME_ERROR 3053
#define ER_STD_UNKNOWN_EXCEPTION 3054


#define ER_FEATURE_NOT_AVAILABLE 3110

#define ER_TRANSACTION_ROLLBACK_DURING_COMMIT 3101
#define ER_WRONG_TABLESPACE_NAME 3119
#define ER_TABLESPACE_IS_NOT_EMPTY 3120
#define ER_WRONG_FILE_NAME 3121

#define ER_SECURE_TRANSPORT_REQUIRED 3159
#define ER_NO_SECURE_TRANSPORTS_CONFIGURED 3160
#define ER_USER_DOES_NOT_EXIST 3162
#define ER_USER_ALREADY_EXISTS 3163

#define ER_SERVER_ISNT_AVAILABLE 3168
#define ER_SESSION_WAS_KILLED 3169
#define ER_CAPACITY_EXCEEDED 3170
#define ER_CAPACITY_EXCEEDED_IN_RANGE_OPTIMIZER 3171

#define ER_CAPACITY_EXCEEDED_IN_PARSER 3186
#define ER_USER_COLUMN_OLD_LENGTH 3189
#define ER_UDF_ERROR 3200

#define ER_WRITE_SET_EXCEEDS_LIMIT 3231
#define ER_UNSUPPORT_COMPRESSED_TEMPORARY_TABLE 3500
#define ER_ACL_OPERATION_FAILED 3501
#define ER_UNSUPPORTED_INDEX_ALGORITHM 3502
#define ER_NO_SUCH_DB 3503
#define ER_TOO_BIG_ENUM 3504
#define ER_TOO_LONG_SET_ENUM_VALUE 3505

#define ER_TABLESPACE_MISSING_WITH_NAME 3510
#define ER_TOO_LONG_ROUTINE_COMMENT 3511
#define ER_INVALID_BITWISE_OPERANDS_SIZE 3513
#define ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE 3514
#define ER_WARN_UNSUPPORTED_HINT 3515

#define ER_UNKNOWN_AUTHID 3523
#define ER_FAILED_ROLE_GRANT 3524
#define ER_FAILED_DEFAULT_ROLES 3526
#define ER_ROLE_NOT_GRANTED 3530
#define ER_FAILED_REVOKE_ROLE 3531
#define ER_RENAME_ROLE 3532

#define ER_LOCK_NOWAIT 3572
#define ER_INVALID_NO_OF_ARGS 3601
#define ER_IMP_SCHEMA_DOES_NOT_EXIST 3609

#define ER_ILLEGAL_PRIVILEGE_LEVEL 3619

#define ER_NON_BOOLEAN_EXPR_FOR_CHECK_CONSTRAINT 3812
#define ER_COLUMN_CHECK_CONSTRAINT_REFERENCES_OTHER_COLUMN 3813
#define ER_CHECK_CONSTRAINT_NAMED_FUNCTION_IS_NOT_ALLOWED 3814
#define ER_CHECK_CONSTRAINT_FUNCTION_IS_NOT_ALLOWED 3815
#define ER_CHECK_CONSTRAINT_VARIABLES 3816
#define ER_CHECK_CONSTRAINT_ROW_VALUE 3817
#define ER_CHECK_CONSTRAINT_REFERS_AUTO_INCREMENT_COLUMN 3818
#define ER_CHECK_CONSTRAINT_VIOLATED 3819
#define ER_CHECK_CONSTRAINT_REFERS_UNKNOWN_COLUMN 3820
#define ER_CHECK_CONSTRAINT_NOT_FOUND 3821
#define ER_CHECK_CONSTRAINT_DUP_NAME 3822
#define ER_CANNOT_CONVERT_STRING 3854
#define ER_DB_ACCESS_DENIED 3879

#define ER_IMPOSSIBLE_STRING_CONVERSION 3988


#define ER_DA_UDF_INVALID_CHARSET_SPECIFIED 3935
#define ER_DA_UDF_INVALID_CHARSET 3936
#define ER_DA_UDF_INVALID_COLLATION 3937
#define ER_DA_UDF_INVALID_EXTENSION_ARGUMENT_TYPE 3938
#define ER_MULTIPLE_CONSTRAINTS_WITH_SAME_NAME 3939
#define ER_CONSTRAINT_NOT_FOUND 3940
#define ER_HOSTNAME_TOO_LONG 3968

#define ER_STATEMENT_NOT_ALLOWED_AFTER_START_TRANSACTION 3977
#define ER_NOT_ALLOWED_WITH_START_TRANSACTION 3979


#define ER_INVALID_PARAMETER_USE 3994
#define ER_CHARACTER_SET_MISMATCH 3995
#define ER_WARN_VAR_VALUE_CHANGE_NOT_SUPPORTED 3996
#define ER_INVALID_TIME_ZONE_INTERVAL 3997
#define ER_INVALID_CAST 3998

#define ER_CLIENT_INTERACTION_TIMEOUT 4031

#define ER_UPDATES_WITH_CONSISTENT_SNAPSHOT 8005
#define ER_ROLLBACK_ONLY 8006
#define ER_ROLLBACK_TO_SAVEPOINT 8007
#define ER_ISOLATION_LEVEL_WITH_CONSISTENT_SNAPSHOT 8008
#define ER_UNSUPPORTED_COLLATION 8009
#define ER_METADATA_INCONSISTENCY 8010

#define ER_DD_METADATA_NOT_FOUND 10024
#define ER_CHECK_CONSTRAINT_NOT_FOUND 3821

#define ER_CONNECTION_ABORTED 13104
#define ER_NORMAL_SERVER_SHUTDOWN 13105
#define ER_SERVER_UNKNOWN_ERROR 13127
#define ER_FILE_TYPE_UNKNOWN 10351

#define ER_LOCK_ORDER_FAILED_WRITE_FILE 13450
#define ER_LOCK_ORDER_FAILED_READ_FILE 13451
#define ER_SERVER_UNKNOWN_ERROR 13127
#define ER_SERVER_NO_SESSION_TO_SEND_TO 13129
#define ER_SERVER_NEW_ABORTING_CONNECTION 13130
#define ER_SHA_PWD_SALT_FOR_USER_CORRUPT 11255

#define ER_CHANGE_RPL_SRC_WRONG_COMPRESSION_ALGORITHM_SIZE 4037
#define ER_CHANGE_MASTER_WRONG_COMPRESSION_ALGORITHM_CLIENT 3920
#define ER_CHANGE_MASTER_WRONG_COMPRESSION_LEVEL_CLIENT 3921
#define ER_WRONG_COMPRESSION_ALGORITHM_CLIENT 3922
#define ER_WRONG_COMPRESSION_LEVEL_CLIENT 3923
#define ER_CHANGE_MASTER_WRONG_COMPRESSION_ALGORITHM_LIST_CLIENT 3924

#define ER_AUTH_RSA_CANT_FIND 10284
#define ER_AUTH_RSA_CANT_PARSE 10285
#define ER_AUTH_RSA_CANT_READ 10286
#define ER_AUTH_RSA_FILES_NOT_FOUND 10287
#define ER_CONN_ATTR_TRUNCATED 10288
#define ER_X509_CIPHERS_MISMATCH 10289
#define ER_X509_ISSUER_MISMATCH 10290
#define ER_X509_SUBJECT_MISMATCH 10291
#define ER_AUTH_CANT_ACTIVATE_ROLE 10292
#define ER_X509_NEEDS_RSA_PRIVKEY 10293
#define ER_X509_CANT_WRITE_KEY 10294
#define ER_X509_CANT_CHMOD_KEY 10295
#define ER_X509_CANT_READ_CA_KEY 10296
#define ER_X509_CANT_READ_CA_CERT 10297
#define ER_X509_CANT_CREATE_CERT 10298
#define ER_X509_CANT_WRITE_CERT 10299
#define ER_AUTH_CANT_CREATE_RSA_PAIR 10300
#define ER_AUTH_CANT_WRITE_PRIVKEY 10301
#define ER_AUTH_CANT_WRITE_PUBKEY 10302
#define ER_AUTH_SSL_CONF_PREVENTS_CERT_GENERATION 10303
#define ER_AUTH_USING_EXISTING_CERTS 10304
#define ER_AUTH_CERTS_SAVED_TO_DATADIR 10305
#define ER_AUTH_CERT_GENERATION_DISABLED 10306
#define ER_AUTH_RSA_CONF_PREVENTS_KEY_GENERATION 10307
#define ER_AUTH_KEY_GENERATION_SKIPPED_PAIR_PRESENT 10308
#define ER_AUTH_KEYS_SAVED_TO_DATADIR 10309
#define ER_AUTH_KEY_GENERATION_DISABLED 10310
#define ER_NET_OK_PACKET_TOO_LARGE 3068

#define ER_DEPRECATED_TLS_VERSION_SESSION 13745
#define ER_WARN_DEPRECATED_TLS_VERSION_FOR_CHANNEL 13746
#define ER_ABORTING_USER_CONNECTION 10914

#define ER_FIELD_IN_GROUPING_NOT_GROUP_BY 3602
#define ER_WINDOW_INVALID_WINDOW_FUNC_USE 3593
#define ER_SCHEMA_DIR_EXISTS 3678
#define ER_TOO_MANY_ROWS 1172

#define ER_FAILED_TO_FIND_COLLATION_NAME 10933
#define ER_SERVER_OUT_OF_RESOURCES 10934
#define ER_SERVER_OUTOFMEMORY 10935
#define ER_INVALID_COLLATION_FOR_CHARSET 10936
#define ER_WRITABLE_CONFIG_REMOVED 10107
#define ER_SERVER_DISK_FULL_NOWAIT 13133
#define ER_AUTHCACHE_PLUGIN_MISSING 10312
#define ER_NET_WAIT_ERROR2 13730
#define ER_FEATURE_UNSUPPORTED 3658
#define ER_CLIENT_DOES_NOT_SUPPORT 3640
#define ER_SERVER_UNKNOWN_SYSTEM_VARIABLE 13128
#define ER_IMP_TABLE_ALREADY_EXISTS 3610
#define ER_ON_DUPLICATE_DISABLED 8004
#define ER_SPATIAL_UNIQUE_INDEX 3728

const char *get_mysql_error_sqlstate(int mysql_errcode);
int get_mysql_errcode(int pg_errcode);
int get_pg_errcode(int mysql_errcode);

#endif // !MYSQL_ERRNO_H
