/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.ListIterator;

public class MarkableSequenceReader
extends Reader {
    private boolean m_closed = false;
    private Reader m_markedStream = null;
    private ListIterator<Reader> m_streams;
    private int m_readlimit_orig;
    private int m_readlimit_curr;
    private boolean m_markSupported;
    private boolean m_markSupported_determined;

    public MarkableSequenceReader(Reader ... streams) {
        if (null == streams) {
            throw new NullPointerException("MarkableSequenceReader(null)");
        }
        LinkedList<Reader> isl = new LinkedList<Reader>();
        for (Reader s : streams) {
            if (null == s) {
                throw new NullPointerException("MarkableSequenceReader(..., null, ...)");
            }
            isl.add(s);
        }
        this.m_streams = isl.listIterator();
    }

    private Reader currentStream() throws IOException {
        if (this.m_closed) {
            throw new IOException("I/O on closed Reader");
        }
        if (this.m_streams.hasNext()) {
            return this.m_streams.next();
        }
        return null;
    }

    private Reader nextStream() throws IOException {
        if (null == this.m_markedStream) {
            this.m_streams.previous().close();
            assert (!this.m_streams.hasPrevious());
            this.m_streams.remove();
            if (this.m_streams.hasNext()) {
                return this.m_streams.next();
            }
        } else if (this.m_streams.hasNext()) {
            Reader is = this.m_streams.next();
            is.mark(this.m_readlimit_curr);
            return is;
        }
        return null;
    }

    private void decrementLimit(long bytes) throws IOException {
        assert (0L < bytes);
        if (null == this.m_markedStream) {
            return;
        }
        if (bytes < (long)this.m_readlimit_curr) {
            this.m_readlimit_curr = (int)((long)this.m_readlimit_curr - bytes);
            return;
        }
        this.mark(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            Reader s = this.currentStream();
            while (null != s) {
                int c = s.read();
                if (-1 != c) {
                    this.decrementLimit(1L);
                    this.m_streams.previous();
                    return c;
                }
                s = this.nextStream();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] b, int off, int len) throws IOException {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            Reader s = this.currentStream();
            while (null != s) {
                int rslt = s.read(b, off, len);
                if (-1 != rslt) {
                    this.decrementLimit(rslt);
                    this.m_streams.previous();
                    return rslt;
                }
                s = this.nextStream();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            long totalSkipped = 0L;
            Reader s = this.currentStream();
            while (null != s) {
                long skipped = s.skip(n);
                this.decrementLimit(skipped);
                totalSkipped += skipped;
                if (0L >= (n -= skipped)) {
                    this.m_streams.previous();
                    break;
                }
                if (-1 != s.read()) {
                    --n;
                    this.decrementLimit(1L);
                    ++totalSkipped;
                    continue;
                }
                s = this.nextStream();
            }
            return totalSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            if (this.m_closed) {
                return;
            }
            while (this.m_streams.hasPrevious()) {
                this.m_streams.previous();
            }
            while (this.m_streams.hasNext()) {
                this.m_streams.next().close();
            }
            this.m_streams = null;
            this.m_closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) throws IOException {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            if (this.m_closed) {
                return;
            }
            Reader activeStream = null;
            if (this.m_streams.hasNext()) {
                this.m_streams.next();
                activeStream = this.m_streams.previous();
            }
            if (null != this.m_markedStream) {
                Reader is = activeStream;
                while (is != this.m_markedStream) {
                    is = this.m_streams.previous();
                }
                this.m_markedStream = null;
                is = this.m_streams.next();
                while (is != activeStream) {
                    try {
                        is = this.nextStream();
                    }
                    catch (IOException e) {
                        throw new UndeclaredThrowableException(e);
                    }
                }
                if (null != activeStream) {
                    this.m_streams.previous();
                }
            }
            if (0 >= readlimit) {
                this.m_readlimit_orig = 0;
                this.m_readlimit_curr = 0;
                return;
            }
            this.m_readlimit_curr = this.m_readlimit_orig = readlimit;
            if (null == activeStream) {
                return;
            }
            this.m_markedStream = activeStream;
            activeStream.mark(readlimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            if (this.m_closed) {
                throw new IOException("reset on closed Reader");
            }
            if (null == this.m_markedStream) {
                if (0 < this.m_readlimit_orig) {
                    return;
                }
                throw new IOException("reset without mark");
            }
            Reader is = this.currentStream();
            while (true) {
                is = this.m_streams.previous();
                is.reset();
                if (is == this.m_markedStream) break;
                is.mark(0);
            }
            this.m_readlimit_curr = this.m_readlimit_orig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        MarkableSequenceReader markableSequenceReader = this;
        synchronized (markableSequenceReader) {
            Reader is;
            if (this.m_markSupported_determined) {
                return this.m_markSupported;
            }
            if (this.m_closed) {
                return false;
            }
            Reader activeStream = null;
            if (this.m_streams.hasNext()) {
                this.m_streams.next();
                activeStream = this.m_streams.previous();
            }
            if (null != this.m_markedStream) {
                is = activeStream;
                while (is != this.m_markedStream) {
                    is = this.m_streams.previous();
                }
            }
            this.m_markSupported = true;
            while (this.m_streams.hasNext()) {
                if (this.m_streams.next().markSupported()) continue;
                this.m_markSupported = false;
            }
            is = null;
            while (is != activeStream) {
                is = this.m_streams.previous();
            }
            this.m_markSupported_determined = true;
            return this.m_markSupported;
        }
    }
}

