/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;

public class Relation {
    private TupleDesc m_tupleDesc;
    private final State m_state;

    Relation(DualState.Key cookie, long resourceOwner, long pointer) {
        this.m_state = new State(cookie, this, resourceOwner, pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Relation._getName(this.m_state.getRelationPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchema() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Relation._getSchema(this.m_state.getRelationPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleDesc getTupleDesc() throws SQLException {
        if (this.m_tupleDesc == null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                this.m_tupleDesc = Relation._getTupleDesc(this.m_state.getRelationPtr());
            }
        }
        return this.m_tupleDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple modifyTuple(Tuple original, int[] fieldNumbers, Object[] values) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Relation._modifyTuple(this.m_state.getRelationPtr(), original.getNativePointer(), fieldNumbers, values);
        }
    }

    private static native String _getName(long var0) throws SQLException;

    private static native String _getSchema(long var0) throws SQLException;

    private static native TupleDesc _getTupleDesc(long var0) throws SQLException;

    private static native Tuple _modifyTuple(long var0, long var2, int[] var4, Object[] var5) throws SQLException;

    private static class State
    extends DualState.SingleGuardedLong<Relation> {
        private State(DualState.Key cookie, Relation r, long ro, long hth) {
            super(cookie, r, ro, hth);
        }

        private long getRelationPtr() throws SQLException {
            this.pin();
            try {
                long l = this.guardedLong();
                return l;
            }
            finally {
                this.unpin();
            }
        }
    }
}

