/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.postgresql.pljava.Adjusting;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.MarkableSequenceInputStream;
import org.postgresql.pljava.internal.MarkableSequenceReader;
import org.postgresql.pljava.internal.Session;
import org.postgresql.pljava.internal.SyntheticXMLReader;
import org.postgresql.pljava.internal.VarlenaWrapper;
import org.postgresql.pljava.internal.VarlenaXMLRenderer;
import org.postgresql.pljava.jdbc.PgNodeTreeAsXML;
import org.postgresql.pljava.jdbc.XMLEventToStreamConsumer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class SQLXMLImpl<V extends VarlenaWrapper>
implements SQLXML {
    protected AtomicReference<V> m_backing;
    static final Pattern s_entirelyWS = Pattern.compile("\\A[ \\t\\n\\r]*+\\z");

    protected SQLXMLImpl(V backing) {
        this.m_backing = new AtomicReference<V>(backing);
    }

    @Override
    public void free() throws SQLException {
        VarlenaWrapper backing = this.m_backing.getAndSet(null);
        if (null == backing) {
            return;
        }
        try {
            backing.close();
        }
        catch (IOException e) {
            throw SQLXMLImpl.normalizedException(e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        throw new SQLNonTransientException("Attempted use of getBinaryStream on an unreadable SQLXML object", "55000");
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        throw new SQLNonTransientException("Attempted use of setBinaryStream on an unwritable SQLXML object", "55000");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        throw new SQLNonTransientException("Attempted use of getCharacterStream on an unreadable SQLXML object", "55000");
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        throw new SQLNonTransientException("Attempted use of setCharacterStream on an unwritable SQLXML object", "55000");
    }

    @Override
    public String getString() throws SQLException {
        throw new SQLNonTransientException("Attempted use of getString on an unreadable SQLXML object", "55000");
    }

    @Override
    public void setString(String value) throws SQLException {
        throw new SQLNonTransientException("Attempted use of setString on an unwritable SQLXML object", "55000");
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        throw new SQLNonTransientException("Attempted use of getSource on an unreadable SQLXML object", "55000");
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        throw new SQLNonTransientException("Attempted use of setResult on an unwritable SQLXML object", "55000");
    }

    protected V backingIfNotFreed() throws SQLException {
        VarlenaWrapper backing = (VarlenaWrapper)this.m_backing.get();
        if (null == backing) {
            throw new SQLNonTransientException("Attempted use of already-freed SQLXML object", "55000");
        }
        return (V)backing;
    }

    static SQLException normalizedException(Exception e) {
        Throwable cause;
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException && (cause = e.getCause()) instanceof SQLException) {
            return (SQLException)cause;
        }
        return new SQLException("Exception in XML processing, not otherwise provided for: " + e.getMessage(), "XX000", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLXML newWritable() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SQLXMLImpl._newWritable();
        }
    }

    private static VarlenaWrapper adopt(SQLXML sx, int oid) throws SQLException {
        if (sx instanceof Readable.PgXML || sx instanceof Writable) {
            return ((SQLXMLImpl)sx).adopt(oid);
        }
        SQLXML rx = SQLXMLImpl.newWritable().setResult(Adjusting.XML.SourceResult.class).set((Source)sx.getSource(null)).getSQLXML();
        sx.free();
        return ((SQLXMLImpl)rx).adopt(oid);
    }

    protected abstract VarlenaWrapper adopt(int var1) throws SQLException;

    public String toString() {
        return this.toString(this);
    }

    protected String toString(Object o) {
        VarlenaWrapper backing;
        if (null == o) {
            o = this;
        }
        if (null != (backing = (VarlenaWrapper)this.m_backing.get())) {
            return backing.toString(o);
        }
        Class<?> c = o.getClass();
        String cn = c.getCanonicalName();
        int pnl = c.getPackage().getName().length();
        return cn.substring(1 + pnl) + " defunct";
    }

    private static native SQLXML _newWritable();

    static InputStream correctedDeclStream(InputStream is, boolean neverWrap, Charset serverCS, boolean[] wrapping) throws IOException, SQLException {
        int got;
        assert (null != wrapping && 1 == wrapping.length);
        byte[] buf = new byte[40];
        boolean needMore = false;
        DeclProbe probe = new DeclProbe();
        while (-1 != (got = is.read(buf))) {
            for (int i = 0; i < got; ++i) {
                needMore = probe.take(buf[i]);
            }
            if (needMore) continue;
        }
        probe.finish();
        return SQLXMLImpl.correctedDeclStream(is, probe, neverWrap, serverCS, wrapping);
    }

    static InputStream correctedDeclStream(InputStream is, DeclProbe probe, boolean neverWrap, Charset serverCS, boolean[] wrapping) throws IOException {
        byte[] pfx = probe.prefix(serverCS);
        int raLen = probe.readaheadLength();
        int raOff = pfx.length - raLen;
        ByteArrayInputStream pfis = new ByteArrayInputStream(pfx, 0, raOff);
        ByteArrayInputStream rais = new ByteArrayInputStream(pfx, raOff, raLen);
        if (neverWrap) {
            return new MarkableSequenceInputStream(pfis, rais, is);
        }
        int markLimit = 0x100000;
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        } else if (is instanceof VarlenaWrapper) {
            markLimit = Integer.MAX_VALUE;
        }
        MarkableSequenceInputStream msis = new MarkableSequenceInputStream(pfis, rais, is);
        if (!SQLXMLImpl.useWrappingElement((InputStream)msis, markLimit)) {
            return msis;
        }
        wrapping[0] = true;
        ByteArrayInputStream elemStart = new ByteArrayInputStream("<pljava-content-wrap>".getBytes(serverCS));
        ByteArrayInputStream elemEnd = new ByteArrayInputStream("</pljava-content-wrap>".getBytes(serverCS));
        msis = new MarkableSequenceInputStream(pfis, elemStart, rais, is, elemEnd);
        return msis;
    }

    static Reader correctedDeclReader(Reader r, DeclProbe probe, Charset impliedCS, boolean[] wrapping) throws IOException {
        MarkableSequenceReader msr;
        char[] pfx = probe.charPrefix(impliedCS);
        int raLen = probe.readaheadLength();
        int raOff = pfx.length - raLen;
        CharArrayReader pfr = new CharArrayReader(pfx, 0, raOff);
        CharArrayReader rar = new CharArrayReader(pfx, raOff, raLen);
        if (!r.markSupported()) {
            r = new BufferedReader(r);
        }
        if (!SQLXMLImpl.useWrappingElement(msr = new MarkableSequenceReader(pfr, rar, r))) {
            return msr;
        }
        wrapping[0] = true;
        StringReader elemStart = new StringReader("<pljava-content-wrap>");
        StringReader elemEnd = new StringReader("</pljava-content-wrap>");
        msr = new MarkableSequenceReader(pfr, elemStart, rar, r, elemEnd);
        return msr;
    }

    static boolean useWrappingElement(InputStream is, int markLimit) throws IOException {
        is.mark(markLimit);
        FilterInputStream tmpis = new FilterInputStream(is){

            @Override
            public void close() throws IOException {
            }
        };
        boolean rslt = SQLXMLImpl.useWrappingElement((InputStream)tmpis, null);
        is.reset();
        is.mark(0);
        return rslt;
    }

    static boolean useWrappingElement(Reader r) throws IOException {
        r.mark(524288);
        FilterReader tmpr = new FilterReader(r){

            @Override
            public void close() throws IOException {
            }
        };
        boolean rslt = SQLXMLImpl.useWrappingElement(null, tmpr);
        r.reset();
        r.mark(0);
        return rslt;
    }

    private static boolean useWrappingElement(InputStream is, Reader r) throws IOException {
        boolean mustBeDocument = false;
        boolean cantBeDocument = false;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isNamespaceAware", true);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        XMLStreamReader xsr = null;
        try {
            xsr = null != is ? xif.createXMLStreamReader(is) : xif.createXMLStreamReader(r);
            while (xsr.hasNext()) {
                int evt = xsr.next();
                if (5 == evt || 3 == evt || 7 == evt) continue;
                if (11 == evt) {
                    mustBeDocument = true;
                } else if (1 != evt) {
                    cantBeDocument = true;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            cantBeDocument = true;
        }
        if (null != xsr) {
            try {
                xsr.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
        return !mustBeDocument;
    }

    static void domUnwrap(DOMSource ds) {
        Document d = (Document)ds.getNode();
        Element wrapper = d.getDocumentElement();
        Document newDoc = d.getImplementation().createDocument(null, null, null);
        DocumentFragment docFrag = newDoc.createDocumentFragment();
        Matcher entirelyWhitespace = s_entirelyWS.matcher("");
        boolean isDocument = true;
        boolean seenElement = false;
        boolean seenText = false;
        Node n = wrapper.getFirstChild();
        Node next = null;
        while (null != n) {
            next = n.getNextSibling();
            switch (n.getNodeType()) {
                case 1: {
                    if (seenElement) {
                        isDocument = false;
                    }
                    seenElement = true;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    if (!isDocument) break;
                    seenText = true;
                    entirelyWhitespace.reset(n.getNodeValue());
                    if (entirelyWhitespace.matches()) break;
                    isDocument = false;
                    break;
                }
                default: {
                    isDocument = false;
                }
            }
            docFrag.appendChild(newDoc.adoptNode(n));
            n = next;
        }
        if (!seenElement) {
            isDocument = false;
        }
        if (isDocument) {
            if (seenText) {
                n = docFrag.getFirstChild();
                next = null;
                while (null != n) {
                    next = n.getNextSibling();
                    if (3 == n.getNodeType()) {
                        docFrag.removeChild(n);
                    }
                    n = next;
                }
            }
            newDoc.appendChild(docFrag);
            ds.setNode(newDoc);
        } else {
            ds.setNode(docFrag);
        }
    }

    static class AdjustingDOMSource
    extends SAXDOMCommon<Adjusting.XML.Source<DOMSource>>
    implements Adjusting.XML.DOMSource {
        private DocumentBuilderFactory m_dbf = DocumentBuilderFactory.newInstance();
        private InputStream m_is;
        private boolean m_wrapped;
        private EntityResolver m_resolver;

        AdjustingDOMSource(InputStream is, boolean wrapped) {
            this.m_dbf.setNamespaceAware(true);
            this.m_is = is;
            this.m_wrapped = wrapped;
        }

        @Override
        public void setSystemId(String systemId) {
            throw new IllegalStateException("AdjustingDOMSource used before get()");
        }

        @Override
        public String getSystemId() {
            throw new IllegalStateException("AdjustingDOMSource used before get()");
        }

        private DocumentBuilderFactory theFactory() {
            if (null == this.m_dbf) {
                throw new IllegalStateException("AdjustingDOMSource too late to adjust after get()");
            }
            return this.m_dbf;
        }

        @Override
        public DOMSource get() throws SQLException {
            if (null == this.m_dbf) {
                throw new IllegalStateException("AdjustingDOMSource get() called more than once");
            }
            try {
                DocumentBuilder db = this.m_dbf.newDocumentBuilder();
                db.setErrorHandler(SAXDOMErrorHandler.instance(this.m_wrapped));
                if (null != this.m_resolver) {
                    db.setEntityResolver(this.m_resolver);
                }
                DOMSource ds = new DOMSource(db.parse(this.m_is));
                if (this.m_wrapped) {
                    SQLXMLImpl.domUnwrap(ds);
                }
                this.m_dbf = null;
                this.m_is = null;
                return ds;
            }
            catch (Exception e) {
                throw SQLXMLImpl.normalizedException(e);
            }
        }

        @Override
        public AdjustingDOMSource xIncludeAware(boolean v) {
            this.theFactory().setXIncludeAware(v);
            return this;
        }

        @Override
        public AdjustingDOMSource expandEntityReferences(boolean v) {
            this.theFactory().setExpandEntityReferences(v);
            return this;
        }

        @Override
        public AdjustingDOMSource setFirstSupportedFeature(boolean value, String ... names) {
            DocumentBuilderFactory dbf = this.theFactory();
            for (String name : names) {
                try {
                    dbf.setFeature(name, value);
                    break;
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        @Override
        public AdjustingDOMSource setFirstSupportedProperty(Object value, String ... names) {
            DocumentBuilderFactory dbf = this.theFactory();
            for (String name : names) {
                try {
                    dbf.setAttribute(name, value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        @Override
        public AdjustingDOMSource entityResolver(EntityResolver resolver) {
            this.m_resolver = resolver;
            return this;
        }

        @Override
        public AdjustingDOMSource schema(Schema schema) {
            this.theFactory().setSchema(schema);
            return this;
        }
    }

    static class AdjustingStAXSource
    extends AdjustingJAXPParser<Adjusting.XML.Source<StAXSource>>
    implements Adjusting.XML.StAXSource {
        private XMLInputFactory m_xif = XMLInputFactory.newInstance();
        private InputStream m_is;
        private Charset m_serverCS;
        private boolean m_wrapped;

        AdjustingStAXSource(InputStream is, Charset serverCS, boolean wrapped) throws XMLStreamException {
            this.m_xif.setProperty("javax.xml.stream.isNamespaceAware", true);
            this.m_is = is;
            this.m_serverCS = serverCS;
            this.m_wrapped = wrapped;
        }

        @Override
        public void setSystemId(String systemId) {
            throw new IllegalStateException("AdjustingStAXSource used before get()");
        }

        @Override
        public String getSystemId() {
            throw new IllegalStateException("AdjustingStAXSource used before get()");
        }

        private XMLInputFactory theFactory() {
            if (null == this.m_xif) {
                throw new IllegalStateException("AdjustingStAXSource too late to adjust after get()");
            }
            return this.m_xif;
        }

        @Override
        public StAXSource get() throws SQLException {
            if (null == this.m_xif) {
                throw new IllegalStateException("AdjustingStAXSource get() called more than once");
            }
            try {
                XMLStreamReader xsr = this.m_xif.createXMLStreamReader(this.m_is, this.m_serverCS.name());
                if (this.m_wrapped) {
                    xsr = new StAXUnwrapFilter(xsr);
                }
                this.m_xif = null;
                return new StAXSource(xsr);
            }
            catch (Exception e) {
                throw SQLXMLImpl.normalizedException(e);
            }
        }

        @Override
        public AdjustingStAXSource allowDTD(boolean v) {
            return this.setFirstSupportedFeature(v, "javax.xml.stream.supportDTD");
        }

        @Override
        public AdjustingStAXSource externalGeneralEntities(boolean v) {
            return this.setFirstSupportedFeature(v, "javax.xml.stream.isSupportingExternalEntities");
        }

        @Override
        public AdjustingStAXSource externalParameterEntities(boolean v) {
            return this;
        }

        @Override
        public AdjustingStAXSource loadExternalDTD(boolean v) {
            return this.setFirstSupportedFeature(!v, "http://java.sun.com/xml/stream/properties/ignore-external-dtd");
        }

        @Override
        public AdjustingStAXSource xIncludeAware(boolean v) {
            return this;
        }

        @Override
        public AdjustingStAXSource expandEntityReferences(boolean v) {
            return this.setFirstSupportedFeature(v, "javax.xml.stream.isReplacingEntityReferences");
        }

        @Override
        public AdjustingStAXSource setFirstSupportedFeature(boolean value, String ... names) {
            XMLInputFactory xif = this.theFactory();
            for (String name : names) {
                try {
                    xif.setProperty(name, value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        @Override
        public AdjustingStAXSource setFirstSupportedProperty(Object value, String ... names) {
            XMLInputFactory xif = this.theFactory();
            for (String name : names) {
                try {
                    xif.setProperty(name, value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }
    }

    static class AdjustingSAXResult
    extends SAXDOMCommon<Adjusting.XML.Result<SAXResult>>
    implements Adjusting.XML.SAXResult {
        private SAXResult m_sr;

        AdjustingSAXResult(SAXResult sr) {
            this.m_sr = sr;
        }

        @Override
        public void setSystemId(String systemId) {
            throw new IllegalStateException("AdjustingSAXResult used before get()");
        }

        @Override
        public String getSystemId() {
            throw new IllegalStateException("AdjustingSAXResult used before get()");
        }

        private AdjustingSAXResult checkedNoOp() {
            if (null == this.m_sr) {
                throw new IllegalStateException("AdjustingSAXResult too late to adjust after get()");
            }
            return this;
        }

        @Override
        public SAXResult get() throws SQLException {
            if (null == this.m_sr) {
                throw new IllegalStateException("AdjustingSAXResult get() called more than once");
            }
            SAXResult sr = this.m_sr;
            this.m_sr = null;
            return sr;
        }

        @Override
        public AdjustingSAXResult xIncludeAware(boolean v) {
            return this.checkedNoOp();
        }

        @Override
        public AdjustingSAXResult expandEntityReferences(boolean v) {
            return this.checkedNoOp();
        }

        @Override
        public AdjustingSAXResult setFirstSupportedFeature(boolean value, String ... names) {
            return this.checkedNoOp();
        }

        @Override
        public AdjustingSAXResult setFirstSupportedProperty(Object value, String ... names) {
            return this.checkedNoOp();
        }

        @Override
        public AdjustingSAXResult entityResolver(EntityResolver resolver) {
            return this.checkedNoOp();
        }

        @Override
        public AdjustingSAXResult schema(Schema schema) {
            return this.checkedNoOp();
        }
    }

    static class AdjustingSAXSource
    extends SAXDOMCommon<Adjusting.XML.Source<SAXSource>>
    implements Adjusting.XML.SAXSource {
        private SAXParserFactory m_spf;
        private XMLReader m_xr;
        private InputSource m_is;
        private boolean m_wrapped;
        private SAXException m_except;
        private boolean m_hasCalledDefaults;

        private AdjustingSAXSource() {
        }

        AdjustingSAXSource(InputSource is, boolean wrapped) throws SAXException {
            this.m_is = is;
            this.m_wrapped = wrapped;
            this.m_spf = SAXParserFactory.newInstance();
            this.m_spf.setNamespaceAware(true);
        }

        AdjustingSAXSource(XMLReader xr, InputSource is) throws SAXException {
            this.m_xr = xr;
            this.m_is = is;
        }

        @Override
        public void setSystemId(String systemId) {
            throw new IllegalStateException("AdjustingSAXSource used before get()");
        }

        @Override
        public String getSystemId() {
            throw new IllegalStateException("AdjustingSAXSource used before get()");
        }

        private SAXParserFactory theFactory() {
            if (null == this.m_spf) {
                throw new IllegalStateException("AdjustingSAXSource too late to set schema after other adjustments");
            }
            return this.m_spf;
        }

        private XMLReader theReader() {
            if (null != this.m_except) {
                return null;
            }
            if (null != this.m_spf) {
                try {
                    this.m_xr = this.m_spf.newSAXParser().getXMLReader();
                }
                catch (SAXException e) {
                    this.m_except = e;
                    return null;
                }
                catch (ParserConfigurationException e) {
                    this.m_except = new SAXException(e.getMessage(), e);
                    return null;
                }
                this.m_spf = null;
                if (this.m_wrapped) {
                    this.m_xr = new SAXUnwrapFilter(this.m_xr);
                }
                this.m_xr.setErrorHandler(SAXDOMErrorHandler.instance(this.m_wrapped));
                if (!this.m_hasCalledDefaults) {
                    this.defaults();
                }
            }
            if (null == this.m_xr) {
                throw new IllegalStateException("AdjustingSAXSource too late to adjust after get()");
            }
            return this.m_xr;
        }

        @Override
        public SAXSource get() throws SQLException {
            XMLReader xr;
            if (null == this.m_xr && null == this.m_spf) {
                throw new IllegalStateException("AdjustingSAXSource get() called more than once");
            }
            if (null != this.m_except || null == (xr = this.theReader())) {
                throw SQLXMLImpl.normalizedException(this.m_except);
            }
            SAXSource ss = new SAXSource(xr, this.m_is);
            this.m_xr = null;
            this.m_is = null;
            return ss;
        }

        @Override
        public AdjustingSAXSource defaults() {
            this.m_hasCalledDefaults = true;
            super.defaults();
            return this;
        }

        @Override
        public AdjustingSAXSource xIncludeAware(boolean v) {
            return this.setFirstSupportedFeature(v, "http://apache.org/xml/features/xinclude");
        }

        @Override
        public AdjustingSAXSource expandEntityReferences(boolean v) {
            return this;
        }

        @Override
        public AdjustingSAXSource setFirstSupportedFeature(boolean value, String ... names) {
            XMLReader r = this.theReader();
            if (null == r) {
                return this;
            }
            for (String name : names) {
                try {
                    r.setFeature(name, value);
                    break;
                }
                catch (SAXNotRecognizedException e) {
                    e.printStackTrace();
                }
                catch (SAXNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        @Override
        public AdjustingSAXSource setFirstSupportedProperty(Object value, String ... names) {
            XMLReader r = this.theReader();
            if (null == r) {
                return this;
            }
            for (String name : names) {
                try {
                    r.setProperty(name, value);
                    break;
                }
                catch (SAXNotRecognizedException e) {
                    e.printStackTrace();
                }
                catch (SAXNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        @Override
        public AdjustingSAXSource entityResolver(EntityResolver resolver) {
            XMLReader r = this.theReader();
            if (null != r) {
                r.setEntityResolver(resolver);
            }
            return this;
        }

        @Override
        public AdjustingSAXSource schema(Schema schema) {
            this.theFactory().setSchema(schema);
            return this;
        }

        static class Dummy
        extends AdjustingSAXSource {
            static final Dummy INSTANCE = new Dummy();

            private Dummy() {
            }

            @Override
            public AdjustingSAXSource setFirstSupportedFeature(boolean value, String ... names) {
                return this;
            }

            @Override
            public AdjustingSAXSource setFirstSupportedProperty(Object value, String ... names) {
                return this;
            }

            @Override
            public AdjustingSAXSource entityResolver(EntityResolver resolver) {
                return this;
            }

            @Override
            public AdjustingSAXSource schema(Schema schema) {
                return this;
            }
        }
    }

    static class AdjustingStreamResult
    extends AdjustingJAXPParser<Adjusting.XML.Result<StreamResult>>
    implements Adjusting.XML.StreamResult {
        private VarlenaWrapper.Output m_vwo;
        private Charset m_serverCS;
        private AdjustingSAXSource m_verifierSource;
        private boolean m_preferWriter = false;
        private boolean m_hasCalledDefaults;

        AdjustingStreamResult(VarlenaWrapper.Output vwo, Charset serverCS) throws SQLException {
            this.m_vwo = vwo;
            this.m_serverCS = serverCS;
            try {
                this.m_verifierSource = new AdjustingSAXSource(null, false);
            }
            catch (SAXException e) {
                throw SQLXMLImpl.normalizedException(e);
            }
        }

        @Override
        public void setSystemId(String systemId) {
            throw new IllegalStateException("AdjustingStreamResult used before get()");
        }

        @Override
        public String getSystemId() {
            throw new IllegalStateException("AdjustingStreamResult used before get()");
        }

        private AdjustingSAXSource theVerifierSource() {
            return this.theVerifierSource(true);
        }

        private AdjustingSAXSource theVerifierSource(boolean afterDefaults) {
            if (null == this.m_verifierSource) {
                throw new IllegalStateException("AdjustingStreamResult too late to adjust after get()");
            }
            if (afterDefaults && !this.m_hasCalledDefaults) {
                this.m_hasCalledDefaults = true;
                this.m_verifierSource.defaults();
            }
            return this.m_verifierSource;
        }

        @Override
        public AdjustingStreamResult preferBinaryStream() {
            this.theVerifierSource(false);
            this.m_preferWriter = false;
            return this;
        }

        @Override
        public AdjustingStreamResult preferCharacterStream() {
            this.theVerifierSource(false);
            this.m_preferWriter = true;
            return this;
        }

        @Override
        public StreamResult get() throws SQLException {
            DeclCheckedOutputStream os;
            if (null == this.m_verifierSource) {
                throw new IllegalStateException("AdjustingStreamResult get() called more than once");
            }
            XMLReader xr = this.theVerifierSource().get().getXMLReader();
            try {
                this.m_vwo.setVerifier(new Verifier(xr));
                os = new DeclCheckedOutputStream(this.m_vwo, this.m_serverCS);
            }
            catch (IOException e) {
                throw SQLXMLImpl.normalizedException(e);
            }
            StreamResult sr = this.m_preferWriter ? new StreamResult(new OutputStreamWriter((OutputStream)os, this.m_serverCS.newEncoder())) : new StreamResult(os);
            this.m_vwo = null;
            this.m_verifierSource = null;
            this.m_serverCS = null;
            return sr;
        }

        @Override
        public AdjustingStreamResult allowDTD(boolean v) {
            this.theVerifierSource().allowDTD(v);
            return this;
        }

        @Override
        public AdjustingStreamResult externalGeneralEntities(boolean v) {
            this.theVerifierSource().externalGeneralEntities(v);
            return this;
        }

        @Override
        public AdjustingStreamResult externalParameterEntities(boolean v) {
            this.theVerifierSource().externalParameterEntities(v);
            return this;
        }

        @Override
        public AdjustingStreamResult loadExternalDTD(boolean v) {
            this.theVerifierSource().loadExternalDTD(v);
            return this;
        }

        @Override
        public AdjustingStreamResult xIncludeAware(boolean v) {
            this.theVerifierSource().xIncludeAware(v);
            return this;
        }

        @Override
        public AdjustingStreamResult expandEntityReferences(boolean v) {
            this.theVerifierSource().expandEntityReferences(v);
            return this;
        }

        @Override
        public AdjustingStreamResult setFirstSupportedFeature(boolean value, String ... names) {
            this.theVerifierSource().setFirstSupportedFeature(value, names);
            return this;
        }

        @Override
        public AdjustingStreamResult defaults() {
            this.m_hasCalledDefaults = true;
            this.theVerifierSource().defaults();
            return this.preferBinaryStream();
        }

        @Override
        public AdjustingStreamResult setFirstSupportedProperty(Object value, String ... names) {
            this.theVerifierSource().setFirstSupportedProperty(value, names);
            return this;
        }

        @Override
        public AdjustingStreamResult entityResolver(EntityResolver resolver) {
            this.theVerifierSource().entityResolver(resolver);
            return this;
        }

        @Override
        public AdjustingStreamResult schema(Schema schema) {
            this.theVerifierSource(false).schema(schema);
            return this;
        }
    }

    static class AdjustingSourceResult
    extends AdjustingJAXPParser<Adjusting.XML.Result<Adjusting.XML.SourceResult>>
    implements Adjusting.XML.SourceResult {
        private Writable m_result;
        private Charset m_serverCS;
        private XMLCopier m_copier;

        AdjustingSourceResult(Writable result, Charset serverCS) {
            this.m_result = result;
            this.m_serverCS = serverCS;
        }

        @Override
        public AdjustingSourceResult set(Source source) throws SQLException {
            if (source instanceof Adjusting.XML.Source) {
                source = ((Adjusting.XML.Source)source).get();
            }
            if (source instanceof StreamSource) {
                return this.set((StreamSource)source);
            }
            if (source instanceof SAXSource) {
                return this.set((SAXSource)source);
            }
            if (source instanceof StAXSource) {
                return this.set((StAXSource)source);
            }
            if (source instanceof DOMSource) {
                return this.set((DOMSource)source);
            }
            this.m_result.free();
            throw new SQLDataException("XML source class " + source.getClass().getName() + " unsupported");
        }

        @Override
        public AdjustingSourceResult set(StreamSource source) throws SQLException {
            block11: {
                if (null == this.m_result) {
                    throw new IllegalStateException("AdjustingSourceResult too late to set source");
                }
                InputStream is = source.getInputStream();
                Reader r = source.getReader();
                DeclProbe probe = new DeclProbe();
                try {
                    if (null != is) {
                        int b;
                        while (-1 != (b = is.read()) && probe.take((byte)b)) {
                        }
                        String probedEncoding = probe.queryEncoding();
                        this.m_copier = XMLCopier.copierFor(this.m_result, this.m_serverCS, probedEncoding).prepare(probe, is);
                        break block11;
                    }
                    if (null != r) {
                        int b;
                        while (-1 != (b = r.read()) && probe.take((char)b)) {
                        }
                        String probedEncoding = probe.queryEncoding();
                        this.m_copier = XMLCopier.copierFor(this.m_result, this.m_serverCS, probedEncoding).prepare(probe, r);
                        break block11;
                    }
                    throw new SQLDataException("Foreign SQLXML implementation has a broken StreamSource", "22000");
                }
                catch (IOException e) {
                    throw SQLXMLImpl.normalizedException(e);
                }
                finally {
                    if (null == this.m_copier) {
                        this.m_result.free();
                        this.m_result = null;
                    }
                }
            }
            return this;
        }

        @Override
        public AdjustingSourceResult set(SAXSource source) throws SQLException {
            if (null == this.m_result) {
                throw new IllegalStateException("AdjustingSourceResult too late to set source");
            }
            if (null != source.getXMLReader()) {
                this.m_copier = new XMLCopier.SAX(this.m_result, source);
            } else {
                try {
                    this.m_copier = new XMLCopier.SAX.Parsing(this.m_result, source);
                }
                catch (SAXException e) {
                    throw SQLXMLImpl.normalizedException(e);
                }
            }
            return this;
        }

        @Override
        public AdjustingSourceResult set(StAXSource source) throws SQLException {
            if (null == this.m_result) {
                throw new IllegalStateException("AdjustingSourceResult too late to set source");
            }
            this.m_copier = new XMLCopier.StAX(this.m_result, source);
            return this;
        }

        @Override
        public AdjustingSourceResult set(DOMSource source) throws SQLException {
            if (null == this.m_result) {
                throw new IllegalStateException("AdjustingSourceResult too late to set source");
            }
            this.m_copier = new XMLCopier.DOM(this.m_result, source);
            return this;
        }

        @Override
        public AdjustingSourceResult set(String source) throws SQLException {
            if (null == this.m_result) {
                throw new IllegalStateException("AdjustingSourceResult too late to set source");
            }
            return this.set(new StreamSource(new StringReader(source)));
        }

        @Override
        public SQLXML getSQLXML() throws SQLException {
            if (null == this.m_result) {
                throw new IllegalStateException("AdjustingSourceResult getSQLXML called more than once");
            }
            if (null == this.m_copier) {
                throw new IllegalStateException("AdjustingSourceResult getSQLXML called before set");
            }
            Writable result = null;
            try {
                result = this.m_copier.finish();
            }
            catch (IOException e) {
                throw SQLXMLImpl.normalizedException(e);
            }
            finally {
                Writable r = this.m_result;
                this.m_result = null;
                this.m_serverCS = null;
                this.m_copier = null;
                if (null == result) {
                    r.free();
                }
            }
            return result;
        }

        @Override
        public void setSystemId(String systemId) {
            throw new UnsupportedOperationException("SourceResult does not support setSystemId");
        }

        @Override
        public String getSystemId() {
            throw new UnsupportedOperationException("SourceResult does not support getSystemId");
        }

        private Adjusting.XML.Source theAdjustable() {
            if (null == this.m_copier) {
                throw new IllegalStateException("AdjustingSourceResult too early or late to adjust");
            }
            return this.m_copier.getAdjustable();
        }

        @Override
        public AdjustingSourceResult get() throws SQLException {
            return this;
        }

        @Override
        public AdjustingSourceResult allowDTD(boolean v) {
            this.theAdjustable().allowDTD(v);
            return this;
        }

        @Override
        public AdjustingSourceResult externalGeneralEntities(boolean v) {
            this.theAdjustable().externalGeneralEntities(v);
            return this;
        }

        @Override
        public AdjustingSourceResult externalParameterEntities(boolean v) {
            this.theAdjustable().externalParameterEntities(v);
            return this;
        }

        @Override
        public AdjustingSourceResult loadExternalDTD(boolean v) {
            this.theAdjustable().loadExternalDTD(v);
            return this;
        }

        @Override
        public AdjustingSourceResult xIncludeAware(boolean v) {
            this.theAdjustable().xIncludeAware(v);
            return this;
        }

        @Override
        public AdjustingSourceResult expandEntityReferences(boolean v) {
            this.theAdjustable().expandEntityReferences(v);
            return this;
        }

        @Override
        public AdjustingSourceResult setFirstSupportedFeature(boolean value, String ... names) {
            this.theAdjustable().setFirstSupportedFeature(value, names);
            return this;
        }

        @Override
        public AdjustingSourceResult setFirstSupportedProperty(Object value, String ... names) {
            this.theAdjustable().setFirstSupportedProperty(value, names);
            return this;
        }

        @Override
        public AdjustingSourceResult entityResolver(EntityResolver resolver) {
            this.theAdjustable().entityResolver(resolver);
            return this;
        }

        @Override
        public AdjustingSourceResult schema(Schema schema) {
            this.theAdjustable().schema(schema);
            return this;
        }
    }

    static class SAXDOMErrorHandler
    implements ErrorHandler {
        private static final SAXDOMErrorHandler s_nonWrappedInstance = new SAXDOMErrorHandler(false);
        static final Pattern s_wrapelement = Pattern.compile("^cvc-elt\\.1(?:\\.a)?+:.*pljava-content-wrap");
        final Logger m_logger = Logger.getLogger("org.postgresql.pljava.jdbc");
        private int m_wrapCount;

        static SAXDOMErrorHandler instance(boolean wrapped) {
            return wrapped ? new SAXDOMErrorHandler(true) : s_nonWrappedInstance;
        }

        private SAXDOMErrorHandler(boolean wrap) {
            this.m_wrapCount = wrap ? 1 : 0;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (0 == this.m_wrapCount) {
                throw exception;
            }
            Matcher m = s_wrapelement.matcher(exception.getMessage());
            if (!m.lookingAt()) {
                throw exception;
            }
            --this.m_wrapCount;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.m_logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    static abstract class SAXDOMCommon<T extends Adjusting.XML.Parsing<T>>
    extends AdjustingJAXPParser<T> {
        SAXDOMCommon() {
        }

        @Override
        public T allowDTD(boolean v) {
            return this.setFirstSupportedFeature(!v, "http://apache.org/xml/features/disallow-doctype-decl", "http://xerces.apache.org/xerces2-j/features.html#disallow-doctype-decl");
        }

        @Override
        public T externalGeneralEntities(boolean v) {
            return this.setFirstSupportedFeature(v, "http://xml.org/sax/features/external-general-entities", "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", "http://xerces.apache.org/xerces-j/features.html#external-general-entities");
        }

        @Override
        public T externalParameterEntities(boolean v) {
            return this.setFirstSupportedFeature(v, "http://xml.org/sax/features/external-parameter-entities", "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities");
        }

        @Override
        public T loadExternalDTD(boolean v) {
            return this.setFirstSupportedFeature(v, "http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
    }

    static abstract class AdjustingJAXPParser<T extends Adjusting.XML.Parsing<T>>
    implements Adjusting.XML.Parsing<T> {
        private static final String LIMIT = "http://www.oracle.com/xml/jaxp/properties/";
        private static final String ACCESS = "http://javax.xml.XMLConstants/property/accessExternal";

        AdjustingJAXPParser() {
        }

        @Override
        public T defaults() {
            return this.allowDTD(false).externalGeneralEntities(false).externalParameterEntities(false).loadExternalDTD(false).xIncludeAware(false).expandEntityReferences(false);
        }

        @Override
        public T elementAttributeLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/elementAttributeLimit");
        }

        @Override
        public T entityExpansionLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit");
        }

        @Override
        public T entityReplacementLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/entityReplacementLimit");
        }

        @Override
        public T maxElementDepth(int depth) {
            return this.setFirstSupportedProperty(depth, "http://www.oracle.com/xml/jaxp/properties/maxElementDepth");
        }

        @Override
        public T maxGeneralEntitySizeLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/maxGeneralEntitySizeLimit");
        }

        @Override
        public T maxParameterEntitySizeLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/maxParameterEntitySizeLimit");
        }

        @Override
        public T maxXMLNameLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/maxXMLNameLimit");
        }

        @Override
        public T totalEntitySizeLimit(int limit) {
            return this.setFirstSupportedProperty(limit, "http://www.oracle.com/xml/jaxp/properties/totalEntitySizeLimit");
        }

        @Override
        public T accessExternalDTD(String protocols) {
            return this.setFirstSupportedProperty(protocols, "http://javax.xml.XMLConstants/property/accessExternalDTD");
        }

        @Override
        public T accessExternalSchema(String protocols) {
            return this.setFirstSupportedProperty(protocols, "http://javax.xml.XMLConstants/property/accessExternalSchema");
        }

        @Override
        public T entityResolver(EntityResolver resolver) {
            throw new UnsupportedOperationException("A SAX EntityResolver cannot be set on a " + this.getClass().getCanonicalName());
        }

        @Override
        public T schema(Schema schema) {
            throw new UnsupportedOperationException("A Schema cannot be set on a " + this.getClass().getCanonicalName());
        }
    }

    static abstract class XMLCopier {
        protected Writable m_tgt;

        protected XMLCopier(Writable tgt) {
            this.m_tgt = tgt;
        }

        Adjusting.XML.Source getAdjustable() {
            return AdjustingSAXSource.Dummy.INSTANCE;
        }

        static Stream copierFor(Writable tgt, Charset tgtCS, String srcCSName) throws SQLException {
            Charset srcCS;
            if (null == srcCSName) {
                srcCSName = "UTF-8";
            }
            if (tgtCS.name().equalsIgnoreCase(srcCSName)) {
                return new Direct(tgt);
            }
            try {
                srcCS = Charset.forName(srcCSName);
            }
            catch (IllegalArgumentException e) {
                throw new SQLDataException("XML declares unsupported encoding \"" + srcCSName + "\"", "2200N");
            }
            if (tgtCS.equals(srcCS)) {
                return new Direct(tgt);
            }
            if (tgtCS.contains(srcCS)) {
                return new Transcoding(tgt, srcCS);
            }
            return new Transforming(tgt, srcCS);
        }

        abstract Writable finish() throws IOException, SQLException;

        static void saxCopy(SAXSource sxs, SAXResult sxr) throws SQLException {
            XMLReader xr = sxs.getXMLReader();
            try {
                LexicalHandler lh;
                ContentHandler ch = sxr.getHandler();
                xr.setContentHandler(ch);
                if (ch instanceof DTDHandler) {
                    xr.setDTDHandler((DTDHandler)((Object)ch));
                }
                if (null == (lh = sxr.getLexicalHandler()) && ch instanceof LexicalHandler) {
                    lh = (LexicalHandler)((Object)ch);
                }
                if (null != lh) {
                    xr.setProperty(SyntheticXMLReader.SAX2PROPERTY.LEXICAL_HANDLER.propertyUri(), lh);
                }
                xr.parse(sxs.getInputSource());
            }
            catch (SAXException e) {
                throw new SQLDataException(e.getMessage(), "22000", e);
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage(), "58030", e);
            }
        }

        static class DOM
        extends XMLCopier {
            private DOMSource m_source;

            DOM(Writable tgt, DOMSource src) {
                super(tgt);
                this.m_source = src;
            }

            @Override
            Writable finish() throws IOException, SQLException {
                DOMResult dr = (DOMResult)this.m_tgt.setResult((VarlenaWrapper.Output)this.m_tgt.backingIfNotFreed(), DOMResult.class);
                dr.setNode(this.m_source.getNode());
                return this.m_tgt;
            }
        }

        static class StAX
        extends XMLCopier {
            private StAXSource m_source;

            StAX(Writable tgt, StAXSource src) {
                super(tgt);
                this.m_source = src;
            }

            @Override
            Writable finish() throws IOException, SQLException {
                StAXResult str = (StAXResult)this.m_tgt.setResult((VarlenaWrapper.Output)this.m_tgt.backingIfNotFreed(), StAXResult.class);
                XMLInputFactory xif = XMLInputFactory.newInstance();
                xif.setProperty("javax.xml.stream.isNamespaceAware", true);
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLEventReader xer = this.m_source.getXMLEventReader();
                try {
                    if (null == xer) {
                        XMLStreamReader xsr = this.m_source.getXMLStreamReader();
                        xsr = new StreamReaderDelegate(xsr){
                            XMLStreamException savedException;

                            @Override
                            public boolean hasNext() throws XMLStreamException {
                                try {
                                    return super.hasNext();
                                }
                                catch (XMLStreamException e) {
                                    this.savedException = e;
                                    return true;
                                }
                            }

                            @Override
                            public int next() throws XMLStreamException {
                                XMLStreamException e = this.savedException;
                                if (null != e) {
                                    this.savedException = null;
                                    throw e;
                                }
                                return super.next();
                            }
                        };
                        xer = xif.createXMLEventReader(xsr);
                    }
                    XMLEventToStreamConsumer xec = new XMLEventToStreamConsumer(str.getXMLStreamWriter());
                    while (xer.hasNext()) {
                        xec.add(xer.nextEvent());
                    }
                    xer.close();
                }
                catch (XMLStreamException e) {
                    throw new SQLDataException(e.getMessage(), "22000", e);
                }
                return this.m_tgt;
            }
        }

        static class SAX
        extends XMLCopier {
            private SAXSource m_source;

            SAX(Writable tgt, SAXSource src) {
                super(tgt);
                this.m_source = src;
            }

            @Override
            Writable finish() throws IOException, SQLException {
                SAX.saxCopy(this.m_source, (SAXResult)this.m_tgt.setResult((VarlenaWrapper.Output)this.m_tgt.backingIfNotFreed(), SAXResult.class));
                return this.m_tgt;
            }

            static class Parsing
            extends XMLCopier {
                private AdjustingSAXSource m_source;

                Parsing(Writable tgt, SAXSource src) throws SAXException {
                    super(tgt);
                    InputSource is = src.getInputSource();
                    this.m_source = new AdjustingSAXSource(is, false);
                }

                @Override
                AdjustingSAXSource getAdjustable() {
                    return this.m_source;
                }

                @Override
                Writable finish() throws IOException, SQLException {
                    Parsing.saxCopy(this.m_source.get(), (SAXResult)this.m_tgt.setResult((VarlenaWrapper.Output)this.m_tgt.backingIfNotFreed(), SAXResult.class));
                    return this.m_tgt;
                }
            }
        }

        static class Transforming
        extends Stream {
            private Charset m_srcCS;

            Transforming(Writable tgt, Charset srcCS) {
                super(tgt);
                this.m_srcCS = srcCS;
            }

            @Override
            XMLCopier prepare(DeclProbe probe, InputStream is) throws IOException, SQLException {
                try {
                    boolean[] wrapping = new boolean[]{false};
                    is = SQLXMLImpl.correctedDeclStream(is, probe, false, this.m_srcCS, wrapping);
                    this.m_adjustable = new AdjustingSAXSource(new InputSource(is), wrapping[0]);
                }
                catch (SAXException e) {
                    throw SQLXMLImpl.normalizedException(e);
                }
                return this;
            }

            @Override
            XMLCopier prepare(DeclProbe probe, Reader r) throws IOException, SQLException {
                try {
                    boolean[] wrapping = new boolean[]{false};
                    r = SQLXMLImpl.correctedDeclReader(r, probe, this.m_srcCS, wrapping);
                    this.m_adjustable = new AdjustingSAXSource(new InputSource(r), wrapping[0]);
                }
                catch (SAXException e) {
                    throw SQLXMLImpl.normalizedException(e);
                }
                return this;
            }

            @Override
            Writable finish() throws IOException, SQLException {
                Transforming.saxCopy((SAXSource)this.m_adjustable.get(), (SAXResult)this.m_tgt.setResult((VarlenaWrapper.Output)this.m_tgt.backingIfNotFreed(), SAXResult.class));
                return this.m_tgt;
            }
        }

        static class Transcoding
        extends Direct {
            private Charset m_srcCS;

            Transcoding(Writable tgt, Charset srcCS) {
                super(tgt);
                this.m_srcCS = srcCS;
            }

            @Override
            XMLCopier prepare(DeclProbe probe, InputStream is) throws SQLException {
                return this.prepare(probe, new InputStreamReader(is, this.m_srcCS));
            }
        }

        static class Direct
        extends Stream {
            private InputStream m_is;
            private Reader m_rdr;
            private DeclProbe m_probe;
            private AdjustingStreamResult m_asr;

            protected Direct(Writable tgt) {
                super(tgt);
            }

            @Override
            XMLCopier prepare(DeclProbe probe, InputStream is) throws SQLException {
                this.m_is = is;
                return this.prepare(probe, (Reader)null);
            }

            @Override
            XMLCopier prepare(DeclProbe probe, Reader r) throws SQLException {
                this.m_rdr = r;
                this.m_probe = probe;
                this.m_asr = (AdjustingStreamResult)this.m_tgt.setResult((VarlenaWrapper.Output)this.m_tgt.backingIfNotFreed(), AdjustingStreamResult.class);
                this.m_adjustable = this.m_asr.theVerifierSource(false);
                return this;
            }

            @Override
            Writable finish() throws IOException, SQLException {
                if (null != this.m_is) {
                    int got;
                    OutputStream os = this.m_asr.preferBinaryStream().get().getOutputStream();
                    os.write(this.m_probe.prefix(null));
                    byte[] b = new byte[8192];
                    while (-1 != (got = this.m_is.read(b))) {
                        os.write(b, 0, got);
                    }
                    this.m_is.close();
                    os.close();
                } else {
                    int got;
                    Writer w = this.m_asr.preferCharacterStream().get().getWriter();
                    w.write(this.m_probe.charPrefix(null));
                    char[] b = new char[8192];
                    while (-1 != (got = this.m_rdr.read(b))) {
                        w.write(b, 0, got);
                    }
                    this.m_rdr.close();
                    w.close();
                }
                return this.m_tgt;
            }
        }

        static abstract class Stream
        extends XMLCopier {
            protected Adjusting.XML.Source<SAXSource> m_adjustable;

            protected Stream(Writable tgt) {
                super(tgt);
            }

            @Override
            Adjusting.XML.Source getAdjustable() {
                return this.m_adjustable;
            }

            abstract XMLCopier prepare(DeclProbe var1, InputStream var2) throws IOException, SQLException;

            abstract XMLCopier prepare(DeclProbe var1, Reader var2) throws IOException, SQLException;
        }
    }

    static class DeclProbe {
        private State m_state = State.START;
        private int m_idx = 0;
        private byte m_q = 0;
        private ByteArrayOutputStream m_save = new ByteArrayOutputStream();
        private static final byte[] s_tpl = new byte[]{60, 63, 120, 109, 108, 0, 118, 101, 114, 115, 105, 111, 110, 0, 49, 46, 0, 101, 110, 99, 111, 100, 105, 110, 103, 0, 115, 116, 97, 110, 100, 97, 108, 111, 110, 101, 0, 121, 101, 115, 0, 110, 111, 0};
        private boolean m_saving = true;
        private int m_pos = 0;
        private boolean m_mustBeDecl = false;
        private boolean m_mustBeXmlDecl = false;
        private boolean m_mustBeTextDecl = false;
        private boolean m_xml1_0 = false;
        private Boolean m_standalone = null;
        private int m_versionStart;
        private int m_versionEnd;
        private int m_encodingStart;
        private int m_encodingEnd;
        private int m_readaheadStart;
        private char m_savedChar;
        private static final Charset s_ASCII;

        DeclProbe() {
        }

        boolean take(byte b) throws SQLException {
            if (this.m_saving) {
                this.m_save.write(b);
                ++this.m_pos;
            }
            byte tpl = s_tpl[this.m_idx];
            switch (this.m_state) {
                case START: {
                    if (0 == tpl && this.isSpace(b)) {
                        this.m_mustBeDecl = true;
                        this.m_saving = false;
                        this.m_state = State.MAYBEVER;
                        return true;
                    }
                    if (tpl != b) {
                        this.m_state = State.UNMATCHED;
                        return false;
                    }
                    ++this.m_idx;
                    return true;
                }
                case MAYBEVER: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    switch (b) {
                        case 118: {
                            this.m_state = State.VER;
                            this.m_idx = 7;
                            return true;
                        }
                        case 101: {
                            this.m_mustBeTextDecl = true;
                            this.m_state = State.ENC;
                            this.m_idx = 18;
                            return true;
                        }
                    }
                    break;
                }
                case VER: {
                    if (0 == tpl) {
                        if (this.isSpace(b)) {
                            this.m_state = State.VEQ;
                            return true;
                        }
                        if (61 == b) {
                            this.m_state = State.VQ;
                            return true;
                        }
                    }
                    if (tpl != b) break;
                    ++this.m_idx;
                    return true;
                }
                case VEQ: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (61 != b) break;
                    this.m_state = State.VQ;
                    return true;
                }
                case VQ: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (39 != b && 34 != b) break;
                    this.m_q = b;
                    this.m_state = State.VVAL;
                    this.m_idx = 14;
                    this.m_saving = true;
                    this.m_versionStart = this.m_pos;
                    return true;
                }
                case VVAL: {
                    if (0 == tpl) {
                        if (48 > b || b > 57) break;
                        if (48 == b) {
                            this.m_xml1_0 = true;
                        }
                        this.m_state = State.VVALTAIL;
                        return true;
                    }
                    if (tpl != b) break;
                    ++this.m_idx;
                    return true;
                }
                case VVALTAIL: {
                    if (48 <= b && b <= 57) {
                        this.m_xml1_0 = false;
                        return true;
                    }
                    if (this.m_q != b) break;
                    this.m_state = State.MAYBEENC;
                    this.m_saving = false;
                    this.m_versionEnd = this.m_pos - 1;
                    return true;
                }
                case MAYBEENC: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (101 == b) {
                        this.m_state = State.ENC;
                        this.m_idx = 18;
                        return true;
                    }
                    if (this.m_mustBeTextDecl) break;
                    this.m_mustBeXmlDecl = true;
                    if (115 == b) {
                        this.m_state = State.SA;
                        this.m_idx = 27;
                        return true;
                    }
                    if (63 != b) break;
                    this.m_state = State.END;
                    return true;
                }
                case ENC: {
                    if (0 == tpl) {
                        if (this.isSpace(b)) {
                            this.m_state = State.EEQ;
                            return true;
                        }
                        if (61 == b) {
                            this.m_state = State.EQ;
                            return true;
                        }
                    }
                    if (tpl != b) break;
                    ++this.m_idx;
                    return true;
                }
                case EEQ: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (61 != b) break;
                    this.m_state = State.EQ;
                    return true;
                }
                case EQ: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (39 != b && 34 != b) break;
                    this.m_q = b;
                    this.m_state = State.EVAL;
                    this.m_saving = true;
                    this.m_encodingStart = this.m_pos;
                    return true;
                }
                case EVAL: {
                    if (!(65 <= b && b <= 90 || 97 <= b && b <= 122)) break;
                    this.m_state = State.EVALTAIL;
                    return true;
                }
                case EVALTAIL: {
                    if (65 <= b && b <= 90 || 97 <= b && b <= 122 || 48 <= b && b <= 57 || 46 == b || 95 == b || 45 == b) {
                        return true;
                    }
                    if (this.m_q != b) break;
                    this.m_state = this.m_mustBeTextDecl ? State.TRAILING : State.MAYBESA;
                    this.m_saving = false;
                    this.m_encodingEnd = this.m_pos - 1;
                    return true;
                }
                case MAYBESA: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    switch (b) {
                        case 115: {
                            this.m_mustBeXmlDecl = true;
                            this.m_state = State.SA;
                            this.m_idx = 27;
                            return true;
                        }
                        case 63: {
                            this.m_state = State.END;
                            return true;
                        }
                    }
                    break;
                }
                case SA: {
                    if (0 == tpl) {
                        if (this.isSpace(b)) {
                            this.m_state = State.SEQ;
                            return true;
                        }
                        if (61 == b) {
                            this.m_state = State.SQ;
                            return true;
                        }
                    }
                    if (tpl != b) break;
                    ++this.m_idx;
                    return true;
                }
                case SEQ: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (61 != b) break;
                    this.m_state = State.SQ;
                    return true;
                }
                case SQ: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (39 != b && 34 != b) break;
                    this.m_q = b;
                    this.m_state = State.SVAL;
                    return true;
                }
                case SVAL: {
                    if (121 == b) {
                        this.m_idx = 38;
                        this.m_standalone = Boolean.TRUE;
                    } else {
                        if (110 != b) break;
                        this.m_idx = 42;
                        this.m_standalone = Boolean.FALSE;
                    }
                    this.m_state = State.SVALTAIL;
                    return true;
                }
                case SVALTAIL: {
                    if (0 == tpl) {
                        if (this.m_q != b) break;
                        this.m_state = State.TRAILING;
                        return true;
                    }
                    if (tpl != b) break;
                    ++this.m_idx;
                    return true;
                }
                case TRAILING: {
                    if (this.isSpace(b)) {
                        return true;
                    }
                    if (63 != b) break;
                    this.m_state = State.END;
                    return true;
                }
                case END: {
                    if (62 != b) break;
                    this.m_state = State.MATCHED;
                    this.m_readaheadStart = this.m_pos;
                    this.m_saving = true;
                    return false;
                }
                case MATCHED: 
                case UNMATCHED: {
                    return false;
                }
            }
            this.m_state = State.ABANDONED;
            String m = "Invalid XML/Text declaration";
            if (this.m_mustBeXmlDecl) {
                m = "Invalid XML declaration";
            } else if (this.m_mustBeTextDecl) {
                m = "Invalid text declaration";
            }
            throw new SQLDataException(m, "2200N");
        }

        boolean take(char c) throws SQLException {
            byte b = (byte)(c & 0x7F);
            switch (this.m_state) {
                case START: {
                    if (b == c) {
                        return this.take(b);
                    }
                    this.m_savedChar = c;
                    this.m_state = State.UNMATCHEDCHAR;
                    return false;
                }
                case MATCHED: 
                case UNMATCHED: 
                case UNMATCHEDCHAR: 
                case ABANDONED: {
                    throw new IllegalStateException("too many take(char) calls");
                }
            }
            if (b == c) {
                return this.take(b);
            }
            return this.take((byte)-1);
        }

        private boolean isSpace(byte b) {
            return 32 == b || 9 == b || 13 == b || 10 == b;
        }

        void finish() throws SQLException {
            switch (this.m_state) {
                case MATCHED: 
                case UNMATCHED: 
                case UNMATCHEDCHAR: 
                case ABANDONED: {
                    return;
                }
                case START: {
                    if (0 != this.m_idx) break;
                    this.m_state = State.UNMATCHED;
                    return;
                }
            }
            throw new SQLDataException("XML begins with an incomplete declaration", "2200N");
        }

        byte[] prefix(Charset serverCharset) throws IOException {
            boolean canOmitVersion = true;
            byte[] version = new byte[]{49, 46, 48};
            boolean canOmitEncoding = null == serverCharset || "UTF-8".equals(serverCharset.name());
            boolean canOmitStandalone = true;
            byte[] parseResult = this.m_save.toByteArray();
            if (State.MATCHED == this.m_state) {
                canOmitVersion = this.m_xml1_0;
                boolean bl = canOmitStandalone = null == this.m_standalone;
                if (!this.m_xml1_0 && this.m_versionEnd > this.m_versionStart) {
                    version = Arrays.copyOfRange(parseResult, this.m_versionStart, this.m_versionEnd);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!(canOmitVersion && canOmitEncoding && canOmitStandalone)) {
                baos.write(s_tpl, 0, 5);
                baos.write(32);
                baos.write(s_tpl, 6, 7);
                baos.write(61);
                baos.write(34);
                baos.write(version);
                baos.write(34);
                if (null != serverCharset) {
                    baos.write(32);
                    baos.write(s_tpl, 17, 8);
                    baos.write(61);
                    baos.write(34);
                    baos.write(serverCharset.name().getBytes(serverCharset));
                    baos.write(34);
                }
                if (!canOmitStandalone) {
                    baos.write(32);
                    baos.write(s_tpl, 26, 10);
                    baos.write(61);
                    baos.write(34);
                    if (this.m_standalone.booleanValue()) {
                        baos.write(s_tpl, 37, 3);
                    } else {
                        baos.write(s_tpl, 41, 2);
                    }
                    baos.write(34);
                }
                baos.write(63);
                baos.write(62);
            }
            baos.write(parseResult, this.m_readaheadStart, parseResult.length - this.m_readaheadStart);
            return baos.toByteArray();
        }

        char[] charPrefix(Charset serverCharset) throws IOException {
            byte[] bpfx = this.prefix(serverCharset);
            char[] cpfx = new char[bpfx.length + (State.UNMATCHEDCHAR == this.m_state ? 1 : 0)];
            int i = 0;
            for (byte b : bpfx) {
                cpfx[i++] = (char)(b & 0x7F);
            }
            if (i < cpfx.length) {
                cpfx[i] = this.m_savedChar;
            }
            return cpfx;
        }

        int readaheadLength() {
            if (State.UNMATCHEDCHAR == this.m_state) {
                return 1;
            }
            return this.m_save.size() - this.m_readaheadStart;
        }

        void checkEncoding(Charset serverCharset, boolean strict) throws SQLException {
            if (State.MATCHED == this.m_state && this.m_encodingEnd > this.m_encodingStart) {
                byte[] parseResult = this.m_save.toByteArray();
                String encName = new String(parseResult, this.m_encodingStart, this.m_encodingEnd - this.m_encodingStart, serverCharset);
                try {
                    Charset cs = Charset.forName(encName);
                    if (serverCharset.equals(cs)) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                throw new SQLDataException("XML declares character set \"" + encName + "\" which does not match server encoding", "2200N");
            }
            if (!strict || "UTF-8".equals(serverCharset.name())) {
                return;
            }
            throw new SQLDataException("XML does not declare a character set, and server encoding is not UTF-8", "2200N");
        }

        String queryEncoding() throws SQLException {
            if (State.MATCHED == this.m_state) {
                if (this.m_encodingEnd <= this.m_encodingStart) {
                    return null;
                }
                byte[] parseResult = this.m_save.toByteArray();
                return new String(parseResult, this.m_encodingStart, this.m_encodingEnd - this.m_encodingStart, s_ASCII);
            }
            return null;
        }

        static {
            try {
                s_ASCII = Charset.forName("US-ASCII");
            }
            catch (IllegalArgumentException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        private static enum State {
            START,
            MAYBEVER,
            VER,
            VEQ,
            VQ,
            VVAL,
            VVALTAIL,
            MAYBEENC,
            ENC,
            EEQ,
            EQ,
            EVAL,
            EVALTAIL,
            MAYBESA,
            SA,
            SEQ,
            SQ,
            SVAL,
            SVALTAIL,
            TRAILING,
            END,
            MATCHED,
            UNMATCHED,
            UNMATCHEDCHAR,
            ABANDONED;

        }
    }

    static class WhitespaceAccumulator {
        static final Pattern s_wsChunk = Pattern.compile("\\G([ \\t\\n\\r])\\1*+(?![^ \\t\\n\\r])");
        private static final char[] s_runValToChar = new char[]{' ', '\t', '\n', '\r'};
        static final int MAX_RUN = 64;
        byte[] m_rleBuffer = new byte[8];
        int m_bufPos = 0;
        int m_disbursePos = 0;
        Matcher m_matcher = s_wsChunk.matcher("");

        WhitespaceAccumulator() {
        }

        int accumulate(char[] content, int start, int length) {
            CharBuffer cb = CharBuffer.wrap(content, start, length);
            int tailPos = 0;
            this.m_matcher.reset(cb);
            while (this.m_matcher.find()) {
                int runLength;
                tailPos = this.m_matcher.end();
                char c = this.m_matcher.group(1).charAt(0);
                int runVal = c & 3 | c >>> 1 & 2;
                this.newRun();
                for (runLength = tailPos - this.m_matcher.start(); runLength > 64; runLength -= 64) {
                    this.m_rleBuffer[this.m_bufPos - 1] = (byte)(runVal | 0xFC);
                    this.newRun();
                }
                this.m_rleBuffer[this.m_bufPos - 1] = (byte)(runVal | runLength - 1 << 2);
            }
            this.m_matcher.reset("");
            if (tailPos == length) {
                return -1;
            }
            return start + tailPos;
        }

        private final void newRun() {
            ++this.m_bufPos;
            if (this.m_rleBuffer.length == this.m_bufPos) {
                this.m_rleBuffer = Arrays.copyOf(this.m_rleBuffer, 2 * this.m_rleBuffer.length);
            }
        }

        int disburse(char[] into) {
            assert (into.length >= 64);
            if (this.m_disbursePos == this.m_bufPos) {
                this.m_disbursePos = 0;
                this.m_bufPos = 0;
                return 0;
            }
            int runVal = this.m_rleBuffer[this.m_disbursePos] & 3;
            int runLength = 1 + ((this.m_rleBuffer[this.m_disbursePos] & 0xFF) >>> 2);
            ++this.m_disbursePos;
            char c = s_runValToChar[runVal];
            Arrays.fill(into, 0, runLength, c);
            return runLength;
        }

        void discard() {
            this.m_disbursePos = 0;
            this.m_bufPos = 0;
        }
    }

    static class StAXResultAdapter
    implements XMLStreamWriter {
        private XMLStreamWriter m_xsw;
        private OutputStream m_os;

        StAXResultAdapter(XMLStreamWriter xsw, OutputStream os) {
            this.m_xsw = xsw;
            this.m_os = os;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.m_xsw.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.m_xsw.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.m_xsw.writeStartElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.m_xsw.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.m_xsw.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.m_xsw.writeEmptyElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.m_xsw.writeEndElement();
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.m_xsw.writeEndDocument();
            this.m_xsw.flush();
            try {
                this.m_os.close();
            }
            catch (Exception ioe) {
                throw new XMLStreamException("Failure closing SQLXML StAXResult", ioe);
            }
        }

        @Override
        public void close() throws XMLStreamException {
            this.m_xsw.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.m_xsw.flush();
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.m_xsw.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.m_xsw.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.m_xsw.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.m_xsw.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.m_xsw.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.m_xsw.writeComment(data);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.m_xsw.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.m_xsw.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.m_xsw.writeCData(data);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.m_xsw.writeDTD(dtd);
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.m_xsw.writeEntityRef(name);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.m_xsw.writeStartDocument();
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.m_xsw.writeStartDocument(version);
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.m_xsw.writeStartDocument(encoding, version);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.m_xsw.writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.m_xsw.writeCharacters(text, start, len);
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.m_xsw.getPrefix(uri);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.m_xsw.setPrefix(prefix, uri);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.m_xsw.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.m_xsw.setNamespaceContext(context);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.m_xsw.getNamespaceContext();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.m_xsw.getProperty(name);
        }
    }

    static class StAXUnwrapFilter
    extends StreamReaderDelegate {
        private boolean m_hasPeeked;
        private int m_nestLevel = 0;
        private WhitespaceAccumulator m_wsAcc = new WhitespaceAccumulator();
        private boolean m_topElementSeen = false;
        private boolean m_couldBeDocument = true;
        private int m_disbursed = 0;
        private int m_disburseOffset = 0;
        private char[] m_disburseBuffer;
        private int m_tailFrom = -1;
        private Matcher m_allWhiteSpace = s_entirelyWS.matcher("");

        StAXUnwrapFilter(XMLStreamReader reader) {
            super(reader);
        }

        private boolean wrappedHasNext() throws XMLStreamException {
            if (0 < this.m_disbursed) {
                return true;
            }
            return super.hasNext();
        }

        private int wrappedNext() throws XMLStreamException {
            if (0 < this.m_disbursed) {
                this.m_disbursed = this.m_wsAcc.disburse(this.m_disburseBuffer);
                if (0 < this.m_disbursed) {
                    return 4;
                }
                if (-1 == this.m_tailFrom) {
                    return super.getEventType();
                }
                if (0 <= this.m_tailFrom) {
                    this.m_disburseBuffer = super.getTextCharacters();
                    this.m_disburseOffset = super.getTextStart() + this.m_tailFrom;
                    this.m_disbursed = super.getTextLength() - this.m_tailFrom;
                    this.m_tailFrom = -2;
                    return 4;
                }
                this.m_tailFrom = -1;
                this.m_disburseBuffer = null;
                this.m_disbursed = 0;
                this.m_disburseOffset = 0;
            }
            return super.next();
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            if (this.m_hasPeeked) {
                return true;
            }
            block8: while (this.wrappedHasNext()) {
                this.m_hasPeeked = true;
                switch (this.wrappedNext()) {
                    case 1: {
                        if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                            if (this.m_topElementSeen) {
                                this.commitToContent();
                                if (0 < this.m_disbursed) {
                                    return true;
                                }
                            } else {
                                this.m_wsAcc.discard();
                            }
                            this.m_topElementSeen = true;
                        }
                        if (0 >= this.m_nestLevel++) continue block8;
                        return true;
                    }
                    case 2: {
                        if (0 >= --this.m_nestLevel) continue block8;
                        return true;
                    }
                    case 8: {
                        if (this.m_couldBeDocument && !this.m_topElementSeen) {
                            this.commitToContent();
                        }
                        return true;
                    }
                    case 4: {
                        if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                            int mismatchIndex = this.m_wsAcc.accumulate(super.getTextCharacters(), super.getTextStart(), super.getTextLength());
                            if (-1 == mismatchIndex) continue block8;
                            this.commitToContent();
                            this.m_tailFrom = mismatchIndex;
                        }
                        return true;
                    }
                    case 3: 
                    case 5: {
                        if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                            this.m_wsAcc.discard();
                        }
                        return true;
                    }
                    case 9: 
                    case 12: {
                        if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                            this.commitToContent();
                        }
                        return true;
                    }
                }
                return true;
            }
            this.m_hasPeeked = false;
            return false;
        }

        @Override
        public int next() throws XMLStreamException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.m_hasPeeked = false;
            return this.getEventType();
        }

        @Override
        public int getEventType() {
            if (0 < this.m_disbursed) {
                return 4;
            }
            return super.getEventType();
        }

        private void commitToContent() {
            char[] buf = new char[64];
            int got = this.m_wsAcc.disburse(buf);
            this.m_couldBeDocument = false;
            if (0 == got) {
                return;
            }
            this.m_disburseBuffer = buf;
            this.m_disbursed = got;
        }

        @Override
        public char[] getTextCharacters() {
            if (0 < this.m_disbursed) {
                return this.m_disburseBuffer;
            }
            return super.getTextCharacters();
        }

        @Override
        public int getTextStart() {
            if (0 < this.m_disbursed) {
                return this.m_disburseOffset;
            }
            return super.getTextStart();
        }

        @Override
        public int getTextLength() {
            if (0 < this.m_disbursed) {
                return this.m_disbursed;
            }
            return super.getTextLength();
        }

        @Override
        public String getText() {
            if (0 < this.m_disbursed) {
                return new String(this.m_disburseBuffer, this.m_disburseOffset, this.m_disbursed);
            }
            return super.getText();
        }

        @Override
        public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
            int internalStart = this.getTextStart();
            int internalLength = this.getTextLength();
            if (sourceStart < 0) {
                throw new IndexOutOfBoundsException();
            }
            internalStart += sourceStart;
            if (length > (internalLength -= sourceStart)) {
                length = internalLength;
            }
            System.arraycopy(this.getTextCharacters(), internalStart, target, targetStart, length);
            return length;
        }

        @Override
        public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
            if (0 < this.m_disbursed && (4 != type || null != namespaceURI || null != localName)) {
                throw new XMLStreamException("Another event expected, parsed CHARACTERS");
            }
            super.require(type, namespaceURI, localName);
        }

        @Override
        public String getNamespaceURI() {
            if (0 < this.m_disbursed) {
                return null;
            }
            return super.getNamespaceURI();
        }

        @Override
        public boolean isStartElement() {
            if (0 < this.m_disbursed) {
                return false;
            }
            return super.isStartElement();
        }

        @Override
        public boolean isEndElement() {
            if (0 < this.m_disbursed) {
                return false;
            }
            return super.isEndElement();
        }

        @Override
        public boolean isCharacters() {
            if (0 < this.m_disbursed) {
                return true;
            }
            return super.isCharacters();
        }

        @Override
        public boolean isWhiteSpace() {
            if (0 == this.m_disbursed) {
                return super.isWhiteSpace();
            }
            CharBuffer cb = CharBuffer.wrap(this.m_disburseBuffer, this.m_disburseOffset, this.m_disbursed);
            this.m_allWhiteSpace.reset(cb);
            boolean result = this.m_allWhiteSpace.matches();
            this.m_allWhiteSpace.reset("");
            return result;
        }

        @Override
        public boolean hasText() {
            if (0 < this.m_disbursed) {
                return true;
            }
            return super.hasText();
        }

        @Override
        public boolean hasName() {
            if (0 < this.m_disbursed) {
                return false;
            }
            return super.hasName();
        }

        @Override
        public int nextTag() throws XMLStreamException {
            int evt;
            do {
                if (this.hasNext()) continue;
                throw new NoSuchElementException();
            } while ((4 == (evt = this.next()) || 12 == evt) && this.isWhiteSpace() || 6 == evt || 3 == evt || 5 == evt);
            if (1 != evt && 2 != evt) {
                throw new XMLStreamException("expected start or end tag", this.getLocation());
            }
            return evt;
        }

        private void illegalForCharacters() {
            if (0 < this.m_disbursed) {
                throw new IllegalStateException("XML parsing method inappropriate for a CHARACTERS event.");
            }
        }

        @Override
        public String getAttributeValue(String namespaceURI, String localName) {
            this.illegalForCharacters();
            return super.getAttributeValue(namespaceURI, localName);
        }

        @Override
        public int getAttributeCount() {
            this.illegalForCharacters();
            return super.getAttributeCount();
        }

        @Override
        public QName getAttributeName(int index) {
            this.illegalForCharacters();
            return super.getAttributeName(index);
        }

        @Override
        public String getAttributeNamespace(int index) {
            this.illegalForCharacters();
            return super.getAttributeNamespace(index);
        }

        @Override
        public String getAttributeLocalName(int index) {
            this.illegalForCharacters();
            return super.getAttributeLocalName(index);
        }

        @Override
        public String getAttributePrefix(int index) {
            this.illegalForCharacters();
            return super.getAttributePrefix(index);
        }

        @Override
        public String getAttributeType(int index) {
            this.illegalForCharacters();
            return super.getAttributeType(index);
        }

        @Override
        public String getAttributeValue(int index) {
            this.illegalForCharacters();
            return super.getAttributeValue(index);
        }

        @Override
        public boolean isAttributeSpecified(int index) {
            this.illegalForCharacters();
            return super.isAttributeSpecified(index);
        }

        @Override
        public int getNamespaceCount() {
            this.illegalForCharacters();
            return super.getNamespaceCount();
        }

        @Override
        public String getNamespacePrefix(int index) {
            this.illegalForCharacters();
            return super.getNamespacePrefix(index);
        }

        @Override
        public String getNamespaceURI(int index) {
            this.illegalForCharacters();
            return super.getNamespaceURI(index);
        }

        @Override
        public QName getName() {
            this.illegalForCharacters();
            return super.getName();
        }

        @Override
        public String getLocalName() {
            this.illegalForCharacters();
            return super.getLocalName();
        }
    }

    static class SAXResultAdapter
    extends XMLFilterImpl
    implements TransformerHandler {
        private Writer m_w;
        private TransformerHandler m_th;

        private SAXResultAdapter(TransformerHandler th, Writer w) {
            this.m_w = w;
            this.m_th = th;
            this.setContentHandler(th);
            this.setDTDHandler(th);
        }

        static TransformerHandler newInstance(TransformerHandler th, Writer w) {
            return new SAXResultAdapter(th, w);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                this.m_w.close();
            }
            catch (IOException ioe) {
                throw new SAXException("Failure closing SQLXML SAXResult", ioe);
            }
            this.m_w = null;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.m_th.startDTD(name, publicId, systemId);
        }

        @Override
        public void endDTD() throws SAXException {
            this.m_th.endDTD();
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            this.m_th.startCDATA();
        }

        @Override
        public void endCDATA() throws SAXException {
            this.m_th.endCDATA();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.m_th.comment(ch, start, length);
        }

        @Override
        public void setResult(Result result) {
            throw new IllegalArgumentException("Result already set");
        }

        @Override
        public void setSystemId(String systemId) {
            this.m_th.setSystemId(systemId);
        }

        @Override
        public String getSystemId() {
            return this.m_th.getSystemId();
        }

        @Override
        public Transformer getTransformer() {
            return this.m_th.getTransformer();
        }
    }

    static class SAXUnwrapFilter
    extends XMLFilterImpl
    implements LexicalHandler {
        private int m_nestLevel = 0;
        private WhitespaceAccumulator m_wsAcc = new WhitespaceAccumulator();
        private boolean m_topElementSeen = false;
        private boolean m_couldBeDocument = true;
        private static final LexicalHandler s_dummy = new DefaultHandler2();
        private LexicalHandler m_consumersLexHandler;
        private LexicalHandler m_realLexHandler;
        private boolean m_lexHandlerIsRegistered = false;

        SAXUnwrapFilter(XMLReader parent) {
            super(parent);
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.m_couldBeDocument && !this.m_topElementSeen) {
                this.commitToContent();
            }
            super.endDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                if (this.m_topElementSeen) {
                    this.commitToContent();
                } else {
                    this.m_wsAcc.discard();
                }
                this.m_topElementSeen = true;
            }
            if (0 < this.m_nestLevel++) {
                super.startElement(uri, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (0 < --this.m_nestLevel) {
                super.endElement(uri, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                int mismatchIndex = this.m_wsAcc.accumulate(ch, start, length);
                if (-1 == mismatchIndex) {
                    return;
                }
                this.commitToContent();
                start = mismatchIndex;
            }
            super.characters(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                this.m_wsAcc.discard();
            }
            super.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                this.commitToContent();
            }
            super.skippedEntity(name);
        }

        private void commitToContent() throws SAXException {
            int length;
            char[] buf = new char[64];
            this.m_couldBeDocument = false;
            while (0 < (length = this.m_wsAcc.disburse(buf))) {
                super.characters(buf, 0, length);
            }
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            super.setContentHandler(handler);
            if (this.m_lexHandlerIsRegistered) {
                return;
            }
            try {
                this.setProperty(SyntheticXMLReader.SAX2PROPERTY.LEXICAL_HANDLER.propertyUri(), this.m_consumersLexHandler);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (SyntheticXMLReader.SAX2PROPERTY.LEXICAL_HANDLER.propertyUri().equals(name)) {
                return this.m_consumersLexHandler;
            }
            return super.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (SyntheticXMLReader.SAX2PROPERTY.LEXICAL_HANDLER.propertyUri().equals(name)) {
                if (!SyntheticXMLReader.SAX2PROPERTY.LEXICAL_HANDLER.valueOk(value)) {
                    throw new SAXNotSupportedException(name);
                }
                if (!this.m_lexHandlerIsRegistered) {
                    super.setProperty(name, this);
                    this.m_lexHandlerIsRegistered = true;
                }
                this.m_consumersLexHandler = (LexicalHandler)value;
                this.m_realLexHandler = null != value ? this.m_consumersLexHandler : s_dummy;
                return;
            }
            super.setProperty(name, value);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            assert (false);
        }

        @Override
        public void endDTD() throws SAXException {
            assert (false);
        }

        @Override
        public void startEntity(String name) throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                this.commitToContent();
            }
            this.m_realLexHandler.startEntity(name);
        }

        @Override
        public void endEntity(String name) throws SAXException {
            this.m_realLexHandler.endEntity(name);
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                this.commitToContent();
            }
            this.m_realLexHandler.startCDATA();
        }

        @Override
        public void endCDATA() throws SAXException {
            this.m_realLexHandler.startCDATA();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.m_couldBeDocument && 1 == this.m_nestLevel) {
                this.m_wsAcc.discard();
            }
            this.m_realLexHandler.comment(ch, start, length);
        }
    }

    static class DeclCheckedOutputStream
    extends FilterOutputStream {
        private Charset m_serverCS;
        private DeclProbe m_probe;

        private DeclCheckedOutputStream(OutputStream os, Charset cs) throws IOException {
            super(os);
            os.write(new byte[0]);
            this.m_serverCS = cs;
            this.m_probe = new DeclProbe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                if (null == this.m_probe) {
                    this.out.write(b);
                    return;
                }
                try {
                    if (!this.m_probe.take((byte)(b & 0xFF))) {
                        this.check();
                    }
                }
                catch (SQLException sqe) {
                    throw this.normalizedException(sqe);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                if (null != this.m_probe) {
                    try {
                        while (0 < len--) {
                            if (this.m_probe.take(b[off++])) continue;
                            this.check();
                            break;
                        }
                    }
                    catch (SQLException sqe) {
                        throw this.normalizedException(sqe);
                    }
                }
                this.out.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                try {
                    this.check();
                }
                catch (SQLException sqe) {
                    throw this.normalizedException(sqe);
                }
                this.out.close();
            }
        }

        private void check() throws IOException, SQLException {
            if (null == this.m_probe) {
                return;
            }
            this.m_probe.finish();
            this.m_probe.checkEncoding(this.m_serverCS, false);
            byte[] prefix = this.m_probe.prefix(null);
            this.m_probe = null;
            this.out.write(prefix);
        }

        private IOException normalizedException(Exception e) {
            if (e instanceof IOException) {
                return (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return new IOException("Malformed XML: " + e.getMessage(), e);
        }
    }

    static class Verifier
    extends VarlenaWrapper.Verifier.Base {
        private XMLReader m_xr;

        Verifier() throws SQLException {
            try {
                this.m_xr = new AdjustingSAXSource(null, false).defaults().get().getXMLReader();
            }
            catch (SAXException e) {
                throw SQLXMLImpl.normalizedException(e);
            }
        }

        Verifier(XMLReader xr) {
            this.m_xr = xr;
        }

        @Override
        protected void verify(InputStream is) throws Exception {
            boolean[] wrapped = new boolean[]{false};
            is = SQLXMLImpl.correctedDeclStream(is, false, Session.implServerCharset(), wrapped);
            if (wrapped[0]) {
                this.m_xr.setErrorHandler(SAXDOMErrorHandler.instance(true));
            }
            this.m_xr.parse(new InputSource(is));
        }
    }

    static class Writable
    extends SQLXMLImpl<VarlenaWrapper.Output> {
        private AtomicBoolean m_writable = new AtomicBoolean(true);
        private Charset m_serverCS = Session.implServerCharset();
        private DOMResult m_domResult;

        private Writable(VarlenaWrapper.Output vwo) throws SQLException {
            super(vwo);
            if (null == this.m_serverCS) {
                try {
                    vwo.free();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new SQLFeatureNotSupportedException("SQLXML: no Java Charset found to match server encoding; perhaps set org.postgresql.server.encoding system property to a valid Java charset name for the same encoding?", "0A000");
            }
        }

        private VarlenaWrapper.Output backingAndClearWritable() throws SQLException {
            VarlenaWrapper.Output backing = (VarlenaWrapper.Output)this.backingIfNotFreed();
            return this.m_writable.getAndSet(false) ? backing : null;
        }

        @Override
        public void free() throws SQLException {
            VarlenaWrapper.Output vwo = this.m_backing.getAndSet(null);
            if (null == vwo) {
                return;
            }
            try {
                vwo.free();
            }
            catch (Exception e) {
                throw Writable.normalizedException(e);
            }
        }

        @Override
        public OutputStream setBinaryStream() throws SQLException {
            VarlenaWrapper.Output vwo = this.backingAndClearWritable();
            if (null == vwo) {
                return super.setBinaryStream();
            }
            return new AdjustingStreamResult(vwo, this.m_serverCS).defaults().preferBinaryStream().get().getOutputStream();
        }

        @Override
        public Writer setCharacterStream() throws SQLException {
            VarlenaWrapper.Output vwo = this.backingAndClearWritable();
            if (null == vwo) {
                return super.setCharacterStream();
            }
            return new AdjustingStreamResult(vwo, this.m_serverCS).defaults().preferCharacterStream().get().getWriter();
        }

        @Override
        public void setString(String value) throws SQLException {
            VarlenaWrapper.Output vwo = this.backingAndClearWritable();
            if (null == vwo) {
                super.setString(value);
            }
            try {
                Writer w = new AdjustingStreamResult(vwo, this.m_serverCS).defaults().preferCharacterStream().get().getWriter();
                w.write(value);
                w.close();
            }
            catch (Exception e) {
                throw Writable.normalizedException(e);
            }
        }

        @Override
        public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
            VarlenaWrapper.Output vwo = this.backingAndClearWritable();
            if (null == vwo) {
                return super.setResult(resultClass);
            }
            return this.setResult(vwo, resultClass);
        }

        protected <T extends Result> Class<? extends T> preferredResultClass(Class<T> resultClass) {
            return Adjusting.XML.Result.class == resultClass ? AdjustingSAXResult.class : SAXResult.class;
        }

        private <T extends Result> T setResult(VarlenaWrapper.Output vwo, Class<T> resultClass) throws SQLException {
            Class<T> rc = resultClass;
            if (null == rc || Result.class == rc || Adjusting.XML.Result.class == rc) {
                rc = this.preferredResultClass(rc);
            }
            try {
                if (rc.isAssignableFrom(StreamResult.class) || rc.isAssignableFrom(AdjustingStreamResult.class)) {
                    AdjustingStreamResult sr = new AdjustingStreamResult(vwo, this.m_serverCS);
                    if (Adjusting.XML.Result.class.isAssignableFrom(rc)) {
                        return (T)((Result)rc.cast(sr));
                    }
                    return (T)((Result)rc.cast(sr.get()));
                }
                if (rc.isAssignableFrom(AdjustingSourceResult.class)) {
                    return (T)((Result)rc.cast(new AdjustingSourceResult(this, this.m_serverCS)));
                }
                vwo.setVerifier(VarlenaWrapper.Verifier.NoOp.INSTANCE);
                OutputStream os = vwo;
                if (rc.isAssignableFrom(SAXResult.class) || rc.isAssignableFrom(AdjustingSAXResult.class)) {
                    SAXTransformerFactory saxtf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    TransformerHandler th = saxtf.newTransformerHandler();
                    th.getTransformer().setOutputProperty("encoding", this.m_serverCS.name());
                    os = new DeclCheckedOutputStream(os, this.m_serverCS);
                    OutputStreamWriter w = new OutputStreamWriter(os, this.m_serverCS.newEncoder());
                    th.setResult(new StreamResult(w));
                    th = SAXResultAdapter.newInstance(th, w);
                    SAXResult sr = new SAXResult(th);
                    if (Adjusting.XML.Result.class.isAssignableFrom(rc)) {
                        return (T)((Result)rc.cast(new AdjustingSAXResult(sr)));
                    }
                    return (T)((Result)rc.cast(sr));
                }
                if (rc.isAssignableFrom(StAXResult.class)) {
                    XMLOutputFactory xof = XMLOutputFactory.newInstance();
                    os = new DeclCheckedOutputStream(os, this.m_serverCS);
                    XMLStreamWriter xsw = xof.createXMLStreamWriter(os, this.m_serverCS.name());
                    xsw = new StAXResultAdapter(xsw, os);
                    return (T)((Result)rc.cast(new StAXResult(xsw)));
                }
                if (rc.isAssignableFrom(DOMResult.class)) {
                    this.m_domResult = new DOMResult();
                    return (T)((Result)rc.cast(this.m_domResult));
                }
            }
            catch (Exception e) {
                throw Writable.normalizedException(e);
            }
            throw new SQLFeatureNotSupportedException("No support for SQLXML.setResult(" + rc.getName() + ".class)", "0A000");
        }

        private void serializeDOM(DOMResult r, OutputStream os) throws SQLException {
            DOMSource src = new DOMSource(r.getNode());
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer t = tf.newTransformer();
                t.setOutputProperty("encoding", this.m_serverCS.name());
                os = new DeclCheckedOutputStream(os, this.m_serverCS);
                OutputStreamWriter w = new OutputStreamWriter(os, this.m_serverCS.newEncoder());
                StreamResult rlt = new StreamResult(w);
                t.transform(src, rlt);
                ((Writer)w).close();
            }
            catch (Exception e) {
                throw Writable.normalizedException(e);
            }
        }

        @Override
        protected VarlenaWrapper adopt(int oid) throws SQLException {
            VarlenaWrapper.Output vwo = this.m_backing.getAndSet(null);
            if (this.m_writable.get()) {
                throw new SQLNonTransientException("Writable SQLXML object has not been written yet", "55000");
            }
            if (null == vwo) {
                this.backingIfNotFreed();
            }
            if (null != this.m_domResult) {
                this.serializeDOM(this.m_domResult, vwo);
                this.m_domResult = null;
            }
            return vwo;
        }

        @Override
        protected String toString(Object o) {
            return String.format("%s %swritable", super.toString(o), this.m_writable.get() ? "" : "not ");
        }
    }

    static abstract class Readable<V extends VarlenaWrapper>
    extends SQLXMLImpl<V> {
        protected final AtomicBoolean m_readable = new AtomicBoolean(true);
        protected final int m_pgTypeID;
        protected Charset m_serverCS = Session.implServerCharset();
        protected boolean m_wrapped = false;

        private Readable(V vwi, int oid) throws SQLException {
            super(vwi);
            this.m_pgTypeID = oid;
            if (null == this.m_serverCS) {
                this.free();
                throw new SQLFeatureNotSupportedException("SQLXML: no Java Charset found to match server encoding; perhaps set org.postgresql.server.encoding system property to a valid Java charset name for the same encoding?", "0A000");
            }
        }

        private V backingAndClearReadable() throws SQLException {
            Object backing = this.backingIfNotFreed();
            return (V)(this.m_readable.getAndSet(false) ? backing : null);
        }

        protected abstract InputStream toBinaryStream(V var1, boolean var2) throws SQLException, IOException;

        @Override
        public InputStream getBinaryStream() throws SQLException {
            V backing = this.backingAndClearReadable();
            if (null == backing) {
                return super.getBinaryStream();
            }
            try {
                return this.toBinaryStream(backing, true);
            }
            catch (IOException e) {
                throw Readable.normalizedException(e);
            }
        }

        protected abstract Reader toCharacterStream(V var1, boolean var2) throws SQLException, IOException;

        @Override
        public Reader getCharacterStream() throws SQLException {
            V backing = this.backingAndClearReadable();
            if (null == backing) {
                return super.getCharacterStream();
            }
            try {
                return this.toCharacterStream(backing, true);
            }
            catch (IOException e) {
                throw Readable.normalizedException(e);
            }
        }

        @Override
        public String getString() throws SQLException {
            V backing = this.backingAndClearReadable();
            if (null == backing) {
                return super.getString();
            }
            CharBuffer cb = CharBuffer.allocate(32768);
            StringBuilder sb = new StringBuilder();
            try {
                Reader r = this.toCharacterStream(backing, true);
                while (-1 != r.read(cb)) {
                    sb.append((CharBuffer)cb.flip());
                    cb.clear();
                }
                r.close();
                return sb.toString();
            }
            catch (Exception e) {
                throw Readable.normalizedException(e);
            }
        }

        protected <T extends Source> Class<? extends T> preferredSourceClass(Class<T> sourceClass) {
            return Adjusting.XML.Source.class == sourceClass ? Adjusting.XML.SAXSource.class : SAXSource.class;
        }

        protected StreamSource toStreamSource(V backing) throws SQLException, IOException {
            return new StreamSource(this.toBinaryStream(backing, true));
        }

        protected abstract Adjusting.XML.SAXSource toSAXSource(V var1) throws SQLException, SAXException, IOException;

        protected abstract Adjusting.XML.StAXSource toStAXSource(V var1) throws SQLException, XMLStreamException, IOException;

        protected abstract Adjusting.XML.DOMSource toDOMSource(V var1) throws SQLException, SAXException, IOException, ParserConfigurationException;

        @Override
        public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
            V backing = this.backingAndClearReadable();
            if (null == backing) {
                return super.getSource(sourceClass);
            }
            Class<T> sc = sourceClass;
            if (null == sc || Source.class == sc || Adjusting.XML.Source.class.equals(sc)) {
                sc = this.preferredSourceClass(sc);
            }
            try {
                if (sc.isAssignableFrom(StreamSource.class)) {
                    return (T)((Source)sc.cast(this.toStreamSource(backing)));
                }
                if (sc.isAssignableFrom(SAXSource.class) || sc.isAssignableFrom(AdjustingSAXSource.class)) {
                    Adjusting.XML.SAXSource ss = this.toSAXSource(backing);
                    if (Adjusting.XML.Source.class.isAssignableFrom(sc)) {
                        return (T)((Source)sc.cast(ss));
                    }
                    return (T)((Source)sc.cast(ss.get()));
                }
                if (sc.isAssignableFrom(StAXSource.class) || sc.isAssignableFrom(AdjustingStAXSource.class)) {
                    Adjusting.XML.StAXSource ss = this.toStAXSource(backing);
                    ss.defaults();
                    if (Adjusting.XML.Source.class.isAssignableFrom(sc)) {
                        return (T)((Source)sc.cast(ss));
                    }
                    return (T)((Source)sc.cast(ss.get()));
                }
                if (sc.isAssignableFrom(DOMSource.class) || sc.isAssignableFrom(AdjustingDOMSource.class)) {
                    Adjusting.XML.DOMSource ds = this.toDOMSource(backing);
                    ds.defaults();
                    if (Adjusting.XML.Source.class.isAssignableFrom(sc)) {
                        return (T)((Source)sc.cast(ds));
                    }
                    return (T)((Source)sc.cast(ds.get()));
                }
            }
            catch (Exception e) {
                throw Readable.normalizedException(e);
            }
            throw new SQLFeatureNotSupportedException("No support for SQLXML.getSource(" + sc.getName() + ".class)", "0A000");
        }

        @Override
        protected String toString(Object o) {
            return String.format("%s %sreadable %swrapped", super.toString(o), this.m_readable.get() ? "" : "not ", this.m_wrapped ? "" : "not ");
        }

        /* synthetic */ Readable(VarlenaWrapper x0, int x1, 1 x2) throws SQLException {
            this(x0, x1);
        }

        static class Synthetic
        extends Readable<VarlenaXMLRenderer> {
            private Synthetic(VarlenaWrapper.Input vwi, int oid) throws SQLException {
                super(Synthetic.xmlRenderer(oid, vwi), oid, null);
            }

            private static VarlenaXMLRenderer xmlRenderer(int oid, VarlenaWrapper.Input vwi) throws SQLException {
                switch (oid) {
                    case 194: {
                        return new PgNodeTreeAsXML(vwi);
                    }
                }
                throw new SQLNonTransientException("no synthetic SQLXML support for Oid " + oid, "0A000");
            }

            @Override
            protected VarlenaWrapper adopt(int oid) throws SQLException {
                throw new SQLFeatureNotSupportedException("adopt() on a synthetic SQLXML not yet supported", "0A000");
            }

            @Override
            protected InputStream toBinaryStream(VarlenaXMLRenderer backing, boolean neverWrap) throws SQLException, IOException {
                throw new SQLFeatureNotSupportedException("synthetic SQLXML as binary stream not yet supported", "0A000");
            }

            @Override
            protected Reader toCharacterStream(VarlenaXMLRenderer backing, boolean neverWrap) throws SQLException, IOException {
                throw new SQLFeatureNotSupportedException("synthetic SQLXML as character stream not yet supported", "0A000");
            }

            @Override
            protected Adjusting.XML.SAXSource toSAXSource(VarlenaXMLRenderer backing) throws SQLException, SAXException, IOException {
                return new AdjustingSAXSource(backing, new InputSource());
            }

            @Override
            protected Adjusting.XML.StAXSource toStAXSource(VarlenaXMLRenderer backing) throws SQLException, XMLStreamException, IOException {
                throw new SQLFeatureNotSupportedException("synthetic SQLXML as StAXSource not yet supported", "0A000");
            }

            @Override
            protected Adjusting.XML.DOMSource toDOMSource(VarlenaXMLRenderer backing) throws SQLException, SAXException, IOException, ParserConfigurationException {
                throw new SQLFeatureNotSupportedException("synthetic SQLXML as DOMSource not yet supported", "0A000");
            }
        }

        static class PgXML
        extends Readable<VarlenaWrapper.Input.Stream> {
            private PgXML(VarlenaWrapper.Input vwi, int oid) throws SQLException {
                super(new VarlenaWrapper.Input.Stream(vwi), oid, null);
            }

            @Override
            protected VarlenaWrapper adopt(int oid) throws SQLException {
                VarlenaWrapper.Input.Stream vw = this.m_backing.getAndSet(null);
                if (!this.m_readable.get()) {
                    throw new SQLNonTransientException("SQLXML object has already been read from", "55000");
                }
                if (null == vw) {
                    this.backingIfNotFreed();
                }
                if (this.m_pgTypeID != oid) {
                    vw.verify(new Verifier());
                }
                return vw;
            }

            @Override
            protected InputStream toBinaryStream(VarlenaWrapper.Input.Stream backing, boolean neverWrap) throws SQLException, IOException {
                boolean[] wrapped = new boolean[]{false};
                InputStream rslt = PgXML.correctedDeclStream(backing, neverWrap, this.m_serverCS, wrapped);
                this.m_wrapped = wrapped[0];
                return rslt;
            }

            @Override
            protected Reader toCharacterStream(VarlenaWrapper.Input.Stream backing, boolean neverWrap) throws SQLException, IOException {
                InputStream is = this.toBinaryStream(backing, neverWrap);
                return new InputStreamReader(is, this.m_serverCS.newDecoder());
            }

            @Override
            protected Adjusting.XML.SAXSource toSAXSource(VarlenaWrapper.Input.Stream backing) throws SQLException, SAXException, IOException {
                InputStream is = this.toBinaryStream(backing, false);
                return new AdjustingSAXSource(new InputSource(is), this.m_wrapped);
            }

            @Override
            protected Adjusting.XML.StAXSource toStAXSource(VarlenaWrapper.Input.Stream backing) throws SQLException, XMLStreamException, IOException {
                InputStream is = this.toBinaryStream(backing, false);
                return new AdjustingStAXSource(is, this.m_serverCS, this.m_wrapped);
            }

            @Override
            protected Adjusting.XML.DOMSource toDOMSource(VarlenaWrapper.Input.Stream backing) throws SQLException, SAXException, IOException, ParserConfigurationException {
                InputStream is = this.toBinaryStream(backing, false);
                return new AdjustingDOMSource(is, this.m_wrapped);
            }
        }
    }
}

