#ifndef NODE_REMOTEPLAN_H
#define NODE_REMOTEPLAN_H

#include "postgres.h"

#include "access/parallel.h"
#include "commands/explain.h"
#include "nodes/execnodes.h"
#include "nodes/plannodes.h"

/*
 * Read pg_class directly to get the latest sharid information, because
 * the syscache has not been updated at this time.
 */
extern Oid GetRelationShardByPassCache(Oid relid);

/* Check if the given relation use cantian storage engine */
extern bool use_cantian_engine(Relation rel);

/* Choose a node when access cantian storage */
extern Oid choose_cantian_node(Oid shardid);

/**
 * @brief Initialize the plan state of remote plan
 */
extern RemotePlanState *ExecInitRemotePlan(RemotePlan *node, EState *estate, int eflags);

/**
 * @brief Optimize the remote plan state with the global plan state tree information
 */
extern void ExecOptimizeRemotePlanAfterwards(RemotePlanState *planstate, List *parents);

/**
 * @brief Begin rescan of the remote plan
 */
extern void ExecReScanRemotePlan(RemotePlanState *node);

/**
 * @brief Free resouces allocated  in remote plan state
 */
extern void ExecEndRemotePlan(RemotePlanState *node);

/**
 * @brieif Compute the amount of space we'll need in the parallel
 *  query DSM, and inform pcxt->estimator about our needs.
 */
extern void ExecRemotePlanEstimate(RemotePlanState *node, ParallelContext *pcxt);

/**
 * @brief Set up parallel remote scan
 */
extern void ExecRemotePlanInitializeDSM(RemotePlanState *node, ParallelContext *pcxt);

/**
 * @brief Reset shared state before begin a fresh remote scan
 */
extern void ExecRemotePlanReInitializeDSM(RemotePlanState *node, ParallelContext *pcxt);

/**
 * @brief Copy information from TOC into planstate.
 */
extern void ExecRemotePlanInitializeWorker(RemotePlanState *node, ParallelWorkerContext *pwcxt);

/**
 * @brief Initialize type's input information for transform mysql output into pg field data
 */
extern void init_type_input_info(TypeInputInfo **pinputinfo, TupleTableSlot *slot, EState *estate);

/**
 * @brief Transform mysql output into pg field data 
 */
extern void ExecStoreRemoteTuple(TypeInputInfo *inputinfo,
				 MYSQL_ROW row,
				 unsigned long *lengths,
				 enum enum_field_types *fieldtypes,
				 TupleTableSlot *slot);

bool explain_remote_plan(RemotePlanState *planstate, ExplainState *es);

#endif